/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria.async;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncCapableRepository;
import io.micronaut.data.operations.async.AsyncCriteriaCapableRepository;
import io.micronaut.data.operations.async.AsyncCriteriaRepositoryOperations;
import io.micronaut.data.operations.async.AsyncRepositoryOperations;
import io.micronaut.data.runtime.intercept.criteria.AbstractSpecificationInterceptor;
import jakarta.persistence.criteria.CriteriaQuery;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;

@Internal
public abstract class AbstractAsyncSpecificationInterceptor<T, R>
extends AbstractSpecificationInterceptor<T, R> {
    protected static final Argument<List<Object>> LIST_OF_OBJECTS = Argument.listOf(Object.class);
    protected final AsyncRepositoryOperations asyncOperations;
    protected final AsyncCriteriaRepositoryOperations asyncCriteriaOperations;

    protected AbstractAsyncSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
        if (!(operations instanceof AsyncCapableRepository)) {
            throw new DataAccessException("Datastore of type [" + operations.getClass() + "] does not support asynchronous operations");
        }
        AsyncCapableRepository asyncCapableRepository = (AsyncCapableRepository)operations;
        this.asyncOperations = asyncCapableRepository.async();
        if (operations instanceof AsyncCriteriaRepositoryOperations) {
            AsyncCriteriaRepositoryOperations asyncCriteriaRepositoryOperations;
            this.asyncCriteriaOperations = asyncCriteriaRepositoryOperations = (AsyncCriteriaRepositoryOperations)operations;
        } else {
            AsyncRepositoryOperations asyncRepositoryOperations = this.asyncOperations;
            if (asyncRepositoryOperations instanceof AsyncCriteriaRepositoryOperations) {
                AsyncCriteriaRepositoryOperations asyncCriteriaRepositoryOperations;
                this.asyncCriteriaOperations = asyncCriteriaRepositoryOperations = (AsyncCriteriaRepositoryOperations)asyncRepositoryOperations;
            } else if (operations instanceof AsyncCriteriaCapableRepository) {
                AsyncCriteriaCapableRepository repository = (AsyncCriteriaCapableRepository)operations;
                this.asyncCriteriaOperations = repository.async();
            } else {
                this.asyncCriteriaOperations = null;
            }
        }
    }

    @NonNull
    protected final CompletionStage<Iterable<Object>> findAllAsync(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context, AbstractSpecificationInterceptor.Type type) {
        Set<JoinPath> methodJoinPaths = this.getMethodJoinPaths(methodKey, context);
        if (this.asyncCriteriaOperations != null) {
            CriteriaQuery criteriaQuery = this.buildQuery(context, type, methodJoinPaths);
            Pageable pageable = this.getPageable(context);
            if (pageable != null) {
                return this.asyncCriteriaOperations.findAll(criteriaQuery, (int)pageable.getOffset(), pageable.getSize()).thenApply(m -> m);
            }
            return this.asyncCriteriaOperations.findAll(criteriaQuery).thenApply(m -> m);
        }
        return this.asyncOperations.findAll(this.preparedQueryForCriteria(methodKey, context, type, methodJoinPaths));
    }

    @NonNull
    protected final CompletionStage<Object> findOneAsync(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context, AbstractSpecificationInterceptor.Type type) {
        Set<JoinPath> methodJoinPaths = this.getMethodJoinPaths(methodKey, context);
        if (this.asyncCriteriaOperations != null) {
            return this.asyncCriteriaOperations.findOne(this.buildQuery(context, type, methodJoinPaths));
        }
        return this.asyncOperations.findOne(this.preparedQueryForCriteria(methodKey, context, type, methodJoinPaths));
    }

    @NonNull
    protected final CompletionStage<Number> countAsync(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context) {
        Set<JoinPath> methodJoinPaths = this.getMethodJoinPaths(methodKey, context);
        if (this.asyncCriteriaOperations != null) {
            return this.asyncCriteriaOperations.findOne(this.buildCountQuery(context)).thenApply(n -> n);
        }
        return this.asyncOperations.findOne(this.preparedQueryForCriteria(methodKey, context, AbstractSpecificationInterceptor.Type.COUNT, methodJoinPaths));
    }

    protected final CompletionStage<Boolean> existsAsync(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context) {
        Set<JoinPath> methodJoinPaths = this.getMethodJoinPaths(methodKey, context);
        if (this.asyncCriteriaOperations != null) {
            return this.asyncCriteriaOperations.findOne(this.buildExistsQuery(context, methodJoinPaths));
        }
        return this.asyncOperations.findOne(this.preparedQueryForCriteria(methodKey, context, AbstractSpecificationInterceptor.Type.EXISTS, methodJoinPaths)).thenApply(one -> {
            Boolean aBoolean;
            return one instanceof Boolean ? (aBoolean = (Boolean)one) : Boolean.valueOf(one != null);
        });
    }

    protected final CompletionStage<Number> deleteAllAsync(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context) {
        Set<JoinPath> methodJoinPaths = this.getMethodJoinPaths(methodKey, context);
        if (this.asyncCriteriaOperations != null) {
            return this.asyncCriteriaOperations.deleteAll(this.buildDeleteQuery(context));
        }
        return this.asyncOperations.executeDelete(this.preparedQueryForCriteria(methodKey, context, AbstractSpecificationInterceptor.Type.DELETE_ALL, methodJoinPaths));
    }

    protected final CompletionStage<Number> updateAllAsync(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context) {
        Set<JoinPath> methodJoinPaths = this.getMethodJoinPaths(methodKey, context);
        if (this.asyncCriteriaOperations != null) {
            return this.asyncCriteriaOperations.updateAll(this.buildUpdateQuery(context));
        }
        return this.asyncOperations.executeUpdate(this.preparedQueryForCriteria(methodKey, context, AbstractSpecificationInterceptor.Type.UPDATE_ALL, methodJoinPaths));
    }

    @Override
    protected final Argument<?> getReturnType(MethodInvocationContext<?, ?> context) {
        return this.findReturnType(context, Argument.OBJECT_ARGUMENT);
    }

    protected final Argument<?> findReturnType(MethodInvocationContext<?, ?> context, Argument<?> defaultArg) {
        if (context.isSuspend()) {
            return context.getReturnType().asArgument();
        }
        return context.getReturnType().asArgument().getFirstTypeVariable().orElse(defaultArg);
    }

    @Nullable
    protected Number convertNumberToReturnType(MethodInvocationContext<?, ?> context, Number number) {
        Argument<?> firstTypeVar = this.findReturnType(context, Argument.LONG);
        Class type = firstTypeVar.getType();
        if (type == Object.class || type == Void.class) {
            return null;
        }
        if (number == null) {
            number = 0;
        }
        if (!type.isInstance(number)) {
            return (Number)this.operations.getConversionService().convert((Object)number, firstTypeVar).orElseThrow(() -> new IllegalStateException("Unsupported number type for return type: " + firstTypeVar));
        }
        return number;
    }
}

