/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.CursoredPage;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.criteria.AbstractSpecificationInterceptor;
import io.micronaut.data.runtime.operations.internal.sql.DefaultSqlPreparedQuery;
import java.util.List;

@Internal
public class FindPageSpecificationInterceptor
extends AbstractSpecificationInterceptor<Object, Object> {
    protected FindPageSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        Page page;
        if (context.getParameterValues().length != 2) {
            throw new IllegalStateException("Expected exactly 2 arguments to method");
        }
        Pageable pageable = this.getPageable(context);
        Iterable<?> iterable = this.findAll(methodKey, context, AbstractSpecificationInterceptor.Type.FIND_PAGE);
        List resultList = CollectionUtils.iterableToList(iterable);
        Long count = null;
        if (pageable.requestTotal()) {
            count = this.count(methodKey, context);
        }
        if (pageable.getMode() == Pageable.Mode.OFFSET) {
            page = Page.of((List)resultList, (Pageable)pageable, (Long)count);
        } else {
            PreparedQuery preparedQuery = context.getAttribute((CharSequence)"PREPARED_QUERY").orElse(null);
            if (preparedQuery instanceof DefaultSqlPreparedQuery) {
                DefaultSqlPreparedQuery sqlPreparedQuery = (DefaultSqlPreparedQuery)preparedQuery;
                List<Pageable.Cursor> cursors = sqlPreparedQuery.createCursors(resultList, pageable);
                page = CursoredPage.of((List)resultList, (Pageable)pageable, cursors, (Long)count);
            } else {
                throw new UnsupportedOperationException("Only offset pageable mode is supported by this query implementation");
            }
        }
        Class rt = context.getReturnType().getType();
        if (rt.isInstance(page)) {
            return page;
        }
        return this.operations.getConversionService().convert((Object)page, rt).orElseThrow(() -> new IllegalStateException("Unsupported page interface type " + rt));
    }
}

