/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.criteria.metamodel;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.criteria.metamodel.RuntimePersistentPropertyCollectionAttribute;
import io.micronaut.data.runtime.criteria.metamodel.RuntimePersistentPropertyListAttribute;
import io.micronaut.data.runtime.criteria.metamodel.RuntimePersistentPropertySetAttribute;
import io.micronaut.data.runtime.criteria.metamodel.RuntimePersistentPropertySingularAttribute;
import jakarta.inject.Singleton;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.StaticMetamodel;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@Internal
@Singleton
public final class StaticMetamodelInitializer {
    private final Set<Class> processedEntityClasses = Collections.synchronizedSet(new HashSet());

    public <T> void initializeMetadata(RuntimePersistentEntity<T> persistentEntity) {
        if (this.processedEntityClasses.contains(persistentEntity.getIntrospection().getBeanType())) {
            return;
        }
        this.initializeMetadataInternal(persistentEntity);
    }

    private synchronized <T> void initializeMetadataInternal(RuntimePersistentEntity<T> persistentEntity) {
        Class beanType = persistentEntity.getIntrospection().getBeanType();
        if (this.processedEntityClasses.contains(beanType)) {
            return;
        }
        this.processedEntityClasses.add(beanType);
        ClassUtils.forName((String)(beanType.getName() + "_"), (ClassLoader)beanType.getClassLoader()).filter(metadataClazz -> metadataClazz.isAnnotationPresent(StaticMetamodel.class)).ifPresent(metadataClazz -> {
            for (String property : persistentEntity.getPersistentPropertyNames()) {
                ReflectionUtils.findField((Class)metadataClazz, (String)property).ifPresent(field -> {
                    try {
                        if (field.get(field.getDeclaringClass()) == null) {
                            RuntimePersistentProperty prop = persistentEntity.getPropertyByName(property);
                            if (prop instanceof RuntimeAssociation) {
                                this.initializeMetadataInternal(((RuntimeAssociation)prop).getAssociatedEntity());
                            }
                            if (field.getType() == SingularAttribute.class) {
                                ReflectionUtils.setField((Field)field, field.getDeclaringClass(), new RuntimePersistentPropertySingularAttribute(persistentEntity, prop));
                            }
                            if (field.getType() == CollectionAttribute.class) {
                                ReflectionUtils.setField((Field)field, field.getDeclaringClass(), new RuntimePersistentPropertyCollectionAttribute(persistentEntity, prop));
                            }
                            if (field.getType() == ListAttribute.class) {
                                ReflectionUtils.setField((Field)field, field.getDeclaringClass(), new RuntimePersistentPropertyListAttribute(persistentEntity, prop));
                            }
                            if (field.getType() == SetAttribute.class) {
                                ReflectionUtils.setField((Field)field, field.getDeclaringClass(), new RuntimePersistentPropertySetAttribute(persistentEntity, prop));
                            }
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                });
            }
        });
    }
}

