/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria.reactive;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.reactive.ReactiveCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveCriteriaCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveCriteriaRepositoryOperations;
import io.micronaut.data.operations.reactive.ReactiveRepositoryOperations;
import io.micronaut.data.runtime.intercept.criteria.AbstractSpecificationInterceptor;
import io.micronaut.data.runtime.intercept.criteria.reactive.PreparedQueryReactiveCriteriaRepositoryOperations;
import jakarta.persistence.criteria.CriteriaQuery;
import org.reactivestreams.Publisher;

public abstract class AbstractReactiveSpecificationInterceptor<T, R>
extends AbstractSpecificationInterceptor<T, R> {
    protected final ReactiveRepositoryOperations reactiveOperations;
    protected final ReactiveCriteriaRepositoryOperations reactiveCriteriaOperations;

    protected AbstractReactiveSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
        if (!(operations instanceof ReactiveCapableRepository)) {
            throw new DataAccessException("Datastore of type [" + String.valueOf(operations.getClass()) + "] does not support reactive operations");
        }
        ReactiveCapableRepository reactiveCapableRepository = (ReactiveCapableRepository)operations;
        this.reactiveOperations = reactiveCapableRepository.reactive();
        ReactiveRepositoryOperations reactiveRepositoryOperations = this.reactiveOperations;
        if (reactiveRepositoryOperations instanceof ReactiveCriteriaRepositoryOperations) {
            ReactiveCriteriaRepositoryOperations reactiveCriteriaRepositoryOperations;
            this.reactiveCriteriaOperations = reactiveCriteriaRepositoryOperations = (ReactiveCriteriaRepositoryOperations)reactiveRepositoryOperations;
        } else if (operations instanceof ReactiveCriteriaRepositoryOperations) {
            ReactiveCriteriaRepositoryOperations reactiveCriteriaRepositoryOperations;
            this.reactiveCriteriaOperations = reactiveCriteriaRepositoryOperations = (ReactiveCriteriaRepositoryOperations)operations;
        } else if (operations instanceof ReactiveCriteriaCapableRepository) {
            ReactiveCriteriaCapableRepository repository = (ReactiveCriteriaCapableRepository)operations;
            this.reactiveCriteriaOperations = repository.reactive();
        } else {
            this.reactiveCriteriaOperations = null;
        }
    }

    final ReactiveCriteriaRepositoryOperations getReactiveCriteriaOperations(RepositoryMethodKey methodKey, MethodInvocationContext<?, ?> context, Pageable pageable) {
        if (this.reactiveCriteriaOperations != null) {
            return this.reactiveCriteriaOperations;
        }
        QueryBuilder sqlQueryBuilder = this.getQueryBuilder(methodKey, context);
        return new PreparedQueryReactiveCriteriaRepositoryOperations(this.criteriaBuilder, this.reactiveOperations, this.operations, context, sqlQueryBuilder, this.getRequiredRootEntity(context), pageable);
    }

    @NonNull
    protected final Publisher<Object> findAllReactive(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context) {
        CriteriaQuery criteriaQuery = this.buildQuery(methodKey, context);
        Pageable pageable = this.applyPaginationAndSort(this.getPageable(context), criteriaQuery, false);
        if (this.reactiveCriteriaOperations != null) {
            if (pageable != null && !pageable.isUnpaged()) {
                if (pageable.getMode() != Pageable.Mode.OFFSET) {
                    throw new UnsupportedOperationException("Pageable mode " + String.valueOf(pageable.getMode()) + " is not supported by hibernate operations");
                }
                return this.reactiveCriteriaOperations.findAll(criteriaQuery, (int)pageable.getOffset(), pageable.getSize());
            }
            int offset = this.getOffset(context);
            int limit = this.getLimit(context);
            if (offset > 0 || limit > 0) {
                return this.reactiveCriteriaOperations.findAll(criteriaQuery, offset, limit);
            }
            return this.reactiveCriteriaOperations.findAll(criteriaQuery);
        }
        return this.getReactiveCriteriaOperations(methodKey, context, pageable).findAll(criteriaQuery);
    }
}

