/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.event.listeners;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.data.event.EntityEventContext;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
final class AutoPopulateUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AutoPopulateUtil.class);

    private AutoPopulateUtil() {
    }

    static void applyTopLevel(EntityEventContext<Object> context, RuntimePersistentProperty<Object>[] properties, Function<RuntimePersistentProperty<Object>, Object> supplier) {
        for (RuntimePersistentProperty<Object> property : properties) {
            Object value = supplier.apply(property);
            if (value == null) continue;
            BeanProperty beanProperty = property.getProperty();
            context.setProperty(beanProperty, value);
        }
    }

    static void applyEmbedded(@NonNull EntityEventContext<Object> context, BiFunction<RuntimePersistentProperty<Object>, Object, Object> propertySetter) {
        RuntimePersistentEntity persistentEntity = context.getPersistentEntity();
        Object rootEntity = context.getEntity();
        for (RuntimeAssociation association : persistentEntity.getAssociations()) {
            if (!association.isEmbedded()) continue;
            BeanProperty embeddedProperty = association.getProperty();
            Object embedded = embeddedProperty.get(rootEntity);
            if (embedded == null) {
                try {
                    embedded = association.getAssociatedEntity().getIntrospection().instantiate();
                }
                catch (Exception e) {
                    LOG.warn("Unable to instantiate embedded property: {}", (Object)embeddedProperty.getName(), (Object)e);
                    continue;
                }
            }
            Object updated = AutoPopulateUtil.populateEmbedded(association.getAssociatedEntity(), embedded, propertySetter);
            context.setProperty(embeddedProperty, updated);
        }
    }

    static Object populateEmbedded(@NonNull RuntimePersistentEntity<?> embeddedEntity, @NonNull Object instance, BiFunction<RuntimePersistentProperty<Object>, Object, Object> propertySetter) {
        Object current = instance;
        for (RuntimePersistentProperty p : embeddedEntity.getPersistentProperties()) {
            current = propertySetter.apply((RuntimePersistentProperty<Object>)p, current);
        }
        for (RuntimeAssociation nested : embeddedEntity.getAssociations()) {
            if (!nested.isEmbedded()) continue;
            BeanProperty ep = nested.getProperty();
            Object child = ep.get(current);
            if (child == null) {
                try {
                    child = nested.getAssociatedEntity().getIntrospection().instantiate();
                }
                catch (Exception e) {
                    LOG.warn("Unable to instantiate embedded property: {}", (Object)ep.getName(), (Object)e);
                    continue;
                }
            }
            Object updatedChild = AutoPopulateUtil.populateEmbedded(nested.getAssociatedEntity(), child, propertySetter);
            if (ep.isReadOnly()) {
                current = ep.withValue(current, updatedChild);
                continue;
            }
            ep.set(current, updatedChild);
        }
        return current;
    }
}

