/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.criteria.metamodel;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.criteria.metamodel.RuntimePersistentPropertyAttribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;

@Internal
final class RuntimePersistentPropertySingularAttribute<T>
extends RuntimePersistentPropertyAttribute<T, Object>
implements SingularAttribute<T, Object> {
    private final RuntimePersistentEntity<T> persistentEntity;

    public RuntimePersistentPropertySingularAttribute(RuntimePersistentEntity<T> persistentEntity, RuntimePersistentProperty<T> persistentProperty) {
        super(persistentProperty);
        this.persistentEntity = persistentEntity;
    }

    public boolean isId() {
        return this.persistentEntity.getIdentity() == this.persistentProperty;
    }

    public boolean isVersion() {
        return this.persistentEntity.getVersion() == this.persistentProperty;
    }

    public boolean isOptional() {
        return this.persistentProperty.isOptional();
    }

    public Type<Object> getType() {
        throw this.notSupportedOperation();
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.SINGULAR_ATTRIBUTE;
    }

    public Class<Object> getBindableJavaType() {
        return this.persistentProperty.getType();
    }
}

