/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.ReturnType;
import io.micronaut.data.intercept.ProcedureReturningOneInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import java.util.List;
import java.util.Optional;

@Internal
public final class DefaultProcedureReturningOneInterceptor<T, R>
extends AbstractQueryInterceptor<T, R>
implements ProcedureReturningOneInterceptor<T, R> {
    DefaultProcedureReturningOneInterceptor(RepositoryOperations datastore) {
        super(datastore);
    }

    public R intercept(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context) {
        PreparedQuery preparedQuery = this.prepareQuery(methodKey, context);
        List results = this.operations.execute(preparedQuery);
        ReturnType returnType = context.getReturnType();
        if (returnType.isVoid()) {
            return null;
        }
        if (returnType.isOptional()) {
            if (results.isEmpty()) {
                return (R)Optional.empty();
            }
            return (R)Optional.ofNullable(this.convertOne(context, results.get(0)));
        }
        if (results.isEmpty()) {
            return null;
        }
        return (R)this.convertOne(context, results.get(0));
    }
}

