/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.convert;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.type.Argument;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.convert.DataConversionServiceImpl;
import io.micronaut.data.runtime.convert.DataTypeConverter;
import jakarta.inject.Singleton;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;

@Internal
@Factory
final class DataConversionServiceFactory {
    private static final String SQL_ARRAY_READ_ERROR = "Unable to read SQL array";

    DataConversionServiceFactory() {
    }

    @Singleton
    @Bean(typed={DataConversionService.class})
    DataConversionServiceImpl build(@NonNull BeanContext beanContext) {
        DataConversionServiceImpl conversionService = new DataConversionServiceImpl(beanContext.getConversionService());
        conversionService.addConverter(Enum.class, Number.class, Enum::ordinal);
        conversionService.addConverter(Number.class, Enum.class, (index, targetType, context) -> {
            Enum[] enumConstants = (Enum[])targetType.getEnumConstants();
            int i = index.intValue();
            if (i >= enumConstants.length) {
                throw new IllegalStateException("Cannot find an enum value at index: " + i + " for enum: " + targetType);
            }
            return Optional.of(enumConstants[i]);
        });
        conversionService.addConverter(Number.class, Character.class, number -> Character.valueOf((char)number.intValue()));
        conversionService.addConverter(byte[].class, UUID.class, UUID::nameUUIDFromBytes);
        conversionService.addConverter(java.util.Date.class, LocalDate.class, date -> Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate());
        conversionService.addConverter(ChronoLocalDate.class, java.util.Date.class, localDate -> new java.util.Date(localDate.atTime(LocalTime.MIDNIGHT).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()));
        conversionService.addConverter(String[].class, Character[].class, values -> {
            Character[] chars = new Character[((String[])values).length];
            for (int i = 0; i < ((String[])values).length; ++i) {
                String value = values[i];
                chars[i] = Character.valueOf(value.length() == 0 ? (char)'\u0000' : value.charAt(0));
            }
            return chars;
        });
        conversionService.addConverter(String[].class, char[].class, values -> {
            char[] chars = new char[((String[])values).length];
            for (int i = 0; i < ((String[])values).length; ++i) {
                String value = values[i];
                chars[i] = value.length() == 0 ? (char)'\u0000' : value.charAt(0);
            }
            return chars;
        });
        conversionService.addConverter(Character[].class, String[].class, values -> {
            String[] strings = new String[((Character[])values).length];
            for (int i = 0; i < ((Character[])values).length; ++i) {
                strings[i] = values[i].toString();
            }
            return strings;
        });
        conversionService.addConverter(char[].class, String[].class, values -> {
            String[] strings = new String[((char[])values).length];
            for (int i = 0; i < ((char[])values).length; ++i) {
                strings[i] = String.valueOf(values[i]);
            }
            return strings;
        });
        conversionService.addConverter(Collection.class, Character[].class, collection -> {
            Character[] chars = new Character[collection.size()];
            int i = 0;
            for (Object value : collection) {
                chars[i++] = this.asCharacter(value, conversionService);
            }
            return chars;
        });
        conversionService.addConverter(Collection.class, char[].class, collection -> {
            char[] chars = new char[collection.size()];
            int i = 0;
            for (Object value : collection) {
                chars[i++] = this.asCharacter(value, conversionService).charValue();
            }
            return chars;
        });
        conversionService.addConverter(Character[].class, char[].class, values -> {
            char[] chars = new char[((Character[])values).length];
            for (int i = 0; i < ((Character[])values).length; ++i) {
                chars[i] = values[i].charValue();
            }
            return chars;
        });
        conversionService.addConverter(char[].class, Character[].class, values -> {
            Character[] chars = new Character[((char[])values).length];
            for (int i = 0; i < ((char[])values).length; ++i) {
                chars[i] = Character.valueOf(values[i]);
            }
            return chars;
        });
        conversionService.addConverter(Collection.class, Short[].class, collection -> {
            Short[] shorts = new Short[collection.size()];
            int i = 0;
            for (Object value : collection) {
                shorts[i++] = this.asShort(value, conversionService);
            }
            return shorts;
        });
        conversionService.addConverter(Collection.class, short[].class, collection -> {
            short[] shorts = new short[collection.size()];
            int i = 0;
            for (Object value : collection) {
                shorts[i++] = this.asShort(value, conversionService);
            }
            return shorts;
        });
        conversionService.addConverter(Short[].class, short[].class, values -> {
            short[] shorts = new short[((Short[])values).length];
            for (int i = 0; i < ((Short[])values).length; ++i) {
                shorts[i] = values[i];
            }
            return shorts;
        });
        conversionService.addConverter(short[].class, Short[].class, values -> {
            Short[] shorts = new Short[((short[])values).length];
            for (int i = 0; i < ((short[])values).length; ++i) {
                shorts[i] = values[i];
            }
            return shorts;
        });
        conversionService.addConverter(Collection.class, Float[].class, collection -> {
            Float[] floats = new Float[collection.size()];
            int i = 0;
            for (Object value : collection) {
                floats[i++] = this.asFloat(value, conversionService);
            }
            return floats;
        });
        conversionService.addConverter(Collection.class, float[].class, collection -> {
            float[] floats = new float[collection.size()];
            int i = 0;
            for (Object value : collection) {
                floats[i++] = this.asFloat(value, conversionService).floatValue();
            }
            return floats;
        });
        conversionService.addConverter(Float[].class, float[].class, values -> {
            float[] floats = new float[((Float[])values).length];
            for (int i = 0; i < ((Float[])values).length; ++i) {
                floats[i] = values[i].floatValue();
            }
            return floats;
        });
        conversionService.addConverter(float[].class, Float[].class, values -> {
            Float[] floats = new Float[((float[])values).length];
            for (int i = 0; i < ((float[])values).length; ++i) {
                floats[i] = Float.valueOf(values[i]);
            }
            return floats;
        });
        conversionService.addConverter(Float[].class, BigDecimal[].class, values -> {
            BigDecimal[] bigs = new BigDecimal[((Float[])values).length];
            for (int i = 0; i < ((Float[])values).length; ++i) {
                bigs[i] = BigDecimal.valueOf(values[i].floatValue());
            }
            return bigs;
        });
        conversionService.addConverter(float[].class, BigDecimal[].class, values -> {
            BigDecimal[] bigs = new BigDecimal[((float[])values).length];
            for (int i = 0; i < ((float[])values).length; ++i) {
                bigs[i] = BigDecimal.valueOf(values[i]);
            }
            return bigs;
        });
        conversionService.addConverter(Collection.class, Integer[].class, collection -> {
            Integer[] ints = new Integer[collection.size()];
            int i = 0;
            for (Object value : collection) {
                ints[i++] = this.asInteger(value, conversionService);
            }
            return ints;
        });
        conversionService.addConverter(Collection.class, int[].class, collection -> {
            int[] ints = new int[collection.size()];
            int i = 0;
            for (Object value : collection) {
                ints[i++] = this.asInteger(value, conversionService);
            }
            return ints;
        });
        conversionService.addConverter(Integer[].class, int[].class, values -> {
            int[] ints = new int[((Integer[])values).length];
            for (int i = 0; i < ((Integer[])values).length; ++i) {
                ints[i] = values[i];
            }
            return ints;
        });
        conversionService.addConverter(int[].class, Integer[].class, values -> {
            Integer[] ints = new Integer[((int[])values).length];
            for (int i = 0; i < ((int[])values).length; ++i) {
                ints[i] = values[i];
            }
            return ints;
        });
        conversionService.addConverter(Collection.class, Long[].class, collection -> {
            Long[] longs = new Long[collection.size()];
            int i = 0;
            for (Object value : collection) {
                longs[i++] = this.asLong(value, conversionService);
            }
            return longs;
        });
        conversionService.addConverter(Collection.class, long[].class, collection -> {
            long[] longs = new long[collection.size()];
            int i = 0;
            for (Object value : collection) {
                longs[i++] = this.asLong(value, conversionService);
            }
            return longs;
        });
        conversionService.addConverter(Long[].class, long[].class, values -> {
            long[] longs = new long[((Long[])values).length];
            for (int i = 0; i < ((Long[])values).length; ++i) {
                longs[i] = values[i];
            }
            return longs;
        });
        conversionService.addConverter(long[].class, Long[].class, values -> {
            Long[] longs = new Long[((long[])values).length];
            for (int i = 0; i < ((long[])values).length; ++i) {
                longs[i] = values[i];
            }
            return longs;
        });
        conversionService.addConverter(Collection.class, Double[].class, collection -> {
            Double[] doubles = new Double[collection.size()];
            int i = 0;
            for (Object value : collection) {
                doubles[i++] = this.asDouble(value, conversionService);
            }
            return doubles;
        });
        conversionService.addConverter(Collection.class, double[].class, collection -> {
            double[] doubles = new double[collection.size()];
            int i = 0;
            for (Object value : collection) {
                doubles[i++] = this.asDouble(value, conversionService);
            }
            return doubles;
        });
        conversionService.addConverter(Double[].class, double[].class, values -> {
            double[] doubles = new double[((Double[])values).length];
            for (int i = 0; i < ((Double[])values).length; ++i) {
                doubles[i] = values[i];
            }
            return doubles;
        });
        conversionService.addConverter(double[].class, Double[].class, values -> {
            Double[] doubles = new Double[((double[])values).length];
            for (int i = 0; i < ((double[])values).length; ++i) {
                doubles[i] = values[i];
            }
            return doubles;
        });
        conversionService.addConverter(Double[].class, BigDecimal[].class, values -> {
            BigDecimal[] bigs = new BigDecimal[((Double[])values).length];
            for (int i = 0; i < ((Double[])values).length; ++i) {
                bigs[i] = BigDecimal.valueOf(values[i]);
            }
            return bigs;
        });
        conversionService.addConverter(double[].class, BigDecimal[].class, values -> {
            BigDecimal[] bigs = new BigDecimal[((double[])values).length];
            for (int i = 0; i < ((double[])values).length; ++i) {
                bigs[i] = BigDecimal.valueOf(values[i]);
            }
            return bigs;
        });
        conversionService.addConverter(Collection.class, Boolean[].class, collection -> {
            Boolean[] booleans = new Boolean[collection.size()];
            int i = 0;
            for (Object value : collection) {
                booleans[i++] = this.asBoolean(value, conversionService);
            }
            return booleans;
        });
        conversionService.addConverter(Collection.class, boolean[].class, collection -> {
            boolean[] booleans = new boolean[collection.size()];
            int i = 0;
            for (Object value : collection) {
                booleans[i++] = this.asBoolean(value, conversionService);
            }
            return booleans;
        });
        conversionService.addConverter(Boolean[].class, boolean[].class, values -> {
            boolean[] booleans = new boolean[((Boolean[])values).length];
            for (int i = 0; i < ((Boolean[])values).length; ++i) {
                booleans[i] = values[i];
            }
            return booleans;
        });
        conversionService.addConverter(boolean[].class, Boolean[].class, values -> {
            Boolean[] booleans = new Boolean[((boolean[])values).length];
            for (int i = 0; i < ((boolean[])values).length; ++i) {
                booleans[i] = values[i];
            }
            return booleans;
        });
        conversionService.addConverter(Array.class, String[].class, sqlArray -> {
            Object[] array;
            try {
                array = (Object[])sqlArray.getArray();
            }
            catch (SQLException e) {
                throw new DataAccessException(SQL_ARRAY_READ_ERROR, (Throwable)e);
            }
            String[] strings = new String[array.length];
            int i = 0;
            for (Object value : array) {
                strings[i++] = value != null ? value.toString() : null;
            }
            return strings;
        });
        conversionService.addConverter(Array.class, Integer[].class, sqlArray -> {
            Object[] array;
            try {
                array = (Object[])sqlArray.getArray();
            }
            catch (SQLException e) {
                throw new DataAccessException(SQL_ARRAY_READ_ERROR, (Throwable)e);
            }
            Integer[] integers = new Integer[array.length];
            int i = 0;
            for (Object value : array) {
                integers[i++] = this.asInteger(value, conversionService);
            }
            return integers;
        });
        conversionService.addConverter(Array.class, int[].class, sqlArray -> {
            Object[] array;
            try {
                array = (Object[])sqlArray.getArray();
            }
            catch (SQLException e) {
                throw new DataAccessException(SQL_ARRAY_READ_ERROR, (Throwable)e);
            }
            int[] ints = new int[array.length];
            int i = 0;
            for (Object value : array) {
                ints[i++] = this.asInteger(value, conversionService);
            }
            return ints;
        });
        conversionService.addConverter(Array.class, Short[].class, sqlArray -> {
            Object[] array;
            try {
                array = (Object[])sqlArray.getArray();
            }
            catch (SQLException e) {
                throw new DataAccessException(SQL_ARRAY_READ_ERROR, (Throwable)e);
            }
            Short[] shorts = new Short[array.length];
            int i = 0;
            for (Object value : array) {
                shorts[i++] = this.asShort(value, conversionService);
            }
            return shorts;
        });
        conversionService.addConverter(Array.class, short[].class, sqlArray -> {
            Object[] array;
            try {
                array = (Object[])sqlArray.getArray();
            }
            catch (SQLException e) {
                throw new DataAccessException(SQL_ARRAY_READ_ERROR, (Throwable)e);
            }
            short[] shorts = new short[array.length];
            int i = 0;
            for (Object value : array) {
                shorts[i++] = this.asShort(value, conversionService);
            }
            return shorts;
        });
        conversionService.addConverter(Array.class, Long[].class, sqlArray -> {
            Object[] array;
            try {
                array = (Object[])sqlArray.getArray();
            }
            catch (SQLException e) {
                throw new DataAccessException(SQL_ARRAY_READ_ERROR, (Throwable)e);
            }
            Long[] longs = new Long[array.length];
            int i = 0;
            for (Object value : array) {
                longs[i++] = this.asLong(value, conversionService);
            }
            return longs;
        });
        conversionService.addConverter(Array.class, long[].class, sqlArray -> {
            Object[] array;
            try {
                array = (Object[])sqlArray.getArray();
            }
            catch (SQLException e) {
                throw new DataAccessException(SQL_ARRAY_READ_ERROR, (Throwable)e);
            }
            long[] longs = new long[array.length];
            int i = 0;
            for (Object value : array) {
                longs[i++] = this.asLong(value, conversionService);
            }
            return longs;
        });
        conversionService.addConverter(Array.class, Float[].class, sqlArray -> {
            Object[] array;
            try {
                array = (Object[])sqlArray.getArray();
            }
            catch (SQLException e) {
                throw new DataAccessException(SQL_ARRAY_READ_ERROR, (Throwable)e);
            }
            Float[] floats = new Float[array.length];
            int i = 0;
            for (Object value : array) {
                floats[i++] = this.asFloat(value, conversionService);
            }
            return floats;
        });
        conversionService.addConverter(Array.class, float[].class, sqlArray -> {
            Object[] array;
            try {
                array = (Object[])sqlArray.getArray();
            }
            catch (SQLException e) {
                throw new DataAccessException(SQL_ARRAY_READ_ERROR, (Throwable)e);
            }
            float[] floats = new float[array.length];
            int i = 0;
            for (Object value : array) {
                floats[i++] = this.asFloat(value, conversionService).floatValue();
            }
            return floats;
        });
        conversionService.addConverter(Array.class, Double[].class, sqlArray -> {
            Object[] array;
            try {
                array = (Object[])sqlArray.getArray();
            }
            catch (SQLException e) {
                throw new DataAccessException(SQL_ARRAY_READ_ERROR, (Throwable)e);
            }
            Double[] doubles = new Double[array.length];
            int i = 0;
            for (Object value : array) {
                doubles[i++] = this.asDouble(value, conversionService);
            }
            return doubles;
        });
        conversionService.addConverter(Array.class, double[].class, sqlArray -> {
            Object[] array;
            try {
                array = (Object[])sqlArray.getArray();
            }
            catch (SQLException e) {
                throw new DataAccessException(SQL_ARRAY_READ_ERROR, (Throwable)e);
            }
            double[] doubles = new double[array.length];
            int i = 0;
            for (Object value : array) {
                doubles[i++] = this.asDouble(value, conversionService);
            }
            return doubles;
        });
        conversionService.addConverter(Array.class, Boolean[].class, sqlArray -> {
            Object[] array;
            try {
                array = (Object[])sqlArray.getArray();
            }
            catch (SQLException e) {
                throw new DataAccessException(SQL_ARRAY_READ_ERROR, (Throwable)e);
            }
            Boolean[] booleans = new Boolean[array.length];
            int i = 0;
            for (Object value : array) {
                booleans[i++] = this.asBoolean(value, conversionService);
            }
            return booleans;
        });
        conversionService.addConverter(Array.class, boolean[].class, sqlArray -> {
            Object[] array;
            try {
                array = (Object[])sqlArray.getArray();
            }
            catch (SQLException e) {
                throw new DataAccessException(SQL_ARRAY_READ_ERROR, (Throwable)e);
            }
            boolean[] booleans = new boolean[array.length];
            int i = 0;
            for (Object value : array) {
                booleans[i++] = this.asBoolean(value, conversionService);
            }
            return booleans;
        });
        conversionService.addConverter(Array.class, Character[].class, sqlArray -> {
            Object[] array;
            try {
                array = (Object[])sqlArray.getArray();
            }
            catch (SQLException e) {
                throw new DataAccessException(SQL_ARRAY_READ_ERROR, (Throwable)e);
            }
            Character[] characters = new Character[array.length];
            int i = 0;
            for (Object value : array) {
                characters[i++] = this.asCharacter(value, conversionService);
            }
            return characters;
        });
        conversionService.addConverter(Array.class, char[].class, sqlArray -> {
            Object[] array;
            try {
                array = (Object[])sqlArray.getArray();
            }
            catch (SQLException e) {
                throw new DataAccessException(SQL_ARRAY_READ_ERROR, (Throwable)e);
            }
            char[] chars = new char[array.length];
            int i = 0;
            for (Object value : array) {
                chars[i++] = this.asCharacter(value, conversionService).charValue();
            }
            return chars;
        });
        conversionService.addConverter(Object[].class, short[].class, array -> {
            short[] shorts = new short[((Object[])array).length];
            int i = 0;
            for (Object value : array) {
                shorts[i++] = this.asShort(value, conversionService);
            }
            return shorts;
        });
        conversionService.addConverter(Object[].class, int[].class, array -> {
            int[] ints = new int[((Object[])array).length];
            int i = 0;
            for (Object value : array) {
                ints[i++] = this.asInteger(value, conversionService);
            }
            return ints;
        });
        conversionService.addConverter(Object[].class, long[].class, array -> {
            long[] longs = new long[((Object[])array).length];
            int i = 0;
            for (Object value : array) {
                longs[i++] = this.asLong(value, conversionService);
            }
            return longs;
        });
        conversionService.addConverter(Object[].class, float[].class, array -> {
            float[] floats = new float[((Object[])array).length];
            int i = 0;
            for (Object value : array) {
                floats[i++] = this.asFloat(value, conversionService).floatValue();
            }
            return floats;
        });
        conversionService.addConverter(Object[].class, double[].class, array -> {
            double[] doubles = new double[((Object[])array).length];
            int i = 0;
            for (Object value : array) {
                doubles[i++] = this.asDouble(value, conversionService);
            }
            return doubles;
        });
        conversionService.addConverter(Object[].class, boolean[].class, array -> {
            boolean[] booleans = new boolean[((Object[])array).length];
            int i = 0;
            for (Object value : array) {
                booleans[i++] = this.asBoolean(value, conversionService);
            }
            return booleans;
        });
        conversionService.addConverter(Object[].class, char[].class, array -> {
            char[] chars = new char[((Object[])array).length];
            int i = 0;
            for (Object value : array) {
                chars[i++] = this.asCharacter(value, conversionService).charValue();
            }
            return chars;
        });
        Function<Instant, ZonedDateTime> instantToZonedDateTime = instant -> instant.atZone(ZoneId.systemDefault());
        this.addZonedConvertorsConvertors(conversionService, Instant.class, instantToZonedDateTime);
        this.addZonedConvertorsConvertors(conversionService, ZonedDateTime.class, Function.identity());
        conversionService.addConverter(LocalDate.class, Date.class, Date::valueOf);
        conversionService.addConverter(LocalTime.class, Timestamp.class, localTime -> Timestamp.valueOf(localTime.atDate(LocalDate.now())));
        conversionService.addConverter(LocalTime.class, Instant.class, localTime -> localTime.atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant());
        conversionService.addConverter(LocalTime.class, Time.class, Time::valueOf);
        conversionService.addConverter(LocalDateTime.class, java.util.Date.class, localDateTime -> java.util.Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant()));
        conversionService.addConverter(LocalDateTime.class, Instant.class, localDateTime -> localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        conversionService.addConverter(LocalDateTime.class, Timestamp.class, Timestamp::valueOf);
        conversionService.addConverter(LocalDateTime.class, LocalDate.class, LocalDateTime::toLocalDate);
        conversionService.addConverter(LocalDateTime.class, LocalTime.class, LocalDateTime::toLocalTime);
        conversionService.addConverter(LocalDateTime.class, ZonedDateTime.class, localDateTime -> localDateTime.atZone(ZoneId.systemDefault()));
        conversionService.addConverter(LocalDateTime.class, Time.class, localDateTime -> Time.valueOf(localDateTime.toLocalTime()));
        conversionService.addConverter(OffsetDateTime.class, java.util.Date.class, offsetDateTime -> java.util.Date.from(offsetDateTime.toInstant()));
        conversionService.addConverter(OffsetDateTime.class, Date.class, offsetDateTime -> new Date(offsetDateTime.toInstant().toEpochMilli()));
        conversionService.addConverter(OffsetDateTime.class, Timestamp.class, offsetDateTime -> Timestamp.from(offsetDateTime.toInstant()));
        conversionService.addConverter(OffsetDateTime.class, Instant.class, OffsetDateTime::toInstant);
        conversionService.addConverter(OffsetDateTime.class, LocalDate.class, OffsetDateTime::toLocalDate);
        conversionService.addConverter(OffsetDateTime.class, LocalDateTime.class, OffsetDateTime::toLocalDateTime);
        conversionService.addConverter(OffsetDateTime.class, ZonedDateTime.class, OffsetDateTime::toZonedDateTime);
        conversionService.addConverter(OffsetDateTime.class, Long.class, offsetDateTime -> offsetDateTime.toInstant().toEpochMilli());
        this.addZonedConvertorsConvertors(conversionService, java.util.Date.class, date -> (ZonedDateTime)instantToZonedDateTime.apply(Instant.ofEpochMilli(date.getTime())));
        this.addZonedConvertorsConvertors(conversionService, Date.class, date -> (ZonedDateTime)instantToZonedDateTime.apply(Instant.ofEpochMilli(date.getTime())));
        this.addZonedConvertorsConvertors(conversionService, Timestamp.class, timestamp -> (ZonedDateTime)instantToZonedDateTime.apply(timestamp.toInstant()));
        if (beanContext != null) {
            Collection typeConverters = beanContext.getBeanRegistrations(DataTypeConverter.class);
            for (BeanRegistration typeConverterRegistration : typeConverters) {
                TypeConverter typeConverter = (TypeConverter)typeConverterRegistration.getBean();
                List typeArguments = typeConverterRegistration.getBeanDefinition().getTypeArguments(TypeConverter.class);
                if (typeArguments.size() != 2) continue;
                Class source = ((Argument)typeArguments.get(0)).getType();
                Class target = ((Argument)typeArguments.get(1)).getType();
                if (source == null || target == null || source == Object.class && target == Object.class) continue;
                conversionService.addConverter(source, target, typeConverter);
            }
            Collection registrars = beanContext.getBeansOfType(TypeConverterRegistrar.class);
            MutableConversionService mutableConversionService = conversionService.getMutableConversionService();
            for (TypeConverterRegistrar registrar : registrars) {
                registrar.register(mutableConversionService);
            }
        }
        return conversionService;
    }

    private <T> void addZonedConvertorsConvertors(DataConversionServiceImpl conversionService, Class<T> dateType, Function<T, ZonedDateTime> dateToZonedDateTime) {
        conversionService.addConverter(dateType, ZonedDateTime.class, dateToZonedDateTime);
        conversionService.addConverter(dateType, OffsetDateTime.class, dateToZonedDateTime.andThen(ZonedDateTime::toOffsetDateTime));
        conversionService.addConverter(dateType, LocalDateTime.class, dateToZonedDateTime.andThen(ZonedDateTime::toLocalDateTime));
        conversionService.addConverter(dateType, LocalDate.class, dateToZonedDateTime.andThen(ZonedDateTime::toLocalDate));
        conversionService.addConverter(dateType, LocalTime.class, dateToZonedDateTime.andThen(ZonedDateTime::toLocalTime));
        conversionService.addConverter(dateType, Instant.class, dateToZonedDateTime.andThen(ChronoZonedDateTime::toInstant));
        conversionService.addConverter(dateType, java.util.Date.class, dateToZonedDateTime.andThen(zonedDateTime -> java.util.Date.from(zonedDateTime.toInstant())));
        conversionService.addConverter(dateType, Timestamp.class, dateToZonedDateTime.andThen(zonedDateTime -> Timestamp.from(zonedDateTime.toInstant())));
    }

    private Integer asInteger(Object value, DataConversionService dataConversionService) {
        if (value instanceof Integer) {
            Integer intValue = (Integer)value;
            return intValue;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        return (Integer)dataConversionService.convertRequired(value, Integer.class);
    }

    private Long asLong(Object value, DataConversionService dataConversionService) {
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return longValue;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.longValue();
        }
        return (Long)dataConversionService.convertRequired(value, Long.class);
    }

    private Double asDouble(Object value, DataConversionService dataConversionService) {
        if (value instanceof Double) {
            Double doubleValue = (Double)value;
            return doubleValue;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        return (Double)dataConversionService.convertRequired(value, Double.class);
    }

    private Boolean asBoolean(Object value, DataConversionService dataConversionService) {
        if (value instanceof Boolean) {
            Boolean boolValue = (Boolean)value;
            return boolValue;
        }
        return (Boolean)dataConversionService.convertRequired(value, Boolean.class);
    }

    private Float asFloat(Object value, DataConversionService dataConversionService) {
        if (value instanceof Float) {
            Float floatValue = (Float)value;
            return floatValue;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return Float.valueOf(number.floatValue());
        }
        return (Float)dataConversionService.convertRequired(value, Float.class);
    }

    private Short asShort(Object value, DataConversionService dataConversionService) {
        if (value instanceof Short) {
            Short shortValue = (Short)value;
            return shortValue;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.shortValue();
        }
        return (Short)dataConversionService.convertRequired(value, Short.class);
    }

    private Character asCharacter(Object value, DataConversionService dataConversionService) {
        if (value instanceof Character) {
            Character charValue = (Character)value;
            return charValue;
        }
        return (Character)dataConversionService.convertRequired(value, Character.class);
    }
}

