/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.multitenancy.internal;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.runtime.multitenancy.DataSourceTenantResolver;
import io.micronaut.data.runtime.multitenancy.TenantResolver;
import io.micronaut.data.runtime.multitenancy.conf.DataSourceMultiTenancyEnabledCondition;
import jakarta.inject.Singleton;
import java.io.Serializable;

@Internal
@Singleton
@Requires(condition=DataSourceMultiTenancyEnabledCondition.class, beans={TenantResolver.class}, missingBeans={DataSourceTenantResolver.class})
final class DefaultDataSourceTenantResolver
implements DataSourceTenantResolver {
    private final TenantResolver tenantResolver;

    DefaultDataSourceTenantResolver(TenantResolver tenantResolver) {
        this.tenantResolver = tenantResolver;
    }

    @Override
    public String resolveTenantDataSourceName() {
        Serializable tenantId = this.tenantResolver.resolveTenantIdentifier();
        return tenantId == null ? null : tenantId.toString();
    }
}

