/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.reactive;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.reactive.ReactiveCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveRepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public abstract class AbstractReactiveInterceptor<T, R>
extends AbstractQueryInterceptor<T, R> {
    @NonNull
    protected final ReactiveRepositoryOperations reactiveOperations;

    protected AbstractReactiveInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
        if (!(operations instanceof ReactiveCapableRepository)) {
            throw new DataAccessException("Datastore of type [" + operations.getClass() + "] does not support reactive operations");
        }
        ReactiveCapableRepository reactiveCapableRepository = (ReactiveCapableRepository)operations;
        this.reactiveOperations = reactiveCapableRepository.reactive();
    }

    protected Publisher<Integer> count(Publisher<?> publisher) {
        return Flux.from(publisher).map(v -> {
            if (v instanceof Number) {
                Number number = (Number)v;
                return number.longValue();
            }
            return 1L;
        }).reduce((Object)0L, Long::sum).map(Long::intValue);
    }
}

