/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.query;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.DataAnnotationUtils;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.operations.HintsCapableRepository;
import io.micronaut.data.runtime.query.StoredQueryResolver;
import io.micronaut.data.runtime.query.internal.DefaultStoredQuery;
import io.micronaut.inject.ExecutableMethod;
import java.util.List;

@Internal
public abstract class DefaultStoredQueryResolver
implements StoredQueryResolver {
    @Override
    public <E, R> StoredQuery<E, R> resolveQuery(MethodInvocationContext<?, ?> context, Class<E> entityClass, Class<R> resultType, boolean isCount) {
        if (resultType == null) {
            resultType = context.classValue(DataMethod.NAME, "resultType").orElse(entityClass);
        }
        String query = (String)context.stringValue(Query.class).orElseThrow(() -> new IllegalStateException("No query present in method"));
        return new DefaultStoredQuery<E, R>(context.getExecutableMethod(), resultType, entityClass, query, isCount, this.getHintsCapableRepository());
    }

    @Override
    public <E, R> StoredQuery<E, R> resolveCountQuery(MethodInvocationContext<?, ?> context, Class<E> entityClass, Class<R> resultType) {
        String query = (String)context.stringValue(Query.class, "countQuery").orElseThrow(() -> new IllegalStateException("No query present in method"));
        return new DefaultStoredQuery<E, R>(context.getExecutableMethod(), resultType, entityClass, query, true, this.getHintsCapableRepository());
    }

    @Override
    public <E, QR> StoredQuery<E, QR> createStoredQuery(ExecutableMethod<?, ?> executableMethod, DataMethod.OperationType operationType, final String name, final AnnotationMetadata annotationMetadata, final Class<Object> rootEntity, final String query, String update, String[] queryParts, final List<QueryParameterBinding> queryParameters, final boolean pageable, final boolean isSingleResult) {
        if (queryParts == null) {
            queryParts = new String[]{};
        }
        final String[] finalQueryParts = queryParts;
        final boolean rawQuery = annotationMetadata.stringValue(Query.class, "rawQuery").isPresent();
        final boolean jsonEntity = DataAnnotationUtils.hasJsonEntityRepresentationAnnotation((AnnotationMetadata)annotationMetadata);
        return new StoredQuery<E, QR>(){

            public Class<E> getRootEntity() {
                return rootEntity;
            }

            public boolean hasPageable() {
                return pageable;
            }

            public String getQuery() {
                return query;
            }

            public String[] getExpandableQueryParts() {
                return finalQueryParts;
            }

            public List<QueryParameterBinding> getQueryBindings() {
                return queryParameters;
            }

            public Class<QR> getResultType() {
                return rootEntity;
            }

            public Argument<QR> getResultArgument() {
                return Argument.of(this.getResultType());
            }

            public DataType getResultDataType() {
                return DataType.ENTITY;
            }

            public boolean useNumericPlaceholders() {
                return annotationMetadata.classValue(RepositoryConfiguration.class, "queryBuilder").map(c -> c == SqlQueryBuilder.class).orElse(false);
            }

            public boolean isCount() {
                return false;
            }

            public boolean isSingleResult() {
                return isSingleResult;
            }

            public boolean hasResultConsumer() {
                return false;
            }

            public boolean isRawQuery() {
                return rawQuery;
            }

            public boolean isJsonEntity() {
                return jsonEntity;
            }

            public String getName() {
                return name;
            }
        };
    }

    @Override
    public StoredQuery<Object, Long> createCountStoredQuery(ExecutableMethod<?, ?> executableMethod, DataMethod.OperationType operationType, final String name, final AnnotationMetadata annotationMetadata, final Class<Object> rootEntity, final String query, String[] queryParts, final List<QueryParameterBinding> queryParameters) {
        if (queryParts == null) {
            queryParts = new String[]{};
        }
        final String[] finalQueryParts = queryParts;
        final boolean rawCountQuery = annotationMetadata.stringValue(Query.class, "rawCountQuery").isPresent();
        return new StoredQuery<Object, Long>(){

            public Class<Object> getRootEntity() {
                return rootEntity;
            }

            public boolean hasPageable() {
                return false;
            }

            public String getQuery() {
                return query;
            }

            public String[] getExpandableQueryParts() {
                return finalQueryParts;
            }

            public List<QueryParameterBinding> getQueryBindings() {
                return queryParameters;
            }

            public Class<Long> getResultType() {
                return Long.class;
            }

            public Argument<Long> getResultArgument() {
                return Argument.LONG;
            }

            public DataType getResultDataType() {
                return DataType.LONG;
            }

            public boolean useNumericPlaceholders() {
                return annotationMetadata.classValue(RepositoryConfiguration.class, "queryBuilder").map(c -> c == SqlQueryBuilder.class).orElse(false);
            }

            public boolean isCount() {
                return true;
            }

            public boolean isSingleResult() {
                return true;
            }

            public boolean hasResultConsumer() {
                return false;
            }

            public String getName() {
                return name;
            }

            public boolean isRawQuery() {
                return rawCountQuery;
            }
        };
    }

    protected abstract HintsCapableRepository getHintsCapableRepository();
}

