/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.mapper;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.annotation.TypeDef;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.mapper.BeanIntrospectionMapper;
import io.micronaut.data.runtime.mapper.JsonColumnReader;
import io.micronaut.data.runtime.mapper.ResultReader;

public class DTOMapper<T, S, R>
implements BeanIntrospectionMapper<S, R> {
    private final RuntimePersistentEntity<T> persistentEntity;
    private final RuntimePersistentEntity<?> dtoEntity;
    private final ResultReader<S, String> resultReader;
    @Nullable
    private final JsonColumnReader<S> jsonColumnReader;
    private final DataConversionService conversionService;

    public DTOMapper(RuntimePersistentEntity<T> persistentEntity, ResultReader<S, String> resultReader, DataConversionService conversionService) {
        this(persistentEntity, resultReader, null, conversionService);
    }

    public DTOMapper(RuntimePersistentEntity<T> persistentEntity, ResultReader<S, String> resultReader, @Nullable JsonColumnReader<S> jsonColumnReader, DataConversionService conversionService) {
        this(persistentEntity, persistentEntity, resultReader, jsonColumnReader, conversionService);
    }

    public DTOMapper(RuntimePersistentEntity<T> persistentEntity, RuntimePersistentEntity<?> dtoEntity, ResultReader<S, String> resultReader, @Nullable JsonColumnReader<S> jsonColumnReader, DataConversionService conversionService) {
        this.conversionService = conversionService;
        ArgumentUtils.requireNonNull((String)"persistentEntity", persistentEntity);
        ArgumentUtils.requireNonNull((String)"resultReader", resultReader);
        this.persistentEntity = persistentEntity;
        this.dtoEntity = dtoEntity;
        this.resultReader = resultReader;
        this.jsonColumnReader = jsonColumnReader;
    }

    @Override
    public DataConversionService getConversionService() {
        return this.conversionService;
    }

    @Override
    @Nullable
    public Object read(@NonNull S object, @NonNull String name) throws ConversionErrorException {
        RuntimePersistentProperty pp = this.persistentEntity.getPropertyByName(name);
        if (pp == null && this.persistentEntity == this.dtoEntity) {
            throw new DataAccessException("DTO projection defines a property [" + name + "] that doesn't exist on root entity: " + this.persistentEntity.getName());
        }
        pp = this.dtoEntity.getPropertyByName(name);
        if (pp == null) {
            throw new DataAccessException("DTO projection doesn't define a property [" + name + "] on DTO entity: " + this.dtoEntity.getName());
        }
        return this.read(object, pp);
    }

    @Override
    @Nullable
    public Object read(@NonNull S object, @NonNull Argument<?> argument) {
        String name = argument.getName();
        RuntimePersistentProperty pp = this.persistentEntity.getPropertyByName(name);
        if (pp == null) {
            RuntimePersistentProperty rp;
            if (this.persistentEntity != this.dtoEntity && (rp = this.dtoEntity.getPropertyByName(name)) != null) {
                return this.read(object, rp);
            }
            DataType type = argument.getAnnotationMetadata().enumValue(TypeDef.class, "type", DataType.class).orElseGet(() -> DataType.forType((Class)argument.getType()));
            return this.read(object, name, type);
        }
        return this.read(object, pp);
    }

    @Override
    @Nullable
    public Object read(@NonNull S resultSet, @NonNull RuntimePersistentProperty<?> property) {
        String propertyName = property.getPersistedName();
        DataType dataType = property.getDataType();
        String aliasPropertyName = property.getAnnotationMetadata().stringValue(MappedProperty.class, "alias").orElse("");
        if (StringUtils.isNotEmpty((CharSequence)aliasPropertyName)) {
            propertyName = aliasPropertyName;
        }
        if (dataType == DataType.JSON && this.jsonColumnReader != null) {
            JsonDataType jsonDataType = property.getJsonDataType();
            return this.jsonColumnReader.readJsonColumn(this.resultReader, resultSet, propertyName, jsonDataType, property.getArgument());
        }
        return this.read(resultSet, propertyName, dataType);
    }

    @Nullable
    public Object read(@NonNull S resultSet, @NonNull String persistedName, @NonNull DataType dataType) {
        return this.resultReader.readDynamic(resultSet, persistedName, dataType);
    }

    public PersistentEntity getPersistentEntity() {
        return this.persistentEntity;
    }

    public ResultReader<S, String> getResultReader() {
        return this.resultReader;
    }
}

