/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.criteria;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.AbstractCriteriaBuilder;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaUpdate;
import io.micronaut.data.model.jpa.criteria.impl.LiteralExpression;
import io.micronaut.data.model.jpa.criteria.impl.query.QueryModelPredicateVisitor;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.runtime.criteria.LiteralsAsParametersQueryModelPredicateVisitor;
import io.micronaut.data.runtime.criteria.RuntimePersistentEntityRoot;
import io.micronaut.data.runtime.criteria.metamodel.StaticMetamodelInitializer;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.ParameterExpression;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@Internal
final class RuntimePersistentEntityCriteriaUpdate<T>
extends AbstractPersistentEntityCriteriaUpdate<T> {
    private final AbstractCriteriaBuilder criteriaBuilder;
    private final RuntimeEntityRegistry runtimeEntityRegistry;
    private final StaticMetamodelInitializer staticMetamodelInitializer;

    public RuntimePersistentEntityCriteriaUpdate(AbstractCriteriaBuilder criteriaBuilder, Class<T> root, RuntimeEntityRegistry runtimeEntityRegistry, StaticMetamodelInitializer staticMetamodelInitializer) {
        this.criteriaBuilder = criteriaBuilder;
        this.runtimeEntityRegistry = runtimeEntityRegistry;
        this.staticMetamodelInitializer = staticMetamodelInitializer;
        this.from(root);
    }

    public PersistentEntityRoot<T> from(Class<T> entityClass) {
        return this.from((PersistentEntity)this.runtimeEntityRegistry.getEntity(entityClass));
    }

    public PersistentEntityRoot<T> from(PersistentEntity persistentEntity) {
        RuntimePersistentEntityRoot newEntityRoot;
        RuntimePersistentEntity runtimePersistentEntity = (RuntimePersistentEntity)persistentEntity;
        if (this.entityRoot != null && !this.entityRoot.getJavaType().equals(runtimePersistentEntity.getIntrospection().getBeanType())) {
            throw new IllegalStateException("The root entity is already specified!");
        }
        this.staticMetamodelInitializer.initializeMetadata(runtimePersistentEntity);
        this.entityRoot = newEntityRoot = new RuntimePersistentEntityRoot(runtimePersistentEntity);
        return newEntityRoot;
    }

    protected void setValue(String attributeName, Object value) {
        super.setValue(attributeName, this.asParameter(value));
    }

    @NotNull
    private ParameterExpression<?> asParameter(Object exp) {
        Object value;
        Class<?> type;
        if (exp instanceof ParameterExpression) {
            return (ParameterExpression)exp;
        }
        Objects.requireNonNull(exp);
        if (exp instanceof LiteralExpression) {
            LiteralExpression literalExpression = (LiteralExpression)exp;
            type = literalExpression.getJavaType();
            value = literalExpression.getValue();
        } else {
            if (exp instanceof Expression) {
                throw new IllegalStateException("Unexpected expression!");
            }
            type = exp.getClass();
            value = exp;
        }
        return this.criteriaBuilder.parameter(type, null, value);
    }

    protected QueryModelPredicateVisitor createPredicateVisitor(QueryModel queryModel) {
        return new LiteralsAsParametersQueryModelPredicateVisitor(this.criteriaBuilder, queryModel);
    }
}

