/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.criteria;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.jpa.criteria.PersistentAssociationPath;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityJoinSupport;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.runtime.criteria.RuntimePersistentAssociationPath;
import io.micronaut.data.runtime.criteria.RuntimePersistentCollectionAssociationPath;
import io.micronaut.data.runtime.criteria.RuntimePersistentListAssociationPath;
import io.micronaut.data.runtime.criteria.RuntimePersistentSetAssociationPath;
import jakarta.persistence.criteria.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@Internal
abstract class AbstractRuntimePersistentEntityJoinSupport<T, J>
extends AbstractPersistentEntityJoinSupport<T, J> {
    AbstractRuntimePersistentEntityJoinSupport() {
    }

    protected abstract List<Association> getCurrentPath();

    protected <X, Y> PersistentAssociationPath<X, Y> createJoinAssociation(Association association, Join.Type associationJoinType, String alias) {
        Class type = ((RuntimeAssociation)association).getProperty().getType();
        if (List.class.isAssignableFrom(type)) {
            return new RuntimePersistentListAssociationPath((Path<?>)this, (RuntimeAssociation)association, this.getCurrentPath(), associationJoinType, alias);
        }
        if (Set.class.isAssignableFrom(type)) {
            return new RuntimePersistentSetAssociationPath((Path<?>)this, (RuntimeAssociation)association, this.getCurrentPath(), associationJoinType, alias);
        }
        if (Collection.class.isAssignableFrom(type)) {
            return new RuntimePersistentCollectionAssociationPath((Path<?>)this, (RuntimeAssociation)association, this.getCurrentPath(), associationJoinType, alias);
        }
        return new RuntimePersistentAssociationPath((Path<?>)this, (RuntimeAssociation)association, this.getCurrentPath(), associationJoinType, alias);
    }
}

