/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal.sql;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.operations.internal.query.DefaultBindableParametersPreparedQuery;
import io.micronaut.data.runtime.operations.internal.query.DummyPreparedQuery;
import io.micronaut.data.runtime.operations.internal.sql.SqlPreparedQuery;
import io.micronaut.data.runtime.operations.internal.sql.SqlStoredQuery;
import io.micronaut.data.runtime.query.internal.DelegatePreparedQuery;
import io.micronaut.data.runtime.query.internal.DelegateStoredQuery;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

@Internal
public final class DefaultSqlPreparedQuery<E, R>
extends DefaultBindableParametersPreparedQuery<E, R>
implements SqlPreparedQuery<E, R>,
DelegatePreparedQuery<E, R> {
    private final SqlStoredQuery<E, R> sqlStoredQuery;
    private String query;

    public DefaultSqlPreparedQuery(PreparedQuery<E, R> preparedQuery) {
        this(preparedQuery, (SqlStoredQuery)((DelegateStoredQuery)preparedQuery).getStoredQueryDelegate());
    }

    public DefaultSqlPreparedQuery(PreparedQuery<E, R> preparedQuery, SqlStoredQuery<E, R> sqlStoredQuery) {
        super(preparedQuery);
        this.sqlStoredQuery = sqlStoredQuery;
        this.query = sqlStoredQuery.getQuery();
    }

    public DefaultSqlPreparedQuery(SqlStoredQuery<E, R> sqlStoredQuery) {
        super(new DummyPreparedQuery<E, R>(sqlStoredQuery), null, sqlStoredQuery);
        this.sqlStoredQuery = sqlStoredQuery;
        this.query = sqlStoredQuery.getQuery();
    }

    @Override
    public RuntimePersistentEntity<E> getPersistentEntity() {
        return this.sqlStoredQuery.getPersistentEntity();
    }

    @Override
    public PreparedQuery<E, R> getPreparedQueryDelegate() {
        return this.preparedQuery;
    }

    @Override
    public boolean isExpandableQuery() {
        return this.sqlStoredQuery.isExpandableQuery();
    }

    @Override
    public Dialect getDialect() {
        return this.sqlStoredQuery.getDialect();
    }

    @Override
    public SqlQueryBuilder getQueryBuilder() {
        return this.sqlStoredQuery.getQueryBuilder();
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public Map<QueryParameterBinding, Object> collectAutoPopulatedPreviousValues(E entity) {
        return this.sqlStoredQuery.collectAutoPopulatedPreviousValues(entity);
    }

    @Override
    public void prepare(E entity) {
        if (this.isExpandableQuery()) {
            SqlQueryBuilder queryBuilder = this.sqlStoredQuery.getQueryBuilder();
            String positionalParameterFormat = queryBuilder.positionalParameterFormat();
            StringBuilder q = new StringBuilder(this.sqlStoredQuery.getExpandableQueryParts()[0]);
            int queryParamIndex = 1;
            int inx = 1;
            for (QueryParameterBinding parameter : this.sqlStoredQuery.getQueryBindings()) {
                if (!parameter.isExpandable()) {
                    q.append(String.format(positionalParameterFormat, inx++));
                } else {
                    int size = Math.max(1, this.getQueryParameterValueSize(parameter));
                    for (int k = 0; k < size; ++k) {
                        q.append(String.format(positionalParameterFormat, inx++));
                        if (k + 1 == size) continue;
                        q.append(",");
                    }
                }
                q.append(this.sqlStoredQuery.getExpandableQueryParts()[queryParamIndex++]);
            }
            this.query = q.toString();
        }
    }

    private int getQueryParameterValueSize(QueryParameterBinding parameter) {
        int parameterIndex = parameter.getParameterIndex();
        Object value = parameterIndex == -1 ? parameter.getValue() : this.preparedQuery.getParameterArray()[parameterIndex];
        return this.sizeOf(value);
    }

    @Override
    public void attachPageable(Pageable pageable, boolean isSingleResult) {
        if (pageable != Pageable.UNPAGED) {
            RuntimePersistentEntity<E> persistentEntity = this.getPersistentEntity();
            SqlQueryBuilder queryBuilder = this.sqlStoredQuery.getQueryBuilder();
            StringBuilder added = new StringBuilder();
            Sort sort = pageable.getSort();
            if (sort.isSorted()) {
                added.append(queryBuilder.buildOrderBy(persistentEntity, sort).getQuery());
            } else if (this.isSqlServerWithoutOrderBy(this.query, this.sqlStoredQuery.getDialect())) {
                sort = this.sortById(persistentEntity);
                added.append(queryBuilder.buildOrderBy(persistentEntity, sort).getQuery());
            }
            if (isSingleResult && pageable.getOffset() > 0L) {
                pageable = Pageable.from((int)pageable.getNumber(), (int)1);
            }
            added.append(queryBuilder.buildPagination(pageable).getQuery());
            int forUpdateIndex = this.query.lastIndexOf(" FOR UPDATE");
            if (forUpdateIndex == -1) {
                forUpdateIndex = this.query.lastIndexOf(" WITH (UPDLOCK, ROWLOCK)");
            }
            this.query = forUpdateIndex > -1 ? this.query.substring(0, forUpdateIndex) + added + this.query.substring(forUpdateIndex) : this.query + added;
        }
    }

    @NonNull
    private <K> Sort sortById(RuntimePersistentEntity<K> persistentEntity) {
        RuntimePersistentProperty identity = persistentEntity.getIdentity();
        if (identity == null) {
            throw new DataAccessException("Pagination requires an entity ID on SQL Server");
        }
        Sort sort = Sort.unsorted().order(Sort.Order.asc((String)identity.getName()));
        return sort;
    }

    private boolean isSqlServerWithoutOrderBy(String query, Dialect dialect) {
        return dialect == Dialect.SQL_SERVER && !query.contains(" ORDER BY ");
    }

    private int sizeOf(Object value) {
        if (value == null) {
            return 1;
        }
        if (value instanceof Collection) {
            return ((Collection)value).size();
        }
        if (value instanceof Iterable) {
            int i = 0;
            Iterator iterator = ((Iterable)value).iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++i;
            }
            return i;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value);
        }
        return 1;
    }
}

