/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.criteria.metamodel;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import java.lang.reflect.Member;

@Internal
abstract class RuntimePersistentPropertyAttribute<T, E>
implements Attribute<T, E> {
    protected final RuntimePersistentProperty<T> persistentProperty;

    public RuntimePersistentPropertyAttribute(RuntimePersistentProperty<T> persistentProperty) {
        this.persistentProperty = persistentProperty;
    }

    public String getName() {
        return this.persistentProperty.getName();
    }

    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        if (this.persistentProperty instanceof RuntimeAssociation) {
            RuntimeAssociation runtimeAssociation = (RuntimeAssociation)this.persistentProperty;
            switch (runtimeAssociation.getKind()) {
                case EMBEDDED: {
                    return Attribute.PersistentAttributeType.EMBEDDED;
                }
                case ONE_TO_ONE: {
                    return Attribute.PersistentAttributeType.ONE_TO_ONE;
                }
                case MANY_TO_ONE: {
                    return Attribute.PersistentAttributeType.MANY_TO_ONE;
                }
                case ONE_TO_MANY: {
                    return Attribute.PersistentAttributeType.ONE_TO_MANY;
                }
                case MANY_TO_MANY: {
                    return Attribute.PersistentAttributeType.MANY_TO_MANY;
                }
            }
            return Attribute.PersistentAttributeType.BASIC;
        }
        return Attribute.PersistentAttributeType.BASIC;
    }

    public ManagedType<T> getDeclaringType() {
        throw this.notSupportedOperation();
    }

    public Class<E> getJavaType() {
        return this.persistentProperty.getType();
    }

    public Member getJavaMember() {
        throw this.notSupportedOperation();
    }

    public boolean isAssociation() {
        return this.persistentProperty instanceof RuntimeAssociation;
    }

    public boolean isCollection() {
        return false;
    }

    protected IllegalStateException notSupportedOperation() {
        return new IllegalStateException("Not supported operation!");
    }
}

