/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.query.internal;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableArgumentValue;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.runtime.DefaultStoredDataOperation;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.StoredQuery;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Internal
public final class DefaultPreparedQuery<E, RT>
extends DefaultStoredDataOperation<RT>
implements PreparedQuery<E, RT> {
    private static final String DATA_METHOD_ANN_NAME = DataMethod.class.getName();
    private final Pageable pageable;
    private final StoredQuery<E, RT> storedQuery;
    private final String query;
    private final boolean dto;
    private final MethodInvocationContext<?, ?> context;
    private final ConversionService<? extends ConversionService> conversionService;

    public DefaultPreparedQuery(MethodInvocationContext<?, ?> context, StoredQuery<E, RT> storedQuery, String finalQuery, @NonNull Pageable pageable, boolean dtoProjection, ConversionService<?> conversionService) {
        super(context);
        this.context = context;
        this.query = finalQuery;
        this.storedQuery = storedQuery;
        this.pageable = pageable;
        this.dto = dtoProjection;
        this.conversionService = conversionService;
    }

    public String[] getExpandableQueryParts() {
        return this.storedQuery.getExpandableQueryParts();
    }

    public List<QueryParameterBinding> getQueryBindings() {
        return this.storedQuery.getQueryBindings();
    }

    public <RT1> Optional<RT1> getParameterInRole(@NonNull String role, @NonNull Class<RT1> type) {
        return this.context.stringValue(DATA_METHOD_ANN_NAME, role).flatMap(name -> {
            Object o;
            Object parameterValue = null;
            Map params = this.context.getParameters();
            MutableArgumentValue arg = (MutableArgumentValue)params.get(name);
            if (arg != null && (o = arg.getValue()) != null) {
                parameterValue = type.isInstance(o) ? o : this.conversionService.convert(o, type).orElse(null);
            }
            return Optional.ofNullable(parameterValue);
        });
    }

    public boolean hasResultConsumer() {
        return this.storedQuery.hasResultConsumer();
    }

    @NonNull
    public Set<JoinPath> getJoinFetchPaths() {
        return this.storedQuery.getJoinFetchPaths();
    }

    public boolean isSingleResult() {
        return this.storedQuery.isSingleResult();
    }

    @NonNull
    public Map<String, Object> getQueryHints() {
        return this.storedQuery.getQueryHints();
    }

    public Class<?> getRepositoryType() {
        return this.context.getTarget().getClass();
    }

    @NonNull
    public Map<String, Object> getParameterValues() {
        return Collections.emptyMap();
    }

    public Object[] getParameterArray() {
        return this.context.getParameterValues();
    }

    public Argument[] getArguments() {
        return this.context.getArguments();
    }

    @NonNull
    public Pageable getPageable() {
        if (this.storedQuery.isCount()) {
            return Pageable.UNPAGED;
        }
        return this.pageable;
    }

    public boolean isNative() {
        return this.storedQuery.isNative();
    }

    public boolean useNumericPlaceholders() {
        return this.storedQuery.useNumericPlaceholders();
    }

    public boolean isDtoProjection() {
        return this.dto;
    }

    @NonNull
    public Class<RT> getResultType() {
        return this.storedQuery.getResultType();
    }

    @NonNull
    public DataType getResultDataType() {
        return this.storedQuery.getResultDataType();
    }

    @Nullable
    public Optional<Class<?>> getEntityIdentifierType() {
        return this.storedQuery.getEntityIdentifierType();
    }

    @NonNull
    public Class<E> getRootEntity() {
        return this.storedQuery.getRootEntity();
    }

    @Deprecated
    public boolean hasInExpression() {
        return this.storedQuery.hasInExpression();
    }

    public boolean hasPageable() {
        return this.storedQuery.hasPageable();
    }

    @NonNull
    public String getQuery() {
        return this.query;
    }

    public String getUpdate() {
        return this.storedQuery.getUpdate();
    }

    @NonNull
    public Class<?>[] getArgumentTypes() {
        return this.storedQuery.getArgumentTypes();
    }

    @NonNull
    public Map<String, String> getParameterBinding() {
        return this.storedQuery.getParameterBinding();
    }

    public boolean isCount() {
        return this.storedQuery.isCount();
    }

    @NonNull
    public String getName() {
        return this.storedQuery.getName();
    }

    @NonNull
    public ConvertibleValues<Object> getAttributes() {
        return this.context.getAttributes();
    }

    @NonNull
    public Optional<Object> getAttribute(CharSequence name) {
        return this.context.getAttribute(name);
    }

    @NonNull
    public <T> Optional<T> getAttribute(CharSequence name, Class<T> type) {
        return this.context.getAttribute(name, type);
    }

    @Nullable
    public String[] getIndexedParameterAutoPopulatedPropertyPaths() {
        return this.storedQuery.getIndexedParameterAutoPopulatedPropertyPaths();
    }

    public String[] getIndexedParameterAutoPopulatedPreviousPropertyPaths() {
        return this.storedQuery.getIndexedParameterAutoPopulatedPreviousPropertyPaths();
    }

    public int[] getIndexedParameterAutoPopulatedPreviousPropertyIndexes() {
        return this.storedQuery.getIndexedParameterAutoPopulatedPreviousPropertyIndexes();
    }

    public boolean isOptimisticLock() {
        return this.storedQuery.isOptimisticLock();
    }
}

