/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.convert;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.type.Argument;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.convert.DataConversionServiceImpl;
import io.micronaut.data.runtime.convert.DataTypeConverter;
import jakarta.inject.Singleton;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

@Internal
@Factory
final class DataConversionServiceFactory {
    DataConversionServiceFactory() {
    }

    @Singleton
    @Bean(typed={DataConversionService.class})
    DataConversionServiceImpl build(@Nullable BeanContext beanContext) {
        DataConversionServiceImpl conversionService = new DataConversionServiceImpl();
        conversionService.addConverter((Class)Enum.class, (Class)Number.class, Enum::ordinal);
        conversionService.addConverter((Class)Number.class, (Class)Enum.class, (index, targetType, context) -> {
            Enum[] enumConstants = (Enum[])targetType.getEnumConstants();
            int i = index.intValue();
            if (i >= enumConstants.length) {
                throw new IllegalStateException("Cannot find an enum value at index: " + i + " for enum: " + targetType);
            }
            return Optional.of(enumConstants[i]);
        });
        conversionService.addConverter((Class)Number.class, (Class)Character.class, number -> Character.valueOf((char)number.intValue()));
        conversionService.addConverter((Class)byte[].class, (Class)UUID.class, UUID::nameUUIDFromBytes);
        conversionService.addConverter((Class)java.util.Date.class, (Class)LocalDate.class, date -> Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate());
        conversionService.addConverter((Class)ChronoLocalDate.class, (Class)java.util.Date.class, localDate -> new java.util.Date(localDate.atTime(LocalTime.MIDNIGHT).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()));
        conversionService.addConverter((Class)String[].class, (Class)Character[].class, values -> {
            Character[] chars = new Character[((String[])values).length];
            for (int i = 0; i < ((String[])values).length; ++i) {
                String value = values[i];
                chars[i] = Character.valueOf(value.length() == 0 ? (char)'\u0000' : value.charAt(0));
            }
            return chars;
        });
        conversionService.addConverter((Class)String[].class, (Class)char[].class, values -> {
            char[] chars = new char[((String[])values).length];
            for (int i = 0; i < ((String[])values).length; ++i) {
                String value = values[i];
                chars[i] = value.length() == 0 ? (char)'\u0000' : value.charAt(0);
            }
            return chars;
        });
        conversionService.addConverter((Class)Character[].class, (Class)String[].class, values -> {
            String[] strings = new String[((Character[])values).length];
            for (int i = 0; i < ((Character[])values).length; ++i) {
                strings[i] = values[i].toString();
            }
            return strings;
        });
        conversionService.addConverter((Class)char[].class, (Class)String[].class, values -> {
            String[] strings = new String[((char[])values).length];
            for (int i = 0; i < ((char[])values).length; ++i) {
                strings[i] = String.valueOf(values[i]);
            }
            return strings;
        });
        conversionService.addConverter((Class)Collection.class, (Class)Character[].class, collection -> {
            Character[] chars = new Character[collection.size()];
            int i = 0;
            for (Object value : collection) {
                chars[i++] = this.asCharacter(value, conversionService);
            }
            return chars;
        });
        conversionService.addConverter((Class)Collection.class, (Class)char[].class, collection -> {
            char[] chars = new char[collection.size()];
            int i = 0;
            for (Object value : collection) {
                chars[i++] = this.asCharacter(value, conversionService).charValue();
            }
            return chars;
        });
        conversionService.addConverter((Class)Character[].class, (Class)char[].class, values -> {
            char[] chars = new char[((Character[])values).length];
            for (int i = 0; i < ((Character[])values).length; ++i) {
                chars[i] = values[i].charValue();
            }
            return chars;
        });
        conversionService.addConverter((Class)char[].class, (Class)Character[].class, values -> {
            Character[] chars = new Character[((char[])values).length];
            for (int i = 0; i < ((char[])values).length; ++i) {
                chars[i] = Character.valueOf(values[i]);
            }
            return chars;
        });
        conversionService.addConverter((Class)Collection.class, (Class)Short[].class, collection -> {
            Short[] shorts = new Short[collection.size()];
            int i = 0;
            for (Object value : collection) {
                shorts[i++] = this.asShort(value, conversionService);
            }
            return shorts;
        });
        conversionService.addConverter((Class)Collection.class, (Class)short[].class, collection -> {
            short[] shorts = new short[collection.size()];
            int i = 0;
            for (Object value : collection) {
                shorts[i++] = this.asShort(value, conversionService);
            }
            return shorts;
        });
        conversionService.addConverter((Class)Short[].class, (Class)short[].class, values -> {
            short[] shorts = new short[((Short[])values).length];
            for (int i = 0; i < ((Short[])values).length; ++i) {
                shorts[i] = values[i];
            }
            return shorts;
        });
        conversionService.addConverter((Class)short[].class, (Class)Short[].class, values -> {
            Short[] shorts = new Short[((short[])values).length];
            for (int i = 0; i < ((short[])values).length; ++i) {
                shorts[i] = values[i];
            }
            return shorts;
        });
        conversionService.addConverter((Class)Collection.class, (Class)Float[].class, collection -> {
            Float[] floats = new Float[collection.size()];
            int i = 0;
            for (Object value : collection) {
                floats[i++] = this.asFloat(value, conversionService);
            }
            return floats;
        });
        conversionService.addConverter((Class)Collection.class, (Class)float[].class, collection -> {
            float[] floats = new float[collection.size()];
            int i = 0;
            for (Object value : collection) {
                floats[i++] = this.asFloat(value, conversionService).floatValue();
            }
            return floats;
        });
        conversionService.addConverter((Class)Float[].class, (Class)float[].class, values -> {
            float[] floats = new float[((Float[])values).length];
            for (int i = 0; i < ((Float[])values).length; ++i) {
                floats[i] = values[i].floatValue();
            }
            return floats;
        });
        conversionService.addConverter((Class)float[].class, (Class)Float[].class, values -> {
            Float[] floats = new Float[((float[])values).length];
            for (int i = 0; i < ((float[])values).length; ++i) {
                floats[i] = Float.valueOf(values[i]);
            }
            return floats;
        });
        conversionService.addConverter((Class)Float[].class, (Class)BigDecimal[].class, values -> {
            BigDecimal[] bigs = new BigDecimal[((Float[])values).length];
            for (int i = 0; i < ((Float[])values).length; ++i) {
                bigs[i] = BigDecimal.valueOf(values[i].floatValue());
            }
            return bigs;
        });
        conversionService.addConverter((Class)float[].class, (Class)BigDecimal[].class, values -> {
            BigDecimal[] bigs = new BigDecimal[((float[])values).length];
            for (int i = 0; i < ((float[])values).length; ++i) {
                bigs[i] = BigDecimal.valueOf(values[i]);
            }
            return bigs;
        });
        conversionService.addConverter((Class)Collection.class, (Class)Integer[].class, collection -> {
            Integer[] ints = new Integer[collection.size()];
            int i = 0;
            for (Object value : collection) {
                ints[i++] = this.asInteger(value, conversionService);
            }
            return ints;
        });
        conversionService.addConverter((Class)Collection.class, (Class)int[].class, collection -> {
            int[] ints = new int[collection.size()];
            int i = 0;
            for (Object value : collection) {
                ints[i++] = this.asInteger(value, conversionService);
            }
            return ints;
        });
        conversionService.addConverter((Class)Integer[].class, (Class)int[].class, values -> {
            int[] ints = new int[((Integer[])values).length];
            for (int i = 0; i < ((Integer[])values).length; ++i) {
                ints[i] = values[i];
            }
            return ints;
        });
        conversionService.addConverter((Class)int[].class, (Class)Integer[].class, values -> {
            Integer[] ints = new Integer[((int[])values).length];
            for (int i = 0; i < ((int[])values).length; ++i) {
                ints[i] = values[i];
            }
            return ints;
        });
        conversionService.addConverter((Class)Collection.class, (Class)Long[].class, collection -> {
            Long[] longs = new Long[collection.size()];
            int i = 0;
            for (Object value : collection) {
                longs[i++] = this.asLong(value, conversionService);
            }
            return longs;
        });
        conversionService.addConverter((Class)Collection.class, (Class)long[].class, collection -> {
            long[] longs = new long[collection.size()];
            int i = 0;
            for (Object value : collection) {
                longs[i++] = this.asLong(value, conversionService);
            }
            return longs;
        });
        conversionService.addConverter((Class)Long[].class, (Class)long[].class, values -> {
            long[] longs = new long[((Long[])values).length];
            for (int i = 0; i < ((Long[])values).length; ++i) {
                longs[i] = values[i];
            }
            return longs;
        });
        conversionService.addConverter((Class)long[].class, (Class)Long[].class, values -> {
            Long[] longs = new Long[((long[])values).length];
            for (int i = 0; i < ((long[])values).length; ++i) {
                longs[i] = values[i];
            }
            return longs;
        });
        conversionService.addConverter((Class)Collection.class, (Class)Double[].class, collection -> {
            Double[] doubles = new Double[collection.size()];
            int i = 0;
            for (Object value : collection) {
                doubles[i++] = this.asDouble(value, conversionService);
            }
            return doubles;
        });
        conversionService.addConverter((Class)Collection.class, (Class)double[].class, collection -> {
            double[] doubles = new double[collection.size()];
            int i = 0;
            for (Object value : collection) {
                doubles[i++] = this.asDouble(value, conversionService);
            }
            return doubles;
        });
        conversionService.addConverter((Class)Double[].class, (Class)double[].class, values -> {
            double[] doubles = new double[((Double[])values).length];
            for (int i = 0; i < ((Double[])values).length; ++i) {
                doubles[i] = values[i];
            }
            return doubles;
        });
        conversionService.addConverter((Class)double[].class, (Class)Double[].class, values -> {
            Double[] doubles = new Double[((double[])values).length];
            for (int i = 0; i < ((double[])values).length; ++i) {
                doubles[i] = values[i];
            }
            return doubles;
        });
        conversionService.addConverter((Class)Double[].class, (Class)BigDecimal[].class, values -> {
            BigDecimal[] bigs = new BigDecimal[((Double[])values).length];
            for (int i = 0; i < ((Double[])values).length; ++i) {
                bigs[i] = BigDecimal.valueOf(values[i]);
            }
            return bigs;
        });
        conversionService.addConverter((Class)double[].class, (Class)BigDecimal[].class, values -> {
            BigDecimal[] bigs = new BigDecimal[((double[])values).length];
            for (int i = 0; i < ((double[])values).length; ++i) {
                bigs[i] = BigDecimal.valueOf(values[i]);
            }
            return bigs;
        });
        conversionService.addConverter((Class)Collection.class, (Class)Boolean[].class, collection -> {
            Boolean[] booleans = new Boolean[collection.size()];
            int i = 0;
            for (Object value : collection) {
                booleans[i++] = this.asBoolean(value, conversionService);
            }
            return booleans;
        });
        conversionService.addConverter((Class)Collection.class, (Class)boolean[].class, collection -> {
            boolean[] booleans = new boolean[collection.size()];
            int i = 0;
            for (Object value : collection) {
                booleans[i++] = this.asBoolean(value, conversionService);
            }
            return booleans;
        });
        conversionService.addConverter((Class)Boolean[].class, (Class)boolean[].class, values -> {
            boolean[] booleans = new boolean[((Boolean[])values).length];
            for (int i = 0; i < ((Boolean[])values).length; ++i) {
                booleans[i] = values[i];
            }
            return booleans;
        });
        conversionService.addConverter((Class)boolean[].class, (Class)Boolean[].class, values -> {
            Boolean[] booleans = new Boolean[((boolean[])values).length];
            for (int i = 0; i < ((boolean[])values).length; ++i) {
                booleans[i] = values[i];
            }
            return booleans;
        });
        conversionService.addConverter((Class)Instant.class, (Class)java.util.Date.class, java.util.Date::from);
        conversionService.addConverter((Class)Instant.class, (Class)Timestamp.class, Timestamp::from);
        conversionService.addConverter((Class)java.util.Date.class, (Class)Instant.class, java.util.Date::toInstant);
        conversionService.addConverter((Class)Date.class, (Class)Instant.class, date -> Instant.ofEpochMilli(date.getTime()));
        conversionService.addConverter((Class)Timestamp.class, (Class)ZonedDateTime.class, timestamp -> timestamp.toLocalDateTime().atZone(ZoneId.systemDefault()));
        conversionService.addConverter((Class)ZonedDateTime.class, (Class)Timestamp.class, zonedDateTime -> Timestamp.from(zonedDateTime.toInstant()));
        conversionService.addConverter((Class)LocalTime.class, (Class)Timestamp.class, localTime -> Timestamp.valueOf(localTime.atDate(LocalDate.now())));
        conversionService.addConverter((Class)Timestamp.class, (Class)LocalTime.class, timestamp -> timestamp.toLocalDateTime().toLocalTime());
        conversionService.addConverter((Class)LocalDateTime.class, (Class)java.util.Date.class, localDateTime -> new java.util.Date(localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()));
        conversionService.addConverter((Class)LocalDateTime.class, (Class)Timestamp.class, Timestamp::valueOf);
        conversionService.addConverter((Class)Timestamp.class, (Class)LocalDateTime.class, Timestamp::toLocalDateTime);
        conversionService.addConverter((Class)java.util.Date.class, (Class)LocalDateTime.class, date -> Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        conversionService.addConverter((Class)java.util.Date.class, (Class)OffsetDateTime.class, date -> Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toOffsetDateTime());
        conversionService.addConverter((Class)OffsetDateTime.class, (Class)java.util.Date.class, offsetDateTime2 -> new java.util.Date(offsetDateTime2.toInstant().toEpochMilli()));
        conversionService.addConverter((Class)OffsetDateTime.class, (Class)Date.class, offsetDateTime1 -> new Date(offsetDateTime1.toInstant().toEpochMilli()));
        conversionService.addConverter((Class)OffsetDateTime.class, (Class)Timestamp.class, offsetDateTime1 -> Timestamp.from(offsetDateTime1.toInstant()));
        conversionService.addConverter((Class)Timestamp.class, (Class)OffsetDateTime.class, timestamp -> OffsetDateTime.ofInstant(timestamp.toInstant(), ZoneId.systemDefault()));
        conversionService.addConverter((Class)OffsetDateTime.class, (Class)Instant.class, OffsetDateTime::toInstant);
        conversionService.addConverter((Class)OffsetDateTime.class, (Class)LocalDate.class, OffsetDateTime::toLocalDate);
        conversionService.addConverter((Class)OffsetDateTime.class, (Class)LocalDateTime.class, OffsetDateTime::toLocalDateTime);
        conversionService.addConverter((Class)OffsetDateTime.class, (Class)Long.class, offsetDateTime -> offsetDateTime.toInstant().toEpochMilli());
        if (beanContext != null) {
            Collection typeConverters = beanContext.getBeanRegistrations(DataTypeConverter.class);
            for (BeanRegistration typeConverterRegistration : typeConverters) {
                TypeConverter typeConverter = (TypeConverter)typeConverterRegistration.getBean();
                List typeArguments = typeConverterRegistration.getBeanDefinition().getTypeArguments(TypeConverter.class);
                if (typeArguments.size() != 2) continue;
                Class source = ((Argument)typeArguments.get(0)).getType();
                Class target = ((Argument)typeArguments.get(1)).getType();
                if (source == null || target == null || source == Object.class && target == Object.class) continue;
                conversionService.addConverter(source, target, typeConverter);
            }
            Collection registrars = beanContext.getBeansOfType(TypeConverterRegistrar.class);
            for (TypeConverterRegistrar registrar : registrars) {
                registrar.register((ConversionService)conversionService);
            }
        }
        return conversionService;
    }

    private Integer asInteger(Object value, DataConversionService<?> dataConversionService) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return (Integer)dataConversionService.convertRequired(value, Integer.class);
    }

    private Long asLong(Object value, DataConversionService<?> dataConversionService) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return (Long)dataConversionService.convertRequired(value, Long.class);
    }

    private Double asDouble(Object value, DataConversionService<?> dataConversionService) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return (Double)dataConversionService.convertRequired(value, Double.class);
    }

    private Boolean asBoolean(Object value, DataConversionService<?> dataConversionService) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return (Boolean)dataConversionService.convertRequired(value, Boolean.class);
    }

    private Float asFloat(Object value, DataConversionService<?> dataConversionService) {
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        return (Float)dataConversionService.convertRequired(value, Float.class);
    }

    private Short asShort(Object value, DataConversionService<?> dataConversionService) {
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        return (Short)dataConversionService.convertRequired(value, Short.class);
    }

    private Character asCharacter(Object value, DataConversionService<?> dataConversionService) {
        if (value instanceof Character) {
            return (Character)value;
        }
        return (Character)dataConversionService.convertRequired(value, Character.class);
    }
}

