/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.event.EntityEventContext;
import io.micronaut.data.event.EntityEventListener;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.exceptions.OptimisticLockException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.runtime.AttributeConverterRegistry;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.convert.AttributeConverter;
import io.micronaut.data.runtime.config.DataSettings;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.date.DateTimeProvider;
import io.micronaut.data.runtime.event.DefaultEntityEventContext;
import io.micronaut.data.runtime.operations.internal.DBOperation;
import io.micronaut.data.runtime.operations.internal.OpContext;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.MediaTypeCodec;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;

@Internal
public abstract class AbstractRepositoryOperations<Cnt, PS, Exc extends Exception>
implements ApplicationContextProvider,
OpContext<Cnt, PS> {
    protected static final Logger QUERY_LOG = DataSettings.QUERY_LOG;
    protected final MediaTypeCodec jsonCodec;
    protected final EntityEventListener<Object> entityEventRegistry;
    protected final DateTimeProvider dateTimeProvider;
    protected final RuntimeEntityRegistry runtimeEntityRegistry;
    protected final DataConversionService<?> conversionService;
    protected final AttributeConverterRegistry attributeConverterRegistry;
    private final Map<Class, RuntimePersistentProperty> idReaders = new ConcurrentHashMap<Class, RuntimePersistentProperty>(10);

    protected AbstractRepositoryOperations(List<MediaTypeCodec> codecs, DateTimeProvider<Object> dateTimeProvider, RuntimeEntityRegistry runtimeEntityRegistry, DataConversionService<?> conversionService, AttributeConverterRegistry attributeConverterRegistry) {
        this.dateTimeProvider = dateTimeProvider;
        this.runtimeEntityRegistry = runtimeEntityRegistry;
        this.entityEventRegistry = runtimeEntityRegistry.getEntityEventListener();
        this.jsonCodec = this.resolveJsonCodec(codecs);
        this.conversionService = conversionService;
        this.attributeConverterRegistry = attributeConverterRegistry;
    }

    public ApplicationContext getApplicationContext() {
        return this.runtimeEntityRegistry.getApplicationContext();
    }

    private MediaTypeCodec resolveJsonCodec(List<MediaTypeCodec> codecs) {
        return CollectionUtils.isNotEmpty(codecs) ? (MediaTypeCodec)codecs.stream().filter(c -> c.getMediaTypes().contains(MediaType.APPLICATION_JSON_TYPE)).findFirst().orElse(null) : null;
    }

    @Override
    @NonNull
    public final <T> RuntimePersistentEntity<T> getEntity(@NonNull Class<T> type) {
        return this.runtimeEntityRegistry.getEntity(type);
    }

    @Override
    public RuntimeEntityRegistry getRuntimeEntityRegistry() {
        return this.runtimeEntityRegistry;
    }

    protected abstract AutoCloseable autoCloseable(PS var1);

    protected abstract void prepareStatement(Cnt var1, Dialect var2, PersistentProperty var3, boolean var4, String var5, DBOperation1<PS, Exc> var6) throws Exc;

    protected <T> T afterCascadedOne(T entity, List<Association> associations, Object prevChild, Object newChild) {
        RuntimeAssociation association = (RuntimeAssociation)associations.iterator().next();
        if (associations.size() == 1) {
            RuntimeAssociation inverseAssociation;
            if (association.isForeignKey() && (inverseAssociation = (RuntimeAssociation)association.getInverseSide().orElse(null)) != null) {
                BeanProperty property = inverseAssociation.getProperty();
                newChild = this.setProperty(property, newChild, entity);
            }
            if (prevChild != newChild) {
                entity = this.setProperty(association.getProperty(), entity, newChild);
            }
            return entity;
        }
        BeanProperty property = association.getProperty();
        Object innerEntity = property.get(entity);
        Object newInnerEntity = this.afterCascadedOne(innerEntity, associations.subList(1, associations.size()), prevChild, newChild);
        if (newInnerEntity != innerEntity) {
            innerEntity = this.convertAndSetWithValue(property, entity, newInnerEntity);
        }
        return (T)innerEntity;
    }

    protected <T> T afterCascadedMany(T entity, List<Association> associations, Iterable<Object> prevChildren, List<Object> newChildren) {
        RuntimeAssociation association = (RuntimeAssociation)associations.iterator().next();
        if (associations.size() == 1) {
            ListIterator<Object> iterator = newChildren.listIterator();
            while (iterator.hasNext()) {
                BeanProperty property;
                Object newc;
                RuntimeAssociation inverseAssociation;
                Object c = iterator.next();
                if (!association.isForeignKey() || (inverseAssociation = (RuntimeAssociation)association.getInverseSide().orElse(null)) == null || c == (newc = this.setProperty(property = inverseAssociation.getProperty(), c, entity))) continue;
                iterator.set(newc);
            }
            if (prevChildren != newChildren) {
                entity = this.convertAndSetWithValue(association.getProperty(), entity, newChildren);
            }
            return entity;
        }
        BeanProperty property = association.getProperty();
        Object innerEntity = property.get(entity);
        Object newInnerEntity = this.afterCascadedMany(innerEntity, associations.subList(1, associations.size()), prevChildren, newChildren);
        if (newInnerEntity != innerEntity) {
            innerEntity = this.convertAndSetWithValue(property, entity, newInnerEntity);
        }
        return (T)innerEntity;
    }

    protected <T> T triggerPostLoad(@NonNull T entity, RuntimePersistentEntity<T> pe, AnnotationMetadata annotationMetadata) {
        DefaultEntityEventContext<T> event = new DefaultEntityEventContext<T>(pe, entity);
        this.entityEventRegistry.postLoad(event);
        return event.getEntity();
    }

    protected <T> void persistOne(Cnt connection, AnnotationMetadata annotationMetadata, Class<?> repositoryType, DBOperation sqlOperation, List<Association> associations, Set<Object> persisted, EntityOperations<T> op) {
        try {
            boolean vetoed;
            boolean hasGeneratedID;
            boolean bl = hasGeneratedID = op.persistentEntity.getIdentity() != null && op.persistentEntity.getIdentity().isGenerated();
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing SQL Insert: {}", (Object)sqlOperation.getQuery());
            }
            if (vetoed = op.triggerPrePersist()) {
                return;
            }
            op.cascadePre(Relation.Cascade.PERSIST, connection, sqlOperation.dialect, annotationMetadata, repositoryType, associations, persisted);
            this.prepareStatement(connection, sqlOperation.getDialect(), (PersistentProperty)op.persistentEntity.getIdentity(), hasGeneratedID, sqlOperation.getQuery(), stmt -> {
                op.setParameters(this, connection, stmt, sqlOperation);
                if (hasGeneratedID) {
                    op.executeUpdateSetGeneratedId(stmt);
                } else {
                    op.executeUpdate(stmt);
                }
            });
            op.triggerPostPersist();
            op.cascadePost(Relation.Cascade.PERSIST, connection, sqlOperation.dialect, annotationMetadata, repositoryType, associations, persisted);
        }
        catch (Exception e) {
            throw new DataAccessException("SQL Error executing INSERT: " + e.getMessage(), (Throwable)e);
        }
    }

    protected <T> void persistInBatch(Cnt connection, AnnotationMetadata annotationMetadata, Class<?> repositoryType, DBOperation sqlOperation, List<Association> associations, Set<Object> persisted, EntitiesOperations<T> op) {
        boolean hasGeneratedID = op.persistentEntity.getIdentity() != null && op.persistentEntity.getIdentity().isGenerated();
        try {
            boolean allVetoed = op.triggerPrePersist();
            if (allVetoed) {
                return;
            }
            op.cascadePre(Relation.Cascade.PERSIST, connection, sqlOperation.dialect, annotationMetadata, repositoryType, associations, persisted);
            this.prepareStatement(connection, sqlOperation.getDialect(), (PersistentProperty)op.persistentEntity.getIdentity(), hasGeneratedID, sqlOperation.getQuery(), stmt -> {
                if (QUERY_LOG.isDebugEnabled()) {
                    QUERY_LOG.debug("Executing Batch SQL Insert: {}", (Object)sqlOperation.getQuery());
                }
                op.setParameters(this, connection, stmt, sqlOperation);
                if (hasGeneratedID) {
                    op.executeUpdateSetGeneratedId(stmt);
                } else {
                    op.executeUpdate(stmt);
                }
            });
            op.triggerPostPersist();
            op.cascadePost(Relation.Cascade.PERSIST, connection, sqlOperation.dialect, annotationMetadata, repositoryType, associations, persisted);
        }
        catch (Exception e) {
            throw new DataAccessException("SQL error executing INSERT: " + e.getMessage(), (Throwable)e);
        }
    }

    private <X, Y> X setProperty(BeanProperty<X, Y> beanProperty, X x, Y y) {
        if (beanProperty.isReadOnly()) {
            return (X)beanProperty.withValue(x, y);
        }
        beanProperty.set(x, y);
        return x;
    }

    private <B, T> B convertAndSetWithValue(BeanProperty<B, T> beanProperty, B bean, T value) {
        Argument argument = beanProperty.asArgument();
        ArgumentConversionContext context = ConversionContext.of((Argument)argument);
        Object convertedValue = this.conversionService.convert(value, context).orElseThrow(() -> new ConversionErrorException(argument, context.getLastError().orElse(() -> new IllegalArgumentException("Value [" + value + "] cannot be converted to type : " + beanProperty.getType()))));
        if (beanProperty.isReadOnly()) {
            return (B)beanProperty.withValue(bean, convertedValue);
        }
        beanProperty.set(bean, convertedValue);
        return bean;
    }

    protected <T> void deleteOne(Cnt connection, EntityOperations<T> op, DBOperation dbOperation) {
        op.collectAutoPopulatedPreviousValues(dbOperation);
        boolean vetoed = op.triggerPreRemove();
        if (vetoed) {
            return;
        }
        try {
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing SQL DELETE: {}", (Object)dbOperation.getQuery());
            }
            Object ps = op.prepare(connection, dbOperation);
            try (AutoCloseable ignore = this.autoCloseable(ps);){
                op.setParameters(this, connection, ps, dbOperation);
                op.executeUpdate(ps, (entries, deleted) -> {
                    if (QUERY_LOG.isTraceEnabled()) {
                        QUERY_LOG.trace("Delete operation deleted {} records", deleted);
                    }
                    if (dbOperation.isOptimisticLock()) {
                        this.checkOptimisticLocking((int)entries, (int)deleted);
                    }
                });
            }
            op.triggerPostRemove();
        }
        catch (OptimisticLockException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new DataAccessException("Error executing SQL DELETE: " + e.getMessage(), (Throwable)e);
        }
    }

    protected <T> void deleteInBatch(Cnt connection, EntitiesOperations<T> op, DBOperation dbOperation) {
        op.collectAutoPopulatedPreviousValues(dbOperation);
        boolean vetoed = op.triggerPreRemove();
        if (vetoed) {
            return;
        }
        try {
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing Batch SQL DELETE: {}", (Object)dbOperation.getQuery());
            }
            Object ps = op.prepare(connection, dbOperation);
            try (AutoCloseable ignore = this.autoCloseable(ps);){
                op.setParameters(this, connection, ps, dbOperation);
                op.executeUpdate(ps, (entries, deleted) -> {
                    if (QUERY_LOG.isTraceEnabled()) {
                        QUERY_LOG.trace("Delete operation deleted {} records", deleted);
                    }
                    if (dbOperation.isOptimisticLock()) {
                        this.checkOptimisticLocking((int)entries, (int)deleted);
                    }
                });
            }
            op.triggerPostRemove();
        }
        catch (OptimisticLockException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new DataAccessException("Error executing SQL DELETE: " + e.getMessage(), (Throwable)e);
        }
    }

    protected <T> void updateOne(Cnt connection, AnnotationMetadata annotationMetadata, Class<?> repositoryType, DBOperation dbOperation, List<Association> associations, Set<Object> persisted, EntityOperations<T> op) {
        op.collectAutoPopulatedPreviousValues(dbOperation);
        boolean vetoed = op.triggerPreUpdate();
        if (vetoed) {
            return;
        }
        op.cascadePre(Relation.Cascade.UPDATE, connection, dbOperation.dialect, annotationMetadata, repositoryType, associations, persisted);
        try {
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing SQL UPDATE: {}", (Object)dbOperation.getQuery());
            }
            Object ps = op.prepare(connection, dbOperation);
            try (AutoCloseable ignore = this.autoCloseable(ps);){
                op.setParameters(this, connection, ps, dbOperation);
                op.executeUpdate(ps, (entries, rowsUpdated) -> {
                    if (QUERY_LOG.isTraceEnabled()) {
                        QUERY_LOG.trace("Update operation updated {} records", rowsUpdated);
                    }
                    if (dbOperation.isOptimisticLock()) {
                        this.checkOptimisticLocking((int)entries, (int)rowsUpdated);
                    }
                });
            }
            op.triggerPostUpdate();
            op.cascadePost(Relation.Cascade.UPDATE, connection, dbOperation.dialect, annotationMetadata, repositoryType, associations, persisted);
        }
        catch (OptimisticLockException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new DataAccessException("Error executing SQL UPDATE: " + e.getMessage(), (Throwable)e);
        }
    }

    protected <T> void updateInBatch(Cnt connection, AnnotationMetadata annotationMetadata, Class<?> repositoryType, DBOperation dbOperation, List<Association> associations, Set<Object> persisted, EntitiesOperations<T> op) {
        op.collectAutoPopulatedPreviousValues(dbOperation);
        op.triggerPreUpdate();
        try {
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing Batch SQL Update: {}", (Object)dbOperation.getQuery());
            }
            op.cascadePre(Relation.Cascade.UPDATE, connection, dbOperation.dialect, annotationMetadata, repositoryType, associations, persisted);
            Object ps = op.prepare(connection, dbOperation);
            try (AutoCloseable ignore = this.autoCloseable(ps);){
                op.setParameters(this, connection, ps, dbOperation);
                op.executeUpdate(ps, (expected, updated) -> {
                    if (QUERY_LOG.isTraceEnabled()) {
                        QUERY_LOG.trace("Update batch operation updated {} records", updated);
                    }
                    if (dbOperation.isOptimisticLock()) {
                        this.checkOptimisticLocking((int)expected, (int)updated);
                    }
                });
            }
            op.cascadePost(Relation.Cascade.UPDATE, connection, dbOperation.dialect, annotationMetadata, repositoryType, associations, persisted);
            op.triggerPostUpdate();
        }
        catch (OptimisticLockException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new DataAccessException("Error executing SQL UPDATE: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public int shiftIndex(int i) {
        return i + 1;
    }

    @NonNull
    protected final RuntimePersistentProperty<Object> getIdReader(@NonNull Object o) {
        Class<?> type = o.getClass();
        RuntimePersistentProperty beanProperty = this.idReaders.get(type);
        if (beanProperty == null) {
            RuntimePersistentEntity<?> entity = this.getEntity(type);
            RuntimePersistentProperty identity = entity.getIdentity();
            if (identity == null) {
                throw new DataAccessException("Entity has no ID: " + entity.getName());
            }
            beanProperty = identity;
            this.idReaders.put(type, beanProperty);
        }
        return beanProperty;
    }

    protected <T> void cascade(Dialect dialect, AnnotationMetadata annotationMetadata, Class<?> repositoryType, boolean fkOnly, Relation.Cascade cascadeType, CascadeContext ctx, RuntimePersistentEntity<T> persistentEntity, T entity, List<CascadeOp> cascadeOps) {
        block4: for (RuntimeAssociation association : persistentEntity.getAssociations()) {
            BeanProperty beanProperty = association.getProperty();
            Object child = beanProperty.get(entity);
            if (child == null) continue;
            if (association instanceof Embedded) {
                this.cascade(dialect, annotationMetadata, repositoryType, fkOnly, cascadeType, ctx.embedded((Association)association), association.getAssociatedEntity(), child, cascadeOps);
                continue;
            }
            if (!association.doesCascade(new Relation.Cascade[]{cascadeType}) || !fkOnly && association.isForeignKey() || association.getInverseSide().map(assoc -> ctx.rootAssociations.contains(assoc) || ctx.associations.contains(assoc)).orElse(false).booleanValue()) continue;
            RuntimePersistentEntity associatedEntity = association.getAssociatedEntity();
            switch (association.getKind()) {
                case ONE_TO_ONE: 
                case MANY_TO_ONE: {
                    cascadeOps.add(new CascadeOneOp(dialect, annotationMetadata, repositoryType, ctx.relation((Association)association), cascadeType, (RuntimePersistentEntity<Object>)associatedEntity, child));
                    continue block4;
                }
                case ONE_TO_MANY: 
                case MANY_TO_MANY: {
                    RuntimeAssociation inverse = association.getInverseSide().orElse(null);
                    ArrayList children = (ArrayList)association.getProperty().get(entity);
                    if (!children.iterator().hasNext()) continue block4;
                    if (inverse != null && inverse.getKind() == Relation.Kind.MANY_TO_ONE) {
                        ArrayList entities = new ArrayList(CollectionUtils.iterableToList((Iterable)children));
                        ListIterator iterator = entities.listIterator();
                        while (iterator.hasNext()) {
                            Object c = iterator.next();
                            BeanProperty property = inverse.getProperty();
                            c = this.setProperty(property, c, entity);
                            iterator.set(c);
                        }
                        children = entities;
                    }
                    cascadeOps.add(new CascadeManyOp(dialect, annotationMetadata, repositoryType, ctx.relation((Association)association), cascadeType, (RuntimePersistentEntity<Object>)associatedEntity, children));
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Cannot cascade for relation: " + association.getKind());
        }
    }

    protected <T> void persistJoinTableAssociation(Cnt connection, Class<?> repositoryType, Dialect dialect, Association association, Object parent, BaseOperations<T> op) {
        RuntimePersistentEntity<?> entity = this.getEntity(parent.getClass());
        DBOperation dbInsertOperation = this.resolveSqlInsertAssociation(repositoryType, dialect, (RuntimeAssociation)association, entity, parent);
        try {
            Object ps = op.prepare(connection, dbInsertOperation);
            try (AutoCloseable ignore = this.autoCloseable(ps);){
                op.setParameters(this, connection, ps, dbInsertOperation);
                op.executeUpdate(ps);
            }
        }
        catch (Exception e) {
            throw new DataAccessException("SQL error executing INSERT: " + e.getMessage(), (Throwable)e);
        }
    }

    protected abstract <T> String resolveAssociationInsert(Class var1, RuntimePersistentEntity<T> var2, RuntimeAssociation<T> var3);

    private <T> DBOperation resolveSqlInsertAssociation(Class<?> repositoryType, Dialect dialect, RuntimeAssociation<T> association, final RuntimePersistentEntity<T> persistentEntity, final T entity) {
        String sqlInsert = this.resolveAssociationInsert(repositoryType, persistentEntity, association);
        return new DBOperation(sqlInsert, dialect){

            @Override
            public <T, Cnt, PS> void setParameters(OpContext<Cnt, PS> context, Cnt connection, PS ps, RuntimePersistentEntity<T> pe, T e, Map<QueryParameterBinding, Object> previousValues) {
                Object value;
                int i = 0;
                for (Map.Entry property : AbstractRepositoryOperations.this.idPropertiesWithValues((PersistentProperty)persistentEntity.getIdentity(), entity).collect(Collectors.toList())) {
                    value = context.convert(connection, property.getValue(), (RuntimePersistentProperty)property.getKey());
                    context.setStatementParameter(ps, AbstractRepositoryOperations.this.shiftIndex(i++), ((PersistentProperty)property.getKey()).getDataType(), value, this.dialect);
                }
                for (Map.Entry property : AbstractRepositoryOperations.this.idPropertiesWithValues((PersistentProperty)pe.getIdentity(), e).collect(Collectors.toList())) {
                    value = context.convert(connection, property.getValue(), (RuntimePersistentProperty)property.getKey());
                    context.setStatementParameter(ps, AbstractRepositoryOperations.this.shiftIndex(i++), ((PersistentProperty)property.getKey()).getDataType(), value, this.dialect);
                }
            }
        };
    }

    private Stream<Map.Entry<PersistentProperty, Object>> idPropertiesWithValues(PersistentProperty property, Object value) {
        Object propertyValue = ((RuntimePersistentProperty)property).getProperty().get(value);
        if (property instanceof Embedded) {
            Embedded embedded = (Embedded)property;
            PersistentEntity embeddedEntity = embedded.getAssociatedEntity();
            return embeddedEntity.getPersistentProperties().stream().flatMap(prop -> this.idPropertiesWithValues((PersistentProperty)prop, propertyValue));
        }
        if (property instanceof Association) {
            Association association = (Association)property;
            if (association.isForeignKey()) {
                return Stream.empty();
            }
            PersistentEntity associatedEntity = association.getAssociatedEntity();
            PersistentProperty identity = associatedEntity.getIdentity();
            if (identity == null) {
                throw new IllegalStateException("Identity cannot be missing for: " + associatedEntity);
            }
            return this.idPropertiesWithValues(identity, propertyValue);
        }
        return Stream.of(new AbstractMap.SimpleEntry<PersistentProperty, Object>(property, propertyValue));
    }

    protected boolean isSupportsBatchInsert(PersistentEntity persistentEntity, Dialect dialect) {
        switch (dialect) {
            case SQL_SERVER: {
                return false;
            }
            case MYSQL: 
            case ORACLE: {
                if (persistentEntity.getIdentity() != null) {
                    return !persistentEntity.getIdentity().isGenerated();
                }
                return false;
            }
        }
        return true;
    }

    protected boolean isSupportsBatchUpdate(PersistentEntity persistentEntity, Dialect dialect) {
        return true;
    }

    protected boolean isSupportsBatchDelete(PersistentEntity persistentEntity, Dialect dialect) {
        return true;
    }

    protected void checkOptimisticLocking(int expected, int received) {
        if (received != expected) {
            throw new OptimisticLockException("Execute update returned unexpected row count. Expected: " + expected + " got: " + received);
        }
    }

    protected boolean isOnlySingleEndedJoins(RuntimePersistentEntity<?> rootPersistentEntity, Set<JoinPath> joinFetchPaths) {
        boolean onlySingleEndedJoins = joinFetchPaths.isEmpty() || joinFetchPaths.stream().flatMap(jp -> {
            PersistentPropertyPath propertyPath = rootPersistentEntity.getPropertyPath(jp.getPath());
            if (propertyPath == null) {
                return Stream.empty();
            }
            if (propertyPath.getProperty() instanceof Association) {
                return Stream.concat(propertyPath.getAssociations().stream(), Stream.of((Association)propertyPath.getProperty()));
            }
            return propertyPath.getAssociations().stream();
        }).allMatch(association -> association.getKind() == Relation.Kind.EMBEDDED || association.getKind().isSingleEnded());
        return onlySingleEndedJoins;
    }

    private static List<Association> associated(List<Association> associations, Association association) {
        if (associations == null) {
            return Collections.singletonList(association);
        }
        ArrayList<Association> newAssociations = new ArrayList<Association>(associations.size() + 1);
        newAssociations.addAll(associations);
        newAssociations.add(association);
        return newAssociations;
    }

    @Override
    public Object convert(Cnt connection, Object value, RuntimePersistentProperty<?> property) {
        AttributeConverter converter = property.getConverter();
        if (converter != null) {
            return converter.convertToPersistedValue(value, this.createTypeConversionContext(connection, property, property.getArgument()));
        }
        return value;
    }

    @Override
    public Object convert(Class<?> converterClass, Cnt connection, Object value, @Nullable Argument<?> argument) {
        if (converterClass == null) {
            return value;
        }
        AttributeConverter converter = this.attributeConverterRegistry.getConverter(converterClass);
        ConversionContext conversionContext = this.createTypeConversionContext(connection, null, argument);
        return converter.convertToPersistedValue(value, conversionContext);
    }

    protected abstract ConversionContext createTypeConversionContext(Cnt var1, @Nullable RuntimePersistentProperty<?> var2, @Nullable Argument<?> var3);

    protected static final class CascadeContext {
        public final List<Association> rootAssociations;
        public final Object parent;
        public final List<Association> associations;

        CascadeContext(List<Association> rootAssociations, Object parent, List<Association> associations) {
            this.rootAssociations = rootAssociations;
            this.parent = parent;
            this.associations = associations;
        }

        public static CascadeContext of(List<Association> rootAssociations, Object parent) {
            return new CascadeContext(rootAssociations, parent, Collections.emptyList());
        }

        CascadeContext embedded(Association association) {
            return new CascadeContext(this.rootAssociations, this.parent, AbstractRepositoryOperations.associated(this.associations, association));
        }

        CascadeContext relation(Association association) {
            return new CascadeContext(this.rootAssociations, this.parent, AbstractRepositoryOperations.associated(this.associations, association));
        }

        public Association getAssociation() {
            return (Association)CollectionUtils.last(this.associations);
        }
    }

    protected static final class CascadeManyOp
    extends CascadeOp {
        public final Iterable<Object> children;

        CascadeManyOp(Dialect dialect, AnnotationMetadata annotationMetadata, Class<?> repositoryType, CascadeContext ctx, Relation.Cascade cascadeType, RuntimePersistentEntity<Object> childPersistentEntity, Iterable<Object> children) {
            super(dialect, annotationMetadata, repositoryType, ctx, cascadeType, childPersistentEntity);
            this.children = children;
        }
    }

    protected static final class CascadeOneOp
    extends CascadeOp {
        public final Object child;

        CascadeOneOp(Dialect dialect, AnnotationMetadata annotationMetadata, Class<?> repositoryType, CascadeContext ctx, Relation.Cascade cascadeType, RuntimePersistentEntity<Object> childPersistentEntity, Object child) {
            super(dialect, annotationMetadata, repositoryType, ctx, cascadeType, childPersistentEntity);
            this.child = child;
        }
    }

    protected static abstract class CascadeOp {
        public final Dialect dialect;
        public final AnnotationMetadata annotationMetadata;
        public final Class<?> repositoryType;
        public final CascadeContext ctx;
        public final Relation.Cascade cascadeType;
        public final RuntimePersistentEntity<Object> childPersistentEntity;

        CascadeOp(Dialect dialect, AnnotationMetadata annotationMetadata, Class<?> repositoryType, CascadeContext ctx, Relation.Cascade cascadeType, RuntimePersistentEntity<Object> childPersistentEntity) {
            this.dialect = dialect;
            this.annotationMetadata = annotationMetadata;
            this.repositoryType = repositoryType;
            this.ctx = ctx;
            this.cascadeType = cascadeType;
            this.childPersistentEntity = childPersistentEntity;
        }
    }

    protected abstract class BaseOperations<T> {
        protected final RuntimePersistentEntity<T> persistentEntity;

        protected BaseOperations(RuntimePersistentEntity<T> persistentEntity) {
            this.persistentEntity = persistentEntity;
        }

        protected abstract void cascadePre(Relation.Cascade var1, Cnt var2, Dialect var3, AnnotationMetadata var4, Class<?> var5, List<Association> var6, Set<Object> var7);

        protected abstract void cascadePost(Relation.Cascade var1, Cnt var2, Dialect var3, AnnotationMetadata var4, Class<?> var5, List<Association> var6, Set<Object> var7);

        protected abstract void collectAutoPopulatedPreviousValues(DBOperation var1);

        protected abstract PS prepare(Cnt var1, DBOperation var2) throws Exception;

        protected abstract void setParameters(OpContext<Cnt, PS> var1, Cnt var2, PS var3, DBOperation var4) throws Exception;

        protected abstract void executeUpdate(PS var1, DBOperation2<Integer, Integer, Exc> var2) throws Exception;

        protected abstract void executeUpdate(PS var1) throws Exception;

        protected abstract void executeUpdateSetGeneratedId(PS var1) throws Exception;

        protected abstract void veto(Predicate<T> var1);

        protected T updateEntityId(BeanProperty<T, Object> identity, T entity, Object id) {
            if (id == null) {
                return entity;
            }
            if (identity.getType().isInstance(id)) {
                return (T)AbstractRepositoryOperations.this.setProperty(identity, entity, id);
            }
            return (T)AbstractRepositoryOperations.this.convertAndSetWithValue(identity, entity, id);
        }

        protected boolean triggerPrePersist() {
            if (!this.persistentEntity.hasPrePersistEventListeners()) {
                return false;
            }
            return this.triggerPre(arg_0 -> AbstractRepositoryOperations.this.entityEventRegistry.prePersist(arg_0));
        }

        protected boolean triggerPreUpdate() {
            if (!this.persistentEntity.hasPreUpdateEventListeners()) {
                return false;
            }
            return this.triggerPre(arg_0 -> AbstractRepositoryOperations.this.entityEventRegistry.preUpdate(arg_0));
        }

        protected boolean triggerPreRemove() {
            if (!this.persistentEntity.hasPreRemoveEventListeners()) {
                return false;
            }
            return this.triggerPre(arg_0 -> AbstractRepositoryOperations.this.entityEventRegistry.preRemove(arg_0));
        }

        protected void triggerPostUpdate() {
            if (!this.persistentEntity.hasPostUpdateEventListeners()) {
                return;
            }
            this.triggerPost(arg_0 -> AbstractRepositoryOperations.this.entityEventRegistry.postUpdate(arg_0));
        }

        protected void triggerPostRemove() {
            if (!this.persistentEntity.hasPostRemoveEventListeners()) {
                return;
            }
            this.triggerPost(arg_0 -> AbstractRepositoryOperations.this.entityEventRegistry.postRemove(arg_0));
        }

        protected void triggerPostPersist() {
            if (!this.persistentEntity.hasPostPersistEventListeners()) {
                return;
            }
            this.triggerPost(arg_0 -> AbstractRepositoryOperations.this.entityEventRegistry.postPersist(arg_0));
        }

        protected abstract boolean triggerPre(Function<EntityEventContext<Object>, Boolean> var1);

        protected abstract void triggerPost(Consumer<EntityEventContext<Object>> var1);
    }

    protected abstract class EntitiesOperations<T>
    extends BaseOperations<T> {
        protected EntitiesOperations(RuntimePersistentEntity<T> persistentEntity) {
            super(persistentEntity);
        }
    }

    protected abstract class EntityOperations<T>
    extends BaseOperations<T> {
        protected EntityOperations(RuntimePersistentEntity<T> persistentEntity) {
            super(persistentEntity);
        }
    }

    @FunctionalInterface
    protected static interface StatementSupplier<PS> {
        public PS create(String var1) throws Exception;
    }

    protected static interface DBOperation2<In1, In2, Exc extends Exception> {
        public void process(In1 var1, In2 var2) throws Exc;
    }

    protected static interface DBOperation1<In, Exc extends Exception> {
        public void process(In var1) throws Exc;
    }
}

