/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.reactive;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.reactive.FindSliceReactiveInterceptor;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Slice;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.reactive.AbstractReactiveInterceptor;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultFindSliceReactiveInterceptor
extends AbstractReactiveInterceptor<Object, Object>
implements FindSliceReactiveInterceptor<Object, Object> {
    protected DefaultFindSliceReactiveInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        if (context.hasAnnotation(Query.class)) {
            PreparedQuery<?, ?> preparedQuery = this.prepareQuery(methodKey, context);
            Pageable pageable = preparedQuery.getPageable();
            Mono publisher = Flux.from((Publisher)this.reactiveOperations.findAll(preparedQuery)).collectList().map(objects -> Slice.of((List)objects, (Pageable)pageable));
            return Publishers.convertPublisher((Object)publisher, (Class)context.getReturnType().getType());
        }
        PagedQuery pagedQuery = this.getPagedQuery(context);
        Mono result = Flux.from((Publisher)this.reactiveOperations.findAll(pagedQuery)).collectList().map(objects -> Slice.of((List)objects, (Pageable)pagedQuery.getPageable()));
        return Publishers.convertPublisher((Object)result, (Class)context.getReturnType().getType());
    }
}

