/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.criteria;

import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaQuery;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.runtime.criteria.RuntimePersistentEntityRoot;

final class RuntimePersistentEntityCriteriaQuery<T>
extends AbstractPersistentEntityCriteriaQuery<T> {
    private final RuntimeEntityRegistry runtimeEntityRegistry;

    public RuntimePersistentEntityCriteriaQuery(RuntimeEntityRegistry runtimeEntityRegistry) {
        this.runtimeEntityRegistry = runtimeEntityRegistry;
    }

    public <X> PersistentEntityRoot<X> from(Class<X> entityClass) {
        return this.from((PersistentEntity)this.runtimeEntityRegistry.getEntity(entityClass));
    }

    public <X> PersistentEntityRoot<X> from(PersistentEntity persistentEntity) {
        RuntimePersistentEntityRoot newEntityRoot;
        if (this.entityRoot != null) {
            throw new IllegalStateException("The root entity is already specified!");
        }
        this.entityRoot = newEntityRoot = new RuntimePersistentEntityRoot((RuntimePersistentEntity)persistentEntity);
        return newEntityRoot;
    }
}

