/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.operations.internal.DBOperation;
import io.micronaut.data.runtime.operations.internal.OpContext;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Internal
public class StoredSqlOperation
extends DBOperation {
    protected final String[] parameterBindingPaths;
    protected final String[] autoPopulatedPreviousProperties;
    protected final boolean isOptimisticLock;
    protected boolean expandedQuery;

    protected StoredSqlOperation(Dialect dialect, String query, String[] parameterBindingPaths, String[] autoPopulatedPreviousProperties, boolean isOptimisticLock) {
        super(query, dialect);
        Objects.requireNonNull(query, "Query cannot be null");
        Objects.requireNonNull(dialect, "Dialect cannot be null");
        this.parameterBindingPaths = parameterBindingPaths;
        this.autoPopulatedPreviousProperties = autoPopulatedPreviousProperties;
        this.isOptimisticLock = isOptimisticLock;
    }

    @Override
    public boolean isOptimisticLock() {
        return this.isOptimisticLock;
    }

    @Override
    public <T> Map<String, Object> collectAutoPopulatedPreviousValues(RuntimePersistentEntity<T> persistentEntity, T entity) {
        if (this.autoPopulatedPreviousProperties == null || this.autoPopulatedPreviousProperties.length == 0) {
            return null;
        }
        return Arrays.stream(this.autoPopulatedPreviousProperties).filter(StringUtils::isNotEmpty).map(propertyPath -> {
            Object value = entity;
            for (String property : propertyPath.split("\\.")) {
                if (value == null) break;
                value = BeanWrapper.getWrapper((Object)value).getRequiredProperty(property, Argument.OBJECT_ARGUMENT);
            }
            return new AbstractMap.SimpleEntry<String, Object>((String)propertyPath, value);
        }).filter(e -> e.getValue() != null).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    public <T> void checkForParameterToBeExpanded(final RuntimePersistentEntity<T> persistentEntity, final T entity, SqlQueryBuilder queryBuilder) {
        Iterator<Object> valuesIt = new Iterator<Object>(){
            int i;

            @Override
            public boolean hasNext() {
                return this.i >= StoredSqlOperation.this.parameterBindingPaths.length;
            }

            @Override
            public Object next() {
                Association association;
                RuntimePersistentProperty property;
                BeanProperty beanProperty;
                String stringPropertyPath = StoredSqlOperation.this.parameterBindingPaths[this.i];
                PersistentPropertyPath propertyPath = persistentEntity.getPropertyPath(stringPropertyPath);
                if (propertyPath == null) {
                    throw new IllegalStateException("Unrecognized path: " + stringPropertyPath);
                }
                Object value = entity;
                Iterator iterator = propertyPath.getAssociations().iterator();
                while (iterator.hasNext() && (value = (beanProperty = (property = (RuntimePersistentProperty)(association = (Association)iterator.next())).getProperty()).get(value)) != null) {
                }
                RuntimePersistentProperty property2 = (RuntimePersistentProperty)propertyPath.getProperty();
                if (value != null) {
                    BeanProperty beanProperty2 = property2.getProperty();
                    value = beanProperty2.get(value);
                }
                ++this.i;
                return value;
            }
        };
        String q = this.expandMultipleValues(this.parameterBindingPaths.length, valuesIt, this.query, queryBuilder);
        if (q != this.query) {
            this.expandedQuery = true;
            this.query = q;
        }
    }

    @Override
    public <T, Cnt, PS> void setParameters(OpContext<Cnt, PS> context, Cnt connection, PS stmt, RuntimePersistentEntity<T> persistentEntity, T entity, Map<String, Object> previousValues) {
        int index = context.shiftIndex(0);
        for (int i = 0; i < this.parameterBindingPaths.length; ++i) {
            String propertyPath = this.parameterBindingPaths[i];
            if (StringUtils.isEmpty((CharSequence)propertyPath)) {
                String autoPopulatedPreviousProperty;
                Object previousValue;
                if (previousValues != null && (previousValue = previousValues.get(autoPopulatedPreviousProperty = this.autoPopulatedPreviousProperties[i])) != null) {
                    PersistentPropertyPath pp = persistentEntity.getPropertyPath(autoPopulatedPreviousProperty);
                    if (pp == null) {
                        throw new IllegalStateException("Unrecognized path: " + autoPopulatedPreviousProperty);
                    }
                    index = this.setStatementParameter(context, stmt, index, pp.getProperty().getDataType(), previousValue, this.dialect);
                    continue;
                }
                index = this.setStatementParameter(context, stmt, index, DataType.ENTITY, entity, this.dialect);
                continue;
            }
            index = this.setPropertyPathParameter(context, connection, stmt, index, persistentEntity, entity, propertyPath);
        }
    }

    private <T, Cnt, PS> int setPropertyPathParameter(OpContext<Cnt, PS> context, Cnt connection, PS stmt, int index, RuntimePersistentEntity<T> persistentEntity, T entity, String propertyStringPath) {
        Association association;
        RuntimePersistentProperty property;
        BeanProperty beanProperty;
        PersistentPropertyPath propertyPath;
        if (propertyStringPath.startsWith("0.")) {
            propertyStringPath = propertyStringPath.substring(2);
        }
        if ((propertyPath = persistentEntity.getPropertyPath(propertyStringPath)) == null) {
            throw new IllegalStateException("Unrecognized path: " + propertyStringPath);
        }
        Object value = entity;
        Iterator iterator = propertyPath.getAssociations().iterator();
        while (iterator.hasNext() && (value = (beanProperty = (property = (RuntimePersistentProperty)(association = (Association)iterator.next())).getProperty()).get(value)) != null) {
        }
        RuntimePersistentProperty property2 = (RuntimePersistentProperty)propertyPath.getProperty();
        if (value != null) {
            BeanProperty beanProperty2 = property2.getProperty();
            value = beanProperty2.get(value);
        }
        DataType type = property2.getDataType();
        if (value == null && type == DataType.ENTITY) {
            RuntimePersistentEntity referencedEntity = context.getEntity(property2.getType());
            RuntimePersistentProperty identity = referencedEntity.getIdentity();
            if (identity == null) {
                throw new IllegalStateException("Cannot set an entity value without identity: " + referencedEntity);
            }
            property2 = identity;
            type = identity.getDataType();
        }
        value = context.convert(connection, value, property2);
        return this.setStatementParameter(context, stmt, index, type, value, this.dialect);
    }

    /*
     * Enabled aggressive block sorting
     */
    private <PS> int setStatementParameter(OpContext<?, PS> context, PS preparedStatement, int index, DataType dataType, Object value, Dialect dialect) {
        if (!this.expandedQuery) {
            context.setStatementParameter(preparedStatement, index, dataType, value, dialect);
            return index + 1;
        }
        List<Object> values = this.expandValue(value, dataType);
        if (values != null && values.isEmpty()) {
            value = null;
            values = null;
        }
        if (values == null) {
            context.setStatementParameter(preparedStatement, index, dataType, value, dialect);
            return index + 1;
        }
        Iterator<Object> iterator = values.iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            context.setStatementParameter(preparedStatement, index, dataType, v, dialect);
            ++index;
        }
        return index;
    }

    List<Object> expandValue(Object value, DataType dataType) {
        if (value == null || dataType.isArray() && dataType != DataType.BYTE_ARRAY || value instanceof byte[]) {
            return null;
        }
        if (value instanceof Iterable) {
            return CollectionUtils.iterableToList((Iterable)((Iterable)value));
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            if (len == 0) {
                return Collections.emptyList();
            }
            ArrayList<Object> list = new ArrayList<Object>(len);
            for (int j = 0; j < len; ++j) {
                Object o = Array.get(value, j);
                list.add(o);
            }
            return list;
        }
        return null;
    }

    String expandMultipleValues(int parametersSize, Iterator<Object> valuesIt, String query, SqlQueryBuilder queryBuilder) {
        int[] parametersListSizes = null;
        for (int i = 0; i < parametersSize; ++i) {
            int size;
            Object value;
            if (!valuesIt.hasNext() || (value = valuesIt.next()) == null || value instanceof byte[] || (size = this.sizeOf(value)) == 1) continue;
            if (parametersListSizes == null) {
                parametersListSizes = new int[parametersSize];
                Arrays.fill(parametersListSizes, 1);
            }
            parametersListSizes[i] = size;
        }
        if (parametersListSizes != null) {
            String positionalParameterFormat = queryBuilder.positionalParameterFormat();
            Pattern positionalParameterPattern = queryBuilder.positionalParameterPattern();
            String[] queryParametersSplit = positionalParameterPattern.split(query);
            StringBuilder sb = new StringBuilder(queryParametersSplit[0]);
            int inx = 1;
            for (int i = 0; i < parametersSize; ++i) {
                int parameterSetSize = parametersListSizes[i];
                sb.append(String.format(positionalParameterFormat, inx));
                for (int sx = 1; sx < parameterSetSize; ++sx) {
                    sb.append(",").append(String.format(positionalParameterFormat, inx + sx));
                }
                sb.append(queryParametersSplit[inx++]);
            }
            return sb.toString();
        }
        return query;
    }

    private int sizeOf(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).size();
        }
        if (value instanceof Iterable) {
            int i = 0;
            for (Object ignored : (Iterable)value) {
                ++i;
            }
            return i;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value);
        }
        return 1;
    }
}

