/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.reactive;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.reactive.FindPageReactiveInterceptor;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.reactive.AbstractReactiveInterceptor;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class DefaultFindPageReactiveInterceptor
extends AbstractReactiveInterceptor<Object, Object>
implements FindPageReactiveInterceptor<Object, Object> {
    protected DefaultFindPageReactiveInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        Publisher publisher;
        if (context.hasAnnotation(Query.class)) {
            PreparedQuery<?, ?> preparedQuery = this.prepareQuery(methodKey, context);
            PreparedQuery<?, Number> countQuery = this.prepareCountQuery(methodKey, context);
            publisher = Flux.from((Publisher)this.reactiveOperations.findOne(countQuery)).flatMap(total -> {
                Flux resultList = Flux.from((Publisher)this.reactiveOperations.findAll(preparedQuery));
                return resultList.collectList().map(list -> Page.of((List)list, (Pageable)preparedQuery.getPageable(), (long)total.longValue()));
            });
        } else {
            publisher = this.reactiveOperations.findPage(this.getPagedQuery(context));
        }
        return Publishers.convertPublisher((Object)publisher, (Class)context.getReturnType().getType());
    }
}

