/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.async;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.async.DeleteAllAsyncInterceptor;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.async.AbstractAsyncInterceptor;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

public class DefaultDeleteAllAsyncInterceptor<T>
extends AbstractAsyncInterceptor<T, Object>
implements DeleteAllAsyncInterceptor<T, Object> {
    protected DefaultDeleteAllAsyncInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    public CompletionStage<Object> intercept(RepositoryMethodKey methodKey, MethodInvocationContext<T, CompletionStage<Object>> context) {
        CompletionStage cs;
        Argument arg = context.getReturnType().asArgument();
        Optional<Iterable<Object>> deleteEntities = this.findEntitiesParameter(context, Object.class);
        Optional<Object> deleteEntity = this.findEntityParameter(context, Object.class);
        if (!deleteEntity.isPresent() && !deleteEntities.isPresent()) {
            PreparedQuery<?, ?> preparedQuery = this.prepareQuery(methodKey, context);
            cs = this.asyncDatastoreOperations.executeDelete(preparedQuery);
        } else {
            cs = this.asyncDatastoreOperations.deleteAll(this.getDeleteBatchOperation(context, deleteEntities.get()));
        }
        return cs.thenApply(number -> this.convertNumberArgumentIfNecessary((Number)number, (Argument<?>)arg));
    }
}

