/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.support;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.context.BeanRegistration;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.annotation.event.PostLoad;
import io.micronaut.data.annotation.event.PostPersist;
import io.micronaut.data.annotation.event.PostRemove;
import io.micronaut.data.annotation.event.PostUpdate;
import io.micronaut.data.annotation.event.PrePersist;
import io.micronaut.data.annotation.event.PreRemove;
import io.micronaut.data.annotation.event.PreUpdate;
import io.micronaut.data.event.EntityEventListener;
import io.micronaut.data.model.runtime.PropertyAutoPopulator;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.event.EntityEventRegistry;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
@Internal
public class DefaultRuntimeEntityRegistry
implements RuntimeEntityRegistry,
ApplicationContextProvider {
    private final Map<Class, RuntimePersistentEntity> entities = new ConcurrentHashMap<Class, RuntimePersistentEntity>(10);
    private final Map<Class<? extends Annotation>, PropertyAutoPopulator<?>> propertyPopulators;
    private final EntityEventRegistry eventRegistry;
    private final ApplicationContext applicationContext;

    public DefaultRuntimeEntityRegistry(EntityEventRegistry eventRegistry, Collection<BeanRegistration<PropertyAutoPopulator<?>>> propertyPopulators, ApplicationContext applicationContext) {
        this.eventRegistry = eventRegistry;
        this.propertyPopulators = new HashMap(propertyPopulators.size());
        for (BeanRegistration<PropertyAutoPopulator<?>> propertyPopulator : propertyPopulators) {
            PropertyAutoPopulator populator = (PropertyAutoPopulator)propertyPopulator.getBean();
            List typeArguments = propertyPopulator.getBeanDefinition().getTypeArguments(PropertyAutoPopulator.class);
            if (typeArguments.isEmpty()) continue;
            Class annotationType = ((Argument)typeArguments.iterator().next()).getType();
            if (this.propertyPopulators.containsKey(annotationType)) {
                throw new IllegalStateException("Multiple property populators for annotation of type are not allowed: " + annotationType);
            }
            this.propertyPopulators.put(annotationType, populator);
        }
        this.applicationContext = applicationContext;
    }

    @NonNull
    public Object autoPopulateRuntimeProperty(@NonNull RuntimePersistentProperty<?> persistentProperty, Object previousValue) {
        for (Map.Entry<Class<Annotation>, PropertyAutoPopulator<?>> entry : this.propertyPopulators.entrySet()) {
            if (!persistentProperty.getAnnotationMetadata().hasAnnotation(entry.getKey())) continue;
            PropertyAutoPopulator<?> populator = entry.getValue();
            return Objects.requireNonNull(populator.populate(persistentProperty, previousValue), () -> "PropertyAutoPopulator illegally returned null: " + populator.getClass());
        }
        throw new IllegalStateException("Cannot auto populate property: " + persistentProperty.getName() + " for entity: " + persistentProperty.getOwner().getName());
    }

    @NonNull
    public EntityEventListener<Object> getEntityEventListener() {
        return this.eventRegistry;
    }

    @NonNull
    public final <T> RuntimePersistentEntity<T> getEntity(@NonNull Class<T> type) {
        ArgumentUtils.requireNonNull((String)"type", type);
        RuntimePersistentEntity<T> entity = this.entities.get(type);
        if (entity == null) {
            entity = this.newEntity(type);
            this.entities.put(type, entity);
        }
        return entity;
    }

    @NonNull
    public <T> RuntimePersistentEntity<T> newEntity(@NonNull Class<T> type) {
        return new RuntimePersistentEntity<T>(type){
            final boolean hasPrePersistEventListeners;
            final boolean hasPreRemoveEventListeners;
            final boolean hasPreUpdateEventListeners;
            final boolean hasPostPersistEventListeners;
            final boolean hasPostRemoveEventListeners;
            final boolean hasPostUpdateEventListeners;
            final boolean hasPostLoadEventListeners;
            {
                this.hasPrePersistEventListeners = DefaultRuntimeEntityRegistry.this.eventRegistry.supports(this, PrePersist.class);
                this.hasPreRemoveEventListeners = DefaultRuntimeEntityRegistry.this.eventRegistry.supports(this, PreRemove.class);
                this.hasPreUpdateEventListeners = DefaultRuntimeEntityRegistry.this.eventRegistry.supports(this, PreUpdate.class);
                this.hasPostPersistEventListeners = DefaultRuntimeEntityRegistry.this.eventRegistry.supports(this, PostPersist.class);
                this.hasPostRemoveEventListeners = DefaultRuntimeEntityRegistry.this.eventRegistry.supports(this, PostRemove.class);
                this.hasPostUpdateEventListeners = DefaultRuntimeEntityRegistry.this.eventRegistry.supports(this, PostUpdate.class);
                this.hasPostLoadEventListeners = DefaultRuntimeEntityRegistry.this.eventRegistry.supports(this, PostLoad.class);
            }

            protected RuntimePersistentEntity<T> getEntity(Class<T> type) {
                return DefaultRuntimeEntityRegistry.this.getEntity(type);
            }

            public boolean hasPostUpdateEventListeners() {
                return this.hasPostUpdateEventListeners;
            }

            public boolean hasPostRemoveEventListeners() {
                return this.hasPostRemoveEventListeners;
            }

            public boolean hasPostLoadEventListeners() {
                return this.hasPostLoadEventListeners;
            }

            public boolean hasPrePersistEventListeners() {
                return this.hasPrePersistEventListeners;
            }

            public boolean hasPreUpdateEventListeners() {
                return this.hasPreUpdateEventListeners;
            }

            public boolean hasPreRemoveEventListeners() {
                return this.hasPreRemoveEventListeners;
            }

            public boolean hasPostPersistEventListeners() {
                return this.hasPostPersistEventListeners;
            }
        };
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

