/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal;

import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.event.EntityEventContext;
import io.micronaut.data.event.EntityEventListener;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.exceptions.OptimisticLockException;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.QueryParameter;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.PropertyAutoPopulator;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.repository.GenericRepository;
import io.micronaut.data.runtime.config.DataSettings;
import io.micronaut.data.runtime.date.DateTimeProvider;
import io.micronaut.data.runtime.event.DefaultEntityEventContext;
import io.micronaut.data.runtime.event.EntityEventRegistry;
import io.micronaut.data.runtime.mapper.QueryStatement;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.data.runtime.support.DefaultRuntimeEntityRegistry;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;

@Internal
public abstract class AbstractSqlRepositoryOperations<Cnt, RS, PS, Exc extends Exception> {
    protected static final Logger QUERY_LOG = DataSettings.QUERY_LOG;
    protected static final SqlQueryBuilder DEFAULT_SQL_BUILDER = new SqlQueryBuilder();
    protected final ResultReader<RS, String> columnNameResultSetReader;
    protected final ResultReader<RS, Integer> columnIndexResultSetReader;
    protected final QueryStatement<PS, Integer> preparedStatementWriter;
    protected final Map<Class, SqlQueryBuilder> queryBuilders = new HashMap<Class, SqlQueryBuilder>(10);
    protected final MediaTypeCodec jsonCodec;
    protected final EntityEventListener<Object> entityEventRegistry;
    protected final DateTimeProvider dateTimeProvider;
    protected final RuntimeEntityRegistry runtimeEntityRegistry;
    private final Map<QueryKey, SqlOperation> entityInserts = new ConcurrentHashMap<QueryKey, SqlOperation>(10);
    private final Map<QueryKey, SqlOperation> entityUpdates = new ConcurrentHashMap<QueryKey, SqlOperation>(10);
    private final Map<Association, String> associationInserts = new ConcurrentHashMap<Association, String>(10);
    private final Map<Class, RuntimePersistentProperty> idReaders = new ConcurrentHashMap<Class, RuntimePersistentProperty>(10);

    @Deprecated
    protected AbstractSqlRepositoryOperations(String dataSourceName, ResultReader<RS, String> columnNameResultSetReader, ResultReader<RS, Integer> columnIndexResultSetReader, QueryStatement<PS, Integer> preparedStatementWriter, List<MediaTypeCodec> codecs, DateTimeProvider<Object> dateTimeProvider, BeanContext beanContext) {
        this(dataSourceName, columnNameResultSetReader, columnIndexResultSetReader, preparedStatementWriter, codecs, dateTimeProvider, new DefaultRuntimeEntityRegistry(new EntityEventRegistry(beanContext), beanContext.getBeanRegistrations(PropertyAutoPopulator.class)), beanContext);
    }

    protected AbstractSqlRepositoryOperations(String dataSourceName, ResultReader<RS, String> columnNameResultSetReader, ResultReader<RS, Integer> columnIndexResultSetReader, QueryStatement<PS, Integer> preparedStatementWriter, List<MediaTypeCodec> codecs, DateTimeProvider<Object> dateTimeProvider, RuntimeEntityRegistry runtimeEntityRegistry, BeanContext beanContext) {
        this.dateTimeProvider = dateTimeProvider;
        this.runtimeEntityRegistry = runtimeEntityRegistry;
        this.entityEventRegistry = runtimeEntityRegistry.getEntityEventListener();
        this.columnNameResultSetReader = columnNameResultSetReader;
        this.columnIndexResultSetReader = columnIndexResultSetReader;
        this.preparedStatementWriter = preparedStatementWriter;
        this.jsonCodec = this.resolveJsonCodec(codecs);
        Collection beanDefinitions = beanContext.getBeanDefinitions(GenericRepository.class, Qualifiers.byStereotype(Repository.class));
        for (BeanDefinition beanDefinition : beanDefinitions) {
            String targetDs = beanDefinition.stringValue(Repository.class).orElse("default");
            if (!targetDs.equalsIgnoreCase(dataSourceName)) continue;
            Class beanType = beanDefinition.getBeanType();
            SqlQueryBuilder queryBuilder = new SqlQueryBuilder(beanDefinition.getAnnotationMetadata());
            this.queryBuilders.put(beanType, queryBuilder);
        }
    }

    private MediaTypeCodec resolveJsonCodec(List<MediaTypeCodec> codecs) {
        return CollectionUtils.isNotEmpty(codecs) ? (MediaTypeCodec)codecs.stream().filter(c -> c.getMediaTypes().contains(MediaType.APPLICATION_JSON_TYPE)).findFirst().orElse(null) : null;
    }

    @NonNull
    public final <T> RuntimePersistentEntity<T> getEntity(@NonNull Class<T> type) {
        return this.runtimeEntityRegistry.getEntity(type);
    }

    protected <T, R> PS prepareStatement(StatementSupplier<PS> statementFunction, @NonNull PreparedQuery<T, R> preparedQuery, boolean isUpdate, boolean isSingleResult) throws Exc {
        PS ps;
        Pageable pageable;
        final Object[] queryParameters = preparedQuery.getParameterArray();
        final int[] parameterBinding = preparedQuery.getIndexedParameterBinding();
        final DataType[] parameterTypes = preparedQuery.getIndexedParameterTypes();
        String[] indexedParameterPaths = preparedQuery.getIndexedParameterPaths();
        String[] indexedParameterAutoPopulatedPropertyPaths = preparedQuery.getIndexedParameterAutoPopulatedPropertyPaths();
        String[] indexedParameterAutoPopulatedPreviousPropertyPaths = preparedQuery.getIndexedParameterAutoPopulatedPreviousPropertyPaths();
        int[] indexedParameterAutoPopulatedPreviousPropertyIndexes = preparedQuery.getIndexedParameterAutoPopulatedPreviousPropertyIndexes();
        String query = preparedQuery.getQuery();
        SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(preparedQuery.getRepositoryType(), DEFAULT_SQL_BUILDER);
        Dialect dialect = queryBuilder.getDialect();
        RuntimePersistentEntity<T> persistentEntity = this.getEntity(preparedQuery.getRootEntity());
        Iterator<Object> valuesIterator = new Iterator<Object>(){
            int i;

            @Override
            public boolean hasNext() {
                if (this.i >= parameterBinding.length) {
                    return false;
                }
                int parameterIndex = parameterBinding[this.i];
                DataType dataType = parameterTypes[this.i];
                if (parameterIndex == -1 || dataType.isArray() && dataType != DataType.BYTE_ARRAY) {
                    ++this.i;
                    return this.hasNext();
                }
                return true;
            }

            @Override
            public Object next() {
                Object queryParameter = queryParameters[parameterBinding[this.i]];
                ++this.i;
                return queryParameter;
            }
        };
        query = this.expandMultipleValues(parameterBinding.length, valuesIterator, query, queryBuilder);
        if (!isUpdate && (pageable = preparedQuery.getPageable()) != Pageable.UNPAGED) {
            Class rootEntity = preparedQuery.getRootEntity();
            Sort sort = pageable.getSort();
            if (sort.isSorted()) {
                query = query + queryBuilder.buildOrderBy(this.getEntity(rootEntity), sort).getQuery();
            } else if (this.isSqlServerWithoutOrderBy(query, dialect)) {
                sort = this.sortById(persistentEntity);
                query = query + queryBuilder.buildOrderBy(persistentEntity, sort).getQuery();
            }
            if (isSingleResult && pageable.getOffset() > 0L) {
                pageable = Pageable.from((int)pageable.getNumber(), (int)1);
            }
            query = query + queryBuilder.buildPagination(pageable).getQuery();
        }
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Query: {}", (Object)query);
        }
        try {
            ps = statementFunction.create(query);
        }
        catch (Exception e) {
            throw new DataAccessException("Unable to prepare query [" + query + "]: " + e.getMessage(), (Throwable)e);
        }
        int index = this.shiftIndex(0);
        for (int i = 0; i < parameterBinding.length; ++i) {
            Object value;
            int parameterIndex = parameterBinding[i];
            DataType dataType = parameterTypes[i];
            if (parameterIndex > -1) {
                value = queryParameters[parameterIndex];
            } else {
                String propertyPath = indexedParameterPaths[i];
                String autoPopulatedPropertyPath = indexedParameterAutoPopulatedPropertyPaths[i];
                if (autoPopulatedPropertyPath != null) {
                    RuntimePersistentProperty persistentProperty = persistentEntity.getPropertyByName(autoPopulatedPropertyPath);
                    if (persistentProperty == null) {
                        throw new IllegalStateException("Cannot find auto populated property: " + autoPopulatedPropertyPath);
                    }
                    Object previousValue = null;
                    int autoPopulatedPreviousPropertyIndex = indexedParameterAutoPopulatedPreviousPropertyIndexes[i];
                    if (autoPopulatedPreviousPropertyIndex > -1) {
                        previousValue = queryParameters[autoPopulatedPreviousPropertyIndex];
                    } else {
                        String previousValuePath = indexedParameterAutoPopulatedPreviousPropertyPaths[i];
                        if (previousValuePath != null) {
                            previousValue = this.resolveQueryParameterByPath(query, i, queryParameters, previousValuePath);
                        }
                    }
                    value = this.runtimeEntityRegistry.autoPopulateRuntimeProperty(persistentProperty, previousValue);
                } else if (propertyPath != null) {
                    value = this.resolveQueryParameterByPath(query, i, queryParameters, propertyPath);
                } else {
                    throw new IllegalStateException("Invalid query [" + query + "]. Unable to establish parameter value for parameter at position: " + (i + 1));
                }
            }
            index = this.setExpandedStatementParameter(value, ps, index, dataType, dialect);
        }
        return ps;
    }

    private int setExpandedStatementParameter(Object value, PS ps, int index, DataType dataType, Dialect dialect) {
        if (value == null || dataType.isArray() && dataType != DataType.BYTE_ARRAY || value instanceof byte[]) {
            this.setStatementParameter(ps, index++, dataType, value, dialect);
        } else if (value instanceof Iterable) {
            Iterator iterator = ((Iterable)value).iterator();
            if (!iterator.hasNext()) {
                this.setStatementParameter(ps, index++, dataType, null, dialect);
            } else {
                while (iterator.hasNext()) {
                    this.setStatementParameter(ps, index++, dataType, iterator.next(), dialect);
                }
            }
        } else if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            if (len == 0) {
                this.setStatementParameter(ps, index++, dataType, null, dialect);
            } else {
                for (int j = 0; j < len; ++j) {
                    Object o = Array.get(value, j);
                    this.setStatementParameter(ps, index++, dataType, o, dialect);
                }
            }
        } else {
            this.setStatementParameter(ps, index++, dataType, value, dialect);
        }
        return index;
    }

    private String expandMultipleValues(int parametersSize, Iterator<Object> valuesIt, String query, SqlQueryBuilder queryBuilder) {
        int[] parametersListSizes = null;
        for (int i = 0; i < parametersSize; ++i) {
            int size;
            Object value;
            if (!valuesIt.hasNext() || (value = valuesIt.next()) == null || value instanceof byte[] || (size = this.sizeOf(value)) == 1) continue;
            if (parametersListSizes == null) {
                parametersListSizes = new int[parametersSize];
                Arrays.fill(parametersListSizes, 1);
            }
            parametersListSizes[i] = size;
        }
        if (parametersListSizes != null) {
            String positionalParameterFormat = queryBuilder.positionalParameterFormat();
            Pattern positionalParameterPattern = queryBuilder.positionalParameterPattern();
            String[] queryParametersSplit = positionalParameterPattern.split(query);
            StringBuilder sb = new StringBuilder(queryParametersSplit[0]);
            int inx = 1;
            for (int i = 0; i < parametersSize; ++i) {
                int parameterSetSize = parametersListSizes[i];
                sb.append(String.format(positionalParameterFormat, inx));
                for (int sx = 1; sx < parameterSetSize; ++sx) {
                    sb.append(",").append(String.format(positionalParameterFormat, inx + sx));
                }
                sb.append(queryParametersSplit[inx++]);
            }
            return sb.toString();
        }
        return query;
    }

    protected abstract void prepareStatement(Cnt var1, String var2, DBOperation1<PS, Exc> var3) throws Exc;

    protected abstract void prepareStatement(Cnt var1, Dialect var2, PersistentProperty var3, boolean var4, String var5, DBOperation1<PS, Exc> var6) throws Exc;

    protected <T> T afterCascadedOne(T entity, List<Association> associations, Object prevChild, Object newChild) {
        RuntimeAssociation association = (RuntimeAssociation)associations.iterator().next();
        if (associations.size() == 1) {
            RuntimeAssociation inverseAssociation;
            if (association.isForeignKey() && (inverseAssociation = (RuntimeAssociation)association.getInverseSide().orElse(null)) != null) {
                BeanProperty property = inverseAssociation.getProperty();
                entity = this.setProperty(property, entity, newChild);
            }
            if (prevChild != newChild) {
                entity = this.setProperty(association.getProperty(), entity, newChild);
            }
            return entity;
        }
        BeanProperty property = association.getProperty();
        Object innerEntity = property.get(entity);
        Object newInnerEntity = this.afterCascadedOne(innerEntity, associations.subList(1, associations.size()), prevChild, newChild);
        if (newInnerEntity != innerEntity) {
            innerEntity = this.convertAndSetWithValue(property, entity, newInnerEntity);
        }
        return (T)innerEntity;
    }

    protected <T> T afterCascadedMany(T entity, List<Association> associations, Iterable<Object> prevChildren, List<Object> newChildren) {
        RuntimeAssociation association = (RuntimeAssociation)associations.iterator().next();
        if (associations.size() == 1) {
            ListIterator<Object> iterator = newChildren.listIterator();
            while (iterator.hasNext()) {
                BeanProperty property;
                Object newc;
                RuntimeAssociation inverseAssociation;
                Object c = iterator.next();
                if (!association.isForeignKey() || (inverseAssociation = (RuntimeAssociation)association.getInverseSide().orElse(null)) == null || c == (newc = this.setProperty(property = inverseAssociation.getProperty(), c, entity))) continue;
                iterator.set(newc);
            }
            if (prevChildren != newChildren) {
                entity = this.convertAndSetWithValue(association.getProperty(), entity, newChildren);
            }
            return entity;
        }
        BeanProperty property = association.getProperty();
        Object innerEntity = property.get(entity);
        Object newInnerEntity = this.afterCascadedMany(innerEntity, associations.subList(1, associations.size()), prevChildren, newChildren);
        if (newInnerEntity != innerEntity) {
            innerEntity = this.convertAndSetWithValue(property, entity, newInnerEntity);
        }
        return (T)innerEntity;
    }

    protected <T> T triggerPostLoad(@NonNull T entity, RuntimePersistentEntity<T> pe, AnnotationMetadata annotationMetadata) {
        DefaultEntityEventContext<T> event = new DefaultEntityEventContext<T>(pe, entity);
        this.entityEventRegistry.postLoad(event);
        return event.getEntity();
    }

    protected <T> void persistOne(Cnt connection, AnnotationMetadata annotationMetadata, Class<?> repositoryType, SqlOperation sqlOperation, List<Association> associations, Set<Object> persisted, EntityOperations<T> op) {
        try {
            boolean vetoed;
            boolean hasGeneratedID;
            boolean bl = hasGeneratedID = op.persistentEntity.getIdentity() != null && op.persistentEntity.getIdentity().isGenerated();
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing SQL Insert: {}", (Object)sqlOperation.getQuery());
            }
            if (vetoed = op.triggerPrePersist()) {
                return;
            }
            op.cascadePre(Relation.Cascade.PERSIST, connection, sqlOperation.dialect, annotationMetadata, repositoryType, associations, persisted);
            this.prepareStatement(connection, sqlOperation.getDialect(), (PersistentProperty)op.persistentEntity.getIdentity(), hasGeneratedID, sqlOperation.getQuery(), stmt -> {
                op.setParameters(stmt, sqlOperation);
                if (hasGeneratedID) {
                    op.executeUpdateSetGeneratedId(stmt);
                } else {
                    op.executeUpdate(stmt);
                }
            });
            op.triggerPostPersist();
            op.cascadePost(Relation.Cascade.PERSIST, connection, sqlOperation.dialect, annotationMetadata, repositoryType, associations, persisted);
        }
        catch (Exception e) {
            throw new DataAccessException("SQL Error executing INSERT: " + e.getMessage(), (Throwable)e);
        }
    }

    protected <T> void persistInBatch(Cnt connection, AnnotationMetadata annotationMetadata, Class<?> repositoryType, SqlOperation sqlOperation, List<Association> associations, Set<Object> persisted, EntitiesOperations<T> op) {
        boolean hasGeneratedID = op.persistentEntity.getIdentity() != null && op.persistentEntity.getIdentity().isGenerated();
        try {
            boolean allVetoed = op.triggerPrePersist();
            if (allVetoed) {
                return;
            }
            op.cascadePre(Relation.Cascade.PERSIST, connection, sqlOperation.dialect, annotationMetadata, repositoryType, associations, persisted);
            this.prepareStatement(connection, sqlOperation.getDialect(), (PersistentProperty)op.persistentEntity.getIdentity(), hasGeneratedID, sqlOperation.getQuery(), stmt -> {
                if (QUERY_LOG.isDebugEnabled()) {
                    QUERY_LOG.debug("Executing Batch SQL Insert: {}", (Object)sqlOperation.getQuery());
                }
                op.setParameters(stmt, sqlOperation);
                if (hasGeneratedID) {
                    op.executeUpdateSetGeneratedId(stmt);
                } else {
                    op.executeUpdate(stmt);
                }
            });
            op.triggerPostPersist();
            op.cascadePost(Relation.Cascade.PERSIST, connection, sqlOperation.dialect, annotationMetadata, repositoryType, associations, persisted);
        }
        catch (Exception e) {
            throw new DataAccessException("SQL error executing INSERT: " + e.getMessage(), (Throwable)e);
        }
    }

    private <X, Y> X setProperty(BeanProperty<X, Y> beanProperty, X x, Y y) {
        if (beanProperty.isReadOnly()) {
            return (X)beanProperty.withValue(x, y);
        }
        beanProperty.set(x, y);
        return x;
    }

    private <B, T> B convertAndSetWithValue(BeanProperty<B, T> beanProperty, B bean, T value) {
        if (beanProperty.isReadOnly()) {
            Argument argument = beanProperty.asArgument();
            ArgumentConversionContext context = ConversionContext.of((Argument)argument);
            Object convertedValue = ConversionService.SHARED.convert(value, context).orElseThrow(() -> new ConversionErrorException(argument, context.getLastError().orElse(() -> new IllegalArgumentException("Value [" + value + "] cannot be converted to type : " + beanProperty.getType()))));
            return (B)beanProperty.withValue(bean, convertedValue);
        }
        beanProperty.convertAndSet(bean, value);
        return bean;
    }

    protected <T> void deleteOne(Cnt connection, Dialect dialect, AnnotationMetadata annotationMetadata, EntityOperations<T> op, SqlQueryBuilder queryBuilder) {
        StoredAnnotationMetadataSqlOperation sqlOperation = new StoredAnnotationMetadataSqlOperation(dialect, annotationMetadata);
        op.collectAutoPopulatedPreviousValues(sqlOperation);
        boolean vetoed = op.triggerPreRemove();
        if (vetoed) {
            return;
        }
        try {
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing SQL DELETE: {}", (Object)sqlOperation.getQuery());
            }
            op.checkForParameterToBeExpanded(sqlOperation, queryBuilder);
            this.prepareStatement(connection, sqlOperation.getQuery(), ps -> {
                op.setParameters(ps, sqlOperation);
                op.executeUpdate(ps, (entries, deleted) -> {
                    if (QUERY_LOG.isTraceEnabled()) {
                        QUERY_LOG.trace("Delete operation deleted {} records", deleted);
                    }
                    if (sqlOperation.isOptimisticLock()) {
                        this.checkOptimisticLocking((int)entries, (int)deleted);
                    }
                });
            });
            op.triggerPostRemove();
        }
        catch (OptimisticLockException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new DataAccessException("Error executing SQL DELETE: " + e.getMessage(), (Throwable)e);
        }
    }

    protected <T> void deleteInBatch(Cnt connection, Dialect dialect, AnnotationMetadata annotationMetadata, EntitiesOperations<T> op) {
        StoredAnnotationMetadataSqlOperation sqlOperation = new StoredAnnotationMetadataSqlOperation(dialect, annotationMetadata);
        op.collectAutoPopulatedPreviousValues(sqlOperation);
        boolean vetoed = op.triggerPreRemove();
        if (vetoed) {
            return;
        }
        try {
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing Batch SQL DELETE: {}", (Object)sqlOperation.getQuery());
            }
            this.prepareStatement(connection, sqlOperation.getQuery(), ps -> {
                op.setParameters(ps, sqlOperation);
                op.executeUpdate(ps, (entries, deleted) -> {
                    if (QUERY_LOG.isTraceEnabled()) {
                        QUERY_LOG.trace("Delete operation deleted {} records", deleted);
                    }
                    if (sqlOperation.isOptimisticLock()) {
                        this.checkOptimisticLocking((int)entries, (int)deleted);
                    }
                });
            });
            op.triggerPostRemove();
        }
        catch (OptimisticLockException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new DataAccessException("Error executing SQL DELETE: " + e.getMessage(), (Throwable)e);
        }
    }

    protected <T> void updateOne(Cnt connection, AnnotationMetadata annotationMetadata, Class<?> repositoryType, SqlOperation sqlOperation, List<Association> associations, Set<Object> persisted, EntityOperations<T> op) {
        op.collectAutoPopulatedPreviousValues(sqlOperation);
        boolean vetoed = op.triggerPreUpdate();
        if (vetoed) {
            return;
        }
        op.cascadePre(Relation.Cascade.UPDATE, connection, sqlOperation.dialect, annotationMetadata, repositoryType, associations, persisted);
        try {
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing SQL UPDATE: {}", (Object)sqlOperation.getQuery());
            }
            this.prepareStatement(connection, sqlOperation.getQuery(), ps -> {
                op.setParameters(ps, sqlOperation);
                op.executeUpdate(ps, (entries, rowsUpdated) -> {
                    if (QUERY_LOG.isTraceEnabled()) {
                        QUERY_LOG.trace("Update operation updated {} records", rowsUpdated);
                    }
                    if (sqlOperation.isOptimisticLock()) {
                        this.checkOptimisticLocking((int)entries, (int)rowsUpdated);
                    }
                });
            });
            op.triggerPostUpdate();
            op.cascadePost(Relation.Cascade.UPDATE, connection, sqlOperation.dialect, annotationMetadata, repositoryType, associations, persisted);
        }
        catch (OptimisticLockException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new DataAccessException("Error executing SQL UPDATE: " + e.getMessage(), (Throwable)e);
        }
    }

    protected <T> void updateInBatch(Cnt connection, AnnotationMetadata annotationMetadata, Class<?> repositoryType, StoredSqlOperation sqlOperation, List<Association> associations, Set<Object> persisted, EntitiesOperations<T> op) {
        op.collectAutoPopulatedPreviousValues(sqlOperation);
        op.triggerPreUpdate();
        try {
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing Batch SQL Update: {}", (Object)sqlOperation.getQuery());
            }
            op.cascadePre(Relation.Cascade.UPDATE, connection, sqlOperation.dialect, annotationMetadata, repositoryType, associations, persisted);
            this.prepareStatement(connection, sqlOperation.getQuery(), ps -> {
                op.setParameters(ps, sqlOperation);
                op.executeUpdate(ps, (expected, updated) -> {
                    if (QUERY_LOG.isTraceEnabled()) {
                        QUERY_LOG.trace("Update batch operation updated {} records", updated);
                    }
                    if (sqlOperation.isOptimisticLock()) {
                        this.checkOptimisticLocking((int)expected, (int)updated);
                    }
                });
            });
            op.cascadePost(Relation.Cascade.UPDATE, connection, sqlOperation.dialect, annotationMetadata, repositoryType, associations, persisted);
            op.triggerPostUpdate();
        }
        catch (OptimisticLockException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new DataAccessException("Error executing SQL UPDATE: " + e.getMessage(), (Throwable)e);
        }
    }

    private Object resolveQueryParameterByPath(String query, int i, Object[] queryParameters, String propertyPath) {
        int j = propertyPath.indexOf(46);
        if (j > -1) {
            String[] properties = propertyPath.split("\\.");
            Object value = queryParameters[Integer.parseInt(properties[0])];
            for (int k = 1; k < properties.length && value != null; ++k) {
                String property = properties[k];
                value = BeanWrapper.getWrapper((Object)value).getRequiredProperty(property, Argument.OBJECT_ARGUMENT);
            }
            return value;
        }
        throw new IllegalStateException("Invalid query [" + query + "]. Unable to establish parameter value for parameter at position: " + (i + 1));
    }

    protected int shiftIndex(int i) {
        return i + 1;
    }

    @NonNull
    protected final RuntimePersistentProperty<Object> getIdReader(@NonNull Object o) {
        Class<?> type = o.getClass();
        RuntimePersistentProperty beanProperty = this.idReaders.get(type);
        if (beanProperty == null) {
            RuntimePersistentEntity<?> entity = this.getEntity(type);
            RuntimePersistentProperty identity = entity.getIdentity();
            if (identity == null) {
                throw new DataAccessException("Entity has no ID: " + entity.getName());
            }
            beanProperty = identity;
            this.idReaders.put(type, beanProperty);
        }
        return beanProperty;
    }

    @NonNull
    protected final <T> Sort sortById(RuntimePersistentEntity<T> persistentEntity) {
        RuntimePersistentProperty identity = persistentEntity.getIdentity();
        if (identity == null) {
            throw new DataAccessException("Pagination requires an entity ID on SQL Server");
        }
        Sort sort = Sort.unsorted().order(Sort.Order.asc((String)identity.getName()));
        return sort;
    }

    protected final boolean isSqlServerWithoutOrderBy(String query, Dialect dialect) {
        return dialect == Dialect.SQL_SERVER && !query.contains(" ORDER BY ");
    }

    protected final int sizeOf(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).size();
        }
        if (value instanceof Iterable) {
            int i = 0;
            for (Object ignored : (Iterable)value) {
                ++i;
            }
            return i;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value);
        }
        return 1;
    }

    protected final void setStatementParameter(PS preparedStatement, int index, DataType dataType, Object value, Dialect dialect) {
        switch (dataType) {
            case UUID: {
                if (value == null || !dialect.requiresStringUUID(dataType)) break;
                value = value.toString();
                break;
            }
            case JSON: {
                if (value == null || this.jsonCodec == null || value.getClass().equals(String.class)) break;
                value = new String(this.jsonCodec.encode(value), StandardCharsets.UTF_8);
                break;
            }
            case ENTITY: {
                if (value == null) break;
                RuntimePersistentProperty<Object> idReader = this.getIdReader(value);
                Object id = idReader.getProperty().get(value);
                if (id == null) {
                    throw new DataAccessException("Supplied entity is a transient instance: " + value);
                }
                this.setStatementParameter(preparedStatement, index, idReader.getDataType(), id, dialect);
                return;
            }
        }
        dataType = dialect.getDataType(dataType);
        if (QUERY_LOG.isTraceEnabled()) {
            QUERY_LOG.trace("Binding parameter at position {} to value {} with data type: {}", new Object[]{index, value, dataType});
        }
        this.preparedStatementWriter.setDynamic(preparedStatement, index, dataType, value);
    }

    @NonNull
    protected SqlOperation resolveEntityInsert(AnnotationMetadata annotationMetadata, Class<?> repositoryType, @NonNull Class<?> rootEntity, @NonNull RuntimePersistentEntity<?> persistentEntity) {
        return this.entityInserts.computeIfAbsent(new QueryKey(repositoryType, rootEntity), queryKey -> {
            SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER);
            QueryResult queryResult = queryBuilder.buildInsert(annotationMetadata, (PersistentEntity)persistentEntity);
            return new StoredSqlOperation(queryBuilder.getDialect(), queryResult.getQuery(), (String[])queryResult.getParameterBindings().stream().map(QueryParameterBinding::getPath).toArray(String[]::new), new String[0], false);
        });
    }

    protected <T> String resolveAssociationInsert(Class repositoryType, RuntimePersistentEntity<T> persistentEntity, RuntimeAssociation<T> association) {
        return this.associationInserts.computeIfAbsent((Association)association, association1 -> {
            SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER);
            return queryBuilder.buildJoinTableInsert((PersistentEntity)persistentEntity, association1);
        });
    }

    protected <T> void cascade(Dialect dialect, AnnotationMetadata annotationMetadata, Class<?> repositoryType, boolean fkOnly, Relation.Cascade cascadeType, CascadeContext ctx, RuntimePersistentEntity<T> persistentEntity, T entity, List<CascadeOp> cascadeOps) {
        block4: for (RuntimeAssociation association : persistentEntity.getAssociations()) {
            BeanProperty beanProperty = association.getProperty();
            Object child = beanProperty.get(entity);
            if (child == null) continue;
            if (association instanceof Embedded) {
                this.cascade(dialect, annotationMetadata, repositoryType, fkOnly, cascadeType, ctx.embedded((Association)association), association.getAssociatedEntity(), child, cascadeOps);
                continue;
            }
            if (!association.doesCascade(new Relation.Cascade[]{cascadeType}) || !fkOnly && association.isForeignKey() || association.getInverseSide().map(assoc -> ctx.rootAssociations.contains(assoc) || ctx.associations.contains(assoc)).orElse(false).booleanValue()) continue;
            RuntimePersistentEntity associatedEntity = association.getAssociatedEntity();
            switch (association.getKind()) {
                case ONE_TO_ONE: 
                case MANY_TO_ONE: {
                    cascadeOps.add(new CascadeOneOp(dialect, annotationMetadata, repositoryType, ctx.relation((Association)association), cascadeType, (RuntimePersistentEntity<Object>)associatedEntity, child));
                    continue block4;
                }
                case ONE_TO_MANY: 
                case MANY_TO_MANY: {
                    RuntimeAssociation inverse = association.getInverseSide().orElse(null);
                    ArrayList children = (ArrayList)association.getProperty().get(entity);
                    if (!children.iterator().hasNext()) continue block4;
                    if (inverse != null && inverse.getKind() == Relation.Kind.MANY_TO_ONE) {
                        ArrayList entities = new ArrayList(CollectionUtils.iterableToList((Iterable)children));
                        ListIterator iterator = entities.listIterator();
                        while (iterator.hasNext()) {
                            Object c = iterator.next();
                            BeanProperty property = inverse.getProperty();
                            c = this.setProperty(property, c, entity);
                            iterator.set(c);
                        }
                        children = entities;
                    }
                    cascadeOps.add(new CascadeManyOp(dialect, annotationMetadata, repositoryType, ctx.relation((Association)association), cascadeType, (RuntimePersistentEntity<Object>)associatedEntity, children));
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Cannot cascade for relation: " + association.getKind());
        }
    }

    protected <T> void persistJoinTableAssociation(Cnt connection, Class<?> repositoryType, Dialect dialect, Association association, Object parent, BaseOperations<T> op) {
        RuntimePersistentEntity<?> entity = this.getEntity(parent.getClass());
        SqlOperation sqlInsertOperation = this.resolveSqlInsertAssociation(repositoryType, dialect, (RuntimeAssociation)association, entity, parent);
        try {
            this.prepareStatement(connection, sqlInsertOperation.getQuery(), ps -> {
                op.setParameters(ps, sqlInsertOperation);
                op.executeUpdate(ps);
            });
        }
        catch (Exception e) {
            throw new DataAccessException("SQL error executing INSERT: " + e.getMessage(), (Throwable)e);
        }
    }

    private <T> SqlOperation resolveSqlInsertAssociation(Class<?> repositoryType, Dialect dialect, RuntimeAssociation<T> association, final RuntimePersistentEntity<T> persistentEntity, final T entity) {
        String sqlInsert = this.resolveAssociationInsert(repositoryType, persistentEntity, association);
        return new SqlOperation(sqlInsert, dialect){

            public <K> void setParameters(PS ps, RuntimePersistentEntity<K> pe, K e, Map<String, Object> previousValues) {
                int i = 0;
                for (Map.Entry property : AbstractSqlRepositoryOperations.this.idPropertiesWithValues((PersistentProperty)persistentEntity.getIdentity(), entity).collect(Collectors.toList())) {
                    AbstractSqlRepositoryOperations.this.setStatementParameter(ps, AbstractSqlRepositoryOperations.this.shiftIndex(i++), ((PersistentProperty)property.getKey()).getDataType(), property.getValue(), this.dialect);
                }
                for (Map.Entry property : AbstractSqlRepositoryOperations.this.idPropertiesWithValues((PersistentProperty)pe.getIdentity(), e).collect(Collectors.toList())) {
                    AbstractSqlRepositoryOperations.this.setStatementParameter(ps, AbstractSqlRepositoryOperations.this.shiftIndex(i++), ((PersistentProperty)property.getKey()).getDataType(), property.getValue(), this.dialect);
                }
            }
        };
    }

    private Stream<Map.Entry<PersistentProperty, Object>> idPropertiesWithValues(PersistentProperty property, Object value) {
        Object propertyValue = ((RuntimePersistentProperty)property).getProperty().get(value);
        if (property instanceof Embedded) {
            Embedded embedded = (Embedded)property;
            PersistentEntity embeddedEntity = embedded.getAssociatedEntity();
            return embeddedEntity.getPersistentProperties().stream().flatMap(prop -> this.idPropertiesWithValues((PersistentProperty)prop, propertyValue));
        }
        if (property instanceof Association) {
            Association association = (Association)property;
            if (association.isForeignKey()) {
                return Stream.empty();
            }
            PersistentEntity associatedEntity = association.getAssociatedEntity();
            PersistentProperty identity = associatedEntity.getIdentity();
            if (identity == null) {
                throw new IllegalStateException("Identity cannot be missing for: " + associatedEntity);
            }
            return this.idPropertiesWithValues(identity, propertyValue);
        }
        return Stream.of(new AbstractMap.SimpleEntry<PersistentProperty, Object>(property, propertyValue));
    }

    protected boolean isSupportsBatchInsert(PersistentEntity persistentEntity, Dialect dialect) {
        switch (dialect) {
            case SQL_SERVER: {
                return false;
            }
            case MYSQL: 
            case ORACLE: {
                if (persistentEntity.getIdentity() != null) {
                    return !persistentEntity.getIdentity().isGenerated();
                }
                return false;
            }
        }
        return true;
    }

    protected boolean isSupportsBatchUpdate(PersistentEntity persistentEntity, Dialect dialect) {
        return true;
    }

    protected boolean isSupportsBatchDelete(PersistentEntity persistentEntity, Dialect dialect) {
        return true;
    }

    @NonNull
    protected SqlOperation resolveEntityUpdate(AnnotationMetadata annotationMetadata, Class<?> repositoryType, @NonNull Class<?> rootEntity, @NonNull RuntimePersistentEntity<?> persistentEntity) {
        QueryKey key = new QueryKey(repositoryType, rootEntity);
        return this.entityUpdates.computeIfAbsent(key, queryKey -> {
            SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER);
            RuntimePersistentProperty identity = persistentEntity.getIdentity();
            String idName = identity != null ? identity.getName() : "id";
            QueryModel queryModel = QueryModel.from((PersistentEntity)persistentEntity).idEq(new QueryParameter(idName));
            List updateProperties = persistentEntity.getPersistentProperties().stream().filter(p -> (!(p instanceof Association) || !((Association)p).isForeignKey()) && p.getAnnotationMetadata().booleanValue(AutoPopulated.class, "updateable").orElse(true) != false).map(PersistentProperty::getName).collect(Collectors.toList());
            QueryResult queryResult = queryBuilder.buildUpdate(annotationMetadata, queryModel, updateProperties);
            return new StoredSqlOperation(queryBuilder.getDialect(), queryResult.getQuery(), (String[])queryResult.getParameterBindings().stream().map(QueryParameterBinding::getPath).toArray(String[]::new), new String[0], false);
        });
    }

    protected void checkOptimisticLocking(int expected, int received) {
        if (received != expected) {
            throw new OptimisticLockException("Execute update returned unexpected row count. Expected: " + expected + " got: " + received);
        }
    }

    protected boolean isOnlySingleEndedJoins(RuntimePersistentEntity<?> rootPersistentEntity, Set<JoinPath> joinFetchPaths) {
        boolean onlySingleEndedJoins = joinFetchPaths.isEmpty() || joinFetchPaths.stream().flatMap(jp -> {
            PersistentPropertyPath propertyPath = rootPersistentEntity.getPropertyPath(jp.getPath());
            if (propertyPath == null) {
                return Stream.empty();
            }
            if (propertyPath.getProperty() instanceof Association) {
                return Stream.concat(propertyPath.getAssociations().stream(), Stream.of((Association)propertyPath.getProperty()));
            }
            return propertyPath.getAssociations().stream();
        }).allMatch(association -> association.getKind() == Relation.Kind.EMBEDDED || association.getKind().isSingleEnded());
        return onlySingleEndedJoins;
    }

    private static List<Association> associated(List<Association> associations, Association association) {
        if (associations == null) {
            return Collections.singletonList(association);
        }
        ArrayList<Association> newAssociations = new ArrayList<Association>(associations.size() + 1);
        newAssociations.addAll(associations);
        newAssociations.add(association);
        return newAssociations;
    }

    protected static final class CascadeContext {
        public final List<Association> rootAssociations;
        public final Object parent;
        public final List<Association> associations;

        CascadeContext(List<Association> rootAssociations, Object parent, List<Association> associations) {
            this.rootAssociations = rootAssociations;
            this.parent = parent;
            this.associations = associations;
        }

        public static CascadeContext of(List<Association> rootAssociations, Object parent) {
            return new CascadeContext(rootAssociations, parent, Collections.emptyList());
        }

        CascadeContext embedded(Association association) {
            return new CascadeContext(this.rootAssociations, this.parent, AbstractSqlRepositoryOperations.associated(this.associations, association));
        }

        CascadeContext relation(Association association) {
            return new CascadeContext(this.rootAssociations, this.parent, AbstractSqlRepositoryOperations.associated(this.associations, association));
        }

        public Association getAssociation() {
            return (Association)CollectionUtils.last(this.associations);
        }
    }

    protected static final class CascadeManyOp
    extends CascadeOp {
        public final Iterable<Object> children;

        CascadeManyOp(Dialect dialect, AnnotationMetadata annotationMetadata, Class<?> repositoryType, CascadeContext ctx, Relation.Cascade cascadeType, RuntimePersistentEntity<Object> childPersistentEntity, Iterable<Object> children) {
            super(dialect, annotationMetadata, repositoryType, ctx, cascadeType, childPersistentEntity);
            this.children = children;
        }
    }

    protected static final class CascadeOneOp
    extends CascadeOp {
        public final Object child;

        CascadeOneOp(Dialect dialect, AnnotationMetadata annotationMetadata, Class<?> repositoryType, CascadeContext ctx, Relation.Cascade cascadeType, RuntimePersistentEntity<Object> childPersistentEntity, Object child) {
            super(dialect, annotationMetadata, repositoryType, ctx, cascadeType, childPersistentEntity);
            this.child = child;
        }
    }

    protected static abstract class CascadeOp {
        public final Dialect dialect;
        public final AnnotationMetadata annotationMetadata;
        public final Class<?> repositoryType;
        public final CascadeContext ctx;
        public final Relation.Cascade cascadeType;
        public final RuntimePersistentEntity<Object> childPersistentEntity;

        CascadeOp(Dialect dialect, AnnotationMetadata annotationMetadata, Class<?> repositoryType, CascadeContext ctx, Relation.Cascade cascadeType, RuntimePersistentEntity<Object> childPersistentEntity) {
            this.dialect = dialect;
            this.annotationMetadata = annotationMetadata;
            this.repositoryType = repositoryType;
            this.ctx = ctx;
            this.cascadeType = cascadeType;
            this.childPersistentEntity = childPersistentEntity;
        }
    }

    protected abstract class SqlOperation {
        protected String query;
        protected final Dialect dialect;

        protected SqlOperation(String query, Dialect dialect) {
            this.query = query;
            this.dialect = dialect;
        }

        public String exandedQuery() {
            return this.query;
        }

        public String getQuery() {
            return this.query;
        }

        public Dialect getDialect() {
            return this.dialect;
        }

        public boolean isOptimisticLock() {
            return false;
        }

        public <T> Map<String, Object> collectAutoPopulatedPreviousValues(RuntimePersistentEntity<T> persistentEntity, T entity) {
            return null;
        }

        public abstract <T> void setParameters(PS var1, RuntimePersistentEntity<T> var2, T var3, Map<String, Object> var4);

        public <T> void setParameters(PS stmt, RuntimePersistentEntity<T> persistentEntity, T entity) {
            this.setParameters(stmt, persistentEntity, entity, null);
        }
    }

    protected class StoredSqlOperation
    extends SqlOperation {
        protected final String[] parameterBindingPaths;
        protected final String[] autoPopulatedPreviousProperties;
        protected final boolean isOptimisticLock;
        protected boolean expandedQuery;

        protected StoredSqlOperation(Dialect dialect, String query, String[] parameterBindingPaths, String[] autoPopulatedPreviousProperties, boolean isOptimisticLock) {
            super(query, dialect);
            Objects.requireNonNull(query, "Query cannot be null");
            Objects.requireNonNull(dialect, "Dialect cannot be null");
            this.parameterBindingPaths = parameterBindingPaths;
            this.autoPopulatedPreviousProperties = autoPopulatedPreviousProperties;
            this.isOptimisticLock = isOptimisticLock;
        }

        @Override
        public boolean isOptimisticLock() {
            return this.isOptimisticLock;
        }

        @Override
        public <T> Map<String, Object> collectAutoPopulatedPreviousValues(RuntimePersistentEntity<T> persistentEntity, T entity) {
            if (this.autoPopulatedPreviousProperties == null || this.autoPopulatedPreviousProperties.length == 0) {
                return null;
            }
            return Arrays.stream(this.autoPopulatedPreviousProperties).filter(StringUtils::isNotEmpty).map(propertyPath -> {
                Object value = entity;
                for (String property : propertyPath.split("\\.")) {
                    if (value == null) break;
                    value = BeanWrapper.getWrapper((Object)value).getRequiredProperty(property, Argument.OBJECT_ARGUMENT);
                }
                return new AbstractMap.SimpleEntry<String, Object>((String)propertyPath, value);
            }).filter(e -> e.getValue() != null).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        }

        public <T> void checkForParameterToBeExpanded(final RuntimePersistentEntity<T> persistentEntity, final T entity, SqlQueryBuilder queryBuilder) {
            Iterator<Object> valuesIt = new Iterator<Object>(){
                int i;

                @Override
                public boolean hasNext() {
                    return this.i >= StoredSqlOperation.this.parameterBindingPaths.length;
                }

                @Override
                public Object next() {
                    Association association;
                    RuntimePersistentProperty property;
                    BeanProperty beanProperty;
                    String stringPropertyPath = StoredSqlOperation.this.parameterBindingPaths[this.i];
                    PersistentPropertyPath propertyPath = persistentEntity.getPropertyPath(stringPropertyPath);
                    if (propertyPath == null) {
                        throw new IllegalStateException("Unrecognized path: " + stringPropertyPath);
                    }
                    Object value = entity;
                    Iterator iterator = propertyPath.getAssociations().iterator();
                    while (iterator.hasNext() && (value = (beanProperty = (property = (RuntimePersistentProperty)(association = (Association)iterator.next())).getProperty()).get(value)) != null) {
                    }
                    RuntimePersistentProperty property2 = (RuntimePersistentProperty)propertyPath.getProperty();
                    if (value != null) {
                        BeanProperty beanProperty2 = property2.getProperty();
                        value = beanProperty2.get(value);
                    }
                    ++this.i;
                    return value;
                }
            };
            String q = AbstractSqlRepositoryOperations.this.expandMultipleValues(this.parameterBindingPaths.length, valuesIt, this.query, queryBuilder);
            if (q != this.query) {
                this.expandedQuery = true;
                this.query = q;
            }
        }

        @Override
        public <T> void setParameters(PS stmt, RuntimePersistentEntity<T> persistentEntity, T entity, Map<String, Object> previousValues) {
            for (int i = 0; i < this.parameterBindingPaths.length; ++i) {
                String propertyPath = this.parameterBindingPaths[i];
                if (StringUtils.isEmpty((CharSequence)propertyPath)) {
                    String autoPopulatedPreviousProperty;
                    Object previousValue;
                    if (previousValues != null && (previousValue = previousValues.get(autoPopulatedPreviousProperty = this.autoPopulatedPreviousProperties[i])) != null) {
                        PersistentPropertyPath pp = persistentEntity.getPropertyPath(autoPopulatedPreviousProperty);
                        if (pp == null) {
                            throw new IllegalStateException("Unrecognized path: " + autoPopulatedPreviousProperty);
                        }
                        this.setStatementParameter(stmt, AbstractSqlRepositoryOperations.this.shiftIndex(i), pp.getProperty().getDataType(), previousValue, this.dialect);
                        continue;
                    }
                    this.setStatementParameter(stmt, AbstractSqlRepositoryOperations.this.shiftIndex(i), DataType.ENTITY, entity, this.dialect);
                    continue;
                }
                this.setPropertyPathParameter(stmt, AbstractSqlRepositoryOperations.this.shiftIndex(i), persistentEntity, entity, propertyPath);
            }
        }

        private <T> void setPropertyPathParameter(PS stmt, int index, RuntimePersistentEntity<T> persistentEntity, T entity, String propertyStringPath) {
            Association association;
            RuntimePersistentProperty property;
            BeanProperty beanProperty;
            PersistentPropertyPath propertyPath;
            if (propertyStringPath.startsWith("0.")) {
                propertyStringPath = propertyStringPath.substring(2);
            }
            if ((propertyPath = persistentEntity.getPropertyPath(propertyStringPath)) == null) {
                throw new IllegalStateException("Unrecognized path: " + propertyStringPath);
            }
            Object value = entity;
            Iterator iterator = propertyPath.getAssociations().iterator();
            while (iterator.hasNext() && (value = (beanProperty = (property = (RuntimePersistentProperty)(association = (Association)iterator.next())).getProperty()).get(value)) != null) {
            }
            RuntimePersistentProperty property2 = (RuntimePersistentProperty)propertyPath.getProperty();
            if (value != null) {
                BeanProperty beanProperty2 = property2.getProperty();
                value = beanProperty2.get(value);
            }
            DataType type = property2.getDataType();
            if (value == null && type == DataType.ENTITY) {
                RuntimePersistentEntity referencedEntity = AbstractSqlRepositoryOperations.this.getEntity(property2.getType());
                RuntimePersistentProperty identity = referencedEntity.getIdentity();
                if (identity == null) {
                    throw new IllegalStateException("Cannot set an entity value without identity: " + referencedEntity);
                }
                type = identity.getDataType();
            }
            this.setStatementParameter(stmt, index, type, value, this.dialect);
        }

        private void setStatementParameter(PS preparedStatement, int index, DataType dataType, Object value, Dialect dialect) {
            if (this.expandedQuery) {
                AbstractSqlRepositoryOperations.this.setExpandedStatementParameter(value, preparedStatement, index, dataType, dialect);
            } else {
                AbstractSqlRepositoryOperations.this.setStatementParameter(preparedStatement, index, dataType, value, dialect);
            }
        }
    }

    protected class StoredAnnotationMetadataSqlOperation
    extends StoredSqlOperation {
        public StoredAnnotationMetadataSqlOperation(Dialect dialect, AnnotationMetadata annotationMetadata) {
            super(dialect, annotationMetadata.stringValue(Query.class, "rawQuery").orElseGet(() -> annotationMetadata.stringValue(Query.class).orElse(null)), annotationMetadata.stringValues(DataMethod.class, "parameterBindingPaths"), annotationMetadata.stringValues(DataMethod.class, "parameterBindingAutoPopulatedPreviousPaths"), annotationMetadata.booleanValue(DataMethod.class, "optimisticLock").orElse(false));
        }
    }

    protected abstract class BaseOperations<T> {
        protected final RuntimePersistentEntity<T> persistentEntity;

        protected BaseOperations(RuntimePersistentEntity<T> persistentEntity) {
            this.persistentEntity = persistentEntity;
        }

        protected abstract void cascadePre(Relation.Cascade var1, Cnt var2, Dialect var3, AnnotationMetadata var4, Class<?> var5, List<Association> var6, Set<Object> var7);

        protected abstract void cascadePost(Relation.Cascade var1, Cnt var2, Dialect var3, AnnotationMetadata var4, Class<?> var5, List<Association> var6, Set<Object> var7);

        protected abstract void collectAutoPopulatedPreviousValues(SqlOperation var1);

        protected void checkForParameterToBeExpanded(SqlOperation sqlOperation, SqlQueryBuilder queryBuilder) {
        }

        protected abstract void setParameters(PS var1, SqlOperation var2) throws Exception;

        protected abstract void executeUpdate(PS var1, DBOperation2<Integer, Integer, Exc> var2) throws Exception;

        protected abstract void executeUpdate(PS var1) throws Exception;

        protected abstract void executeUpdateSetGeneratedId(PS var1) throws Exception;

        protected abstract void veto(Predicate<T> var1);

        protected T updateEntityId(BeanProperty<T, Object> identity, T entity, Object id) {
            if (id == null) {
                return entity;
            }
            if (identity.getType().isInstance(id)) {
                return (T)AbstractSqlRepositoryOperations.this.setProperty(identity, entity, id);
            }
            return (T)AbstractSqlRepositoryOperations.this.convertAndSetWithValue(identity, entity, id);
        }

        protected boolean triggerPrePersist() {
            if (!this.persistentEntity.hasPrePersistEventListeners()) {
                return false;
            }
            return this.triggerPre(arg_0 -> AbstractSqlRepositoryOperations.this.entityEventRegistry.prePersist(arg_0));
        }

        protected boolean triggerPreUpdate() {
            if (!this.persistentEntity.hasPreUpdateEventListeners()) {
                return false;
            }
            return this.triggerPre(arg_0 -> AbstractSqlRepositoryOperations.this.entityEventRegistry.preUpdate(arg_0));
        }

        protected boolean triggerPreRemove() {
            if (!this.persistentEntity.hasPreRemoveEventListeners()) {
                return false;
            }
            return this.triggerPre(arg_0 -> AbstractSqlRepositoryOperations.this.entityEventRegistry.preRemove(arg_0));
        }

        protected void triggerPostUpdate() {
            if (!this.persistentEntity.hasPostUpdateEventListeners()) {
                return;
            }
            this.triggerPost(arg_0 -> AbstractSqlRepositoryOperations.this.entityEventRegistry.postUpdate(arg_0));
        }

        protected void triggerPostRemove() {
            if (!this.persistentEntity.hasPostRemoveEventListeners()) {
                return;
            }
            this.triggerPost(arg_0 -> AbstractSqlRepositoryOperations.this.entityEventRegistry.postRemove(arg_0));
        }

        protected void triggerPostPersist() {
            if (!this.persistentEntity.hasPostPersistEventListeners()) {
                return;
            }
            this.triggerPost(arg_0 -> AbstractSqlRepositoryOperations.this.entityEventRegistry.postPersist(arg_0));
        }

        protected abstract boolean triggerPre(Function<EntityEventContext<Object>, Boolean> var1);

        protected abstract void triggerPost(Consumer<EntityEventContext<Object>> var1);
    }

    protected abstract class EntitiesOperations<T>
    extends BaseOperations<T> {
        protected EntitiesOperations(RuntimePersistentEntity<T> persistentEntity) {
            super(persistentEntity);
        }
    }

    protected abstract class EntityOperations<T>
    extends BaseOperations<T> {
        protected EntityOperations(RuntimePersistentEntity<T> persistentEntity) {
            super(persistentEntity);
        }
    }

    private class QueryKey {
        final Class repositoryType;
        final Class entityType;

        QueryKey(Class repositoryType, Class entityType) {
            this.repositoryType = repositoryType;
            this.entityType = entityType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryKey queryKey = (QueryKey)o;
            return this.repositoryType.equals(queryKey.repositoryType) && this.entityType.equals(queryKey.entityType);
        }

        public int hashCode() {
            return Objects.hash(this.repositoryType, this.entityType);
        }
    }

    @FunctionalInterface
    protected static interface StatementSupplier<PS> {
        public PS create(String var1) throws Exception;
    }

    protected static interface DBOperation2<In1, In2, Exc extends Exception> {
        public void process(In1 var1, In2 var2) throws Exc;
    }

    protected static interface DBOperation1<In, Exc extends Exception> {
        public void process(In var1) throws Exc;
    }
}

