/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.async;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.async.DeleteAllAsyncInterceptor;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.async.AbstractAsyncInterceptor;
import java.util.concurrent.CompletionStage;

public class DefaultDeleteAllAsyncInterceptor<T>
extends AbstractAsyncInterceptor<T, Number>
implements DeleteAllAsyncInterceptor<T> {
    protected DefaultDeleteAllAsyncInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    public CompletionStage<Number> intercept(RepositoryMethodKey methodKey, MethodInvocationContext<T, CompletionStage<Number>> context) {
        Argument arg = context.getReturnType().asArgument();
        if (context.hasAnnotation(Query.class)) {
            PreparedQuery<?, ?> preparedQuery = this.prepareQuery(methodKey, context);
            return this.asyncDatastoreOperations.executeUpdate(preparedQuery).thenApply(number -> this.convertNumberArgumentIfNecessary((Number)number, (Argument<?>)arg));
        }
        Object[] parameterValues = context.getParameterValues();
        Class<?> rootEntity = this.getRequiredRootEntity(context);
        if (parameterValues.length == 1 && parameterValues[0] instanceof Iterable) {
            DeleteBatchOperation<?> batchOperation = this.getDeleteBatchOperation(context, rootEntity, (Iterable)parameterValues[0]);
            return this.asyncDatastoreOperations.deleteAll(batchOperation).thenApply(number -> this.convertNumberArgumentIfNecessary((Number)number, (Argument<?>)arg));
        }
        if (parameterValues.length == 0) {
            DeleteBatchOperation<?> batchOperation = this.getDeleteAllBatchOperation(context, rootEntity);
            return this.asyncDatastoreOperations.deleteAll(batchOperation).thenApply(number -> this.convertNumberArgumentIfNecessary((Number)number, (Argument<?>)arg));
        }
        throw new IllegalArgumentException("Unexpected argument types received to deleteAll method");
    }
}

