/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.DeleteAllInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;

public class DefaultDeleteAllInterceptor<T>
extends AbstractQueryInterceptor<T, Number>
implements DeleteAllInterceptor<T> {
    protected DefaultDeleteAllInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    public Number intercept(RepositoryMethodKey methodKey, MethodInvocationContext<T, Number> context) {
        boolean isBatch;
        Argument resultType = context.getReturnType().asArgument();
        Object[] parameterValues = context.getParameterValues();
        boolean bl = isBatch = parameterValues.length == 1 && parameterValues[0] instanceof Iterable;
        if (context.hasAnnotation(Query.class)) {
            PreparedQuery<?, ?> preparedQuery = this.prepareQuery(methodKey, context);
            if (isBatch) {
                RuntimePersistentProperty identity = this.operations.getEntity(preparedQuery.getRootEntity()).getIdentity();
                if (identity instanceof Embedded) {
                    Iterable iterable = (Iterable)parameterValues[0];
                    int deleteCount = 0;
                    BeanProperty idProp = identity.getProperty();
                    for (Object o : iterable) {
                        Object idValue = idProp.get(o);
                        if (idValue == null) {
                            throw new IllegalStateException("Cannot delete an entity with null ID: " + o);
                        }
                        preparedQuery.getParameterArray()[0] = idValue;
                        this.operations.executeDelete(preparedQuery);
                        ++deleteCount;
                    }
                    return this.convertIfNecessary((Argument<Number>)resultType, deleteCount);
                }
                Number result = this.operations.executeDelete(preparedQuery).orElse(0);
                return this.convertIfNecessary((Argument<Number>)resultType, result);
            }
            Number result = this.operations.executeDelete(preparedQuery).orElse(0);
            return this.convertIfNecessary((Argument<Number>)resultType, result);
        }
        Class<?> rootEntity = this.getRequiredRootEntity(context);
        if (isBatch) {
            Iterable iterable = (Iterable)parameterValues[0];
            DeleteBatchOperation batchOperation = this.getDeleteBatchOperation(context, iterable);
            Number deleted = this.operations.deleteAll(batchOperation).orElse(0);
            return this.convertIfNecessary((Argument<Number>)resultType, deleted);
        }
        if (parameterValues.length == 0) {
            DeleteBatchOperation<?> batchOperation = this.getDeleteAllBatchOperation(context, rootEntity);
            Number result = this.operations.deleteAll(batchOperation).orElse(0);
            return this.convertIfNecessary((Argument<Number>)resultType, result);
        }
        throw new IllegalArgumentException("Unexpected argument types received to deleteAll method");
    }

    private Number convertIfNecessary(Argument<Number> resultType, Number result) {
        if (!resultType.getType().isInstance(result)) {
            return ConversionService.SHARED.convert((Object)result, resultType).orElse(0);
        }
        return result;
    }
}

