/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.mapper;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.annotation.TypeDef;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.mapper.BeanIntrospectionMapper;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.http.codec.MediaTypeCodec;

public class DTOMapper<T, S, R>
implements BeanIntrospectionMapper<S, R> {
    private final RuntimePersistentEntity<T> persistentEntity;
    private final ResultReader<S, String> resultReader;
    @Nullable
    private final MediaTypeCodec jsonCodec;

    public DTOMapper(RuntimePersistentEntity<T> persistentEntity, ResultReader<S, String> resultReader) {
        this(persistentEntity, resultReader, null);
    }

    public DTOMapper(RuntimePersistentEntity<T> persistentEntity, ResultReader<S, String> resultReader, @Nullable MediaTypeCodec jsonCodec) {
        ArgumentUtils.requireNonNull((String)"persistentEntity", persistentEntity);
        ArgumentUtils.requireNonNull((String)"resultReader", resultReader);
        this.persistentEntity = persistentEntity;
        this.resultReader = resultReader;
        this.jsonCodec = jsonCodec;
    }

    @Override
    @Nullable
    public Object read(@NonNull S object, @NonNull String name) throws ConversionErrorException {
        RuntimePersistentProperty pp = this.persistentEntity.getPropertyByName(name);
        if (pp == null) {
            throw new DataAccessException("DTO projection defines a property [" + name + "] that doesn't exist on root entity: " + this.persistentEntity.getName());
        }
        return this.read(object, pp);
    }

    @Override
    @Nullable
    public Object read(@NonNull S object, @NonNull Argument<?> argument) {
        RuntimePersistentProperty pp = this.persistentEntity.getPropertyByName(argument.getName());
        if (pp == null) {
            DataType type = argument.getAnnotationMetadata().enumValue(TypeDef.class, "type", DataType.class).orElseGet(() -> DataType.forType((Class)argument.getType()));
            return this.read(object, argument.getName(), type);
        }
        return this.read(object, pp);
    }

    @Override
    @Nullable
    public Object read(@NonNull S resultSet, @NonNull RuntimePersistentProperty<T> property) {
        String propertyName = property.getPersistedName();
        DataType dataType = property.getDataType();
        if (dataType == DataType.JSON && this.jsonCodec != null) {
            String data = this.resultReader.readString(resultSet, propertyName);
            return this.jsonCodec.decode(property.getArgument(), data);
        }
        return this.read(resultSet, propertyName, dataType);
    }

    @Nullable
    public Object read(@NonNull S resultSet, @NonNull String persistedName, @NonNull DataType dataType) {
        return this.resultReader.readDynamic(resultSet, persistedName, dataType);
    }

    public PersistentEntity getPersistentEntity() {
        return this.persistentEntity;
    }

    public ResultReader<S, String> getResultReader() {
        return this.resultReader;
    }
}

