/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.FindPageInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import java.util.List;

public class DefaultFindPageInterceptor<T, R>
extends AbstractQueryInterceptor<T, R>
implements FindPageInterceptor<T, R> {
    protected DefaultFindPageInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    public R intercept(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context) {
        Class returnType = context.getReturnType().getType();
        if (context.hasAnnotation(Query.class)) {
            PreparedQuery<?, ?> preparedQuery = this.prepareQuery(methodKey, context);
            PreparedQuery<?, Number> countQuery = this.prepareCountQuery(methodKey, context);
            Iterable iterable = this.operations.findAll(preparedQuery);
            List resultList = CollectionUtils.iterableToList((Iterable)iterable);
            Number n = (Number)this.operations.findOne(countQuery);
            Long result = n != null ? n.longValue() : 0L;
            Page page = Page.of((List)resultList, (Pageable)this.getPageable(context), (long)result);
            if (returnType.isInstance(page)) {
                return (R)page;
            }
            return (R)ConversionService.SHARED.convert((Object)page, returnType).orElseThrow(() -> new IllegalStateException("Unsupported page interface type " + returnType));
        }
        Page page = this.operations.findPage(this.getPagedQuery(context));
        if (returnType.isInstance(page)) {
            return (R)page;
        }
        return (R)ConversionService.SHARED.convert((Object)page, returnType).orElseThrow(() -> new IllegalStateException("Unsupported page interface type " + returnType));
    }
}

