/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.exceptions.EmptyResultException;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.runtime.BatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncRepositoryOperations;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class ExecutorAsyncOperations
implements AsyncRepositoryOperations {
    private final RepositoryOperations datastore;
    private final Executor executor;

    public ExecutorAsyncOperations(@NonNull RepositoryOperations operations, @NonNull Executor executor) {
        ArgumentUtils.requireNonNull((String)"operations", (Object)operations);
        ArgumentUtils.requireNonNull((String)"executor", (Object)executor);
        this.datastore = operations;
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    @NonNull
    public <T> CompletableFuture<T> findOne(@NonNull Class<T> type, @NonNull Serializable id) {
        return CompletableFuture.supplyAsync(() -> {
            Object r = this.datastore.findOne(type, id);
            if (r != null) {
                return r;
            }
            throw new EmptyResultException();
        }, this.executor);
    }

    public <T> CompletableFuture<Boolean> exists(@NonNull PreparedQuery<T, Boolean> preparedQuery) {
        return CompletableFuture.supplyAsync(() -> this.datastore.exists(preparedQuery), this.executor);
    }

    @NonNull
    public <T, R> CompletableFuture<R> findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
        return CompletableFuture.supplyAsync(() -> {
            Object r = this.datastore.findOne(preparedQuery);
            if (r != null) {
                return r;
            }
            throw new EmptyResultException();
        }, this.executor);
    }

    @NonNull
    public <T> CompletableFuture<T> findOptional(@NonNull Class<T> type, @NonNull Serializable id) {
        return CompletableFuture.supplyAsync(() -> {
            Object r = this.datastore.findOne(type, id);
            if (r != null) {
                return r;
            }
            throw new EmptyResultException();
        }, this.executor);
    }

    @NonNull
    public <T, R> CompletableFuture<R> findOptional(@NonNull PreparedQuery<T, R> preparedQuery) {
        return CompletableFuture.supplyAsync(() -> this.datastore.findOne(preparedQuery), this.executor);
    }

    @NonNull
    public <T> CompletableFuture<Iterable<T>> findAll(@NonNull PagedQuery<T> pagedQuery) {
        return CompletableFuture.supplyAsync(() -> this.datastore.findAll(pagedQuery), this.executor);
    }

    public <T> CompletableFuture<Long> count(@NonNull PagedQuery<T> pagedQuery) {
        return CompletableFuture.supplyAsync(() -> this.datastore.count(pagedQuery), this.executor);
    }

    @NonNull
    public <T, R> CompletableFuture<Iterable<R>> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
        return CompletableFuture.supplyAsync(() -> this.datastore.findAll(preparedQuery), this.executor);
    }

    @NonNull
    public <T> CompletableFuture<T> persist(@NonNull InsertOperation<T> entity) {
        return CompletableFuture.supplyAsync(() -> this.datastore.persist(entity), this.executor);
    }

    @NonNull
    public <T> CompletableFuture<Iterable<T>> persistAll(@NonNull BatchOperation<T> operation) {
        return CompletableFuture.supplyAsync(() -> this.datastore.persistAll(operation), this.executor);
    }

    @NonNull
    public CompletableFuture<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return CompletableFuture.supplyAsync(() -> this.datastore.executeUpdate(preparedQuery).orElse(0), this.executor);
    }

    @NonNull
    public <T> CompletableFuture<Number> deleteAll(@NonNull BatchOperation<T> operation) {
        return CompletableFuture.supplyAsync(() -> this.datastore.deleteAll(operation).orElse(0), this.executor);
    }

    public <R> CompletableFuture<Page<R>> findPage(@NonNull PagedQuery<R> pagedQuery) {
        return CompletableFuture.supplyAsync(() -> this.datastore.findPage(pagedQuery), this.executor);
    }
}

