/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.mapper;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.DataType;
import java.math.BigDecimal;
import java.util.Date;

public interface ResultReader<RS, IDX> {
    default public <T> T convertRequired(Object value, Class<T> type) {
        return ConversionService.SHARED.convert(value, type).orElseThrow(() -> new DataAccessException("Cannot convert type [" + value.getClass() + "] with value [" + value + "] to target type: " + type + ". Consider defining a TypeConverter bean to handle this case."));
    }

    @Nullable
    public <T> T getRequiredValue(RS var1, IDX var2, Class<T> var3) throws DataAccessException;

    @Nullable
    default public Object readNextDynamic(@NonNull RS resultSet, @NonNull IDX index, @NonNull DataType dataType) {
        if (this.next(resultSet)) {
            return this.readDynamic(resultSet, index, dataType);
        }
        return null;
    }

    public boolean next(RS var1);

    @Nullable
    default public Object readDynamic(@NonNull RS resultSet, @NonNull IDX index, @NonNull DataType dataType) {
        switch (dataType) {
            case STRING: {
                return this.readString(resultSet, index);
            }
            case LONG: {
                return this.readLong(resultSet, index);
            }
            case INTEGER: {
                return this.readInt(resultSet, index);
            }
            case BOOLEAN: {
                return this.readBoolean(resultSet, index);
            }
            case BYTE: {
                return this.readByte(resultSet, index);
            }
            case TIMESTAMP: {
                return this.readTimestamp(resultSet, index);
            }
            case DATE: {
                return this.readDate(resultSet, index);
            }
            case CHARACTER: {
                return Character.valueOf(this.readChar(resultSet, index));
            }
            case FLOAT: {
                return Float.valueOf(this.readFloat(resultSet, index));
            }
            case SHORT: {
                return this.readShort(resultSet, index);
            }
            case DOUBLE: {
                return this.readDouble(resultSet, index);
            }
            case BYTE_ARRAY: {
                return this.readBytes(resultSet, index);
            }
            case BIGDECIMAL: {
                return this.readBigDecimal(resultSet, index);
            }
        }
        return this.getRequiredValue(resultSet, index, Object.class);
    }

    default public long readLong(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, Long.TYPE);
    }

    default public char readChar(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, Character.TYPE).charValue();
    }

    default public Date readDate(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, Date.class);
    }

    default public Date readTimestamp(RS resultSet, IDX index) {
        return this.getRequiredValue(resultSet, index, Date.class);
    }

    @Nullable
    default public String readString(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, String.class);
    }

    default public int readInt(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, Integer.TYPE);
    }

    default public boolean readBoolean(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, Boolean.TYPE);
    }

    default public float readFloat(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, Float.TYPE).floatValue();
    }

    default public byte readByte(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, Byte.TYPE);
    }

    default public short readShort(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, Short.TYPE);
    }

    default public double readDouble(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, Double.TYPE);
    }

    default public BigDecimal readBigDecimal(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, BigDecimal.class);
    }

    default public byte[] readBytes(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, byte[].class);
    }
}

