/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.http;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.runtime.config.DataConfiguration;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Singleton;

@Requires(classes={RequestArgumentBinder.class})
@Singleton
public class PageableRequestArgumentBinder
implements TypedRequestArgumentBinder<Pageable> {
    public static final Argument<Pageable> TYPE = Argument.of(Pageable.class);
    private final DataConfiguration.PageableConfiguration configuration;
    private final Function<String, Sort.Order> sortMapper;

    protected PageableRequestArgumentBinder(DataConfiguration.PageableConfiguration configuration) {
        this.configuration = configuration;
        this.sortMapper = s -> {
            String[] tokens = configuration.getSortDelimiterPattern().split((CharSequence)s);
            if (tokens.length == 1) {
                return new Sort.Order(tokens[0], Sort.Order.Direction.ASC, configuration.isSortIgnoreCase());
            }
            try {
                Sort.Order.Direction direction = Sort.Order.Direction.valueOf((String)tokens[1].toUpperCase(Locale.ENGLISH));
                return new Sort.Order(tokens[0], direction, configuration.isSortIgnoreCase());
            }
            catch (IllegalArgumentException e) {
                return new Sort.Order(tokens[0], Sort.Order.Direction.ASC, configuration.isSortIgnoreCase());
            }
        };
    }

    public Argument<Pageable> argumentType() {
        return TYPE;
    }

    public ArgumentBinder.BindingResult<Pageable> bind(ArgumentConversionContext<Pageable> context, HttpRequest<?> source) {
        HttpParameters parameters = source.getParameters();
        int page = Math.max(parameters.getFirst((CharSequence)this.configuration.getPageParameterName(), Integer.class).orElse(0), 0);
        int configuredMaxSize = this.configuration.getMaxPageSize();
        int size = Math.min(parameters.getFirst((CharSequence)this.configuration.getSizeParameterName(), Integer.class).orElse(configuredMaxSize), configuredMaxSize);
        String sortParameterName = this.configuration.getSortParameterName();
        boolean hasSort = parameters.contains(sortParameterName);
        Sort sort = null;
        if (hasSort) {
            List sortParams = parameters.getAll((CharSequence)sortParameterName);
            List orders = sortParams.stream().map(this.sortMapper).collect(Collectors.toList());
            sort = Sort.of(orders);
        }
        Pageable pageable = size < 1 ? (page == 0 && configuredMaxSize < 1 && sort == null ? Pageable.UNPAGED : Pageable.from((int)page, (int)configuredMaxSize, sort)) : Pageable.from((int)page, (int)size, sort);
        return () -> Optional.of(pageable);
    }
}

