/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.r2dbc.operations;

import io.micronaut.aop.InvocationContext;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.attr.AttributeHolder;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.QueryResult;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.exceptions.NonUniqueResultException;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.runtime.AttributeConverterRegistry;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.EntityOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.QueryResultInfo;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.model.runtime.convert.AttributeConverter;
import io.micronaut.data.operations.async.AsyncRepositoryOperations;
import io.micronaut.data.operations.reactive.BlockingExecutorReactorRepositoryOperations;
import io.micronaut.data.r2dbc.config.DataR2dbcConfiguration;
import io.micronaut.data.r2dbc.convert.R2dbcConversionContext;
import io.micronaut.data.r2dbc.mapper.ColumnIndexR2dbcResultReader;
import io.micronaut.data.r2dbc.mapper.ColumnNameR2dbcResultReader;
import io.micronaut.data.r2dbc.mapper.R2dbcQueryStatement;
import io.micronaut.data.r2dbc.operations.R2dbcOperations;
import io.micronaut.data.r2dbc.operations.R2dbcRepositoryOperations;
import io.micronaut.data.r2dbc.operations.R2dbcSchemaHandler;
import io.micronaut.data.r2dbc.operations.ReactorReactiveRepositoryOperations;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.convert.RuntimePersistentPropertyConversionContext;
import io.micronaut.data.runtime.date.DateTimeProvider;
import io.micronaut.data.runtime.mapper.QueryStatement;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.data.runtime.mapper.TypeMapper;
import io.micronaut.data.runtime.mapper.sql.SqlDTOMapper;
import io.micronaut.data.runtime.mapper.sql.SqlResultEntityTypeMapper;
import io.micronaut.data.runtime.mapper.sql.SqlTypeMapper;
import io.micronaut.data.runtime.multitenancy.SchemaTenantResolver;
import io.micronaut.data.runtime.operations.ReactorToAsyncOperationsAdaptor;
import io.micronaut.data.runtime.operations.internal.AbstractReactiveEntitiesOperations;
import io.micronaut.data.runtime.operations.internal.AbstractReactiveEntityOperations;
import io.micronaut.data.runtime.operations.internal.OperationContext;
import io.micronaut.data.runtime.operations.internal.ReactiveCascadeOperations;
import io.micronaut.data.runtime.operations.internal.query.BindableParametersStoredQuery;
import io.micronaut.data.runtime.operations.internal.sql.AbstractSqlRepositoryOperations;
import io.micronaut.data.runtime.operations.internal.sql.SqlJsonColumnMapperProvider;
import io.micronaut.data.runtime.operations.internal.sql.SqlPreparedQuery;
import io.micronaut.data.runtime.operations.internal.sql.SqlStoredQuery;
import io.micronaut.data.runtime.support.AbstractConversionContext;
import io.micronaut.json.JsonMapper;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.exceptions.NoTransactionException;
import io.micronaut.transaction.exceptions.TransactionSystemException;
import io.micronaut.transaction.exceptions.TransactionUsageException;
import io.micronaut.transaction.reactive.ReactiveTransactionOperations;
import io.micronaut.transaction.reactive.ReactiveTransactionStatus;
import io.micronaut.transaction.reactive.ReactorReactiveTransactionOperations;
import io.micronaut.transaction.support.TransactionSynchronizationManager;
import io.micronaut.transaction.support.TransactionUtil;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.Statement;
import jakarta.inject.Named;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@EachBean(value=ConnectionFactory.class)
@Internal
final class DefaultR2dbcRepositoryOperations
extends AbstractSqlRepositoryOperations<Row, Statement, RuntimeException>
implements BlockingExecutorReactorRepositoryOperations,
R2dbcRepositoryOperations,
R2dbcOperations,
ReactorReactiveTransactionOperations<Connection>,
ReactiveCascadeOperations.ReactiveCascadeOperationsHelper<R2dbcOperationContext> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultR2dbcRepositoryOperations.class);
    private static final String NAME = "r2dbc";
    private final ConnectionFactory connectionFactory;
    private final ReactorReactiveRepositoryOperations reactiveOperations;
    private final String dataSourceName;
    private ExecutorService ioExecutorService;
    private AsyncRepositoryOperations asyncRepositoryOperations;
    private final ReactiveCascadeOperations<R2dbcOperationContext> cascadeOperations;
    private final String txStatusKey;
    private final String txDefinitionKey;
    private final String currentConnectionKey;
    @Nullable
    private final SchemaTenantResolver schemaTenantResolver;
    private final R2dbcSchemaHandler schemaHandler;
    private final DataR2dbcConfiguration configuration;

    @Internal
    protected DefaultR2dbcRepositoryOperations(@Parameter String dataSourceName, ConnectionFactory connectionFactory, @NonNull DateTimeProvider<Object> dateTimeProvider, RuntimeEntityRegistry runtimeEntityRegistry, ApplicationContext applicationContext, @Nullable @Named(value="io") ExecutorService executorService, DataConversionService conversionService, AttributeConverterRegistry attributeConverterRegistry, @Nullable SchemaTenantResolver schemaTenantResolver, R2dbcSchemaHandler schemaHandler, @Parameter DataR2dbcConfiguration configuration, @Nullable JsonMapper jsonMapper, SqlJsonColumnMapperProvider<Row> sqlJsonColumnMapperProvider) {
        super(dataSourceName, (ResultReader)new ColumnNameR2dbcResultReader(conversionService), (ResultReader)new ColumnIndexR2dbcResultReader(conversionService), (QueryStatement)new R2dbcQueryStatement(conversionService), dateTimeProvider, runtimeEntityRegistry, (BeanContext)applicationContext, conversionService, attributeConverterRegistry, jsonMapper, sqlJsonColumnMapperProvider);
        this.connectionFactory = connectionFactory;
        this.ioExecutorService = executorService;
        this.schemaTenantResolver = schemaTenantResolver;
        this.schemaHandler = schemaHandler;
        this.configuration = configuration;
        this.reactiveOperations = new DefaultR2dbcReactiveRepositoryOperations();
        this.dataSourceName = dataSourceName;
        this.cascadeOperations = new ReactiveCascadeOperations((ConversionService)conversionService, (ReactiveCascadeOperations.ReactiveCascadeOperationsHelper)this);
        String name = dataSourceName;
        if (name == null) {
            name = "default";
        }
        this.txStatusKey = "io.micronaut.tx.status.r2dbc." + name;
        this.txDefinitionKey = "io.micronaut.tx.definition.r2dbc." + name;
        this.currentConnectionKey = "io.micronaut.r2dbc.connection." + name;
    }

    public <T> T block(Function<io.micronaut.data.operations.reactive.ReactorReactiveRepositoryOperations, Mono<T>> supplier) {
        TransactionSynchronizationManager.TransactionSynchronizationState state = TransactionSynchronizationManager.getOrCreateState();
        return (T)Mono.defer(() -> {
            try (TransactionSynchronizationManager.TransactionSynchronizationStateOp ignore = TransactionSynchronizationManager.withState((TransactionSynchronizationManager.TransactionSynchronizationState)state);){
                Mono mono = ((Mono)supplier.apply(this.reactive())).contextWrite((ContextView)TransactionSynchronizationManager.getResourceOrDefault(ContextView.class, (Object)Context.empty()));
                return mono;
            }
        }).block();
    }

    public <T> Optional<T> blockOptional(Function<io.micronaut.data.operations.reactive.ReactorReactiveRepositoryOperations, Mono<T>> supplier) {
        TransactionSynchronizationManager.TransactionSynchronizationState state = TransactionSynchronizationManager.getOrCreateState();
        return Mono.defer(() -> {
            try (TransactionSynchronizationManager.TransactionSynchronizationStateOp ignore = TransactionSynchronizationManager.withState((TransactionSynchronizationManager.TransactionSynchronizationState)state);){
                Mono mono = ((Mono)supplier.apply(this.reactive())).contextWrite((ContextView)TransactionSynchronizationManager.getResourceOrDefault(ContextView.class, (Object)Context.empty()));
                return mono;
            }
        }).blockOptional();
    }

    public <T> Mono<T> persistOne(R2dbcOperationContext ctx, T value, RuntimePersistentEntity<T> persistentEntity) {
        SqlStoredQuery storedQuery = this.resolveEntityInsert(ctx.annotationMetadata, ctx.repositoryType, value.getClass(), persistentEntity);
        R2dbcEntityOperations<T> op = new R2dbcEntityOperations<T>(ctx, storedQuery, persistentEntity, value, true);
        op.persist();
        return op.getEntity();
    }

    public <T> Flux<T> persistBatch(R2dbcOperationContext ctx, Iterable<T> values, RuntimePersistentEntity<T> persistentEntity, Predicate<T> predicate) {
        SqlStoredQuery storedQuery = this.resolveEntityInsert(ctx.annotationMetadata, ctx.repositoryType, persistentEntity.getIntrospection().getBeanType(), persistentEntity);
        R2dbcEntitiesOperations<T> op = new R2dbcEntitiesOperations<T>(ctx, storedQuery, persistentEntity, values, true);
        if (predicate != null) {
            op.veto(predicate);
        }
        op.persist();
        return op.getEntities();
    }

    public <T> Mono<T> updateOne(R2dbcOperationContext ctx, T value, RuntimePersistentEntity<T> persistentEntity) {
        SqlStoredQuery storedQuery = this.resolveEntityUpdate(ctx.annotationMetadata, ctx.repositoryType, value.getClass(), persistentEntity);
        R2dbcEntityOperations<T> op = new R2dbcEntityOperations<T>(ctx, persistentEntity, value, storedQuery);
        op.update();
        return op.getEntity();
    }

    public Mono<Void> persistManyAssociation(R2dbcOperationContext ctx, RuntimeAssociation runtimeAssociation, Object value, RuntimePersistentEntity<Object> persistentEntity, Object child, RuntimePersistentEntity<Object> childPersistentEntity) {
        SqlStoredQuery storedQuery = this.resolveSqlInsertAssociation(ctx.repositoryType, runtimeAssociation, persistentEntity, value);
        R2dbcEntityOperations<Object> assocEntityOp = new R2dbcEntityOperations<Object>(ctx, childPersistentEntity, child, storedQuery);
        try {
            assocEntityOp.execute();
        }
        catch (Exception e1) {
            throw new DataAccessException("SQL error executing INSERT: " + e1.getMessage(), (Throwable)e1);
        }
        return assocEntityOp.getEntity().then();
    }

    public Mono<Void> persistManyAssociationBatch(R2dbcOperationContext ctx, RuntimeAssociation runtimeAssociation, Object value, RuntimePersistentEntity<Object> persistentEntity, Iterable<Object> child, RuntimePersistentEntity<Object> childPersistentEntity, Predicate<Object> veto) {
        SqlStoredQuery storedQuery = this.resolveSqlInsertAssociation(ctx.repositoryType, runtimeAssociation, persistentEntity, value);
        R2dbcEntitiesOperations<Object> assocEntitiesOp = new R2dbcEntitiesOperations<Object>(ctx, childPersistentEntity, child, storedQuery);
        assocEntitiesOp.veto(veto);
        try {
            assocEntitiesOp.execute();
        }
        catch (Exception e1) {
            throw new DataAccessException("SQL error executing INSERT: " + e1.getMessage(), (Throwable)e1);
        }
        return assocEntitiesOp.getEntities().then();
    }

    private Mono<Number> sum(Stream<Mono<Number>> stream) {
        return stream.reduce((m1, m2) -> m1.zipWith(m2).map(t -> ((Number)t.getT1()).longValue() + ((Number)t.getT2()).longValue())).orElse((Mono<Number>)Mono.empty());
    }

    private <T> Flux<T> concatMono(Stream<Mono<T>> stream) {
        return Flux.concat((Iterable)stream.collect(Collectors.toList()));
    }

    @NonNull
    public ReactorReactiveRepositoryOperations reactive() {
        return this.reactiveOperations;
    }

    @NonNull
    public AsyncRepositoryOperations async() {
        if (this.asyncRepositoryOperations == null) {
            if (this.ioExecutorService == null) {
                this.ioExecutorService = Executors.newCachedThreadPool();
            }
            this.asyncRepositoryOperations = new ReactorToAsyncOperationsAdaptor((io.micronaut.data.operations.reactive.ReactorReactiveRepositoryOperations)this.reactiveOperations, (Executor)this.ioExecutorService);
        }
        return this.asyncRepositoryOperations;
    }

    @Override
    @NonNull
    public ConnectionFactory connectionFactory() {
        return this.connectionFactory;
    }

    @NonNull
    public <T> Flux<T> withConnection(@NonNull Function<Connection, Publisher<? extends T>> handler) {
        Objects.requireNonNull(handler, "Handler cannot be null");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating a new Connection for DataSource: " + this.dataSourceName);
        }
        return Flux.usingWhen((Publisher)this.connectionFactory.create(), this.tenantAwareHandler(handler), connection -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing Connection for DataSource: " + this.dataSourceName);
            }
            return connection.close();
        });
    }

    private <K> Function<Connection, Publisher<? extends K>> tenantAwareHandler(Function<Connection, Publisher<? extends K>> handler) {
        Function<Connection, Object> theHandler = this.schemaTenantResolver == null ? handler : connection -> {
            String schemaName = this.schemaTenantResolver.resolveTenantSchemaName();
            if (schemaName != null) {
                return Mono.fromDirect(this.schemaHandler.useSchema((Connection)connection, this.configuration.getDialect(), schemaName)).thenReturn(connection).flatMapMany(handler::apply);
            }
            return (Publisher)handler.apply((Connection)connection);
        };
        return theHandler;
    }

    private <T> Flux<T> withConnectionWithCancelCallback(@NonNull BiFunction<Connection, Supplier<Publisher<Void>>, Publisher<? extends T>> handler) {
        Objects.requireNonNull(handler, "Handler cannot be null");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating a new Connection for DataSource: " + this.dataSourceName);
        }
        return Mono.from((Publisher)this.connectionFactory.create()).flatMapMany(connection -> {
            Supplier<Publisher> cancelCallback = () -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Closing Connection for DataSource: " + this.dataSourceName);
                }
                return connection.close();
            };
            Function theHandler = c -> (Publisher)handler.apply((Connection)c, (Supplier<Publisher<Void>>)cancelCallback);
            return this.tenantAwareHandler(theHandler).apply((Connection)connection);
        });
    }

    private IsolationLevel getIsolationLevel(TransactionDefinition definition) {
        TransactionDefinition.Isolation isolationLevel = definition.getIsolationLevel();
        switch (isolationLevel) {
            case READ_COMMITTED: {
                return IsolationLevel.READ_COMMITTED;
            }
            case READ_UNCOMMITTED: {
                return IsolationLevel.READ_UNCOMMITTED;
            }
            case REPEATABLE_READ: {
                return IsolationLevel.REPEATABLE_READ;
            }
            case SERIALIZABLE: {
                return IsolationLevel.SERIALIZABLE;
            }
        }
        return null;
    }

    @Override
    @NonNull
    public <T> Publisher<T> withTransaction(@NonNull ReactiveTransactionStatus<Connection> status, @NonNull ReactiveTransactionOperations.TransactionalCallback<Connection, T> handler) {
        Objects.requireNonNull(status, "Transaction status cannot be null");
        Objects.requireNonNull(handler, "Callback handler cannot be null");
        return Flux.defer(() -> {
            try {
                return handler.doInTransaction(status);
            }
            catch (Exception e) {
                return Flux.error((Throwable)new TransactionSystemException("Error invoking doInTransaction handler: " + e.getMessage(), (Throwable)e));
            }
        }).contextWrite(context -> context.put((Object)this.txStatusKey, (Object)status));
    }

    public ReactiveTransactionStatus<Connection> getTransactionStatus(ContextView contextView) {
        return (ReactiveTransactionStatus)contextView.getOrDefault((Object)this.txStatusKey, null);
    }

    public TransactionDefinition getTransactionDefinition(ContextView contextView) {
        return (TransactionDefinition)contextView.getOrDefault((Object)this.txDefinitionKey, null);
    }

    @NonNull
    public <T> Flux<T> withTransaction(@NonNull TransactionDefinition definition, @NonNull ReactiveTransactionOperations.TransactionalCallback<Connection, T> handler) {
        Objects.requireNonNull(definition, "Transaction definition cannot be null");
        Objects.requireNonNull(handler, "Callback handler cannot be null");
        return Flux.deferContextual(contextView -> {
            TransactionDefinition.Propagation propagationBehavior = definition.getPropagationBehavior();
            ReactiveTransactionStatus<Connection> transactionStatus = this.getTransactionStatus((ContextView)contextView);
            if (transactionStatus != null) {
                if (propagationBehavior == TransactionDefinition.Propagation.NOT_SUPPORTED || propagationBehavior == TransactionDefinition.Propagation.NEVER) {
                    return Flux.error((Throwable)new TransactionUsageException("Found an existing transaction but propagation behaviour doesn't support it: " + propagationBehavior));
                }
                ReactiveTransactionStatus<Connection> existingTransaction = this.existingTransaction(transactionStatus);
                try {
                    return Flux.from((Publisher)handler.doInTransaction(existingTransaction)).contextWrite(ctx -> ctx.put((Object)this.txStatusKey, (Object)existingTransaction));
                }
                catch (Exception e) {
                    return Flux.error((Throwable)new TransactionSystemException("Error invoking doInTransaction handler: " + e.getMessage(), (Throwable)e));
                }
            }
            if (propagationBehavior == TransactionDefinition.Propagation.MANDATORY) {
                return Flux.error((Throwable)new NoTransactionException("Expected an existing transaction, but none was found in the Reactive context."));
            }
            return this.withConnectionWithCancelCallback((connection, cancelCallback) -> {
                Mono resourceSupplier;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Transaction: {} begin for dataSource: {}", (Object)definition.getName(), (Object)this.dataSourceName);
                }
                DefaultReactiveTransactionStatus status = new DefaultReactiveTransactionStatus(definition, (Connection)connection, true);
                if (definition.getIsolationLevel() != TransactionDefinition.DEFAULT.getIsolationLevel()) {
                    IsolationLevel isolationLevel = this.getIsolationLevel(definition);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Setting Isolation Level ({}) for transaction: {} for dataSource: {}", new Object[]{isolationLevel, definition.getName(), this.dataSourceName});
                    }
                    resourceSupplier = isolationLevel != null ? Flux.from((Publisher)connection.setTransactionIsolationLevel(isolationLevel)).thenMany(connection.beginTransaction()).hasElements() : Flux.from((Publisher)connection.beginTransaction()).hasElements();
                } else {
                    resourceSupplier = Flux.from((Publisher)connection.beginTransaction()).hasElements();
                }
                Function<Boolean, Publisher> onSuccess = arg_0 -> this.lambda$withTransaction$12(status, (Supplier)cancelCallback, arg_0);
                BiFunction<Boolean, Throwable, Publisher> onException = (arg_0, arg_1) -> this.lambda$withTransaction$13(status, definition, (Supplier)cancelCallback, arg_0, arg_1);
                return Flux.usingWhen((Publisher)resourceSupplier, b -> {
                    try {
                        return Flux.from((Publisher)handler.doInTransaction((ReactiveTransactionStatus)status)).contextWrite(context -> context.put((Object)this.txStatusKey, (Object)status).put((Object)this.txDefinitionKey, (Object)definition));
                    }
                    catch (Exception e) {
                        return Flux.error((Throwable)new TransactionSystemException("Error invoking doInTransaction handler: " + e.getMessage(), (Throwable)e));
                    }
                }, onSuccess, onException, onSuccess);
            });
        });
    }

    private Flux<Void> onException(DefaultReactiveTransactionStatus status, TransactionDefinition definition, Throwable throwable, Supplier<Publisher<Void>> cancelConnection) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("Rolling back transaction: {} on error: {} for dataSource {}", new Object[]{status.getDefinition().getName(), throwable.getMessage(), this.dataSourceName, throwable});
        }
        if (!definition.rollbackOn(throwable)) {
            return this.doCommit(status, cancelConnection);
        }
        return this.rollback(status, cancelConnection).onErrorResume(rollbackError -> {
            if (rollbackError != throwable && LOG.isWarnEnabled()) {
                LOG.warn("Error occurred during transaction: {} rollback failed with: {} for dataSource {}", new Object[]{status.getDefinition().getName(), rollbackError.getMessage(), this.dataSourceName, rollbackError});
            }
            return Mono.error((Throwable)throwable);
        });
    }

    private Flux<Void> rollback(DefaultReactiveTransactionStatus status, Supplier<Publisher<Void>> cancelConnection) {
        return (Flux)Flux.from((Publisher)status.getConnection().rollbackTransaction()).as(flux -> this.finishTx((Flux<Void>)flux, status, cancelConnection));
    }

    private Flux<Void> doCommit(DefaultReactiveTransactionStatus status, Supplier<Publisher<Void>> cancelConnection) {
        if (status.isRollbackOnly()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Rolling back transaction: {} for dataSource {}", (Object)status.getDefinition().getName(), (Object)this.dataSourceName);
            }
            return this.rollback(status, cancelConnection);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Committing transaction: {} for dataSource {}", (Object)status.getDefinition().getName(), (Object)this.dataSourceName);
        }
        return (Flux)Flux.from((Publisher)status.getConnection().commitTransaction()).as(flux -> this.finishTx((Flux<Void>)flux, status, cancelConnection));
    }

    private Flux<Void> finishTx(Flux<Void> flux, DefaultReactiveTransactionStatus status, Supplier<Publisher<Void>> cancelConnection) {
        return flux.hasElements().flatMapMany(ignore -> {
            status.completed = true;
            return (Publisher)cancelConnection.get();
        });
    }

    private ReactiveTransactionStatus<Connection> existingTransaction(final ReactiveTransactionStatus<Connection> existing) {
        return new ReactiveTransactionStatus<Connection>(){

            public Connection getConnection() {
                return (Connection)existing.getConnection();
            }

            public boolean isNewTransaction() {
                return false;
            }

            public void setRollbackOnly() {
                existing.setRollbackOnly();
            }

            public boolean isRollbackOnly() {
                return existing.isRollbackOnly();
            }

            public boolean isCompleted() {
                return existing.isCompleted();
            }
        };
    }

    private static <R> Mono<R> toSingleResult(Flux<R> flux) {
        return Mono.fromDirect((Publisher)flux.collectList().flatMap(result -> {
            if (result.isEmpty()) {
                return Mono.empty();
            }
            if (result.size() > 1) {
                return Mono.error((Throwable)new NonUniqueResultException());
            }
            return Mono.just(result.get(0));
        }));
    }

    public boolean isSupportsBatchInsert(R2dbcOperationContext context, RuntimePersistentEntity<?> persistentEntity) {
        return this.isSupportsBatchInsert((PersistentEntity)persistentEntity, context.dialect);
    }

    private static <T> Flux<T> executeAndMapEachRow(Statement statement, Function<Row, T> mapper) {
        return Flux.from((Publisher)statement.execute()).flatMap(result -> Flux.from((Publisher)result.map((row, rowMetadata) -> mapper.apply((Row)row))));
    }

    private static <T> Mono<T> executeAndMapEachRowSingle(Statement statement, Function<Row, T> mapper) {
        return (Mono)DefaultR2dbcRepositoryOperations.executeAndMapEachRow(statement, mapper).as(DefaultR2dbcRepositoryOperations::toSingleResult);
    }

    private static Mono<Number> executeAndGetRowsUpdatedSingle(Statement statement, Dialect dialect) {
        return (Mono)DefaultR2dbcRepositoryOperations.executeAndGetRowsUpdated(statement).onErrorResume(throwable -> {
            Throwable patt30344$temp = throwable.getCause();
            if (patt30344$temp instanceof SQLException) {
                SQLException sqlException = (SQLException)patt30344$temp;
                Throwable newThrowable = DefaultR2dbcRepositoryOperations.handleSqlException((SQLException)sqlException, (Dialect)dialect);
                return Mono.error((Throwable)newThrowable);
            }
            return Mono.error((Throwable)throwable);
        }).as(DefaultR2dbcRepositoryOperations::toSingleResult);
    }

    private static Flux<Number> executeAndGetRowsUpdated(Statement statement) {
        return Flux.from((Publisher)statement.execute()).flatMap(Result::getRowsUpdated).map(n -> n.longValue());
    }

    private /* synthetic */ Publisher lambda$withTransaction$13(DefaultReactiveTransactionStatus status, TransactionDefinition definition, Supplier cancelCallback, Boolean b, Throwable throwable) {
        return this.onException(status, definition, throwable, cancelCallback);
    }

    private /* synthetic */ Publisher lambda$withTransaction$12(DefaultReactiveTransactionStatus status, Supplier cancelCallback, Boolean ignore) {
        return this.doCommit(status, cancelCallback);
    }

    private final class DefaultR2dbcReactiveRepositoryOperations
    implements ReactorReactiveRepositoryOperations {
        private DefaultR2dbcReactiveRepositoryOperations() {
        }

        public <T> Mono<Boolean> exists(@NonNull PreparedQuery<T, Boolean> pq) {
            SqlPreparedQuery preparedQuery = DefaultR2dbcRepositoryOperations.this.getSqlPreparedQuery(pq);
            return this.withNewOrExistingTransactionMono((PreparedQuery)preparedQuery, false, (ReactiveTransactionOperations.TransactionalCallback)status -> {
                Connection connection = (Connection)status.getConnection();
                Statement statement = (Statement)DefaultR2dbcRepositoryOperations.this.prepareStatement(arg_0 -> ((Connection)connection).createStatement(arg_0), (PreparedQuery)preparedQuery, false, true);
                preparedQuery.bindParameters((BindableParametersStoredQuery.Binder)new R2dbcParameterBinder(connection, statement, (SqlStoredQuery<?, ?>)preparedQuery));
                return DefaultR2dbcRepositoryOperations.executeAndMapEachRow(statement, row -> true).collectList().map(records -> !records.isEmpty() && records.stream().allMatch(v -> v));
            });
        }

        @NonNull
        public <T, R> Mono<R> findOne(@NonNull PreparedQuery<T, R> pq) {
            SqlPreparedQuery preparedQuery = DefaultR2dbcRepositoryOperations.this.getSqlPreparedQuery(pq);
            return this.withNewOrExistingTransactionMono((PreparedQuery<T, R>)preparedQuery, false, (ReactiveTransactionOperations.TransactionalCallback<Connection, R>)((ReactiveTransactionOperations.TransactionalCallback)status -> {
                Connection connection = (Connection)status.getConnection();
                Statement statement = (Statement)DefaultR2dbcRepositoryOperations.this.prepareStatement(arg_0 -> ((Connection)connection).createStatement(arg_0), (PreparedQuery)preparedQuery, false, true);
                preparedQuery.bindParameters((BindableParametersStoredQuery.Binder)new R2dbcParameterBinder(connection, statement, (SqlStoredQuery<?, ?>)preparedQuery));
                if (preparedQuery.getResultDataType() == DataType.ENTITY) {
                    Class resultType = preparedQuery.getResultType();
                    RuntimePersistentEntity persistentEntity = DefaultR2dbcRepositoryOperations.this.getEntity(resultType);
                    BiFunction<RuntimePersistentEntity, Object, Object> loadListener = (loadedEntity, o) -> {
                        if (loadedEntity.hasPostLoadEventListeners()) {
                            return DefaultR2dbcRepositoryOperations.this.triggerPostLoad(o, loadedEntity, preparedQuery.getAnnotationMetadata());
                        }
                        return o;
                    };
                    QueryResultInfo queryResultInfo = preparedQuery.getQueryResultInfo();
                    if (queryResultInfo != null && queryResultInfo.getType() != QueryResult.Type.TABULAR) {
                        SqlTypeMapper queryResultMapper = DefaultR2dbcRepositoryOperations.this.createQueryResultMapper(preparedQuery, queryResultInfo.getColumnName(), queryResultInfo.getJsonDataType(), Row.class, persistentEntity, loadListener);
                        return DefaultR2dbcRepositoryOperations.executeAndMapEachRow(statement, row -> queryResultMapper.map(row, resultType));
                    }
                    SqlResultEntityTypeMapper mapper = new SqlResultEntityTypeMapper(persistentEntity, DefaultR2dbcRepositoryOperations.this.columnNameResultSetReader, preparedQuery.getJoinFetchPaths(), DefaultR2dbcRepositoryOperations.this.sqlJsonColumnMapperProvider.getJsonColumnReader(preparedQuery, Row.class), loadListener, DefaultR2dbcRepositoryOperations.this.conversionService);
                    SqlResultEntityTypeMapper.PushingMapper rowsMapper = mapper.readOneWithJoins();
                    return DefaultR2dbcRepositoryOperations.executeAndMapEachRow(statement, row -> {
                        rowsMapper.processRow(row);
                        return "";
                    }).collectList().flatMap(ignore -> Mono.justOrEmpty((Object)rowsMapper.getResult()));
                }
                Class resultType = preparedQuery.getResultType();
                if (preparedQuery.isDtoProjection()) {
                    RuntimePersistentEntity persistentEntity = preparedQuery.getPersistentEntity();
                    boolean isRawQuery = preparedQuery.isRawQuery();
                    QueryResultInfo queryResultInfo = preparedQuery.getQueryResultInfo();
                    Object mapper = queryResultInfo == null || queryResultInfo.getType() == QueryResult.Type.TABULAR ? new SqlDTOMapper(persistentEntity, isRawQuery ? DefaultR2dbcRepositoryOperations.this.getEntity(preparedQuery.getResultType()) : persistentEntity, DefaultR2dbcRepositoryOperations.this.columnNameResultSetReader, DefaultR2dbcRepositoryOperations.this.sqlJsonColumnMapperProvider.getJsonColumnReader(preparedQuery, Row.class), DefaultR2dbcRepositoryOperations.this.conversionService) : DefaultR2dbcRepositoryOperations.this.createQueryResultMapper(preparedQuery, queryResultInfo.getColumnName(), queryResultInfo.getJsonDataType(), Row.class, persistentEntity, null);
                    return DefaultR2dbcRepositoryOperations.executeAndMapEachRow(statement, arg_0 -> DefaultR2dbcReactiveRepositoryOperations.lambda$findOne$8((TypeMapper)mapper, resultType, arg_0));
                }
                return DefaultR2dbcRepositoryOperations.executeAndMapEachRow(statement, row -> {
                    QueryResultInfo queryResultInfo = preparedQuery.getQueryResultInfo();
                    if (queryResultInfo == null || queryResultInfo.getType() == QueryResult.Type.TABULAR) {
                        Object v = DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic(row, (Object)0, preparedQuery.getResultDataType());
                        if (v == null) {
                            return Flux.empty();
                        }
                        if (resultType.isInstance(v)) {
                            return Flux.just((Object)v);
                        }
                        return Flux.just((Object)DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.convertRequired(v, resultType));
                    }
                    SqlTypeMapper mapper = DefaultR2dbcRepositoryOperations.this.createQueryResultMapper(preparedQuery, queryResultInfo.getColumnName(), queryResultInfo.getJsonDataType(), Row.class, preparedQuery.getPersistentEntity(), null);
                    return Flux.just((Object)mapper.map(row, resultType));
                }).flatMap(m -> m);
            }));
        }

        @NonNull
        public <T, R> Flux<R> findAll(@NonNull PreparedQuery<T, R> pq) {
            SqlPreparedQuery preparedQuery = DefaultR2dbcRepositoryOperations.this.getSqlPreparedQuery(pq);
            return this.withNewOrExistingTransactionFlux((PreparedQuery<T, R>)preparedQuery, false, (ReactiveTransactionOperations.TransactionalCallback<Connection, R>)((ReactiveTransactionOperations.TransactionalCallback)status -> {
                boolean isEntity;
                Connection connection = (Connection)status.getConnection();
                Statement statement = (Statement)DefaultR2dbcRepositoryOperations.this.prepareStatement(arg_0 -> ((Connection)connection).createStatement(arg_0), (PreparedQuery)preparedQuery, false, false);
                preparedQuery.bindParameters((BindableParametersStoredQuery.Binder)new R2dbcParameterBinder(connection, statement, (SqlStoredQuery<?, ?>)preparedQuery));
                Class resultType = preparedQuery.getResultType();
                boolean dtoProjection = preparedQuery.isDtoProjection();
                boolean bl = isEntity = preparedQuery.getResultDataType() == DataType.ENTITY;
                if (isEntity || dtoProjection) {
                    Object mapper;
                    RuntimePersistentEntity persistentEntity = preparedQuery.getPersistentEntity();
                    if (dtoProjection) {
                        boolean isRawQuery;
                        QueryResultInfo queryResultInfo = preparedQuery.getQueryResultInfo();
                        mapper = queryResultInfo == null || queryResultInfo.getType() == QueryResult.Type.TABULAR ? new SqlDTOMapper(persistentEntity, (isRawQuery = preparedQuery.isRawQuery()) ? DefaultR2dbcRepositoryOperations.this.getEntity(preparedQuery.getResultType()) : persistentEntity, DefaultR2dbcRepositoryOperations.this.columnNameResultSetReader, DefaultR2dbcRepositoryOperations.this.sqlJsonColumnMapperProvider.getJsonColumnReader(preparedQuery, Row.class), DefaultR2dbcRepositoryOperations.this.conversionService) : DefaultR2dbcRepositoryOperations.this.createQueryResultMapper(preparedQuery, queryResultInfo.getColumnName(), queryResultInfo.getJsonDataType(), Row.class, persistentEntity, null);
                    } else {
                        BiFunction<RuntimePersistentEntity, Object, Object> loadListener = (loadedEntity, o) -> {
                            if (loadedEntity.hasPostLoadEventListeners()) {
                                return DefaultR2dbcRepositoryOperations.this.triggerPostLoad(o, loadedEntity, preparedQuery.getAnnotationMetadata());
                            }
                            return o;
                        };
                        QueryResultInfo queryResultInfo = preparedQuery.getQueryResultInfo();
                        if (queryResultInfo == null || queryResultInfo.getType() == QueryResult.Type.TABULAR) {
                            Set joinFetchPaths = preparedQuery.getJoinFetchPaths();
                            SqlResultEntityTypeMapper entityTypeMapper = new SqlResultEntityTypeMapper(DefaultR2dbcRepositoryOperations.this.getEntity(resultType), DefaultR2dbcRepositoryOperations.this.columnNameResultSetReader, joinFetchPaths, DefaultR2dbcRepositoryOperations.this.sqlJsonColumnMapperProvider.getJsonColumnReader(preparedQuery, Row.class), loadListener, DefaultR2dbcRepositoryOperations.this.conversionService);
                            boolean onlySingleEndedJoins = DefaultR2dbcRepositoryOperations.this.isOnlySingleEndedJoins(persistentEntity, joinFetchPaths);
                            if (!onlySingleEndedJoins) {
                                SqlResultEntityTypeMapper.PushingMapper manyReader = entityTypeMapper.readAllWithJoins();
                                return DefaultR2dbcRepositoryOperations.executeAndMapEachRow(statement, row -> {
                                    manyReader.processRow(row);
                                    return "";
                                }).collectList().flatMapIterable(ignore -> (Iterable)manyReader.getResult());
                            }
                            mapper = entityTypeMapper;
                        } else {
                            mapper = DefaultR2dbcRepositoryOperations.this.createQueryResultMapper(preparedQuery, queryResultInfo.getColumnName(), queryResultInfo.getJsonDataType(), Row.class, persistentEntity, loadListener);
                        }
                    }
                    return DefaultR2dbcRepositoryOperations.executeAndMapEachRow(statement, arg_0 -> DefaultR2dbcReactiveRepositoryOperations.lambda$findAll$15((TypeMapper)mapper, resultType, arg_0));
                }
                return DefaultR2dbcRepositoryOperations.executeAndMapEachRow(statement, row -> {
                    Object v = DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic(row, (Object)0, preparedQuery.getResultDataType());
                    if (v == null) {
                        return Mono.empty();
                    }
                    if (resultType.isInstance(v)) {
                        return Mono.just((Object)v);
                    }
                    Object converted = DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.convertRequired(v, resultType);
                    if (converted != null) {
                        return Mono.just((Object)converted);
                    }
                    return Mono.empty();
                }).flatMap(m -> m);
            }));
        }

        @NonNull
        public Mono<Number> executeUpdate(@NonNull PreparedQuery<?, Number> pq) {
            SqlPreparedQuery preparedQuery = DefaultR2dbcRepositoryOperations.this.getSqlPreparedQuery(pq);
            return this.withNewOrExistingTransactionMono((PreparedQuery)preparedQuery, true, (ReactiveTransactionOperations.TransactionalCallback)status -> {
                Connection connection = (Connection)status.getConnection();
                Statement statement = (Statement)DefaultR2dbcRepositoryOperations.this.prepareStatement(arg_0 -> ((Connection)connection).createStatement(arg_0), (PreparedQuery)preparedQuery, true, true);
                Dialect dialect = preparedQuery.getDialect();
                preparedQuery.bindParameters((BindableParametersStoredQuery.Binder)new R2dbcParameterBinder(connection, statement, (SqlStoredQuery<?, ?>)preparedQuery));
                return DefaultR2dbcRepositoryOperations.executeAndGetRowsUpdatedSingle(statement, dialect).flatMap(rowsUpdated -> {
                    Argument argument;
                    if (QUERY_LOG.isTraceEnabled()) {
                        QUERY_LOG.trace("Update operation updated {} records", rowsUpdated);
                    }
                    if (preparedQuery.isOptimisticLock()) {
                        DefaultR2dbcRepositoryOperations.this.checkOptimisticLocking(1, rowsUpdated);
                    }
                    if ((argument = (Argument)preparedQuery.getResultArgument().getFirstTypeVariable().orElse(null)) != null) {
                        if (argument.isVoid() || argument.getType() == Void.class) {
                            return Mono.empty();
                        }
                        if (argument.getType().isInstance(rowsUpdated)) {
                            return Mono.just((Object)rowsUpdated);
                        }
                        return Mono.just((Object)((Number)DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.convertRequired(rowsUpdated, argument)));
                    }
                    return Mono.just((Object)rowsUpdated);
                });
            });
        }

        @NonNull
        public Mono<Number> executeDelete(@NonNull PreparedQuery<?, Number> preparedQuery) {
            return this.executeUpdate(preparedQuery);
        }

        @NonNull
        public <T> Mono<Number> delete(@NonNull DeleteOperation<T> operation) {
            return this.withNewOrExistingTransactionMono((EntityOperation<T>)operation, true, (ReactiveTransactionOperations.TransactionalCallback)status -> {
                SqlStoredQuery storedQuery = DefaultR2dbcRepositoryOperations.this.getSqlStoredQuery(operation.getStoredQuery());
                R2dbcOperationContext ctx = this.createContext((EntityOperation)operation, (ReactiveTransactionStatus<Connection>)status, (SqlStoredQuery)storedQuery);
                R2dbcEntityOperations<Object> op = new R2dbcEntityOperations<Object>(ctx, storedQuery.getPersistentEntity(), operation.getEntity(), storedQuery);
                op.delete();
                return op.getRowsUpdated();
            });
        }

        @NonNull
        public <T> Flux<T> persistAll(@NonNull InsertBatchOperation<T> operation) {
            return this.withNewOrExistingTransactionFlux((EntityOperation<T>)operation, true, (ReactiveTransactionOperations.TransactionalCallback)status -> {
                SqlStoredQuery storedQuery = DefaultR2dbcRepositoryOperations.this.getSqlStoredQuery(operation.getStoredQuery());
                RuntimePersistentEntity persistentEntity = storedQuery.getPersistentEntity();
                R2dbcOperationContext ctx = this.createContext((EntityOperation)operation, (ReactiveTransactionStatus<Connection>)status, (SqlStoredQuery)storedQuery);
                if (!DefaultR2dbcRepositoryOperations.this.isSupportsBatchInsert((PersistentEntity)persistentEntity, storedQuery.getDialect())) {
                    return DefaultR2dbcRepositoryOperations.this.concatMono(operation.split().stream().map(persistOp -> {
                        R2dbcEntityOperations<Object> op = new R2dbcEntityOperations<Object>(ctx, storedQuery, persistentEntity, persistOp.getEntity(), true);
                        op.persist();
                        return op.getEntity();
                    }));
                }
                R2dbcEntitiesOperations op = new R2dbcEntitiesOperations(ctx, storedQuery, persistentEntity, operation, true);
                op.persist();
                return op.getEntities();
            });
        }

        @NonNull
        public <T, R> Mono<R> findOptional(@NonNull PreparedQuery<T, R> preparedQuery) {
            return this.findOne(preparedQuery);
        }

        @NonNull
        public <T> Mono<T> persist(@NonNull InsertOperation<T> operation) {
            return this.withNewOrExistingTransactionMono((EntityOperation<T>)operation, true, (ReactiveTransactionOperations.TransactionalCallback)status -> {
                SqlStoredQuery storedQuery = DefaultR2dbcRepositoryOperations.this.getSqlStoredQuery(operation.getStoredQuery());
                R2dbcOperationContext ctx = this.createContext((EntityOperation)operation, (ReactiveTransactionStatus<Connection>)status, (SqlStoredQuery)storedQuery);
                R2dbcEntityOperations<Object> op = new R2dbcEntityOperations<Object>(ctx, storedQuery, storedQuery.getPersistentEntity(), operation.getEntity(), true);
                op.persist();
                return op.getEntity();
            });
        }

        @NonNull
        public <T> Mono<T> update(@NonNull UpdateOperation<T> operation) {
            return this.withNewOrExistingTransactionMono((EntityOperation<T>)operation, true, (ReactiveTransactionOperations.TransactionalCallback)status -> {
                SqlStoredQuery storedQuery = DefaultR2dbcRepositoryOperations.this.getSqlStoredQuery(operation.getStoredQuery());
                R2dbcOperationContext ctx = this.createContext((EntityOperation)operation, (ReactiveTransactionStatus<Connection>)status, (SqlStoredQuery)storedQuery);
                R2dbcEntityOperations<Object> op = new R2dbcEntityOperations<Object>(ctx, storedQuery.getPersistentEntity(), operation.getEntity(), storedQuery);
                op.update();
                return op.getEntity();
            });
        }

        @NonNull
        private TransactionDefinition newTransactionDefinition(AttributeHolder attributeHolder) {
            return attributeHolder.getAttribute((CharSequence)DefaultR2dbcRepositoryOperations.this.txDefinitionKey, TransactionDefinition.class).orElseGet(() -> {
                if (attributeHolder instanceof AnnotationMetadataProvider) {
                    String name = null;
                    if (attributeHolder instanceof io.micronaut.core.naming.Named) {
                        name = ((io.micronaut.core.naming.Named)attributeHolder).getName();
                    }
                    return TransactionUtil.getTransactionDefinition((String)name, (AnnotationMetadataProvider)((AnnotationMetadataProvider)attributeHolder));
                }
                return TransactionDefinition.DEFAULT;
            });
        }

        private <T, R> Mono<R> withNewOrExistingTransactionMono(@NonNull EntityOperation<T> operation, boolean isWrite, ReactiveTransactionOperations.TransactionalCallback<Connection, R> entityOperation) {
            ReactiveTransactionStatus connection = operation.getParameterInRole("tx-status", ReactiveTransactionStatus.class).orElse(null);
            if (connection != null) {
                try {
                    return Mono.fromDirect((Publisher)entityOperation.doInTransaction(connection));
                }
                catch (Exception e) {
                    return Mono.error((Throwable)e);
                }
            }
            return this.withNewOrExistingTxAttributeMono((AttributeHolder)operation, entityOperation, isWrite);
        }

        private <T, R> Flux<R> withNewOrExistingTransactionFlux(@NonNull EntityOperation<T> operation, boolean isWrite, ReactiveTransactionOperations.TransactionalCallback<Connection, R> entityOperation) {
            ReactiveTransactionStatus connection = operation.getParameterInRole("tx-status", ReactiveTransactionStatus.class).orElse(null);
            if (connection != null) {
                try {
                    return Flux.from((Publisher)entityOperation.doInTransaction(connection));
                }
                catch (Exception e) {
                    return Flux.error((Throwable)e);
                }
            }
            return this.withNewOrExistingTxAttributeFlux((AttributeHolder)operation, entityOperation, isWrite);
        }

        private <T, R> Mono<R> withNewOrExistingTransactionMono(@NonNull PreparedQuery<T, R> operation, boolean isWrite, ReactiveTransactionOperations.TransactionalCallback<Connection, R> entityOperation) {
            ReactiveTransactionStatus connection = operation.getParameterInRole("tx-status", ReactiveTransactionStatus.class).orElse(null);
            if (connection != null) {
                try {
                    return Mono.fromDirect((Publisher)entityOperation.doInTransaction(connection));
                }
                catch (Exception e) {
                    return Mono.error((Throwable)new TransactionSystemException("Error invoking doInTransaction handler: " + e.getMessage(), (Throwable)e));
                }
            }
            return this.withNewOrExistingTxAttributeMono((AttributeHolder)operation, entityOperation, isWrite);
        }

        private <T, R> Flux<R> withNewOrExistingTransactionFlux(@NonNull PreparedQuery<T, R> operation, boolean isWrite, ReactiveTransactionOperations.TransactionalCallback<Connection, R> entityOperation) {
            ReactiveTransactionStatus connection = operation.getParameterInRole("tx-status", ReactiveTransactionStatus.class).orElse(null);
            if (connection != null) {
                try {
                    return Flux.from((Publisher)entityOperation.doInTransaction(connection));
                }
                catch (Exception e) {
                    return Flux.error((Throwable)new TransactionSystemException("Error invoking doInTransaction handler: " + e.getMessage(), (Throwable)e));
                }
            }
            return this.withNewOrExistingTxAttributeFlux((AttributeHolder)operation, entityOperation, isWrite);
        }

        private <R> Flux<R> withNewOrExistingTxAttributeFlux(@NonNull AttributeHolder attributeHolder, ReactiveTransactionOperations.TransactionalCallback<Connection, R> entityOperation, boolean isWrite) {
            TransactionDefinition definition = this.newTransactionDefinition(attributeHolder);
            if (isWrite && definition.isReadOnly()) {
                return Flux.error((Throwable)new TransactionUsageException("Cannot perform write operation with read-only transaction"));
            }
            return DefaultR2dbcRepositoryOperations.this.withTransaction(definition, entityOperation);
        }

        private <R> Mono<R> withNewOrExistingTxAttributeMono(@NonNull AttributeHolder attributeHolder, ReactiveTransactionOperations.TransactionalCallback<Connection, R> entityOperation, boolean isWrite) {
            TransactionDefinition definition = this.newTransactionDefinition(attributeHolder);
            if (isWrite && definition.isReadOnly()) {
                return Mono.error((Throwable)new TransactionUsageException("Cannot perform write operation with read-only transaction"));
            }
            return (Mono)DefaultR2dbcRepositoryOperations.this.withTransaction(definition, entityOperation).as(DefaultR2dbcRepositoryOperations::toSingleResult);
        }

        @NonNull
        public <T> Mono<Number> deleteAll(DeleteBatchOperation<T> operation) {
            return this.withNewOrExistingTransactionMono((EntityOperation<T>)operation, true, (ReactiveTransactionOperations.TransactionalCallback)status -> {
                SqlStoredQuery storedQuery = DefaultR2dbcRepositoryOperations.this.getSqlStoredQuery(operation.getStoredQuery());
                RuntimePersistentEntity persistentEntity = storedQuery.getPersistentEntity();
                R2dbcOperationContext ctx = this.createContext((EntityOperation)operation, (ReactiveTransactionStatus<Connection>)status, (SqlStoredQuery)storedQuery);
                if (DefaultR2dbcRepositoryOperations.this.isSupportsBatchDelete((PersistentEntity)persistentEntity, storedQuery.getDialect())) {
                    R2dbcEntitiesOperations op = new R2dbcEntitiesOperations(ctx, persistentEntity, operation, storedQuery);
                    op.delete();
                    return op.getRowsUpdated();
                }
                return DefaultR2dbcRepositoryOperations.this.sum(operation.split().stream().map(deleteOp -> {
                    R2dbcEntityOperations<Object> op = new R2dbcEntityOperations<Object>(ctx, persistentEntity, deleteOp.getEntity(), storedQuery);
                    op.delete();
                    return op.getRowsUpdated();
                }));
            });
        }

        @NonNull
        public <T> Flux<T> updateAll(@NonNull UpdateBatchOperation<T> operation) {
            return this.withNewOrExistingTransactionFlux((EntityOperation<T>)operation, true, (ReactiveTransactionOperations.TransactionalCallback)status -> {
                SqlStoredQuery storedQuery = DefaultR2dbcRepositoryOperations.this.getSqlStoredQuery(operation.getStoredQuery());
                R2dbcOperationContext ctx = this.createContext((EntityOperation)operation, (ReactiveTransactionStatus<Connection>)status, (SqlStoredQuery)storedQuery);
                RuntimePersistentEntity persistentEntity = storedQuery.getPersistentEntity();
                if (!DefaultR2dbcRepositoryOperations.this.isSupportsBatchUpdate((PersistentEntity)persistentEntity, storedQuery.getDialect())) {
                    return DefaultR2dbcRepositoryOperations.this.concatMono(operation.split().stream().map(updateOp -> {
                        R2dbcEntityOperations<Object> op = new R2dbcEntityOperations<Object>(ctx, persistentEntity, updateOp.getEntity(), storedQuery);
                        op.update();
                        return op.getEntity();
                    }));
                }
                R2dbcEntitiesOperations op = new R2dbcEntitiesOperations(ctx, persistentEntity, operation, storedQuery);
                op.update();
                return op.getEntities();
            });
        }

        private <T> R2dbcOperationContext createContext(EntityOperation<T> operation, ReactiveTransactionStatus<Connection> status, SqlStoredQuery<T, ?> storedQuery) {
            return new R2dbcOperationContext(operation.getAnnotationMetadata(), operation.getInvocationContext(), operation.getRepositoryType(), storedQuery.getDialect(), (Connection)status.getConnection());
        }

        @NonNull
        public <T> Mono<T> findOptional(@NonNull Class<T> type, @NonNull Serializable id) {
            throw new UnsupportedOperationException("The findOptional method by ID is not supported. Execute the SQL query directly");
        }

        @NonNull
        public <R> Mono<Page<R>> findPage(@NonNull PagedQuery<R> pagedQuery) {
            throw new UnsupportedOperationException("The findPage method is not supported. Execute the SQL query directly");
        }

        @NonNull
        public <T> Mono<T> findOne(@NonNull Class<T> type, @NonNull Serializable id) {
            throw new UnsupportedOperationException("The findOne method by ID is not supported. Execute the SQL query directly");
        }

        @NonNull
        public <T> Mono<Long> count(PagedQuery<T> pagedQuery) {
            throw new UnsupportedOperationException("The count method without an explicit query is not supported. Use findAll(PreparedQuery) instead");
        }

        @NonNull
        public <T> Flux<T> findAll(PagedQuery<T> pagedQuery) {
            throw new UnsupportedOperationException("The findAll method without an explicit query is not supported. Use findAll(PreparedQuery) instead");
        }

        public ConversionService getConversionService() {
            return DefaultR2dbcRepositoryOperations.this.conversionService;
        }

        private static /* synthetic */ Object lambda$findAll$15(TypeMapper mapper, Class resultType, Row row) {
            return mapper.map((Object)row, resultType);
        }

        private static /* synthetic */ Object lambda$findOne$8(TypeMapper mapper, Class resultType, Row row) {
            return mapper.map((Object)row, resultType);
        }
    }

    protected static class R2dbcOperationContext
    extends OperationContext {
        private final Connection connection;
        private final Dialect dialect;
        private final InvocationContext<?, ?> invocationContext;

        @Deprecated
        public R2dbcOperationContext(AnnotationMetadata annotationMetadata, Class<?> repositoryType, Dialect dialect, Connection connection) {
            this(annotationMetadata, null, repositoryType, dialect, connection);
        }

        public R2dbcOperationContext(AnnotationMetadata annotationMetadata, InvocationContext<?, ?> invocationContext, Class<?> repositoryType, Dialect dialect, Connection connection) {
            super(annotationMetadata, repositoryType);
            this.dialect = dialect;
            this.connection = connection;
            this.invocationContext = invocationContext;
        }
    }

    private final class R2dbcEntityOperations<T>
    extends AbstractReactiveEntityOperations<R2dbcOperationContext, T, RuntimeException> {
        private final SqlStoredQuery<T, ?> storedQuery;

        private R2dbcEntityOperations(R2dbcOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, T entity, SqlStoredQuery<T, ?> storedQuery) {
            this(ctx, storedQuery, persistentEntity, entity, false);
        }

        private R2dbcEntityOperations(R2dbcOperationContext ctx, SqlStoredQuery<T, ?> storedQuery, RuntimePersistentEntity<T> persistentEntity, T entity, boolean insert) {
            super((OperationContext)ctx, DefaultR2dbcRepositoryOperations.this.cascadeOperations, (ConversionService)DefaultR2dbcRepositoryOperations.this.conversionService, DefaultR2dbcRepositoryOperations.this.entityEventRegistry, persistentEntity, entity, insert);
            this.storedQuery = storedQuery;
        }

        protected void collectAutoPopulatedPreviousValues() {
            this.data = this.data.map(d -> {
                if (d.vetoed) {
                    return d;
                }
                d.previousValues = this.storedQuery.collectAutoPopulatedPreviousValues(d.entity);
                return d;
            });
        }

        private Statement prepare(Connection connection) throws RuntimeException {
            if (this.storedQuery instanceof SqlPreparedQuery) {
                this.data = this.data.map(d -> {
                    if (d.vetoed) {
                        return d;
                    }
                    ((SqlPreparedQuery)this.storedQuery).prepare(d.entity);
                    return d;
                });
            }
            LOG.debug(this.storedQuery.getQuery());
            Statement statement = connection.createStatement(this.storedQuery.getQuery());
            if (this.hasGeneratedId) {
                return statement.returnGeneratedValues(new String[]{this.persistentEntity.getIdentity().getPersistedName()});
            }
            return statement;
        }

        private void setParameters(Statement stmt, SqlStoredQuery<T, ?> storedQuery) {
            this.data = this.data.map(d -> {
                if (d.vetoed) {
                    return d;
                }
                storedQuery.bindParameters((BindableParametersStoredQuery.Binder)new R2dbcParameterBinder((R2dbcOperationContext)this.ctx, stmt, storedQuery), ((R2dbcOperationContext)this.ctx).invocationContext, d.entity, d.previousValues);
                return d;
            });
        }

        protected void execute() throws RuntimeException {
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing SQL query: {}", (Object)this.storedQuery.getQuery());
            }
            Statement statement = this.prepare(((R2dbcOperationContext)this.ctx).connection);
            this.setParameters(statement, this.storedQuery);
            this.data = this.hasGeneratedId ? this.data.flatMap(d -> {
                if (d.vetoed) {
                    return Mono.just((Object)d);
                }
                RuntimePersistentProperty identity = this.persistentEntity.getIdentity();
                return DefaultR2dbcRepositoryOperations.executeAndMapEachRowSingle(statement, row -> DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic(row, (Object)0, identity.getDataType())).map(id -> {
                    BeanProperty property = identity.getProperty();
                    d.entity = this.updateEntityId(property, d.entity, id);
                    return d;
                });
            }) : this.data.flatMap(d -> {
                if (d.vetoed) {
                    return Mono.just((Object)d);
                }
                return DefaultR2dbcRepositoryOperations.executeAndGetRowsUpdatedSingle(statement, ((R2dbcOperationContext)this.ctx).dialect).map(rowsUpdated -> {
                    d.rowsUpdated = rowsUpdated.longValue();
                    return d;
                });
            });
            if (this.storedQuery.isOptimisticLock()) {
                this.data = this.data.map(d -> {
                    this.checkOptimisticLocking(1L, d.rowsUpdated);
                    return d;
                });
            }
        }
    }

    private final class R2dbcEntitiesOperations<T>
    extends AbstractReactiveEntitiesOperations<R2dbcOperationContext, T, RuntimeException> {
        private final SqlStoredQuery<T, ?> storedQuery;

        private R2dbcEntitiesOperations(R2dbcOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities, SqlStoredQuery storedQuery) {
            this(ctx, storedQuery, persistentEntity, entities, false);
        }

        private R2dbcEntitiesOperations(R2dbcOperationContext ctx, SqlStoredQuery storedQuery, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities, boolean insert) {
            super((OperationContext)ctx, DefaultR2dbcRepositoryOperations.this.cascadeOperations, (ConversionService)DefaultR2dbcRepositoryOperations.this.conversionService, DefaultR2dbcRepositoryOperations.this.entityEventRegistry, persistentEntity, entities, insert);
            this.storedQuery = storedQuery;
        }

        protected void collectAutoPopulatedPreviousValues() {
            this.entities = this.entities.map(list -> {
                for (AbstractReactiveEntitiesOperations.Data d : list) {
                    if (d.vetoed) continue;
                    d.previousValues = this.storedQuery.collectAutoPopulatedPreviousValues(d.entity);
                }
                return list;
            });
        }

        private void setParameters(Statement stmt, SqlStoredQuery<T, ?> storedQuery) {
            AtomicBoolean isFirst = new AtomicBoolean(true);
            this.entities = this.entities.map(list -> {
                for (AbstractReactiveEntitiesOperations.Data d : list) {
                    if (d.vetoed) continue;
                    if (isFirst.get()) {
                        isFirst.set(false);
                    } else {
                        stmt.add();
                    }
                    storedQuery.bindParameters((BindableParametersStoredQuery.Binder)new R2dbcParameterBinder((R2dbcOperationContext)this.ctx, stmt, storedQuery), ((R2dbcOperationContext)this.ctx).invocationContext, d.entity, d.previousValues);
                }
                return list;
            });
        }

        protected void execute() throws RuntimeException {
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing SQL query: {}", (Object)this.storedQuery.getQuery());
            }
            Statement statement = this.hasGeneratedId ? ((R2dbcOperationContext)this.ctx).connection.createStatement(this.storedQuery.getQuery()).returnGeneratedValues(new String[]{this.persistentEntity.getIdentity().getPersistedName()}) : ((R2dbcOperationContext)this.ctx).connection.createStatement(this.storedQuery.getQuery());
            this.setParameters(statement, this.storedQuery);
            if (this.hasGeneratedId) {
                this.entities = this.entities.flatMap(list -> {
                    List notVetoedEntities = list.stream().filter(x$0 -> this.notVetoed((AbstractReactiveEntitiesOperations.Data)x$0)).collect(Collectors.toList());
                    if (notVetoedEntities.isEmpty()) {
                        return Mono.just(notVetoedEntities);
                    }
                    Mono ids = DefaultR2dbcRepositoryOperations.executeAndMapEachRow(statement, row -> DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic(row, (Object)0, this.persistentEntity.getIdentity().getDataType())).collectList();
                    return ids.flatMap(idList -> {
                        Iterator iterator = idList.iterator();
                        ListIterator resultIterator = notVetoedEntities.listIterator();
                        RuntimePersistentProperty identity = this.persistentEntity.getIdentity();
                        while (resultIterator.hasNext()) {
                            AbstractReactiveEntitiesOperations.Data d = (AbstractReactiveEntitiesOperations.Data)resultIterator.next();
                            if (!iterator.hasNext()) {
                                throw new DataAccessException("Failed to generate ID for entity: " + d.entity);
                            }
                            Object id = iterator.next();
                            d.entity = this.updateEntityId(identity.getProperty(), d.entity, id);
                        }
                        return Mono.just((Object)list);
                    });
                });
            } else {
                Mono entitiesWithRowsUpdated = this.entities.flatMap(list -> {
                    List notVetoedEntities = list.stream().filter(x$0 -> this.notVetoed((AbstractReactiveEntitiesOperations.Data)x$0)).collect(Collectors.toList());
                    if (notVetoedEntities.isEmpty()) {
                        return Mono.just((Object)Tuples.of((Object)list, (Object)0L));
                    }
                    return DefaultR2dbcRepositoryOperations.executeAndGetRowsUpdated(statement).map(Number::longValue).reduce((Object)0L, Long::sum).map(rowsUpdated -> {
                        if (this.storedQuery.isOptimisticLock()) {
                            this.checkOptimisticLocking(notVetoedEntities.size(), (long)rowsUpdated);
                        }
                        return Tuples.of((Object)list, (Object)rowsUpdated);
                    });
                }).cache();
                this.entities = entitiesWithRowsUpdated.flatMap(t -> Mono.just((Object)((List)t.getT1())));
                this.rowsUpdated = entitiesWithRowsUpdated.map(Tuple2::getT2);
            }
        }
    }

    private static final class DefaultReactiveTransactionStatus
    implements ReactiveTransactionStatus<Connection> {
        private final TransactionDefinition definition;
        private final Connection connection;
        private final boolean isNew;
        private boolean rollbackOnly;
        private boolean completed;

        public DefaultReactiveTransactionStatus(TransactionDefinition definition, Connection connection, boolean isNew) {
            this.definition = definition;
            this.connection = connection;
            this.isNew = isNew;
        }

        public TransactionDefinition getDefinition() {
            return this.definition;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public boolean isNewTransaction() {
            return this.isNew;
        }

        public void setRollbackOnly() {
            this.rollbackOnly = true;
        }

        public boolean isRollbackOnly() {
            return this.rollbackOnly;
        }

        public boolean isCompleted() {
            return this.completed;
        }
    }

    private static class R2dbcConversionContextImpl
    extends AbstractConversionContext
    implements R2dbcConversionContext {
        private final Connection connection;

        public R2dbcConversionContextImpl(Connection connection) {
            this(ConversionContext.DEFAULT, connection);
        }

        public R2dbcConversionContextImpl(ConversionContext conversionContext, Connection connection) {
            super(conversionContext);
            this.connection = connection;
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }
    }

    private static final class ArgumentR2dbcCC
    extends R2dbcConversionContextImpl
    implements ArgumentConversionContext<Object> {
        private final Argument argument;

        public ArgumentR2dbcCC(Connection connection, Argument argument) {
            super((ConversionContext)ConversionContext.of((Argument)argument), connection);
            this.argument = argument;
        }

        public Argument<Object> getArgument() {
            return this.argument;
        }
    }

    private static final class RuntimePersistentPropertyR2dbcCC
    extends R2dbcConversionContextImpl
    implements RuntimePersistentPropertyConversionContext {
        private final RuntimePersistentProperty<?> property;

        public RuntimePersistentPropertyR2dbcCC(Connection connection, RuntimePersistentProperty<?> property) {
            super((ConversionContext)ConversionContext.of((Argument)property.getArgument()), connection);
            this.property = property;
        }

        public RuntimePersistentProperty<?> getRuntimePersistentProperty() {
            return this.property;
        }
    }

    private final class R2dbcParameterBinder
    implements BindableParametersStoredQuery.Binder {
        private final Connection connection;
        private final Statement ps;
        private final SqlStoredQuery<?, ?> sqlStoredQuery;
        private int index = 0;

        private R2dbcParameterBinder(R2dbcOperationContext ctx, Statement ps, SqlStoredQuery<?, ?> sqlStoredQuery) {
            this(ctx.connection, ps, sqlStoredQuery);
        }

        private R2dbcParameterBinder(Connection connection, Statement ps, SqlStoredQuery<?, ?> sqlStoredQuery) {
            this.connection = connection;
            this.ps = ps;
            this.sqlStoredQuery = sqlStoredQuery;
        }

        public Object autoPopulateRuntimeProperty(RuntimePersistentProperty<?> persistentProperty, Object previousValue) {
            return DefaultR2dbcRepositoryOperations.this.runtimeEntityRegistry.autoPopulateRuntimeProperty(persistentProperty, previousValue);
        }

        public Object convert(Object value, RuntimePersistentProperty<?> property) {
            if (property == null) {
                return value;
            }
            AttributeConverter converter = property.getConverter();
            if (converter != null) {
                return converter.convertToPersistedValue(value, this.createTypeConversionContext(property, property.getArgument()));
            }
            return value;
        }

        public Object convert(Class<?> converterClass, Object value, Argument<?> argument) {
            if (converterClass == null) {
                return value;
            }
            AttributeConverter converter = DefaultR2dbcRepositoryOperations.this.attributeConverterRegistry.getConverter(converterClass);
            ConversionContext conversionContext = this.createTypeConversionContext(null, argument);
            return converter.convertToPersistedValue(value, conversionContext);
        }

        private ConversionContext createTypeConversionContext(@Nullable RuntimePersistentProperty<?> property, @Nullable Argument<?> argument) {
            if (property != null) {
                return new RuntimePersistentPropertyR2dbcCC(this.connection, property);
            }
            if (argument != null) {
                return new ArgumentR2dbcCC(this.connection, argument);
            }
            return new R2dbcConversionContextImpl(this.connection);
        }

        public void bindOne(QueryParameterBinding binding, Object value) {
            JsonDataType jsonDataType = null;
            if (binding.getDataType() == DataType.JSON) {
                jsonDataType = binding.getJsonDataType();
            }
            DefaultR2dbcRepositoryOperations.this.setStatementParameter(this.ps, this.index, binding.getDataType(), jsonDataType, value, this.sqlStoredQuery);
            ++this.index;
        }

        public void bindMany(QueryParameterBinding binding, Collection<Object> values) {
            for (Object value : values) {
                this.bindOne(binding, value);
            }
        }

        public int currentIndex() {
            return this.index;
        }
    }
}

