/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.r2dbc.mapper;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.DataType;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.mapper.QueryStatement;
import io.r2dbc.spi.Statement;
import java.math.BigDecimal;
import java.sql.Time;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.UUID;

public class R2dbcQueryStatement
implements QueryStatement<Statement, Integer> {
    private final ConversionService<?> conversionService;

    public R2dbcQueryStatement() {
        this(null);
    }

    public R2dbcQueryStatement(DataConversionService<?> conversionService) {
        this.conversionService = conversionService == null ? ConversionService.SHARED : conversionService;
    }

    public ConversionService<?> getConversionService() {
        return this.conversionService;
    }

    public QueryStatement<Statement, Integer> setDynamic(@NonNull Statement statement, @NonNull Integer index, @NonNull DataType dataType, Object value) {
        if (value == null) {
            switch (dataType) {
                case UUID: {
                    statement.bindNull(index.intValue(), UUID.class);
                    break;
                }
                case STRING: 
                case JSON: {
                    statement.bindNull(index.intValue(), String.class);
                    break;
                }
                case BYTE: {
                    statement.bindNull(index.intValue(), Byte.class);
                    break;
                }
                case CHARACTER: {
                    statement.bindNull(index.intValue(), Character.class);
                    break;
                }
                case INTEGER: {
                    statement.bindNull(index.intValue(), Integer.class);
                    break;
                }
                case LONG: {
                    statement.bindNull(index.intValue(), Long.class);
                    break;
                }
                case FLOAT: {
                    statement.bindNull(index.intValue(), Float.class);
                    break;
                }
                case SHORT: {
                    statement.bindNull(index.intValue(), Short.class);
                    break;
                }
                case DOUBLE: {
                    statement.bindNull(index.intValue(), Double.class);
                    break;
                }
                case BOOLEAN: {
                    statement.bindNull(index.intValue(), Boolean.class);
                    break;
                }
                case SHORT_ARRAY: {
                    statement.bindNull(index.intValue(), Short[].class);
                    break;
                }
                case STRING_ARRAY: {
                    statement.bindNull(index.intValue(), String[].class);
                    break;
                }
                case INTEGER_ARRAY: {
                    statement.bindNull(index.intValue(), Integer[].class);
                    break;
                }
                case DOUBLE_ARRAY: {
                    statement.bindNull(index.intValue(), Double[].class);
                    break;
                }
                case LONG_ARRAY: {
                    statement.bindNull(index.intValue(), Long[].class);
                    break;
                }
                case BOOLEAN_ARRAY: {
                    statement.bindNull(index.intValue(), Boolean[].class);
                    break;
                }
                case BYTE_ARRAY: {
                    statement.bindNull(index.intValue(), Byte[].class);
                    break;
                }
                case CHARACTER_ARRAY: {
                    statement.bindNull(index.intValue(), Character[].class);
                    break;
                }
                case FLOAT_ARRAY: {
                    statement.bindNull(index.intValue(), BigDecimal[].class);
                    break;
                }
                default: {
                    return super.setDynamic((Object)statement, (Object)index, dataType, value);
                }
            }
            return this;
        }
        switch (dataType) {
            case DOUBLE_ARRAY: 
            case FLOAT_ARRAY: {
                return this.setArray(statement, index, (Object)this.convertRequired(value, BigDecimal[].class));
            }
        }
        return super.setDynamic((Object)statement, (Object)index, dataType, value);
    }

    public QueryStatement<Statement, Integer> setValue(Statement statement, Integer index, Object value) throws DataAccessException {
        if (value == null) {
            statement.bindNull(index.intValue(), Object.class);
        } else {
            statement.bind(index.intValue(), value);
        }
        return this;
    }

    @Nullable
    public <T> T convertRequired(@Nullable Object value, Class<T> type) {
        return (T)this.conversionService.convertRequired(value, type);
    }

    @NonNull
    public QueryStatement<Statement, Integer> setLong(Statement statement, Integer name, long value) {
        this.setValue(statement, name, (Object)value);
        return this;
    }

    @NonNull
    public QueryStatement<Statement, Integer> setChar(Statement statement, Integer name, char value) {
        this.setValue(statement, name, (Object)String.valueOf(value));
        return this;
    }

    @NonNull
    public QueryStatement<Statement, Integer> setDate(Statement statement, Integer name, Date date) {
        if (date == null) {
            statement.bindNull(name.intValue(), LocalDate.class);
        } else {
            statement.bind(name.intValue(), (Object)this.convertRequired(date, LocalDate.class));
        }
        return this;
    }

    public QueryStatement<Statement, Integer> setTimestamp(Statement statement, Integer name, Instant instant) {
        if (instant == null) {
            statement.bindNull(name.intValue(), LocalDateTime.class);
        } else {
            statement.bind(name.intValue(), (Object)instant.atZone(ZoneId.systemDefault()).toLocalDateTime());
        }
        return this;
    }

    public QueryStatement<Statement, Integer> setTime(Statement statement, Integer name, Time instant) {
        if (statement.getClass().getName().equals("oracle.r2dbc.impl.OracleStatementImpl")) {
            this.setTimestamp(statement, name, Instant.ofEpochMilli(instant.getTime()));
            return this;
        }
        if (instant == null) {
            statement.bindNull(name.intValue(), LocalTime.class);
        } else {
            statement.bind(name.intValue(), (Object)instant.toLocalTime());
        }
        return this;
    }

    public QueryStatement<Statement, Integer> setString(Statement statement, Integer name, String string) {
        if (string == null) {
            statement.bindNull(name.intValue(), String.class);
        } else {
            statement.bind(name.intValue(), (Object)string);
        }
        return this;
    }

    @NonNull
    public QueryStatement<Statement, Integer> setInt(Statement statement, Integer name, int integer) {
        this.setValue(statement, name, (Object)integer);
        return this;
    }

    @NonNull
    public QueryStatement<Statement, Integer> setBoolean(Statement statement, Integer name, boolean bool) {
        this.setValue(statement, name, (Object)bool);
        return this;
    }

    @NonNull
    public QueryStatement<Statement, Integer> setFloat(Statement statement, Integer name, float f) {
        this.setValue(statement, name, (Object)Float.valueOf(f));
        return this;
    }

    @NonNull
    public QueryStatement<Statement, Integer> setByte(Statement statement, Integer name, byte b) {
        this.setValue(statement, name, (Object)b);
        return this;
    }

    @NonNull
    public QueryStatement<Statement, Integer> setShort(Statement statement, Integer name, short s) {
        this.setValue(statement, name, (Object)s);
        return this;
    }

    @NonNull
    public QueryStatement<Statement, Integer> setDouble(Statement statement, Integer name, double d) {
        this.setValue(statement, name, (Object)d);
        return this;
    }

    @NonNull
    public QueryStatement<Statement, Integer> setBigDecimal(Statement statement, Integer name, BigDecimal bd) {
        if (bd == null) {
            statement.bindNull(name.intValue(), BigDecimal.class);
        } else {
            statement.bind(name.intValue(), (Object)bd);
        }
        return this;
    }

    @NonNull
    public QueryStatement<Statement, Integer> setBytes(Statement statement, Integer name, byte[] bytes) {
        if (bytes == null) {
            statement.bindNull(name.intValue(), byte[].class);
        } else {
            statement.bind(name.intValue(), (Object)bytes);
        }
        return this;
    }

    @NonNull
    public QueryStatement<Statement, Integer> setArray(Statement statement, Integer name, Object array) {
        if (array == null) {
            statement.bindNull(name.intValue(), Object[].class);
        } else {
            statement.bind(name.intValue(), array);
        }
        return this;
    }
}

