/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.r2dbc.transaction;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.async.AsyncTransactionOperations;
import io.micronaut.transaction.async.AsyncUsingReactiveTransactionOperations;
import io.micronaut.transaction.interceptor.CoroutineTxHelper;
import io.micronaut.transaction.reactive.ReactorReactiveTransactionOperations;
import io.micronaut.transaction.sync.SynchronousFromReactiveTransactionManager;
import io.r2dbc.spi.ConnectionFactory;
import jakarta.inject.Named;
import java.util.concurrent.ExecutorService;

@Factory
final class R2dbcTransactionManagerFactory {
    R2dbcTransactionManagerFactory() {
    }

    @EachBean(value=ConnectionFactory.class)
    <T> SynchronousTransactionManager<T> buildSynchronousTransactionManager(@Parameter ReactorReactiveTransactionOperations<T> reactiveTransactionOperations, @Named(value="io") ExecutorService executorService) {
        return new SynchronousFromReactiveTransactionManager(reactiveTransactionOperations, executorService);
    }

    @EachBean(value=ConnectionFactory.class)
    <T> AsyncTransactionOperations<T> buildAsyncTransactionOperations(@Parameter ReactorReactiveTransactionOperations<T> reactiveTransactionOperations, @Nullable CoroutineTxHelper coroutineTxHelper) {
        return new AsyncUsingReactiveTransactionOperations(reactiveTransactionOperations, coroutineTxHelper);
    }
}

