/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.r2dbc.config;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Context;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.r2dbc.config.DataR2dbcConfiguration;
import io.micronaut.data.r2dbc.operations.R2dbcOperations;
import io.micronaut.data.runtime.config.DataSettings;
import io.micronaut.data.runtime.config.SchemaGenerate;
import io.r2dbc.spi.Connection;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Context
@Internal
public class R2dbcSchemaGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(R2dbcSchemaGenerator.class);
    private final List<DataR2dbcConfiguration> configurations;

    public R2dbcSchemaGenerator(List<DataR2dbcConfiguration> configurations) {
        this.configurations = configurations;
    }

    @PostConstruct
    protected void createSchema(BeanLocator beanLocator) {
        RuntimeEntityRegistry runtimeEntityRegistry = (RuntimeEntityRegistry)beanLocator.getBean(RuntimeEntityRegistry.class);
        for (DataR2dbcConfiguration configuration : this.configurations) {
            List<String> packages;
            Collection introspections;
            Object[] entities;
            SchemaGenerate schemaGenerate = configuration.getSchemaGenerate();
            if (schemaGenerate == null || schemaGenerate == SchemaGenerate.NONE || !ArrayUtils.isNotEmpty((Object[])(entities = (PersistentEntity[])(introspections = CollectionUtils.isNotEmpty(packages = configuration.getPackages()) ? BeanIntrospector.SHARED.findIntrospections(MappedEntity.class, packages.toArray(new String[0])) : BeanIntrospector.SHARED.findIntrospections(MappedEntity.class)).stream().filter(i -> !i.getBeanType().getName().contains("$")).filter(i -> !Modifier.isAbstract(i.getBeanType().getModifiers())).map(e -> runtimeEntityRegistry.getEntity(e.getBeanType())).toArray(PersistentEntity[]::new)))) continue;
            R2dbcOperations r2dbcOperations = configuration.getR2dbcOperations();
            SqlQueryBuilder builder = new SqlQueryBuilder(configuration.getDialect());
            Mono.from(r2dbcOperations.withConnection(arg_0 -> this.lambda$createSchema$10((PersistentEntity[])entities, builder, schemaGenerate, arg_0))).block();
        }
    }

    private Mono<Void> execute(Connection connection, String sql) {
        return Flux.from((Publisher)connection.createStatement(sql).execute()).flatMap(result -> Flux.from((Publisher)result.getRowsUpdated())).collectList().then();
    }

    private /* synthetic */ Publisher lambda$createSchema$10(PersistentEntity[] entities, SqlQueryBuilder builder, SchemaGenerate schemaGenerate, Connection connection) {
        List createStatements = Arrays.stream(entities).flatMap(entity -> Arrays.stream(builder.buildCreateTableStatements(entity))).collect(Collectors.toList());
        Flux createTablesFlow = Flux.fromIterable(createStatements).concatMap(sql -> {
            if (DataSettings.QUERY_LOG.isDebugEnabled()) {
                DataSettings.QUERY_LOG.debug("Creating Table: \n{}", sql);
            }
            return this.execute(connection, (String)sql).onErrorResume(throwable -> {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Unable to create table :{}", (Object)throwable.getMessage());
                }
                return Mono.empty();
            });
        });
        switch (schemaGenerate) {
            case CREATE_DROP: {
                List dropStatements = Arrays.stream(entities).flatMap(entity -> Arrays.stream(builder.buildDropTableStatements(entity))).collect(Collectors.toList());
                return Flux.fromIterable(dropStatements).concatMap(sql -> {
                    if (DataSettings.QUERY_LOG.isDebugEnabled()) {
                        DataSettings.QUERY_LOG.debug("Dropping Table: \n{}", sql);
                    }
                    return this.execute(connection, (String)sql).onErrorResume(throwable -> Mono.empty());
                }).thenMany((Publisher)createTablesFlow).then();
            }
        }
        return createTablesFlow.then();
    }
}

