/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.r2dbc.operations;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.attr.AttributeHolder;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.exceptions.NonUniqueResultException;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.AttributeConverterRegistry;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.EntityOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.async.AsyncRepositoryOperations;
import io.micronaut.data.operations.reactive.ReactiveRepositoryOperations;
import io.micronaut.data.r2dbc.convert.R2dbcConversionContext;
import io.micronaut.data.r2dbc.mapper.ColumnIndexR2dbcResultReader;
import io.micronaut.data.r2dbc.mapper.ColumnNameR2dbcResultReader;
import io.micronaut.data.r2dbc.mapper.R2dbcQueryStatement;
import io.micronaut.data.r2dbc.operations.BlockingReactorRepositoryOperations;
import io.micronaut.data.r2dbc.operations.R2dbcOperations;
import io.micronaut.data.r2dbc.operations.R2dbcRepositoryOperations;
import io.micronaut.data.r2dbc.operations.ReactorReactiveRepositoryOperations;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.convert.RuntimePersistentPropertyConversionContext;
import io.micronaut.data.runtime.date.DateTimeProvider;
import io.micronaut.data.runtime.mapper.DTOMapper;
import io.micronaut.data.runtime.mapper.QueryStatement;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.data.runtime.mapper.TypeMapper;
import io.micronaut.data.runtime.mapper.sql.SqlDTOMapper;
import io.micronaut.data.runtime.mapper.sql.SqlResultEntityTypeMapper;
import io.micronaut.data.runtime.operations.AsyncFromReactiveAsyncRepositoryOperation;
import io.micronaut.data.runtime.operations.internal.AbstractReactiveEntitiesOperations;
import io.micronaut.data.runtime.operations.internal.AbstractReactiveEntityOperations;
import io.micronaut.data.runtime.operations.internal.AbstractSqlRepositoryOperations;
import io.micronaut.data.runtime.operations.internal.DBOperation;
import io.micronaut.data.runtime.operations.internal.OpContext;
import io.micronaut.data.runtime.operations.internal.OperationContext;
import io.micronaut.data.runtime.operations.internal.ReactiveCascadeOperations;
import io.micronaut.data.runtime.operations.internal.StoredQuerySqlOperation;
import io.micronaut.data.runtime.operations.internal.StoredSqlOperation;
import io.micronaut.data.runtime.support.AbstractConversionContext;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.annotation.TransactionalAdvice;
import io.micronaut.transaction.exceptions.NoTransactionException;
import io.micronaut.transaction.exceptions.TransactionSystemException;
import io.micronaut.transaction.exceptions.TransactionUsageException;
import io.micronaut.transaction.interceptor.DefaultTransactionAttribute;
import io.micronaut.transaction.reactive.ReactiveTransactionOperations;
import io.micronaut.transaction.reactive.ReactiveTransactionStatus;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import io.r2dbc.spi.Statement;
import jakarta.inject.Named;
import java.io.Serializable;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@EachBean(value=ConnectionFactory.class)
@Internal
final class DefaultR2dbcRepositoryOperations
extends AbstractSqlRepositoryOperations<Connection, Row, Statement, RuntimeException>
implements BlockingReactorRepositoryOperations,
R2dbcRepositoryOperations,
R2dbcOperations,
ReactiveTransactionOperations<Connection>,
ReactiveCascadeOperations.ReactiveCascadeOperationsHelper<R2dbcOperationContext> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultR2dbcRepositoryOperations.class);
    private final ConnectionFactory connectionFactory;
    private final ReactorReactiveRepositoryOperations reactiveOperations;
    private final String dataSourceName;
    private ExecutorService executorService;
    private AsyncRepositoryOperations asyncRepositoryOperations;
    private final ReactiveCascadeOperations<R2dbcOperationContext> cascadeOperations;

    @Internal
    protected DefaultR2dbcRepositoryOperations(@Parameter String dataSourceName, ConnectionFactory connectionFactory, List<MediaTypeCodec> mediaTypeCodecList, @NonNull DateTimeProvider<Object> dateTimeProvider, RuntimeEntityRegistry runtimeEntityRegistry, ApplicationContext applicationContext, @Nullable @Named(value="io") ExecutorService executorService, DataConversionService<?> conversionService, AttributeConverterRegistry attributeConverterRegistry) {
        super(dataSourceName, (ResultReader)new ColumnNameR2dbcResultReader(conversionService), (ResultReader)new ColumnIndexR2dbcResultReader(conversionService), (QueryStatement)new R2dbcQueryStatement(conversionService), mediaTypeCodecList, dateTimeProvider, runtimeEntityRegistry, (BeanContext)applicationContext, conversionService, attributeConverterRegistry);
        this.connectionFactory = connectionFactory;
        this.executorService = executorService;
        this.reactiveOperations = new DefaultR2dbcReactiveRepositoryOperations();
        this.dataSourceName = dataSourceName;
        this.cascadeOperations = new ReactiveCascadeOperations(conversionService, (ReactiveCascadeOperations.ReactiveCascadeOperationsHelper)this);
    }

    public <T> Mono<T> persistOne(R2dbcOperationContext ctx, T value, RuntimePersistentEntity<T> persistentEntity) {
        DBOperation childSqlPersistOperation = this.resolveEntityInsert(ctx.annotationMetadata, ctx.repositoryType, value.getClass(), persistentEntity);
        R2dbcEntityOperations op = new R2dbcEntityOperations(ctx, childSqlPersistOperation, persistentEntity, value, true);
        op.persist();
        return op.getEntity();
    }

    public <T> Flux<T> persistBatch(R2dbcOperationContext ctx, Iterable<T> values, RuntimePersistentEntity<T> persistentEntity, Predicate<T> predicate) {
        DBOperation childSqlPersistOperation = this.resolveEntityInsert(ctx.annotationMetadata, ctx.repositoryType, persistentEntity.getIntrospection().getBeanType(), persistentEntity);
        R2dbcEntitiesOperations op = new R2dbcEntitiesOperations(ctx, childSqlPersistOperation, persistentEntity, values, true);
        if (predicate != null) {
            op.veto(predicate);
        }
        op.persist();
        return op.getEntities();
    }

    public <T> Mono<T> updateOne(R2dbcOperationContext ctx, T value, RuntimePersistentEntity<T> persistentEntity) {
        DBOperation childSqlUpdateOperation = this.resolveEntityUpdate(ctx.annotationMetadata, ctx.repositoryType, value.getClass(), persistentEntity);
        R2dbcEntityOperations op = new R2dbcEntityOperations(ctx, persistentEntity, value, childSqlUpdateOperation);
        op.update();
        return op.getEntity();
    }

    public Mono<Void> persistManyAssociation(R2dbcOperationContext ctx, RuntimeAssociation runtimeAssociation, Object value, RuntimePersistentEntity<Object> persistentEntity, Object child, RuntimePersistentEntity<Object> childPersistentEntity) {
        DBOperation dbInsertOperation = this.resolveSqlInsertAssociation(ctx.repositoryType, ctx.dialect, runtimeAssociation, persistentEntity, value);
        R2dbcEntityOperations assocEntityOp = new R2dbcEntityOperations(ctx, childPersistentEntity, child, dbInsertOperation);
        try {
            assocEntityOp.execute();
        }
        catch (Exception e1) {
            throw new DataAccessException("SQL error executing INSERT: " + e1.getMessage(), (Throwable)e1);
        }
        return assocEntityOp.getEntity().then();
    }

    public Mono<Void> persistManyAssociationBatch(R2dbcOperationContext ctx, RuntimeAssociation runtimeAssociation, Object value, RuntimePersistentEntity<Object> persistentEntity, Iterable<Object> child, RuntimePersistentEntity<Object> childPersistentEntity, Predicate<Object> veto) {
        DBOperation dbInsertOperation = this.resolveSqlInsertAssociation(ctx.repositoryType, ctx.dialect, runtimeAssociation, persistentEntity, value);
        R2dbcEntitiesOperations assocEntitiesOp = new R2dbcEntitiesOperations(ctx, childPersistentEntity, child, dbInsertOperation);
        assocEntitiesOp.veto(veto);
        try {
            assocEntitiesOp.execute();
        }
        catch (Exception e1) {
            throw new DataAccessException("SQL error executing INSERT: " + e1.getMessage(), (Throwable)e1);
        }
        return assocEntitiesOp.getEntities().then();
    }

    protected ConversionContext createTypeConversionContext(Connection connection, RuntimePersistentProperty<?> property, Argument<?> argument) {
        Objects.requireNonNull(connection);
        if (property != null) {
            return new RuntimePersistentPropertyR2dbcCC(connection, property);
        }
        if (argument != null) {
            return new ArgumentR2dbcCC(connection, argument);
        }
        return new R2dbcConversionContextImpl(connection);
    }

    private Mono<Long> sum(Stream<Mono<Long>> stream) {
        return stream.reduce((m1, m2) -> m1.zipWith(m2).map(t -> (Long)t.getT1() + (Long)t.getT2())).orElse((Mono<Long>)Mono.empty());
    }

    private <T> Flux<T> concatMono(Stream<Mono<T>> stream) {
        return Flux.concat((Iterable)stream.collect(Collectors.toList()));
    }

    public int shiftIndex(int i) {
        return i;
    }

    @NonNull
    public ReactorReactiveRepositoryOperations reactive() {
        return this.reactiveOperations;
    }

    @NonNull
    public AsyncRepositoryOperations async() {
        if (this.asyncRepositoryOperations == null) {
            if (this.executorService == null) {
                this.executorService = Executors.newCachedThreadPool();
            }
            this.asyncRepositoryOperations = new AsyncFromReactiveAsyncRepositoryOperation((ReactiveRepositoryOperations)this.reactiveOperations, (Executor)this.executorService);
        }
        return this.asyncRepositoryOperations;
    }

    @Override
    @NonNull
    public ConnectionFactory connectionFactory() {
        return this.connectionFactory;
    }

    @Override
    @NonNull
    public <T> Publisher<T> withConnection(@NonNull Function<Connection, Publisher<T>> handler) {
        Objects.requireNonNull(handler, "Handler cannot be null");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating a new Connection for DataSource: " + this.dataSourceName);
        }
        return Flux.usingWhen((Publisher)this.connectionFactory.create(), handler, connection -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing Connection for DataSource: " + this.dataSourceName);
            }
            return connection.close();
        });
    }

    private IsolationLevel getIsolationLevel(TransactionDefinition definition) {
        TransactionDefinition.Isolation isolationLevel = definition.getIsolationLevel();
        switch (isolationLevel) {
            case READ_COMMITTED: {
                return IsolationLevel.READ_COMMITTED;
            }
            case READ_UNCOMMITTED: {
                return IsolationLevel.READ_UNCOMMITTED;
            }
            case REPEATABLE_READ: {
                return IsolationLevel.REPEATABLE_READ;
            }
            case SERIALIZABLE: {
                return IsolationLevel.SERIALIZABLE;
            }
        }
        return null;
    }

    @Override
    @NonNull
    public <T> Publisher<T> withTransaction(@NonNull ReactiveTransactionStatus<Connection> status, @NonNull ReactiveTransactionOperations.TransactionalCallback<Connection, T> handler) {
        Objects.requireNonNull(status, "Transaction status cannot be null");
        Objects.requireNonNull(handler, "Callback handler cannot be null");
        return Flux.defer(() -> {
            try {
                return handler.doInTransaction(status);
            }
            catch (Exception e) {
                return Flux.error((Throwable)new TransactionSystemException("Error invoking doInTransaction handler: " + e.getMessage(), (Throwable)e));
            }
        }).contextWrite(context -> context.put((Object)"io.micronaut.tx.STATUS", (Object)status));
    }

    @NonNull
    public <T> Flux<T> withTransaction(@NonNull TransactionDefinition definition, @NonNull ReactiveTransactionOperations.TransactionalCallback<Connection, T> handler) {
        Objects.requireNonNull(definition, "Transaction definition cannot be null");
        Objects.requireNonNull(handler, "Callback handler cannot be null");
        return Flux.deferContextual(contextView -> {
            Object o = contextView.getOrDefault((Object)"io.micronaut.tx.STATUS", null);
            TransactionDefinition.Propagation propagationBehavior = definition.getPropagationBehavior();
            if (o instanceof ReactiveTransactionStatus) {
                if (propagationBehavior == TransactionDefinition.Propagation.NOT_SUPPORTED || propagationBehavior == TransactionDefinition.Propagation.NEVER) {
                    return Flux.error((Throwable)new TransactionUsageException("Found an existing transaction but propagation behaviour doesn't support it: " + propagationBehavior));
                }
                try {
                    return handler.doInTransaction((ReactiveTransactionStatus)o);
                }
                catch (Exception e) {
                    return Flux.error((Throwable)new TransactionSystemException("Error invoking doInTransaction handler: " + e.getMessage(), (Throwable)e));
                }
            }
            if (propagationBehavior == TransactionDefinition.Propagation.MANDATORY) {
                return Flux.error((Throwable)new NoTransactionException("Expected an existing transaction, but none was found in the Reactive context."));
            }
            return this.withConnection(connection -> {
                Mono resourceSupplier;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Transaction Begin for DataSource: {}", (Object)this.dataSourceName);
                }
                DefaultReactiveTransactionStatus status = new DefaultReactiveTransactionStatus((Connection)connection, true);
                if (definition.getIsolationLevel() != TransactionDefinition.DEFAULT.getIsolationLevel()) {
                    IsolationLevel isolationLevel = this.getIsolationLevel(definition);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Setting Isolation Level ({}) for Transaction on DataSource: {}", (Object)isolationLevel, (Object)this.dataSourceName);
                    }
                    resourceSupplier = isolationLevel != null ? Flux.from((Publisher)connection.setTransactionIsolationLevel(isolationLevel)).thenMany(connection.beginTransaction()).hasElements() : Flux.from((Publisher)connection.beginTransaction()).hasElements();
                } else {
                    resourceSupplier = Flux.from((Publisher)connection.beginTransaction()).hasElements();
                }
                return Flux.usingWhen((Publisher)resourceSupplier, b -> {
                    try {
                        return Flux.from((Publisher)handler.doInTransaction((ReactiveTransactionStatus)status)).contextWrite(context -> context.put((Object)"io.micronaut.tx.STATUS", (Object)status).put((Object)"io.micronaut.tx.ATTRIBUTE", (Object)definition));
                    }
                    catch (Exception e) {
                        return Mono.error((Throwable)new TransactionSystemException("Error invoking doInTransaction handler: " + e.getMessage(), (Throwable)e));
                    }
                }, b -> this.doCommit(status), (b, throwable) -> {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Rolling back transaction on error: " + throwable.getMessage(), throwable);
                    }
                    return Flux.from((Publisher)connection.rollbackTransaction()).hasElements().onErrorResume(rollbackError -> {
                        if (rollbackError != throwable && LOG.isWarnEnabled()) {
                            LOG.warn("Error occurred during transaction rollback: " + rollbackError.getMessage(), rollbackError);
                        }
                        return Mono.error((Throwable)throwable);
                    }).doFinally(sig -> status.completed = true);
                }, b -> this.doCommit(status));
            });
        });
    }

    private Publisher<Void> doCommit(DefaultReactiveTransactionStatus status) {
        if (status.isRollbackOnly()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Rolling back transaction on DataSource {}.", (Object)this.dataSourceName);
            }
            return Flux.from((Publisher)status.getConnection().rollbackTransaction()).doFinally(sig -> status.completed = true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Committing transaction for DataSource {}.", (Object)this.dataSourceName);
        }
        return Flux.from((Publisher)status.getConnection().commitTransaction()).doFinally(sig -> status.completed = true);
    }

    private static <R> Mono<R> toSingleResult(Flux<R> flux) {
        return flux.collectList().flatMap(result -> {
            if (result.isEmpty()) {
                return Mono.empty();
            }
            if (result.size() > 1) {
                return Mono.error((Throwable)new NonUniqueResultException());
            }
            return Mono.just(result.get(0));
        });
    }

    public boolean isSupportsBatchInsert(R2dbcOperationContext context, RuntimePersistentEntity<?> persistentEntity) {
        return this.isSupportsBatchInsert((PersistentEntity)persistentEntity, context.dialect);
    }

    private static class R2dbcConversionContextImpl
    extends AbstractConversionContext
    implements R2dbcConversionContext {
        private final Connection connection;

        public R2dbcConversionContextImpl(Connection connection) {
            this(ConversionContext.DEFAULT, connection);
        }

        public R2dbcConversionContextImpl(ConversionContext conversionContext, Connection connection) {
            super(conversionContext);
            this.connection = connection;
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }
    }

    private static final class ArgumentR2dbcCC
    extends R2dbcConversionContextImpl
    implements ArgumentConversionContext<Object> {
        private final Argument argument;

        public ArgumentR2dbcCC(Connection connection, Argument argument) {
            super((ConversionContext)ConversionContext.of((Argument)argument), connection);
            this.argument = argument;
        }

        public Argument<Object> getArgument() {
            return this.argument;
        }
    }

    private static final class RuntimePersistentPropertyR2dbcCC
    extends R2dbcConversionContextImpl
    implements RuntimePersistentPropertyConversionContext {
        private final RuntimePersistentProperty<?> property;

        public RuntimePersistentPropertyR2dbcCC(Connection connection, RuntimePersistentProperty<?> property) {
            super((ConversionContext)ConversionContext.of((Argument)property.getArgument()), connection);
            this.property = property;
        }

        public RuntimePersistentProperty<?> getRuntimePersistentProperty() {
            return this.property;
        }
    }

    protected static class R2dbcOperationContext
    extends OperationContext {
        private final Connection connection;
        private final Dialect dialect;

        public R2dbcOperationContext(AnnotationMetadata annotationMetadata, Class<?> repositoryType, Dialect dialect, Connection connection) {
            super(annotationMetadata, repositoryType);
            this.dialect = dialect;
            this.connection = connection;
        }
    }

    private final class R2dbcEntitiesOperations<T>
    extends AbstractReactiveEntitiesOperations<R2dbcOperationContext, T, RuntimeException> {
        private final DBOperation dbOperation;

        private R2dbcEntitiesOperations(R2dbcOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities, DBOperation dbOperation) {
            this(ctx, dbOperation, persistentEntity, entities, false);
        }

        private R2dbcEntitiesOperations(R2dbcOperationContext ctx, DBOperation dbOperation, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities, boolean insert) {
            super((OperationContext)ctx, DefaultR2dbcRepositoryOperations.this.cascadeOperations, (ConversionService)DefaultR2dbcRepositoryOperations.this.conversionService, DefaultR2dbcRepositoryOperations.this.entityEventRegistry, persistentEntity, entities, insert);
            this.dbOperation = dbOperation;
        }

        protected void collectAutoPopulatedPreviousValues() {
            this.entities = this.entities.map(d -> {
                if (d.vetoed) {
                    return d;
                }
                d.previousValues = this.dbOperation.collectAutoPopulatedPreviousValues(this.persistentEntity, d.entity);
                return d;
            });
        }

        private void setParameters(OpContext<Connection, Statement> context, Connection connection, Statement stmt, DBOperation dbOperation) {
            AtomicBoolean isFirst = new AtomicBoolean(true);
            this.entities = this.entities.map(d -> {
                if (d.vetoed) {
                    return d;
                }
                if (isFirst.get()) {
                    isFirst.set(false);
                } else {
                    stmt.add();
                }
                dbOperation.setParameters(context, (Object)connection, (Object)stmt, this.persistentEntity, d.entity, d.previousValues);
                return d;
            });
        }

        protected void execute() throws RuntimeException {
            Statement statement = this.hasGeneratedId ? ((R2dbcOperationContext)this.ctx).connection.createStatement(this.dbOperation.getQuery()).returnGeneratedValues(new String[]{this.persistentEntity.getIdentity().getPersistedName()}) : ((R2dbcOperationContext)this.ctx).connection.createStatement(this.dbOperation.getQuery());
            this.setParameters((OpContext<Connection, Statement>)DefaultR2dbcRepositoryOperations.this, ((R2dbcOperationContext)this.ctx).connection, statement, this.dbOperation);
            if (this.hasGeneratedId) {
                this.entities = this.entities.collectList().flatMapMany(e -> {
                    List notVetoedEntities = e.stream().filter(arg_0 -> ((R2dbcEntitiesOperations)this).notVetoed(arg_0)).collect(Collectors.toList());
                    if (notVetoedEntities.isEmpty()) {
                        return Flux.fromIterable(notVetoedEntities);
                    }
                    Mono ids = Flux.from((Publisher)statement.execute()).flatMap(result -> Flux.from((Publisher)result.map((row, rowMetadata) -> DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic(row, (Object)0, this.persistentEntity.getIdentity().getDataType())))).collectList();
                    return ids.flatMapMany(idList -> {
                        Iterator iterator = idList.iterator();
                        ListIterator resultIterator = notVetoedEntities.listIterator();
                        RuntimePersistentProperty identity = this.persistentEntity.getIdentity();
                        while (resultIterator.hasNext()) {
                            AbstractReactiveEntitiesOperations.Data d = (AbstractReactiveEntitiesOperations.Data)resultIterator.next();
                            if (!iterator.hasNext()) {
                                throw new DataAccessException("Failed to generate ID for entity: " + d.entity);
                            }
                            Object id = iterator.next();
                            d.entity = this.updateEntityId(identity.getProperty(), d.entity, id);
                        }
                        return Flux.fromIterable((Iterable)e);
                    });
                });
            } else {
                Mono entitiesWithRowsUpdated = this.entities.collectList().flatMap(e -> {
                    List notVetoedEntities = e.stream().filter(arg_0 -> ((R2dbcEntitiesOperations)this).notVetoed(arg_0)).collect(Collectors.toList());
                    if (notVetoedEntities.isEmpty()) {
                        return Mono.just((Object)Tuples.of((Object)e, (Object)0L));
                    }
                    return Flux.from((Publisher)statement.execute()).flatMap(result -> Flux.from((Publisher)result.getRowsUpdated())).map(ru -> ru.longValue()).reduce((Object)0L, Long::sum).map(rowsUpdated -> {
                        if (this.dbOperation.isOptimisticLock()) {
                            this.checkOptimisticLocking(notVetoedEntities.size(), (long)rowsUpdated);
                        }
                        return Tuples.of((Object)e, (Object)rowsUpdated);
                    });
                }).cache();
                this.entities = entitiesWithRowsUpdated.flatMapMany(t -> Flux.fromIterable((Iterable)((Iterable)t.getT1())));
                this.rowsUpdated = entitiesWithRowsUpdated.map(Tuple2::getT2);
            }
        }
    }

    private final class R2dbcEntityOperations<T>
    extends AbstractReactiveEntityOperations<R2dbcOperationContext, T, RuntimeException> {
        private final DBOperation dbOperation;

        private R2dbcEntityOperations(R2dbcOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, T entity, DBOperation dbOperation) {
            this(ctx, dbOperation, persistentEntity, entity, false);
        }

        private R2dbcEntityOperations(R2dbcOperationContext ctx, DBOperation dbOperation, RuntimePersistentEntity<T> persistentEntity, T entity, boolean insert) {
            super((OperationContext)ctx, DefaultR2dbcRepositoryOperations.this.cascadeOperations, (ConversionService)DefaultR2dbcRepositoryOperations.this.conversionService, DefaultR2dbcRepositoryOperations.this.entityEventRegistry, persistentEntity, entity, insert);
            this.dbOperation = dbOperation;
        }

        protected void collectAutoPopulatedPreviousValues() {
            this.data = this.data.map(d -> {
                if (d.vetoed) {
                    return d;
                }
                d.previousValues = this.dbOperation.collectAutoPopulatedPreviousValues(this.persistentEntity, d.entity);
                return d;
            });
        }

        private Statement prepare(Connection connection) throws RuntimeException {
            if (StoredSqlOperation.class.isInstance(this.dbOperation)) {
                this.data = this.data.map(d -> {
                    if (d.vetoed) {
                        return d;
                    }
                    ((StoredSqlOperation)this.dbOperation).checkForParameterToBeExpanded(this.persistentEntity, d.entity);
                    return d;
                });
            }
            Statement statement = connection.createStatement(this.dbOperation.getQuery());
            if (this.hasGeneratedId) {
                return statement.returnGeneratedValues(new String[]{this.persistentEntity.getIdentity().getPersistedName()});
            }
            return statement;
        }

        private void setParameters(OpContext<Connection, Statement> context, Connection connection, Statement stmt, DBOperation sqlOperation) {
            this.data = this.data.map(d -> {
                if (d.vetoed) {
                    return d;
                }
                sqlOperation.setParameters(context, (Object)connection, (Object)stmt, this.persistentEntity, d.entity, d.previousValues);
                return d;
            });
        }

        protected void execute() throws RuntimeException {
            Statement statement = this.prepare(((R2dbcOperationContext)this.ctx).connection);
            this.setParameters((OpContext<Connection, Statement>)DefaultR2dbcRepositoryOperations.this, ((R2dbcOperationContext)this.ctx).connection, statement, this.dbOperation);
            this.data = this.hasGeneratedId ? this.data.flatMap(d -> {
                if (d.vetoed) {
                    return Mono.just((Object)d);
                }
                RuntimePersistentProperty identity = this.persistentEntity.getIdentity();
                return ((Mono)Flux.from((Publisher)statement.execute()).flatMap(result -> Flux.from((Publisher)result.map((row, rowMetadata) -> DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic(row, (Object)0, identity.getDataType())))).as(x$0 -> DefaultR2dbcRepositoryOperations.toSingleResult(x$0))).map(id -> {
                    BeanProperty property = identity.getProperty();
                    d.entity = this.updateEntityId(property, d.entity, id);
                    return d;
                });
            }) : this.data.flatMap(d -> {
                if (d.vetoed) {
                    return Mono.just((Object)d);
                }
                return ((Mono)Flux.from((Publisher)statement.execute()).flatMap(r -> Flux.from((Publisher)r.getRowsUpdated())).as(x$0 -> DefaultR2dbcRepositoryOperations.toSingleResult(x$0))).map(rowsUpdated -> {
                    d.rowsUpdated = rowsUpdated.longValue();
                    return d;
                });
            });
            if (this.dbOperation.isOptimisticLock()) {
                this.data = this.data.map(d -> {
                    this.checkOptimisticLocking(1L, d.rowsUpdated);
                    return d;
                });
            }
        }
    }

    private final class DefaultR2dbcReactiveRepositoryOperations
    implements ReactorReactiveRepositoryOperations {
        private DefaultR2dbcReactiveRepositoryOperations() {
        }

        public <T> Mono<Boolean> exists(@NonNull PreparedQuery<T, Boolean> preparedQuery) {
            return Flux.from(this.withNewOrExistingTransaction(preparedQuery, false, status -> {
                Statement statement = (Statement)DefaultR2dbcRepositoryOperations.this.prepareStatement(status.getConnection(), sql -> ((Connection)status.getConnection()).createStatement(sql), preparedQuery, false, true);
                return Flux.from((Publisher)statement.execute()).flatMap(r -> Flux.from((Publisher)r.map((row, metadata) -> true)));
            })).collectList().map(results -> !results.isEmpty()).defaultIfEmpty((Object)false);
        }

        @NonNull
        public <T, R> Mono<R> findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
            return (Mono)Flux.from(this.withNewOrExistingTransaction(preparedQuery, false, status -> {
                Statement statement = (Statement)DefaultR2dbcRepositoryOperations.this.prepareStatement(status.getConnection(), sql -> ((Connection)status.getConnection()).createStatement(sql), preparedQuery, false, true);
                return Flux.from((Publisher)statement.execute()).flatMap(r -> {
                    if (preparedQuery.getResultDataType() == DataType.ENTITY) {
                        Class resultType = preparedQuery.getResultType();
                        RuntimePersistentEntity persistentEntity = DefaultR2dbcRepositoryOperations.this.getEntity(resultType);
                        SqlResultEntityTypeMapper mapper = new SqlResultEntityTypeMapper(persistentEntity, DefaultR2dbcRepositoryOperations.this.columnNameResultSetReader, preparedQuery.getJoinFetchPaths(), DefaultR2dbcRepositoryOperations.this.jsonCodec, (loadedEntity, o) -> {
                            if (loadedEntity.hasPostLoadEventListeners()) {
                                return DefaultR2dbcRepositoryOperations.this.triggerPostLoad(o, loadedEntity, preparedQuery.getAnnotationMetadata());
                            }
                            return o;
                        }, DefaultR2dbcRepositoryOperations.this.conversionService);
                        SqlResultEntityTypeMapper.PushingMapper rowsMapper = mapper.readOneWithJoins();
                        return Flux.from((Publisher)r.map((row, metadata) -> {
                            rowsMapper.processRow(row);
                            return "";
                        })).collectList().flatMap(ignore -> Mono.justOrEmpty((Object)rowsMapper.getResult()));
                    }
                    Class resultType = preparedQuery.getResultType();
                    if (preparedQuery.isDtoProjection()) {
                        return Flux.from((Publisher)r.map((row, metadata) -> {
                            DTOMapper introspectedDataMapper = new DTOMapper(DefaultR2dbcRepositoryOperations.this.getEntity(preparedQuery.getRootEntity()), DefaultR2dbcRepositoryOperations.this.columnNameResultSetReader, DefaultR2dbcRepositoryOperations.this.jsonCodec, DefaultR2dbcRepositoryOperations.this.conversionService);
                            return introspectedDataMapper.map(row, resultType);
                        }));
                    }
                    return Flux.from((Publisher)r.map((row, metadata) -> {
                        Object v = DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic(row, (Object)0, preparedQuery.getResultDataType());
                        if (v == null) {
                            return Flux.empty();
                        }
                        if (resultType.isInstance(v)) {
                            return Flux.just((Object)v);
                        }
                        return Flux.just((Object)DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.convertRequired(v, resultType));
                    })).flatMap(m -> m);
                });
            })).as(x$0 -> DefaultR2dbcRepositoryOperations.toSingleResult(x$0));
        }

        @NonNull
        public <T, R> Flux<R> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
            return Flux.from(this.withNewOrExistingTransaction(preparedQuery, false, status -> {
                Statement statement = (Statement)DefaultR2dbcRepositoryOperations.this.prepareStatement(status.getConnection(), sql -> ((Connection)status.getConnection()).createStatement(sql), preparedQuery, false, false);
                Class resultType = preparedQuery.getResultType();
                boolean dtoProjection = preparedQuery.isDtoProjection();
                boolean isEntity = preparedQuery.getResultDataType() == DataType.ENTITY;
                return Flux.from((Publisher)statement.execute()).flatMap(r -> {
                    if (isEntity || dtoProjection) {
                        SqlDTOMapper mapper;
                        RuntimePersistentEntity persistentEntity = DefaultR2dbcRepositoryOperations.this.getEntity(preparedQuery.getRootEntity());
                        if (dtoProjection) {
                            boolean isRawQuery = preparedQuery.getAnnotationMetadata().stringValue(Query.class, "rawQuery").isPresent();
                            mapper = new SqlDTOMapper(persistentEntity, isRawQuery ? DefaultR2dbcRepositoryOperations.this.getEntity(preparedQuery.getResultType()) : persistentEntity, DefaultR2dbcRepositoryOperations.this.columnNameResultSetReader, DefaultR2dbcRepositoryOperations.this.jsonCodec, DefaultR2dbcRepositoryOperations.this.conversionService);
                        } else {
                            Set joinFetchPaths = preparedQuery.getJoinFetchPaths();
                            SqlResultEntityTypeMapper entityTypeMapper = new SqlResultEntityTypeMapper(DefaultR2dbcRepositoryOperations.this.getEntity(resultType), DefaultR2dbcRepositoryOperations.this.columnNameResultSetReader, joinFetchPaths, DefaultR2dbcRepositoryOperations.this.jsonCodec, (loadedEntity, o) -> {
                                if (loadedEntity.hasPostLoadEventListeners()) {
                                    return DefaultR2dbcRepositoryOperations.this.triggerPostLoad(o, loadedEntity, preparedQuery.getAnnotationMetadata());
                                }
                                return o;
                            }, DefaultR2dbcRepositoryOperations.this.conversionService);
                            boolean onlySingleEndedJoins = DefaultR2dbcRepositoryOperations.this.isOnlySingleEndedJoins(persistentEntity, joinFetchPaths);
                            if (!onlySingleEndedJoins) {
                                SqlResultEntityTypeMapper.PushingMapper manyReader = entityTypeMapper.readAllWithJoins();
                                return Flux.from((Publisher)r.map((row, rowMetadata) -> {
                                    manyReader.processRow(row);
                                    return "";
                                })).collectList().flatMapIterable(ignore -> (List)manyReader.getResult());
                            }
                            mapper = entityTypeMapper;
                        }
                        return Flux.from((Publisher)r.map((arg_0, arg_1) -> DefaultR2dbcReactiveRepositoryOperations.lambda$null$19((TypeMapper)mapper, resultType, arg_0, arg_1)));
                    }
                    return Flux.from((Publisher)r.map((row, rowMetadata) -> {
                        Object v = DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic(row, (Object)0, preparedQuery.getResultDataType());
                        if (v == null) {
                            return Mono.empty();
                        }
                        if (resultType.isInstance(v)) {
                            return Mono.just((Object)v);
                        }
                        Object converted = DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.convertRequired(v, resultType);
                        if (converted != null) {
                            return Mono.just((Object)converted);
                        }
                        return Mono.empty();
                    })).flatMap(m -> m);
                });
            }));
        }

        @NonNull
        public Mono<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
            return (Mono)Flux.from(this.withNewOrExistingTransaction(preparedQuery, true, status -> {
                Statement statement = (Statement)DefaultR2dbcRepositoryOperations.this.prepareStatement(status.getConnection(), sql -> ((Connection)status.getConnection()).createStatement(sql), preparedQuery, true, true);
                return Flux.from((Publisher)statement.execute()).flatMap(result -> Flux.from((Publisher)result.getRowsUpdated()).flatMap(rowsUpdated -> {
                    Argument argument;
                    if (QUERY_LOG.isTraceEnabled()) {
                        QUERY_LOG.trace("Update operation updated {} records", rowsUpdated);
                    }
                    if (preparedQuery.isOptimisticLock()) {
                        DefaultR2dbcRepositoryOperations.this.checkOptimisticLocking(1, rowsUpdated);
                    }
                    if ((argument = (Argument)preparedQuery.getResultArgument().getFirstTypeVariable().orElse(null)) != null) {
                        if (argument.isVoid() || argument.getType() == Void.class) {
                            return Mono.empty();
                        }
                        if (argument.getType().isInstance(rowsUpdated)) {
                            return Mono.just((Object)rowsUpdated);
                        }
                        return Mono.just((Object)((Number)DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.convertRequired(rowsUpdated, argument)));
                    }
                    return Mono.just((Object)rowsUpdated);
                }));
            })).as(x$0 -> DefaultR2dbcRepositoryOperations.toSingleResult(x$0));
        }

        @NonNull
        public Mono<Number> executeDelete(@NonNull PreparedQuery<?, Number> preparedQuery) {
            return this.executeUpdate(preparedQuery);
        }

        @NonNull
        public <T> Mono<Number> delete(@NonNull DeleteOperation<T> operation) {
            SqlQueryBuilder queryBuilder = DefaultR2dbcRepositoryOperations.this.queryBuilders.getOrDefault(operation.getRepositoryType(), DEFAULT_SQL_BUILDER);
            return (Mono)Flux.from(this.withNewOrExistingTransaction((EntityOperation<T>)operation, true, (ReactiveTransactionOperations.TransactionalCallback)status -> {
                R2dbcOperationContext ctx = new R2dbcOperationContext(operation.getAnnotationMetadata(), operation.getRepositoryType(), queryBuilder.dialect(), (Connection)status.getConnection());
                StoredQuerySqlOperation dbOperation = new StoredQuerySqlOperation(queryBuilder, operation.getStoredQuery());
                R2dbcEntityOperations op = new R2dbcEntityOperations(ctx, DefaultR2dbcRepositoryOperations.this.getEntity(operation.getRootEntity()), operation.getEntity(), (DBOperation)dbOperation);
                op.delete();
                return op.getRowsUpdated();
            })).as(x$0 -> DefaultR2dbcRepositoryOperations.toSingleResult(x$0));
        }

        @NonNull
        public <T> Flux<T> persistAll(@NonNull InsertBatchOperation<T> operation) {
            return Flux.from(this.withNewOrExistingTransaction((EntityOperation<T>)operation, true, (ReactiveTransactionOperations.TransactionalCallback)status -> {
                AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
                Class repositoryType = operation.getRepositoryType();
                SqlQueryBuilder queryBuilder = DefaultR2dbcRepositoryOperations.this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER);
                StoredQuerySqlOperation dbOperation = new StoredQuerySqlOperation(queryBuilder, operation.getStoredQuery());
                RuntimePersistentEntity persistentEntity = DefaultR2dbcRepositoryOperations.this.getEntity(operation.getRootEntity());
                R2dbcOperationContext ctx = new R2dbcOperationContext(annotationMetadata, repositoryType, queryBuilder.dialect(), (Connection)status.getConnection());
                if (!DefaultR2dbcRepositoryOperations.this.isSupportsBatchInsert((PersistentEntity)persistentEntity, queryBuilder.dialect())) {
                    return DefaultR2dbcRepositoryOperations.this.concatMono(operation.split().stream().map(arg_0 -> this.lambda$null$31(ctx, (DBOperation)dbOperation, persistentEntity, arg_0)));
                }
                R2dbcEntitiesOperations op = new R2dbcEntitiesOperations(ctx, (DBOperation)dbOperation, persistentEntity, (Iterable)operation, true);
                op.persist();
                return op.getEntities();
            }));
        }

        @NonNull
        public <T, R> Mono<R> findOptional(@NonNull PreparedQuery<T, R> preparedQuery) {
            return this.findOne(preparedQuery);
        }

        @NonNull
        public <T> Mono<T> persist(@NonNull InsertOperation<T> operation) {
            AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
            SqlQueryBuilder queryBuilder = DefaultR2dbcRepositoryOperations.this.queryBuilders.getOrDefault(operation.getRepositoryType(), DEFAULT_SQL_BUILDER);
            StoredQuerySqlOperation dbOperation = new StoredQuerySqlOperation(queryBuilder, operation.getStoredQuery());
            return (Mono)Flux.from(this.withNewOrExistingTransaction((EntityOperation<T>)operation, true, (ReactiveTransactionOperations.TransactionalCallback)arg_0 -> this.lambda$persist$33(annotationMetadata, operation, queryBuilder, (StoredSqlOperation)dbOperation, arg_0))).as(x$0 -> DefaultR2dbcRepositoryOperations.toSingleResult(x$0));
        }

        @NonNull
        public <T> Mono<T> update(@NonNull UpdateOperation<T> operation) {
            AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
            SqlQueryBuilder queryBuilder = DefaultR2dbcRepositoryOperations.this.queryBuilders.getOrDefault(operation.getRepositoryType(), DEFAULT_SQL_BUILDER);
            StoredQuerySqlOperation dbOperation = new StoredQuerySqlOperation(queryBuilder, operation.getStoredQuery());
            return (Mono)Flux.from(this.withNewOrExistingTransaction((EntityOperation<T>)operation, true, (ReactiveTransactionOperations.TransactionalCallback)arg_0 -> this.lambda$update$35(annotationMetadata, operation, queryBuilder, (StoredSqlOperation)dbOperation, arg_0))).as(x$0 -> DefaultR2dbcRepositoryOperations.toSingleResult(x$0));
        }

        @NonNull
        private TransactionDefinition newTransactionDefinition(AttributeHolder attributeHolder) {
            return attributeHolder.getAttribute((CharSequence)"io.micronaut.tx.ATTRIBUTE", TransactionDefinition.class).orElseGet(() -> {
                AnnotationValue annotation;
                if (attributeHolder instanceof AnnotationMetadataProvider && (annotation = ((AnnotationMetadataProvider)attributeHolder).getAnnotationMetadata().getAnnotation(TransactionalAdvice.class)) != null) {
                    DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
                    attribute.setReadOnly(annotation.isTrue("readOnly"));
                    annotation.intValue("timeout").ifPresent(value -> attribute.setTimeout(Duration.ofSeconds(value)));
                    Class[] noRollbackFors = annotation.classValues("noRollbackFor");
                    attribute.setNoRollbackFor(noRollbackFors);
                    annotation.enumValue("propagation", TransactionDefinition.Propagation.class).ifPresent(arg_0 -> ((DefaultTransactionAttribute)attribute).setPropagationBehavior(arg_0));
                    annotation.enumValue("isolation", TransactionDefinition.Isolation.class).ifPresent(arg_0 -> ((DefaultTransactionAttribute)attribute).setIsolationLevel(arg_0));
                    return attribute;
                }
                return TransactionDefinition.DEFAULT;
            });
        }

        private <T, R> Publisher<R> withNewOrExistingTransaction(@NonNull EntityOperation<T> operation, boolean isWrite, ReactiveTransactionOperations.TransactionalCallback<Connection, R> entityOperation) {
            ReactiveTransactionStatus connection = operation.getParameterInRole("tx-status", ReactiveTransactionStatus.class).orElse(null);
            if (connection != null) {
                try {
                    return entityOperation.doInTransaction(connection);
                }
                catch (Exception e) {
                    return Mono.error((Throwable)e);
                }
            }
            return this.withNewOrExistingTxAttribute((AttributeHolder)operation, entityOperation, isWrite);
        }

        private <T, R> Publisher<R> withNewOrExistingTransaction(@NonNull PreparedQuery<T, R> operation, boolean isWrite, ReactiveTransactionOperations.TransactionalCallback<Connection, R> entityOperation) {
            ReactiveTransactionStatus connection = operation.getParameterInRole("tx-status", ReactiveTransactionStatus.class).orElse(null);
            if (connection != null) {
                try {
                    return entityOperation.doInTransaction(connection);
                }
                catch (Exception e) {
                    return Mono.error((Throwable)new TransactionSystemException("Error invoking doInTransaction handler: " + e.getMessage(), (Throwable)e));
                }
            }
            return this.withNewOrExistingTxAttribute((AttributeHolder)operation, entityOperation, isWrite);
        }

        private <R> Publisher<R> withNewOrExistingTxAttribute(@NonNull AttributeHolder attributeHolder, ReactiveTransactionOperations.TransactionalCallback<Connection, R> entityOperation, boolean isWrite) {
            TransactionDefinition definition = this.newTransactionDefinition(attributeHolder);
            if (isWrite && definition.isReadOnly()) {
                return Mono.error((Throwable)new TransactionUsageException("Cannot perform write operation with read-only transaction"));
            }
            return DefaultR2dbcRepositoryOperations.this.withTransaction(definition, entityOperation);
        }

        @NonNull
        public <T> Mono<Number> deleteAll(DeleteBatchOperation<T> operation) {
            return (Mono)Flux.from(this.withNewOrExistingTransaction((EntityOperation<T>)operation, true, (ReactiveTransactionOperations.TransactionalCallback)status -> {
                SqlQueryBuilder queryBuilder = DefaultR2dbcRepositoryOperations.this.queryBuilders.getOrDefault(operation.getRepositoryType(), DEFAULT_SQL_BUILDER);
                RuntimePersistentEntity persistentEntity = DefaultR2dbcRepositoryOperations.this.getEntity(operation.getRootEntity());
                R2dbcOperationContext ctx = new R2dbcOperationContext(operation.getAnnotationMetadata(), operation.getRepositoryType(), queryBuilder.dialect(), (Connection)status.getConnection());
                if (DefaultR2dbcRepositoryOperations.this.isSupportsBatchDelete((PersistentEntity)persistentEntity, queryBuilder.dialect())) {
                    StoredQuerySqlOperation dbOperation = new StoredQuerySqlOperation(queryBuilder, operation.getStoredQuery());
                    R2dbcEntitiesOperations op = new R2dbcEntitiesOperations(ctx, persistentEntity, (Iterable)operation, (DBOperation)dbOperation);
                    op.delete();
                    return op.getRowsUpdated();
                }
                return DefaultR2dbcRepositoryOperations.this.sum(operation.split().stream().map(deleteOp -> {
                    StoredQuerySqlOperation dbOperation = new StoredQuerySqlOperation(queryBuilder, operation.getStoredQuery());
                    R2dbcEntityOperations op = new R2dbcEntityOperations(ctx, persistentEntity, deleteOp.getEntity(), (DBOperation)dbOperation);
                    op.delete();
                    return op.getRowsUpdated();
                }));
            })).as(x$0 -> DefaultR2dbcRepositoryOperations.toSingleResult(x$0));
        }

        @NonNull
        public <T> Flux<T> updateAll(@NonNull UpdateBatchOperation<T> operation) {
            return Flux.from(this.withNewOrExistingTransaction((EntityOperation<T>)operation, true, (ReactiveTransactionOperations.TransactionalCallback)status -> {
                Class repositoryType = operation.getRepositoryType();
                SqlQueryBuilder queryBuilder = DefaultR2dbcRepositoryOperations.this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER);
                R2dbcOperationContext ctx = new R2dbcOperationContext(operation.getAnnotationMetadata(), operation.getRepositoryType(), queryBuilder.dialect(), (Connection)status.getConnection());
                RuntimePersistentEntity persistentEntity = DefaultR2dbcRepositoryOperations.this.getEntity(operation.getRootEntity());
                StoredQuerySqlOperation dbOperation = new StoredQuerySqlOperation(queryBuilder, operation.getStoredQuery());
                if (!DefaultR2dbcRepositoryOperations.this.isSupportsBatchUpdate((PersistentEntity)persistentEntity, queryBuilder.dialect())) {
                    return DefaultR2dbcRepositoryOperations.this.concatMono(operation.split().stream().map(arg_0 -> this.lambda$null$42(ctx, persistentEntity, (StoredSqlOperation)dbOperation, arg_0)));
                }
                R2dbcEntitiesOperations op = new R2dbcEntitiesOperations(ctx, persistentEntity, (Iterable)operation, (DBOperation)dbOperation);
                op.update();
                return op.getEntities();
            }));
        }

        @NonNull
        public <T> Mono<T> findOptional(@NonNull Class<T> type, @NonNull Serializable id) {
            throw new UnsupportedOperationException("The findOptional method by ID is not supported. Execute the SQL query directly");
        }

        @NonNull
        public <R> Mono<Page<R>> findPage(@NonNull PagedQuery<R> pagedQuery) {
            throw new UnsupportedOperationException("The findPage method is not supported. Execute the SQL query directly");
        }

        @NonNull
        public <T> Mono<T> findOne(@NonNull Class<T> type, @NonNull Serializable id) {
            throw new UnsupportedOperationException("The findOne method by ID is not supported. Execute the SQL query directly");
        }

        @NonNull
        public <T> Mono<Long> count(PagedQuery<T> pagedQuery) {
            throw new UnsupportedOperationException("The count method without an explicit query is not supported. Use findAll(PreparedQuery) instead");
        }

        @NonNull
        public <T> Flux<T> findAll(PagedQuery<T> pagedQuery) {
            throw new UnsupportedOperationException("The findAll method without an explicit query is not supported. Use findAll(PreparedQuery) instead");
        }

        private /* synthetic */ Mono lambda$null$42(R2dbcOperationContext ctx, RuntimePersistentEntity persistentEntity, StoredSqlOperation dbOperation, UpdateOperation updateOp) {
            R2dbcEntityOperations op = new R2dbcEntityOperations(ctx, persistentEntity, updateOp.getEntity(), (DBOperation)dbOperation);
            op.update();
            return op.getEntity();
        }

        private /* synthetic */ Publisher lambda$update$35(AnnotationMetadata annotationMetadata, UpdateOperation operation, SqlQueryBuilder queryBuilder, StoredSqlOperation dbOperation, ReactiveTransactionStatus status) throws Exception {
            R2dbcOperationContext ctx = new R2dbcOperationContext(annotationMetadata, operation.getRepositoryType(), queryBuilder.dialect(), (Connection)status.getConnection());
            R2dbcEntityOperations op = new R2dbcEntityOperations(ctx, DefaultR2dbcRepositoryOperations.this.getEntity(operation.getRootEntity()), operation.getEntity(), (DBOperation)dbOperation);
            op.update();
            return op.getEntity();
        }

        private /* synthetic */ Publisher lambda$persist$33(AnnotationMetadata annotationMetadata, InsertOperation operation, SqlQueryBuilder queryBuilder, StoredSqlOperation dbOperation, ReactiveTransactionStatus status) throws Exception {
            R2dbcOperationContext ctx = new R2dbcOperationContext(annotationMetadata, operation.getRepositoryType(), queryBuilder.dialect(), (Connection)status.getConnection());
            R2dbcEntityOperations op = new R2dbcEntityOperations(ctx, (DBOperation)dbOperation, DefaultR2dbcRepositoryOperations.this.getEntity(operation.getRootEntity()), operation.getEntity(), true);
            op.persist();
            return op.getEntity();
        }

        private /* synthetic */ Mono lambda$null$31(R2dbcOperationContext ctx, DBOperation dbOperation, RuntimePersistentEntity persistentEntity, InsertOperation persistOp) {
            R2dbcEntityOperations op = new R2dbcEntityOperations(ctx, dbOperation, persistentEntity, persistOp.getEntity(), true);
            op.persist();
            return op.getEntity();
        }

        private static /* synthetic */ Object lambda$null$19(TypeMapper mapper, Class resultType, Row row, RowMetadata rowMetadata) {
            return mapper.map((Object)row, resultType);
        }
    }

    private static final class DefaultReactiveTransactionStatus
    implements ReactiveTransactionStatus<Connection> {
        private final Connection connection;
        private final boolean isNew;
        private boolean rollbackOnly;
        private boolean completed;

        public DefaultReactiveTransactionStatus(Connection connection, boolean isNew) {
            this.connection = connection;
            this.isNew = isNew;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public boolean isNewTransaction() {
            return this.isNew;
        }

        public void setRollbackOnly() {
            this.rollbackOnly = true;
        }

        public boolean isRollbackOnly() {
            return this.rollbackOnly;
        }

        public boolean isCompleted() {
            return this.completed;
        }
    }
}

