/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.r2dbc.operations;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.attr.AttributeHolder;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.event.EntityEventContext;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.exceptions.NonUniqueResultException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.AttributeConverterRegistry;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.EntityOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.async.AsyncRepositoryOperations;
import io.micronaut.data.operations.reactive.ReactiveRepositoryOperations;
import io.micronaut.data.r2dbc.convert.R2dbcConversionContext;
import io.micronaut.data.r2dbc.mapper.ColumnIndexR2dbcResultReader;
import io.micronaut.data.r2dbc.mapper.ColumnNameR2dbcResultReader;
import io.micronaut.data.r2dbc.mapper.R2dbcQueryStatement;
import io.micronaut.data.r2dbc.operations.BlockingReactorRepositoryOperations;
import io.micronaut.data.r2dbc.operations.R2dbcOperations;
import io.micronaut.data.r2dbc.operations.R2dbcRepositoryOperations;
import io.micronaut.data.r2dbc.operations.ReactorReactiveRepositoryOperations;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.convert.RuntimePersistentPropertyConversionContext;
import io.micronaut.data.runtime.date.DateTimeProvider;
import io.micronaut.data.runtime.event.DefaultEntityEventContext;
import io.micronaut.data.runtime.mapper.DTOMapper;
import io.micronaut.data.runtime.mapper.QueryStatement;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.data.runtime.mapper.TypeMapper;
import io.micronaut.data.runtime.mapper.sql.SqlDTOMapper;
import io.micronaut.data.runtime.mapper.sql.SqlResultEntityTypeMapper;
import io.micronaut.data.runtime.operations.AsyncFromReactiveAsyncRepositoryOperation;
import io.micronaut.data.runtime.operations.internal.AbstractRepositoryOperations;
import io.micronaut.data.runtime.operations.internal.AbstractSqlRepositoryOperations;
import io.micronaut.data.runtime.operations.internal.DBOperation;
import io.micronaut.data.runtime.operations.internal.OpContext;
import io.micronaut.data.runtime.operations.internal.StoredQuerySqlOperation;
import io.micronaut.data.runtime.operations.internal.StoredSqlOperation;
import io.micronaut.data.runtime.support.AbstractConversionContext;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.annotation.TransactionalAdvice;
import io.micronaut.transaction.exceptions.NoTransactionException;
import io.micronaut.transaction.exceptions.TransactionSystemException;
import io.micronaut.transaction.exceptions.TransactionUsageException;
import io.micronaut.transaction.interceptor.DefaultTransactionAttribute;
import io.micronaut.transaction.reactive.ReactiveTransactionOperations;
import io.micronaut.transaction.reactive.ReactiveTransactionStatus;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import io.r2dbc.spi.Statement;
import jakarta.inject.Named;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@EachBean(value=ConnectionFactory.class)
@Internal
final class DefaultR2dbcRepositoryOperations
extends AbstractSqlRepositoryOperations<Connection, Row, Statement, RuntimeException>
implements BlockingReactorRepositoryOperations,
R2dbcRepositoryOperations,
R2dbcOperations,
ReactiveTransactionOperations<Connection> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultR2dbcRepositoryOperations.class);
    private static final AutoCloseable NOOP = () -> {};
    private final ConnectionFactory connectionFactory;
    private final ReactorReactiveRepositoryOperations reactiveOperations;
    private final String dataSourceName;
    private ExecutorService executorService;
    private AsyncRepositoryOperations asyncRepositoryOperations;

    @Internal
    protected DefaultR2dbcRepositoryOperations(@Parameter String dataSourceName, ConnectionFactory connectionFactory, List<MediaTypeCodec> mediaTypeCodecList, @NonNull DateTimeProvider<Object> dateTimeProvider, RuntimeEntityRegistry runtimeEntityRegistry, ApplicationContext applicationContext, @Nullable @Named(value="io") ExecutorService executorService, DataConversionService<?> conversionService, AttributeConverterRegistry attributeConverterRegistry) {
        super(dataSourceName, (ResultReader)new ColumnNameR2dbcResultReader(conversionService), (ResultReader)new ColumnIndexR2dbcResultReader(conversionService), (QueryStatement)new R2dbcQueryStatement(conversionService), mediaTypeCodecList, dateTimeProvider, runtimeEntityRegistry, (BeanContext)applicationContext, conversionService, attributeConverterRegistry);
        this.connectionFactory = connectionFactory;
        this.executorService = executorService;
        this.reactiveOperations = new DefaultR2dbcReactiveRepositoryOperations();
        this.dataSourceName = dataSourceName;
    }

    private <T> Mono<T> cascadeEntity(T en, RuntimePersistentEntity<T> persistentEntity, boolean isPost, Relation.Cascade cascadeType, Connection connection, Dialect dialect, AnnotationMetadata annotationMetadata, Class<?> repositoryType, List<Association> associations, Set<Object> persisted) {
        ArrayList cascadeOps = new ArrayList();
        this.cascade(dialect, annotationMetadata, repositoryType, isPost, cascadeType, AbstractRepositoryOperations.CascadeContext.of(associations, en), persistentEntity, en, cascadeOps);
        Mono entity = Mono.just(en);
        for (AbstractRepositoryOperations.CascadeOp cascadeOp : cascadeOps) {
            Mono children;
            if (cascadeOp instanceof AbstractRepositoryOperations.CascadeOneOp) {
                Mono childMono;
                Object op;
                boolean hasId;
                AbstractRepositoryOperations.CascadeOneOp cascadeOneOp = (AbstractRepositoryOperations.CascadeOneOp)cascadeOp;
                Object child = cascadeOneOp.child;
                RuntimePersistentEntity childPersistentEntity = cascadeOneOp.childPersistentEntity;
                RuntimeAssociation association = (RuntimeAssociation)cascadeOp.ctx.getAssociation();
                if (persisted.contains(child)) continue;
                boolean bl = hasId = childPersistentEntity.getIdentity().getProperty().get(child) != null;
                if (!hasId && cascadeType == Relation.Cascade.PERSIST) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cascading PERSIST for '{}' association: '{}'", (Object)persistentEntity.getName(), (Object)cascadeOp.ctx.associations);
                    }
                    op = new R2dbcEntityOperations<Object>(childPersistentEntity, child);
                    DBOperation childSqlPersistOperation = this.resolveEntityInsert(annotationMetadata, repositoryType, child.getClass(), childPersistentEntity);
                    this.persistOne(connection, cascadeOneOp.annotationMetadata, cascadeOneOp.repositoryType, childSqlPersistOperation, associations, persisted, (AbstractRepositoryOperations.EntityOperations)op);
                    entity = entity.flatMap(e -> ((R2dbcEntityOperations)op).data.map(childData -> this.afterCascadedOne(e, cascadeOp.ctx.associations, child, childData.entity)));
                    childMono = ((R2dbcEntityOperations)op).data.map(childData -> childData.entity);
                } else if (hasId && cascadeType == Relation.Cascade.UPDATE) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cascading MERGE for '{}' ({}) association: '{}'", new Object[]{persistentEntity.getName(), persistentEntity.getIdentity().getProperty().get(en), cascadeOp.ctx.associations});
                    }
                    op = new R2dbcEntityOperations<Object>(childPersistentEntity, child);
                    DBOperation childSqlUpdateOperation = this.resolveEntityUpdate(annotationMetadata, repositoryType, child.getClass(), childPersistentEntity);
                    this.updateOne(connection, cascadeOneOp.annotationMetadata, cascadeOneOp.repositoryType, childSqlUpdateOperation, associations, persisted, (AbstractRepositoryOperations.EntityOperations)op);
                    entity = entity.flatMap(e -> ((R2dbcEntityOperations)op).data.map(childData -> this.afterCascadedOne(e, cascadeOp.ctx.associations, child, childData.entity)));
                    childMono = ((R2dbcEntityOperations)op).data.map(childData -> childData.entity);
                } else {
                    childMono = Mono.just((Object)child);
                }
                if (!hasId && (cascadeType == Relation.Cascade.PERSIST || cascadeType == Relation.Cascade.UPDATE) && SqlQueryBuilder.isForeignKeyWithJoinTable((Association)association)) {
                    entity = entity.flatMap(e -> childMono.flatMap(c -> {
                        if (persisted.contains(c)) {
                            return Mono.just((Object)e);
                        }
                        persisted.add(c);
                        R2dbcEntityOperations<Object> assocEntityOp = new R2dbcEntityOperations<Object>(childPersistentEntity, c);
                        this.persistJoinTableAssociation(connection, repositoryType, dialect, (Association)association, e, (AbstractRepositoryOperations.BaseOperations)assocEntityOp);
                        return assocEntityOp.getEntity().thenReturn(e);
                    }));
                    continue;
                }
                entity = entity.flatMap(e -> childMono.map(c -> {
                    persisted.add(c);
                    return e;
                }));
                continue;
            }
            if (!(cascadeOp instanceof AbstractRepositoryOperations.CascadeManyOp)) continue;
            AbstractRepositoryOperations.CascadeManyOp cascadeManyOp = (AbstractRepositoryOperations.CascadeManyOp)cascadeOp;
            RuntimePersistentEntity childPersistentEntity = cascadeManyOp.childPersistentEntity;
            if (cascadeType == Relation.Cascade.UPDATE) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cascading UPDATE for '{}' association: '{}'", (Object)persistentEntity.getName(), (Object)cascadeOp.ctx.associations);
                }
                DBOperation childSqlUpdateOperation = null;
                DBOperation childSqlInsertOperation = null;
                Flux childrenFlux = Flux.empty();
                for (Object child : cascadeManyOp.children) {
                    if (persisted.contains(child)) continue;
                    R2dbcEntityOperations op = new R2dbcEntityOperations(childPersistentEntity, child);
                    if (childPersistentEntity.getIdentity().getProperty().get(child) == null) {
                        if (childSqlInsertOperation == null) {
                            childSqlInsertOperation = this.resolveEntityInsert(annotationMetadata, repositoryType, childPersistentEntity.getIntrospection().getBeanType(), childPersistentEntity);
                        }
                        this.persistOne(connection, cascadeManyOp.annotationMetadata, cascadeManyOp.repositoryType, childSqlInsertOperation, associations, persisted, op);
                    } else {
                        if (childSqlUpdateOperation == null) {
                            childSqlUpdateOperation = this.resolveEntityUpdate(annotationMetadata, repositoryType, childPersistentEntity.getIntrospection().getBeanType(), childPersistentEntity);
                        }
                        this.updateOne(connection, cascadeManyOp.annotationMetadata, cascadeManyOp.repositoryType, childSqlUpdateOperation, associations, persisted, op);
                    }
                    childrenFlux = childrenFlux.concatWith(op.getEntity());
                }
                children = childrenFlux.collectList();
            } else {
                if (cascadeType != Relation.Cascade.PERSIST) continue;
                DBOperation childSqlPersistOperation = this.resolveEntityInsert(annotationMetadata, repositoryType, childPersistentEntity.getIntrospection().getBeanType(), childPersistentEntity);
                if (this.isSupportsBatchInsert((PersistentEntity)persistentEntity, dialect)) {
                    R2dbcEntitiesOperations<Object> op = new R2dbcEntitiesOperations<Object>(childPersistentEntity, cascadeManyOp.children);
                    op.veto(persisted::contains);
                    RuntimePersistentProperty identity = childPersistentEntity.getIdentity();
                    op.veto(e -> identity.getProperty().get(e) != null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cascading PERSIST for '{}' association: '{}'", (Object)persistentEntity.getName(), (Object)cascadeOp.ctx.associations);
                    }
                    this.persistInBatch(connection, cascadeManyOp.annotationMetadata, cascadeManyOp.repositoryType, childSqlPersistOperation, associations, persisted, op);
                    children = op.getEntities().collectList();
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cascading PERSIST for '{}' association: '{}'", (Object)persistentEntity.getName(), (Object)cascadeOp.ctx.associations);
                    }
                    Flux childrenFlux = Flux.empty();
                    for (Object child : cascadeManyOp.children) {
                        if (persisted.contains(child) || childPersistentEntity.getIdentity().getProperty().get(child) != null) {
                            childrenFlux = childrenFlux.concatWith((Publisher)Mono.just(child));
                            continue;
                        }
                        R2dbcEntityOperations op = new R2dbcEntityOperations(childPersistentEntity, child);
                        this.persistOne(connection, cascadeManyOp.annotationMetadata, cascadeManyOp.repositoryType, childSqlPersistOperation, associations, persisted, op);
                        childrenFlux = childrenFlux.concatWith(op.getEntity());
                    }
                    children = childrenFlux.collectList();
                }
            }
            entity = entity.flatMap(e -> children.flatMap(newChildren -> {
                Object e2 = this.afterCascadedMany(e, cascadeOp.ctx.associations, cascadeManyOp.children, (List)newChildren);
                RuntimeAssociation association = (RuntimeAssociation)cascadeOp.ctx.getAssociation();
                if (SqlQueryBuilder.isForeignKeyWithJoinTable((Association)association)) {
                    if (dialect.allowBatch()) {
                        R2dbcEntitiesOperations<Object> assocEntitiesOp = new R2dbcEntitiesOperations<Object>(childPersistentEntity, (Iterable)newChildren);
                        assocEntitiesOp.veto(persisted::contains);
                        this.persistJoinTableAssociation(connection, repositoryType, dialect, (Association)association, cascadeOp.ctx.parent, (AbstractRepositoryOperations.BaseOperations)assocEntitiesOp);
                        return ((R2dbcEntitiesOperations)assocEntitiesOp).entities.collectList().thenReturn(e2);
                    }
                    Mono res = Mono.just((Object)e2);
                    for (Object child : newChildren) {
                        if (persisted.contains(child)) continue;
                        R2dbcEntityOperations assocEntityOp = new R2dbcEntityOperations(childPersistentEntity, child);
                        this.persistJoinTableAssociation(connection, repositoryType, dialect, (Association)association, cascadeOp.ctx.parent, (AbstractRepositoryOperations.BaseOperations)assocEntityOp);
                        res = res.flatMap(e3 -> assocEntityOp.getEntity().thenReturn(e3));
                    }
                    return res;
                }
                persisted.addAll((Collection<Object>)newChildren);
                return Mono.just((Object)e2);
            }));
        }
        return entity;
    }

    protected ConversionContext createTypeConversionContext(Connection connection, RuntimePersistentProperty<?> property, Argument<?> argument) {
        Objects.requireNonNull(connection);
        if (property != null) {
            return new RuntimePersistentPropertyR2dbcCC(connection, property);
        }
        if (argument != null) {
            return new ArgumentR2dbcCC(connection, argument);
        }
        return new R2dbcConversionContextImpl(connection);
    }

    protected AutoCloseable autoCloseable(Statement statement) {
        return NOOP;
    }

    protected void prepareStatement(Connection connection, Dialect dialect, PersistentProperty identity, boolean hasGeneratedID, String insertSql, AbstractRepositoryOperations.DBOperation1<Statement, RuntimeException> fn) {
        Statement statement = connection.createStatement(insertSql);
        if (hasGeneratedID) {
            statement.returnGeneratedValues(new String[]{identity.getPersistedName()});
        }
        fn.process((Object)statement);
    }

    private Mono<Integer> sum(Stream<Mono<Integer>> stream) {
        return stream.reduce((m1, m2) -> m1.zipWith(m2).map(t -> (Integer)t.getT1() + (Integer)t.getT2())).orElse((Mono<Integer>)Mono.empty());
    }

    private <T> Flux<T> concatMono(Stream<Mono<T>> stream) {
        return Flux.concat((Iterable)stream.collect(Collectors.toList()));
    }

    public int shiftIndex(int i) {
        return i;
    }

    @Override
    @NonNull
    public ReactorReactiveRepositoryOperations reactive() {
        return this.reactiveOperations;
    }

    @NonNull
    public AsyncRepositoryOperations async() {
        if (this.asyncRepositoryOperations == null) {
            if (this.executorService == null) {
                this.executorService = Executors.newCachedThreadPool();
            }
            this.asyncRepositoryOperations = new AsyncFromReactiveAsyncRepositoryOperation((ReactiveRepositoryOperations)this.reactiveOperations, (Executor)this.executorService);
        }
        return this.asyncRepositoryOperations;
    }

    @Override
    @NonNull
    public ConnectionFactory connectionFactory() {
        return this.connectionFactory;
    }

    @Override
    @NonNull
    public <T> Publisher<T> withConnection(@NonNull Function<Connection, Publisher<T>> handler) {
        Objects.requireNonNull(handler, "Handler cannot be null");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating a new Connection for DataSource: " + this.dataSourceName);
        }
        return Flux.usingWhen((Publisher)this.connectionFactory.create(), handler, connection -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing Connection for DataSource: " + this.dataSourceName);
            }
            return connection.close();
        });
    }

    private IsolationLevel getIsolationLevel(TransactionDefinition definition) {
        TransactionDefinition.Isolation isolationLevel = definition.getIsolationLevel();
        switch (isolationLevel) {
            case READ_COMMITTED: {
                return IsolationLevel.READ_COMMITTED;
            }
            case READ_UNCOMMITTED: {
                return IsolationLevel.READ_UNCOMMITTED;
            }
            case REPEATABLE_READ: {
                return IsolationLevel.REPEATABLE_READ;
            }
            case SERIALIZABLE: {
                return IsolationLevel.SERIALIZABLE;
            }
        }
        return null;
    }

    @Override
    @NonNull
    public <T> Publisher<T> withTransaction(@NonNull ReactiveTransactionStatus<Connection> status, @NonNull ReactiveTransactionOperations.TransactionalCallback<Connection, T> handler) {
        Objects.requireNonNull(status, "Transaction status cannot be null");
        Objects.requireNonNull(handler, "Callback handler cannot be null");
        return Flux.defer(() -> {
            try {
                return handler.doInTransaction(status);
            }
            catch (Exception e) {
                return Flux.error((Throwable)new TransactionSystemException("Error invoking doInTransaction handler: " + e.getMessage(), (Throwable)e));
            }
        }).contextWrite(context -> context.put((Object)"io.micronaut.tx.STATUS", (Object)status));
    }

    @NonNull
    public <T> Flux<T> withTransaction(@NonNull TransactionDefinition definition, @NonNull ReactiveTransactionOperations.TransactionalCallback<Connection, T> handler) {
        Objects.requireNonNull(definition, "Transaction definition cannot be null");
        Objects.requireNonNull(handler, "Callback handler cannot be null");
        return Flux.deferContextual(contextView -> {
            Object o = contextView.getOrDefault((Object)"io.micronaut.tx.STATUS", null);
            TransactionDefinition.Propagation propagationBehavior = definition.getPropagationBehavior();
            if (o instanceof ReactiveTransactionStatus) {
                if (propagationBehavior == TransactionDefinition.Propagation.NOT_SUPPORTED || propagationBehavior == TransactionDefinition.Propagation.NEVER) {
                    return Flux.error((Throwable)new TransactionUsageException("Found an existing transaction but propagation behaviour doesn't support it: " + propagationBehavior));
                }
                try {
                    return handler.doInTransaction((ReactiveTransactionStatus)o);
                }
                catch (Exception e) {
                    return Flux.error((Throwable)new TransactionSystemException("Error invoking doInTransaction handler: " + e.getMessage(), (Throwable)e));
                }
            }
            if (propagationBehavior == TransactionDefinition.Propagation.MANDATORY) {
                return Flux.error((Throwable)new NoTransactionException("Expected an existing transaction, but none was found in the Reactive context."));
            }
            return this.withConnection(connection -> {
                Mono resourceSupplier;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Transaction Begin for DataSource: {}", (Object)this.dataSourceName);
                }
                DefaultReactiveTransactionStatus status = new DefaultReactiveTransactionStatus((Connection)connection, true);
                if (definition.getIsolationLevel() != TransactionDefinition.DEFAULT.getIsolationLevel()) {
                    IsolationLevel isolationLevel = this.getIsolationLevel(definition);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Setting Isolation Level ({}) for Transaction on DataSource: {}", (Object)isolationLevel, (Object)this.dataSourceName);
                    }
                    resourceSupplier = isolationLevel != null ? Flux.from((Publisher)connection.setTransactionIsolationLevel(isolationLevel)).thenMany(connection.beginTransaction()).hasElements() : Flux.from((Publisher)connection.beginTransaction()).hasElements();
                } else {
                    resourceSupplier = Flux.from((Publisher)connection.beginTransaction()).hasElements();
                }
                return Flux.usingWhen((Publisher)resourceSupplier, b -> {
                    try {
                        return Flux.from((Publisher)handler.doInTransaction((ReactiveTransactionStatus)status)).contextWrite(context -> context.put((Object)"io.micronaut.tx.STATUS", (Object)status).put((Object)"io.micronaut.tx.ATTRIBUTE", (Object)definition));
                    }
                    catch (Exception e) {
                        return Mono.error((Throwable)new TransactionSystemException("Error invoking doInTransaction handler: " + e.getMessage(), (Throwable)e));
                    }
                }, b -> this.doCommit(status), (b, throwable) -> {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Rolling back transaction on error: " + throwable.getMessage(), throwable);
                    }
                    return Flux.from((Publisher)connection.rollbackTransaction()).hasElements().onErrorResume(rollbackError -> {
                        if (rollbackError != throwable && LOG.isWarnEnabled()) {
                            LOG.warn("Error occurred during transaction rollback: " + rollbackError.getMessage(), rollbackError);
                        }
                        return Mono.error((Throwable)throwable);
                    }).doFinally(sig -> status.completed = true);
                }, b -> this.doCommit(status));
            });
        });
    }

    private Publisher<Void> doCommit(DefaultReactiveTransactionStatus status) {
        if (status.isRollbackOnly()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Rolling back transaction on DataSource {}.", (Object)this.dataSourceName);
            }
            return Flux.from((Publisher)status.getConnection().rollbackTransaction()).doFinally(sig -> status.completed = true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Committing transaction for DataSource {}.", (Object)this.dataSourceName);
        }
        return Flux.from((Publisher)status.getConnection().commitTransaction()).doFinally(sig -> status.completed = true);
    }

    private static <R> Mono<R> toSingleResult(Flux<R> flux) {
        return flux.collectList().flatMap(result -> {
            if (result.isEmpty()) {
                return Mono.empty();
            }
            if (result.size() > 1) {
                return Mono.error((Throwable)new NonUniqueResultException());
            }
            return Mono.just(result.get(0));
        });
    }

    private static class R2dbcConversionContextImpl
    extends AbstractConversionContext
    implements R2dbcConversionContext {
        private final Connection connection;

        public R2dbcConversionContextImpl(Connection connection) {
            this(ConversionContext.DEFAULT, connection);
        }

        public R2dbcConversionContextImpl(ConversionContext conversionContext, Connection connection) {
            super(conversionContext);
            this.connection = connection;
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }
    }

    private static final class ArgumentR2dbcCC
    extends R2dbcConversionContextImpl
    implements ArgumentConversionContext<Object> {
        private final Argument argument;

        public ArgumentR2dbcCC(Connection connection, Argument argument) {
            super((ConversionContext)ConversionContext.of((Argument)argument), connection);
            this.argument = argument;
        }

        public Argument<Object> getArgument() {
            return this.argument;
        }
    }

    private static final class RuntimePersistentPropertyR2dbcCC
    extends R2dbcConversionContextImpl
    implements RuntimePersistentPropertyConversionContext {
        private final RuntimePersistentProperty<?> property;

        public RuntimePersistentPropertyR2dbcCC(Connection connection, RuntimePersistentProperty<?> property) {
            super((ConversionContext)ConversionContext.of((Argument)property.getArgument()), connection);
            this.property = property;
        }

        public RuntimePersistentProperty<?> getRuntimePersistentProperty() {
            return this.property;
        }
    }

    private final class R2dbcEntitiesOperations<T>
    extends AbstractRepositoryOperations.EntitiesOperations<T> {
        private Flux<Data> entities;
        private Mono<Integer> rowsUpdated;

        private R2dbcEntitiesOperations(RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities) {
            super((AbstractRepositoryOperations)DefaultR2dbcRepositoryOperations.this, persistentEntity);
            Objects.requireNonNull(entities, "Entities cannot be null");
            if (!entities.iterator().hasNext()) {
                throw new IllegalStateException("Entities cannot be empty");
            }
            this.entities = Flux.fromIterable(entities).map(entity -> {
                Data data = new Data();
                data.entity = entity;
                return data;
            });
        }

        protected void collectAutoPopulatedPreviousValues(DBOperation dbOperation) {
            this.entities = this.entities.map(d -> {
                if (d.vetoed) {
                    return d;
                }
                d.previousValues = dbOperation.collectAutoPopulatedPreviousValues(this.persistentEntity, d.entity);
                return d;
            });
        }

        protected Statement prepare(Connection connection, DBOperation sqlOperation) throws RuntimeException {
            return connection.createStatement(sqlOperation.getQuery());
        }

        protected void cascadePre(Relation.Cascade cascadeType, Connection connection, Dialect dialect, AnnotationMetadata annotationMetadata, Class<?> repositoryType, List<Association> associations, Set<Object> persisted) {
            this.doCascade(false, cascadeType, connection, dialect, annotationMetadata, repositoryType, associations, persisted);
        }

        protected void cascadePost(Relation.Cascade cascadeType, Connection connection, Dialect dialect, AnnotationMetadata annotationMetadata, Class<?> repositoryType, List<Association> associations, Set<Object> persisted) {
            this.doCascade(true, cascadeType, connection, dialect, annotationMetadata, repositoryType, associations, persisted);
        }

        private void doCascade(boolean isPost, Relation.Cascade cascadeType, Connection connection, Dialect dialect, AnnotationMetadata annotationMetadata, Class<?> repositoryType, List<Association> associations, Set<Object> persisted) {
            this.entities = this.entities.flatMap(d -> {
                if (d.vetoed) {
                    return Mono.just((Object)d);
                }
                Mono entity = DefaultR2dbcRepositoryOperations.this.cascadeEntity(d.entity, this.persistentEntity, isPost, cascadeType, connection, dialect, annotationMetadata, repositoryType, associations, persisted);
                return entity.map(e -> {
                    d.entity = e;
                    return d;
                });
            });
        }

        protected void veto(Predicate<T> predicate) {
            this.entities = this.entities.map(d -> {
                if (d.vetoed) {
                    return d;
                }
                d.vetoed = predicate.test(d.entity);
                return d;
            });
        }

        protected boolean triggerPre(Function<EntityEventContext<Object>, Boolean> fn) {
            this.entities = this.entities.map(d -> {
                if (d.vetoed) {
                    return d;
                }
                DefaultEntityEventContext event = new DefaultEntityEventContext(this.persistentEntity, d.entity);
                d.vetoed = (Boolean)fn.apply((EntityEventContext<Object>)event) == false;
                d.entity = event.getEntity();
                return d;
            });
            return false;
        }

        protected void triggerPost(Consumer<EntityEventContext<Object>> fn) {
            this.entities = this.entities.map(d -> {
                if (d.vetoed) {
                    return d;
                }
                DefaultEntityEventContext event = new DefaultEntityEventContext(this.persistentEntity, d.entity);
                fn.accept((EntityEventContext<Object>)event);
                d.entity = event.getEntity();
                return d;
            });
        }

        protected void setParameters(OpContext<Connection, Statement> context, Connection connection, Statement stmt, DBOperation dbOperation) {
            this.entities = this.entities.map(d -> {
                if (d.vetoed) {
                    return d;
                }
                dbOperation.setParameters(context, (Object)connection, (Object)stmt, this.persistentEntity, d.entity, d.previousValues);
                stmt.add();
                return d;
            });
        }

        protected void executeUpdate(Statement stmt) {
            this.entities = this.entities.collectList().flatMapMany(e -> {
                List notVetoedEntities = e.stream().filter(this::notVetoed).collect(Collectors.toList());
                if (notVetoedEntities.isEmpty()) {
                    return Flux.fromIterable((Iterable)e);
                }
                return Flux.from((Publisher)stmt.execute()).flatMap(result -> Flux.from((Publisher)result.getRowsUpdated())).thenMany((Publisher)Flux.fromIterable((Iterable)e));
            });
        }

        protected void executeUpdate(Statement stmt, AbstractRepositoryOperations.DBOperation2<Integer, Integer, RuntimeException> fn) {
            Mono entitiesWithRowsUpdated = this.entities.collectList().flatMap(e -> {
                List notVetoedEntities = e.stream().filter(this::notVetoed).collect(Collectors.toList());
                if (notVetoedEntities.isEmpty()) {
                    return Mono.just((Object)Tuples.of((Object)e, (Object)0));
                }
                return Flux.from((Publisher)stmt.execute()).flatMap(result -> Flux.from((Publisher)result.getRowsUpdated())).reduce((Object)0, Integer::sum).map(rowsUpdated -> {
                    fn.process((Object)notVetoedEntities.size(), rowsUpdated);
                    return Tuples.of((Object)e, (Object)rowsUpdated);
                });
            }).cache();
            this.entities = entitiesWithRowsUpdated.flatMapMany(t -> Flux.fromIterable((Iterable)((Iterable)t.getT1())));
            this.rowsUpdated = entitiesWithRowsUpdated.map(Tuple2::getT2);
        }

        protected void executeUpdateSetGeneratedId(Statement stmt) {
            this.entities = this.entities.collectList().flatMapMany(e -> {
                List notVetoedEntities = e.stream().filter(this::notVetoed).collect(Collectors.toList());
                if (notVetoedEntities.isEmpty()) {
                    return Flux.fromIterable(notVetoedEntities);
                }
                Mono ids = Flux.from((Publisher)stmt.execute()).flatMap(result -> Flux.from((Publisher)result.map((row, rowMetadata) -> DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic(row, (Object)0, this.persistentEntity.getIdentity().getDataType())))).collectList();
                return ids.flatMapMany(idList -> {
                    Iterator iterator = idList.iterator();
                    ListIterator resultIterator = notVetoedEntities.listIterator();
                    RuntimePersistentProperty identity = this.persistentEntity.getIdentity();
                    while (resultIterator.hasNext()) {
                        Data d = (Data)resultIterator.next();
                        if (!iterator.hasNext()) {
                            throw new DataAccessException("Failed to generate ID for entity: " + d.entity);
                        }
                        Object id = iterator.next();
                        d.entity = this.updateEntityId(identity.getProperty(), d.entity, id);
                    }
                    return Flux.fromIterable((Iterable)e);
                });
            });
        }

        private boolean notVetoed(Data data) {
            return !data.vetoed;
        }

        protected Flux<T> getEntities() {
            return this.entities.map(d -> d.entity);
        }

        protected Mono<Integer> getRowsUpdated() {
            return this.rowsUpdated.flatMap(rows -> this.entities.then(Mono.just((Object)rows)));
        }

        class Data {
            T entity;
            Map<QueryParameterBinding, Object> previousValues;
            boolean vetoed = false;

            Data() {
            }
        }
    }

    private final class R2dbcEntityOperations<T>
    extends AbstractRepositoryOperations.EntityOperations<T> {
        private Mono<Data> data;

        protected R2dbcEntityOperations(RuntimePersistentEntity<T> persistentEntity, T entity) {
            super((AbstractRepositoryOperations)DefaultR2dbcRepositoryOperations.this, persistentEntity);
            Data data = new Data();
            data.entity = entity;
            this.data = Mono.just((Object)data);
        }

        protected void cascadePre(Relation.Cascade cascadeType, Connection connection, Dialect dialect, AnnotationMetadata annotationMetadata, Class<?> repositoryType, List<Association> associations, Set<Object> persisted) {
            this.doCascade(false, cascadeType, connection, dialect, annotationMetadata, repositoryType, associations, persisted);
        }

        protected void cascadePost(Relation.Cascade cascadeType, Connection connection, Dialect dialect, AnnotationMetadata annotationMetadata, Class<?> repositoryType, List<Association> associations, Set<Object> persisted) {
            this.doCascade(true, cascadeType, connection, dialect, annotationMetadata, repositoryType, associations, persisted);
        }

        private void doCascade(boolean isPost, Relation.Cascade cascadeType, Connection connection, Dialect dialect, AnnotationMetadata annotationMetadata, Class<?> repositoryType, List<Association> associations, Set<Object> persisted) {
            this.data = this.data.flatMap(d -> {
                if (d.vetoed) {
                    return Mono.just((Object)d);
                }
                Mono entity = DefaultR2dbcRepositoryOperations.this.cascadeEntity(d.entity, this.persistentEntity, isPost, cascadeType, connection, dialect, annotationMetadata, repositoryType, associations, persisted);
                return entity.map(e -> {
                    d.entity = e;
                    return d;
                });
            });
        }

        protected void collectAutoPopulatedPreviousValues(DBOperation sqlOperation) {
            this.data = this.data.map(d -> {
                if (d.vetoed) {
                    return d;
                }
                d.previousValues = sqlOperation.collectAutoPopulatedPreviousValues(this.persistentEntity, d.entity);
                return d;
            });
        }

        protected Statement prepare(Connection connection, DBOperation sqlOperation) throws RuntimeException {
            if (StoredSqlOperation.class.isInstance(sqlOperation)) {
                this.data = this.data.map(d -> {
                    if (d.vetoed) {
                        return d;
                    }
                    ((StoredSqlOperation)sqlOperation).checkForParameterToBeExpanded(this.persistentEntity, d.entity);
                    return d;
                });
            }
            return connection.createStatement(sqlOperation.getQuery());
        }

        protected void setParameters(OpContext<Connection, Statement> context, Connection connection, Statement stmt, DBOperation sqlOperation) {
            this.data = this.data.map(d -> {
                if (d.vetoed) {
                    return d;
                }
                sqlOperation.setParameters(context, (Object)connection, (Object)stmt, this.persistentEntity, d.entity, d.previousValues);
                return d;
            });
        }

        protected void executeUpdate(Statement stmt, AbstractRepositoryOperations.DBOperation2<Integer, Integer, RuntimeException> fn) {
            this.data = this.data.flatMap(d -> ((Mono)Flux.from((Publisher)stmt.execute()).flatMap(result -> Flux.from((Publisher)result.getRowsUpdated())).as(x$0 -> DefaultR2dbcRepositoryOperations.toSingleResult(x$0))).map(rowsUpdated -> {
                if (d.vetoed) {
                    return d;
                }
                d.rowsUpdated = rowsUpdated;
                fn.process((Object)1, rowsUpdated);
                return d;
            }));
        }

        protected void executeUpdate(Statement stmt) throws RuntimeException {
            this.data = this.data.flatMap(d -> {
                if (d.vetoed) {
                    return Mono.just((Object)d);
                }
                return ((Mono)Flux.from((Publisher)stmt.execute()).flatMap(r -> Flux.from((Publisher)r.getRowsUpdated())).as(x$0 -> DefaultR2dbcRepositoryOperations.toSingleResult(x$0))).thenReturn(d);
            });
        }

        protected void executeUpdateSetGeneratedId(Statement stmt) throws RuntimeException {
            this.data = this.data.flatMap(d -> {
                if (d.vetoed) {
                    return Mono.just((Object)d);
                }
                RuntimePersistentProperty identity = this.persistentEntity.getIdentity();
                return ((Mono)Flux.from((Publisher)stmt.execute()).flatMap(result -> Flux.from((Publisher)result.map((row, rowMetadata) -> DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic(row, (Object)0, identity.getDataType())))).as(x$0 -> DefaultR2dbcRepositoryOperations.toSingleResult(x$0))).map(id -> {
                    BeanProperty property = identity.getProperty();
                    d.entity = this.updateEntityId(property, d.entity, id);
                    return d;
                });
            });
        }

        protected boolean triggerPre(Function<EntityEventContext<Object>, Boolean> fn) {
            this.data = this.data.map(d -> {
                if (d.vetoed) {
                    return d;
                }
                DefaultEntityEventContext event = new DefaultEntityEventContext(this.persistentEntity, d.entity);
                d.vetoed = (Boolean)fn.apply((EntityEventContext<Object>)event) == false;
                d.entity = event.getEntity();
                return d;
            });
            return false;
        }

        protected void triggerPost(Consumer<EntityEventContext<Object>> fn) {
            this.data = this.data.map(d -> {
                if (d.vetoed) {
                    return d;
                }
                DefaultEntityEventContext event = new DefaultEntityEventContext(this.persistentEntity, d.entity);
                fn.accept((EntityEventContext<Object>)event);
                return d;
            });
        }

        protected void veto(Predicate<T> predicate) {
            this.data = this.data.map(d -> {
                if (d.vetoed) {
                    return d;
                }
                d.vetoed = predicate.test(d.entity);
                return d;
            });
        }

        private boolean notVetoed(Data data) {
            return !data.vetoed;
        }

        Mono<T> getEntity() {
            return this.data.filter(this::notVetoed).map(d -> d.entity);
        }

        Mono<Integer> getRowsUpdated() {
            return this.data.filter(this::notVetoed).map(d -> d.rowsUpdated).switchIfEmpty(Mono.just((Object)0));
        }

        class Data {
            T entity;
            Map<QueryParameterBinding, Object> previousValues;
            int rowsUpdated;
            boolean vetoed = false;

            Data() {
            }
        }
    }

    private final class DefaultR2dbcReactiveRepositoryOperations
    implements ReactorReactiveRepositoryOperations {
        private DefaultR2dbcReactiveRepositoryOperations() {
        }

        @Override
        public <T> Mono<Boolean> exists(@NonNull PreparedQuery<T, Boolean> preparedQuery) {
            return Flux.from(this.withNewOrExistingTransaction(preparedQuery, false, status -> {
                Statement statement = (Statement)DefaultR2dbcRepositoryOperations.this.prepareStatement(status.getConnection(), sql -> ((Connection)status.getConnection()).createStatement(sql), preparedQuery, false, true);
                return Flux.from((Publisher)statement.execute()).flatMap(r -> Flux.from((Publisher)r.map((row, metadata) -> true)));
            })).collectList().map(results -> !results.isEmpty()).defaultIfEmpty((Object)false);
        }

        @Override
        @NonNull
        public <T, R> Mono<R> findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
            return (Mono)Flux.from(this.withNewOrExistingTransaction(preparedQuery, false, status -> {
                Statement statement = (Statement)DefaultR2dbcRepositoryOperations.this.prepareStatement(status.getConnection(), sql -> ((Connection)status.getConnection()).createStatement(sql), preparedQuery, false, true);
                return Flux.from((Publisher)statement.execute()).flatMap(r -> {
                    if (preparedQuery.getResultDataType() == DataType.ENTITY) {
                        Class resultType = preparedQuery.getResultType();
                        RuntimePersistentEntity persistentEntity = DefaultR2dbcRepositoryOperations.this.getEntity(resultType);
                        SqlResultEntityTypeMapper mapper = new SqlResultEntityTypeMapper(persistentEntity, DefaultR2dbcRepositoryOperations.this.columnNameResultSetReader, preparedQuery.getJoinFetchPaths(), DefaultR2dbcRepositoryOperations.this.jsonCodec, (loadedEntity, o) -> {
                            if (loadedEntity.hasPostLoadEventListeners()) {
                                return DefaultR2dbcRepositoryOperations.this.triggerPostLoad(o, loadedEntity, preparedQuery.getAnnotationMetadata());
                            }
                            return o;
                        }, DefaultR2dbcRepositoryOperations.this.conversionService);
                        SqlResultEntityTypeMapper.PushingMapper rowsMapper = mapper.readOneWithJoins();
                        return Flux.from((Publisher)r.map((row, metadata) -> {
                            rowsMapper.processRow(row);
                            return "";
                        })).collectList().flatMap(ignore -> Mono.justOrEmpty((Object)rowsMapper.getResult()));
                    }
                    Class resultType = preparedQuery.getResultType();
                    if (preparedQuery.isDtoProjection()) {
                        return Flux.from((Publisher)r.map((row, metadata) -> {
                            DTOMapper introspectedDataMapper = new DTOMapper(DefaultR2dbcRepositoryOperations.this.getEntity(preparedQuery.getRootEntity()), DefaultR2dbcRepositoryOperations.this.columnNameResultSetReader, DefaultR2dbcRepositoryOperations.this.jsonCodec, DefaultR2dbcRepositoryOperations.this.conversionService);
                            return introspectedDataMapper.map(row, resultType);
                        }));
                    }
                    return Flux.from((Publisher)r.map((row, metadata) -> {
                        Object v = DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic(row, (Object)0, preparedQuery.getResultDataType());
                        if (v == null) {
                            return Flux.empty();
                        }
                        if (resultType.isInstance(v)) {
                            return Flux.just((Object)v);
                        }
                        return Flux.just((Object)DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.convertRequired(v, resultType));
                    })).flatMap(m -> m);
                });
            })).as(x$0 -> DefaultR2dbcRepositoryOperations.toSingleResult(x$0));
        }

        @Override
        @NonNull
        public <T, R> Flux<R> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
            return Flux.from(this.withNewOrExistingTransaction(preparedQuery, false, status -> {
                Statement statement = (Statement)DefaultR2dbcRepositoryOperations.this.prepareStatement(status.getConnection(), sql -> ((Connection)status.getConnection()).createStatement(sql), preparedQuery, false, false);
                Class resultType = preparedQuery.getResultType();
                boolean dtoProjection = preparedQuery.isDtoProjection();
                boolean isEntity = preparedQuery.getResultDataType() == DataType.ENTITY;
                return Flux.from((Publisher)statement.execute()).flatMap(r -> {
                    if (isEntity || dtoProjection) {
                        SqlDTOMapper mapper;
                        RuntimePersistentEntity persistentEntity = DefaultR2dbcRepositoryOperations.this.getEntity(resultType);
                        if (dtoProjection) {
                            mapper = new SqlDTOMapper(persistentEntity, DefaultR2dbcRepositoryOperations.this.columnNameResultSetReader, DefaultR2dbcRepositoryOperations.this.jsonCodec, DefaultR2dbcRepositoryOperations.this.conversionService);
                        } else {
                            Set joinFetchPaths = preparedQuery.getJoinFetchPaths();
                            SqlResultEntityTypeMapper entityTypeMapper = new SqlResultEntityTypeMapper(persistentEntity, DefaultR2dbcRepositoryOperations.this.columnNameResultSetReader, joinFetchPaths, DefaultR2dbcRepositoryOperations.this.jsonCodec, (loadedEntity, o) -> {
                                if (loadedEntity.hasPostLoadEventListeners()) {
                                    return DefaultR2dbcRepositoryOperations.this.triggerPostLoad(o, loadedEntity, preparedQuery.getAnnotationMetadata());
                                }
                                return o;
                            }, DefaultR2dbcRepositoryOperations.this.conversionService);
                            boolean onlySingleEndedJoins = DefaultR2dbcRepositoryOperations.this.isOnlySingleEndedJoins(DefaultR2dbcRepositoryOperations.this.getEntity(preparedQuery.getRootEntity()), joinFetchPaths);
                            if (!onlySingleEndedJoins) {
                                SqlResultEntityTypeMapper.PushingMapper manyReader = entityTypeMapper.readAllWithJoins();
                                return Flux.from((Publisher)r.map((row, rowMetadata) -> {
                                    manyReader.processRow(row);
                                    return "";
                                })).collectList().flatMapIterable(ignore -> (List)manyReader.getResult());
                            }
                            mapper = entityTypeMapper;
                        }
                        return Flux.from((Publisher)r.map((arg_0, arg_1) -> DefaultR2dbcReactiveRepositoryOperations.lambda$null$19((TypeMapper)mapper, resultType, arg_0, arg_1)));
                    }
                    return Flux.from((Publisher)r.map((row, rowMetadata) -> {
                        Object v = DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic(row, (Object)0, preparedQuery.getResultDataType());
                        if (v == null) {
                            return Mono.empty();
                        }
                        if (resultType.isInstance(v)) {
                            return Mono.just((Object)v);
                        }
                        Object converted = DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.convertRequired(v, resultType);
                        if (converted != null) {
                            return Mono.just((Object)converted);
                        }
                        return Mono.empty();
                    })).flatMap(m -> m);
                });
            }));
        }

        @Override
        @NonNull
        public Mono<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
            return (Mono)Flux.from(this.withNewOrExistingTransaction(preparedQuery, true, status -> {
                Statement statement = (Statement)DefaultR2dbcRepositoryOperations.this.prepareStatement(status.getConnection(), sql -> ((Connection)status.getConnection()).createStatement(sql), preparedQuery, true, true);
                return Flux.from((Publisher)statement.execute()).flatMap(result -> Flux.from((Publisher)result.getRowsUpdated()).flatMap(rowsUpdated -> {
                    Argument argument;
                    if (QUERY_LOG.isTraceEnabled()) {
                        QUERY_LOG.trace("Update operation updated {} records", rowsUpdated);
                    }
                    if (preparedQuery.isOptimisticLock()) {
                        DefaultR2dbcRepositoryOperations.this.checkOptimisticLocking(1, rowsUpdated);
                    }
                    if ((argument = (Argument)preparedQuery.getResultArgument().getFirstTypeVariable().orElse(null)) != null) {
                        if (argument.isVoid() || argument.getType() == Void.class) {
                            return Mono.empty();
                        }
                        if (argument.getType().isInstance(rowsUpdated)) {
                            return Mono.just((Object)rowsUpdated);
                        }
                        return Mono.just((Object)((Number)DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.convertRequired(rowsUpdated, argument)));
                    }
                    return Mono.just((Object)rowsUpdated);
                }));
            })).as(x$0 -> DefaultR2dbcRepositoryOperations.toSingleResult(x$0));
        }

        @Override
        @NonNull
        public Mono<Number> executeDelete(@NonNull PreparedQuery<?, Number> preparedQuery) {
            return this.executeUpdate(preparedQuery);
        }

        @Override
        @NonNull
        public <T> Mono<Number> delete(@NonNull DeleteOperation<T> operation) {
            SqlQueryBuilder queryBuilder = DefaultR2dbcRepositoryOperations.this.queryBuilders.getOrDefault(operation.getRepositoryType(), DEFAULT_SQL_BUILDER);
            return (Mono)Flux.from(this.withNewOrExistingTransaction((EntityOperation<T>)operation, true, (ReactiveTransactionOperations.TransactionalCallback)status -> {
                R2dbcEntityOperations<Object> op = new R2dbcEntityOperations<Object>(DefaultR2dbcRepositoryOperations.this.getEntity(operation.getRootEntity()), operation.getEntity());
                StoredQuerySqlOperation dbOperation = new StoredQuerySqlOperation(queryBuilder, operation.getStoredQuery());
                DefaultR2dbcRepositoryOperations.this.deleteOne(status.getConnection(), op, (DBOperation)dbOperation);
                return op.getRowsUpdated();
            })).as(x$0 -> DefaultR2dbcRepositoryOperations.toSingleResult(x$0));
        }

        @Override
        @NonNull
        public <T> Flux<T> persistAll(@NonNull InsertBatchOperation<T> operation) {
            return Flux.from(this.withNewOrExistingTransaction((EntityOperation<T>)operation, true, (ReactiveTransactionOperations.TransactionalCallback)status -> {
                AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
                Class repositoryType = operation.getRepositoryType();
                SqlQueryBuilder queryBuilder = DefaultR2dbcRepositoryOperations.this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER);
                StoredQuerySqlOperation sqlOperation = new StoredQuerySqlOperation(queryBuilder, operation.getStoredQuery());
                RuntimePersistentEntity persistentEntity = DefaultR2dbcRepositoryOperations.this.getEntity(operation.getRootEntity());
                HashSet persisted = new HashSet(5);
                if (!DefaultR2dbcRepositoryOperations.this.isSupportsBatchInsert((PersistentEntity)persistentEntity, queryBuilder.dialect())) {
                    return DefaultR2dbcRepositoryOperations.this.concatMono(operation.split().stream().map(arg_0 -> this.lambda$null$31(persistentEntity, status, annotationMetadata, repositoryType, (DBOperation)sqlOperation, persisted, arg_0)));
                }
                R2dbcEntitiesOperations op = new R2dbcEntitiesOperations(persistentEntity, (Iterable)operation);
                DefaultR2dbcRepositoryOperations.this.persistInBatch(status.getConnection(), operation.getAnnotationMetadata(), operation.getRepositoryType(), (DBOperation)sqlOperation, Collections.emptyList(), persisted, op);
                return op.getEntities();
            }));
        }

        @Override
        @NonNull
        public <T, R> Mono<R> findOptional(@NonNull PreparedQuery<T, R> preparedQuery) {
            return this.findOne(preparedQuery);
        }

        @Override
        @NonNull
        public <T> Mono<T> persist(@NonNull InsertOperation<T> operation) {
            AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
            SqlQueryBuilder queryBuilder = DefaultR2dbcRepositoryOperations.this.queryBuilders.getOrDefault(operation.getRepositoryType(), DEFAULT_SQL_BUILDER);
            HashSet persisted = new HashSet(10);
            StoredQuerySqlOperation dbOperation = new StoredQuerySqlOperation(queryBuilder, operation.getStoredQuery());
            return (Mono)Flux.from(this.withNewOrExistingTransaction((EntityOperation<T>)operation, true, (ReactiveTransactionOperations.TransactionalCallback)arg_0 -> this.lambda$persist$33(operation, annotationMetadata, (StoredSqlOperation)dbOperation, persisted, arg_0))).as(x$0 -> DefaultR2dbcRepositoryOperations.toSingleResult(x$0));
        }

        @Override
        @NonNull
        public <T> Mono<T> update(@NonNull UpdateOperation<T> operation) {
            AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
            SqlQueryBuilder queryBuilder = DefaultR2dbcRepositoryOperations.this.queryBuilders.getOrDefault(operation.getRepositoryType(), DEFAULT_SQL_BUILDER);
            StoredQuerySqlOperation dbOperation = new StoredQuerySqlOperation(queryBuilder, operation.getStoredQuery());
            HashSet persisted = new HashSet(10);
            Class repositoryType = operation.getRepositoryType();
            return (Mono)Flux.from(this.withNewOrExistingTransaction((EntityOperation<T>)operation, true, (ReactiveTransactionOperations.TransactionalCallback)arg_0 -> this.lambda$update$35(operation, annotationMetadata, repositoryType, (StoredSqlOperation)dbOperation, persisted, arg_0))).as(x$0 -> DefaultR2dbcRepositoryOperations.toSingleResult(x$0));
        }

        @NonNull
        private TransactionDefinition newTransactionDefinition(AttributeHolder attributeHolder) {
            return attributeHolder.getAttribute((CharSequence)"io.micronaut.tx.ATTRIBUTE", TransactionDefinition.class).orElseGet(() -> {
                AnnotationValue annotation;
                if (attributeHolder instanceof AnnotationMetadataProvider && (annotation = ((AnnotationMetadataProvider)attributeHolder).getAnnotationMetadata().getAnnotation(TransactionalAdvice.class)) != null) {
                    DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
                    attribute.setReadOnly(annotation.isTrue("readOnly"));
                    annotation.intValue("timeout").ifPresent(value -> attribute.setTimeout(Duration.ofSeconds(value)));
                    Class[] noRollbackFors = annotation.classValues("noRollbackFor");
                    attribute.setNoRollbackFor(noRollbackFors);
                    annotation.enumValue("propagation", TransactionDefinition.Propagation.class).ifPresent(arg_0 -> ((DefaultTransactionAttribute)attribute).setPropagationBehavior(arg_0));
                    annotation.enumValue("isolation", TransactionDefinition.Isolation.class).ifPresent(arg_0 -> ((DefaultTransactionAttribute)attribute).setIsolationLevel(arg_0));
                    return attribute;
                }
                return TransactionDefinition.DEFAULT;
            });
        }

        private <T, R> Publisher<R> withNewOrExistingTransaction(@NonNull EntityOperation<T> operation, boolean isWrite, ReactiveTransactionOperations.TransactionalCallback<Connection, R> entityOperation) {
            ReactiveTransactionStatus connection = operation.getParameterInRole("tx-status", ReactiveTransactionStatus.class).orElse(null);
            if (connection != null) {
                try {
                    return entityOperation.doInTransaction(connection);
                }
                catch (Exception e) {
                    return Mono.error((Throwable)e);
                }
            }
            return this.withNewOrExistingTxAttribute((AttributeHolder)operation, entityOperation, isWrite);
        }

        private <T, R> Publisher<R> withNewOrExistingTransaction(@NonNull PreparedQuery<T, R> operation, boolean isWrite, ReactiveTransactionOperations.TransactionalCallback<Connection, R> entityOperation) {
            ReactiveTransactionStatus connection = operation.getParameterInRole("tx-status", ReactiveTransactionStatus.class).orElse(null);
            if (connection != null) {
                try {
                    return entityOperation.doInTransaction(connection);
                }
                catch (Exception e) {
                    return Mono.error((Throwable)new TransactionSystemException("Error invoking doInTransaction handler: " + e.getMessage(), (Throwable)e));
                }
            }
            return this.withNewOrExistingTxAttribute((AttributeHolder)operation, entityOperation, isWrite);
        }

        private <R> Publisher<R> withNewOrExistingTxAttribute(@NonNull AttributeHolder attributeHolder, ReactiveTransactionOperations.TransactionalCallback<Connection, R> entityOperation, boolean isWrite) {
            TransactionDefinition definition = this.newTransactionDefinition(attributeHolder);
            if (isWrite && definition.isReadOnly()) {
                return Mono.error((Throwable)new TransactionUsageException("Cannot perform write operation with read-only transaction"));
            }
            return DefaultR2dbcRepositoryOperations.this.withTransaction(definition, entityOperation);
        }

        @Override
        @NonNull
        public <T> Mono<Number> deleteAll(DeleteBatchOperation<T> operation) {
            return (Mono)Flux.from(this.withNewOrExistingTransaction((EntityOperation<T>)operation, true, (ReactiveTransactionOperations.TransactionalCallback)status -> {
                SqlQueryBuilder queryBuilder = DefaultR2dbcRepositoryOperations.this.queryBuilders.getOrDefault(operation.getRepositoryType(), DEFAULT_SQL_BUILDER);
                RuntimePersistentEntity persistentEntity = DefaultR2dbcRepositoryOperations.this.getEntity(operation.getRootEntity());
                if (DefaultR2dbcRepositoryOperations.this.isSupportsBatchDelete((PersistentEntity)persistentEntity, queryBuilder.dialect())) {
                    R2dbcEntitiesOperations op = new R2dbcEntitiesOperations(persistentEntity, (Iterable)operation);
                    StoredQuerySqlOperation dbOperation = new StoredQuerySqlOperation(queryBuilder, operation.getStoredQuery());
                    DefaultR2dbcRepositoryOperations.this.deleteInBatch(status.getConnection(), op, (DBOperation)dbOperation);
                    return op.getRowsUpdated();
                }
                return DefaultR2dbcRepositoryOperations.this.sum(operation.split().stream().map(deleteOp -> {
                    R2dbcEntityOperations<Object> op = new R2dbcEntityOperations<Object>(persistentEntity, deleteOp.getEntity());
                    StoredQuerySqlOperation dbOperation = new StoredQuerySqlOperation(queryBuilder, operation.getStoredQuery());
                    DefaultR2dbcRepositoryOperations.this.deleteOne(status.getConnection(), op, (DBOperation)dbOperation);
                    return op.getRowsUpdated();
                }));
            })).as(x$0 -> DefaultR2dbcRepositoryOperations.toSingleResult(x$0));
        }

        @Override
        @NonNull
        public <T> Flux<T> updateAll(@NonNull UpdateBatchOperation<T> operation) {
            return Flux.from(this.withNewOrExistingTransaction((EntityOperation<T>)operation, true, (ReactiveTransactionOperations.TransactionalCallback)status -> {
                AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
                HashSet persisted = new HashSet(10);
                Class repositoryType = operation.getRepositoryType();
                SqlQueryBuilder queryBuilder = DefaultR2dbcRepositoryOperations.this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER);
                RuntimePersistentEntity persistentEntity = DefaultR2dbcRepositoryOperations.this.getEntity(operation.getRootEntity());
                StoredQuerySqlOperation dbOperation = new StoredQuerySqlOperation(queryBuilder, operation.getStoredQuery());
                if (!DefaultR2dbcRepositoryOperations.this.isSupportsBatchUpdate((PersistentEntity)persistentEntity, queryBuilder.dialect())) {
                    return DefaultR2dbcRepositoryOperations.this.concatMono(operation.split().stream().map(arg_0 -> this.lambda$null$42(persistentEntity, status, annotationMetadata, repositoryType, (StoredSqlOperation)dbOperation, persisted, arg_0)));
                }
                R2dbcEntitiesOperations op = new R2dbcEntitiesOperations(persistentEntity, (Iterable)operation);
                DefaultR2dbcRepositoryOperations.this.updateInBatch(status.getConnection(), annotationMetadata, repositoryType, (DBOperation)dbOperation, Collections.emptyList(), persisted, op);
                return op.getEntities();
            }));
        }

        @Override
        @NonNull
        public <T> Mono<T> findOptional(@NonNull Class<T> type, @NonNull Serializable id) {
            throw new UnsupportedOperationException("The findOptional method by ID is not supported. Execute the SQL query directly");
        }

        @Override
        @NonNull
        public <R> Mono<Page<R>> findPage(@NonNull PagedQuery<R> pagedQuery) {
            throw new UnsupportedOperationException("The findPage method is not supported. Execute the SQL query directly");
        }

        @Override
        @NonNull
        public <T> Mono<T> findOne(@NonNull Class<T> type, @NonNull Serializable id) {
            throw new UnsupportedOperationException("The findOne method by ID is not supported. Execute the SQL query directly");
        }

        @Override
        @NonNull
        public <T> Mono<Long> count(PagedQuery<T> pagedQuery) {
            throw new UnsupportedOperationException("The count method without an explicit query is not supported. Use findAll(PreparedQuery) instead");
        }

        @Override
        @NonNull
        public <T> Flux<T> findAll(PagedQuery<T> pagedQuery) {
            throw new UnsupportedOperationException("The findAll method without an explicit query is not supported. Use findAll(PreparedQuery) instead");
        }

        private /* synthetic */ Mono lambda$null$42(RuntimePersistentEntity persistentEntity, ReactiveTransactionStatus status, AnnotationMetadata annotationMetadata, Class repositoryType, StoredSqlOperation dbOperation, Set persisted, UpdateOperation updateOp) {
            R2dbcEntityOperations<Object> op = new R2dbcEntityOperations<Object>(persistentEntity, updateOp.getEntity());
            DefaultR2dbcRepositoryOperations.this.updateOne(status.getConnection(), annotationMetadata, repositoryType, (DBOperation)dbOperation, Collections.emptyList(), persisted, op);
            return op.getEntity();
        }

        private /* synthetic */ Publisher lambda$update$35(UpdateOperation operation, AnnotationMetadata annotationMetadata, Class repositoryType, StoredSqlOperation dbOperation, Set persisted, ReactiveTransactionStatus status) throws Exception {
            R2dbcEntityOperations<Object> op = new R2dbcEntityOperations<Object>(DefaultR2dbcRepositoryOperations.this.getEntity(operation.getRootEntity()), operation.getEntity());
            DefaultR2dbcRepositoryOperations.this.updateOne(status.getConnection(), annotationMetadata, repositoryType, (DBOperation)dbOperation, Collections.emptyList(), persisted, op);
            return op.getEntity();
        }

        private /* synthetic */ Publisher lambda$persist$33(InsertOperation operation, AnnotationMetadata annotationMetadata, StoredSqlOperation dbOperation, Set persisted, ReactiveTransactionStatus status) throws Exception {
            R2dbcEntityOperations<Object> op = new R2dbcEntityOperations<Object>(DefaultR2dbcRepositoryOperations.this.getEntity(operation.getRootEntity()), operation.getEntity());
            DefaultR2dbcRepositoryOperations.this.persistOne(status.getConnection(), annotationMetadata, operation.getRepositoryType(), (DBOperation)dbOperation, Collections.emptyList(), persisted, op);
            return op.getEntity();
        }

        private /* synthetic */ Mono lambda$null$31(RuntimePersistentEntity persistentEntity, ReactiveTransactionStatus status, AnnotationMetadata annotationMetadata, Class repositoryType, DBOperation sqlOperation, HashSet persisted, InsertOperation persistOp) {
            R2dbcEntityOperations<Object> op = new R2dbcEntityOperations<Object>(persistentEntity, persistOp.getEntity());
            DefaultR2dbcRepositoryOperations.this.persistOne(status.getConnection(), annotationMetadata, repositoryType, sqlOperation, Collections.emptyList(), persisted, op);
            return op.getEntity();
        }

        private static /* synthetic */ Object lambda$null$19(TypeMapper mapper, Class resultType, Row row, RowMetadata rowMetadata) {
            return mapper.map((Object)row, resultType);
        }
    }

    private static final class DefaultReactiveTransactionStatus
    implements ReactiveTransactionStatus<Connection> {
        private final Connection connection;
        private final boolean isNew;
        private boolean rollbackOnly;
        private boolean completed;

        public DefaultReactiveTransactionStatus(Connection connection, boolean isNew) {
            this.connection = connection;
            this.isNew = isNew;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public boolean isNewTransaction() {
            return this.isNew;
        }

        public void setRollbackOnly() {
            this.rollbackOnly = true;
        }

        public boolean isRollbackOnly() {
            return this.rollbackOnly;
        }

        public boolean isCompleted() {
            return this.completed;
        }
    }
}

