/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.r2dbc.mapper;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.DataType;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.r2dbc.spi.Row;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class ColumnIndexR2dbcResultReader
implements ResultReader<Row, Integer> {
    private final ConversionService<?> conversionService;

    public ColumnIndexR2dbcResultReader() {
        this(null);
    }

    public ColumnIndexR2dbcResultReader(DataConversionService<?> conversionService) {
        this.conversionService = conversionService == null ? ConversionService.SHARED : conversionService;
    }

    public ConversionService<?> getConversionService() {
        return this.conversionService;
    }

    @Nullable
    public Object readDynamic(@NonNull Row resultSet, @NonNull Integer index, @NonNull DataType dataType) {
        switch (dataType) {
            case STRING: 
            case UUID: 
            case JSON: {
                return this.readString(resultSet, index);
            }
            case LONG: {
                return resultSet.get(index.intValue(), Long.class);
            }
            case INTEGER: {
                Object value = resultSet.get(index.intValue());
                if (value instanceof Integer) {
                    return value;
                }
                return this.convertRequired(value, Integer.class);
            }
            case BOOLEAN: {
                return resultSet.get(index.intValue(), Boolean.class);
            }
            case BYTE: {
                return resultSet.get(index.intValue(), Byte.class);
            }
            case TIMESTAMP: {
                return resultSet.get(index.intValue(), Timestamp.class);
            }
            case DATE: {
                return resultSet.get(index.intValue(), java.util.Date.class);
            }
            case CHARACTER: {
                return resultSet.get(index.intValue(), Character.class);
            }
            case FLOAT: {
                return resultSet.get(index.intValue(), Float.class);
            }
            case SHORT: {
                return resultSet.get(index.intValue(), Short.class);
            }
            case DOUBLE: {
                return resultSet.get(index.intValue(), Double.class);
            }
            case BYTE_ARRAY: {
                return resultSet.get(index.intValue(), byte[].class);
            }
            case BIGDECIMAL: {
                return resultSet.get(index.intValue(), BigDecimal.class);
            }
        }
        return this.getRequiredValue(resultSet, index, Object.class);
    }

    public long readLong(Row resultSet, Integer name) {
        Long l = (Long)resultSet.get(name.intValue(), Long.class);
        if (l != null) {
            return l;
        }
        return 0L;
    }

    public char readChar(Row resultSet, Integer name) {
        Character character = (Character)resultSet.get(name.intValue(), Character.class);
        if (character != null) {
            return character.charValue();
        }
        return '\u0000';
    }

    public java.util.Date readDate(Row resultSet, Integer name) {
        LocalDate localDate = (LocalDate)resultSet.get(name.intValue(), LocalDate.class);
        if (localDate != null) {
            return Date.valueOf(localDate);
        }
        return null;
    }

    public java.util.Date readTimestamp(Row resultSet, Integer index) {
        LocalDateTime localDateTime = (LocalDateTime)resultSet.get(index.intValue(), LocalDateTime.class);
        if (localDateTime != null) {
            return java.util.Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        }
        return null;
    }

    @Nullable
    public String readString(Row resultSet, Integer name) {
        return (String)resultSet.get(name.intValue(), String.class);
    }

    public int readInt(Row resultSet, Integer name) {
        Integer l = (Integer)resultSet.get(name.intValue(), Integer.class);
        if (l != null) {
            return l;
        }
        return 0;
    }

    public boolean readBoolean(Row resultSet, Integer name) {
        Boolean l = (Boolean)resultSet.get(name.intValue(), Boolean.class);
        if (l != null) {
            return l;
        }
        return false;
    }

    public float readFloat(Row resultSet, Integer name) {
        Float l = (Float)resultSet.get(name.intValue(), Float.class);
        if (l != null) {
            return l.floatValue();
        }
        return 0.0f;
    }

    public byte readByte(Row resultSet, Integer name) {
        Byte l = (Byte)resultSet.get(name.intValue(), Byte.class);
        if (l != null) {
            return l;
        }
        return 0;
    }

    public short readShort(Row resultSet, Integer name) {
        Short l = (Short)resultSet.get(name.intValue(), Short.class);
        if (l != null) {
            return l;
        }
        return 0;
    }

    public double readDouble(Row resultSet, Integer name) {
        Double l = (Double)resultSet.get(name.intValue(), Double.class);
        if (l != null) {
            return l;
        }
        return 0.0;
    }

    public BigDecimal readBigDecimal(Row resultSet, Integer name) {
        return (BigDecimal)resultSet.get(name.intValue(), BigDecimal.class);
    }

    public byte[] readBytes(Row resultSet, Integer name) {
        return (byte[])resultSet.get(name.intValue(), byte[].class);
    }

    @Nullable
    public <T> T getRequiredValue(Row resultSet, Integer name, Class<T> type) throws DataAccessException {
        try {
            return (T)resultSet.get(name.intValue(), type);
        }
        catch (ConversionErrorException | IllegalArgumentException e) {
            try {
                return (T)this.conversionService.convertRequired(resultSet.get(name.intValue()), type);
            }
            catch (Exception exception) {
                throw this.exceptionForColumn(name, (Exception)e);
            }
        }
    }

    public boolean next(Row resultSet) {
        return false;
    }

    private DataAccessException exceptionForColumn(Integer name, Exception e) {
        return new DataAccessException("Error reading object for index [" + name + "] from result set: " + e.getMessage(), (Throwable)e);
    }
}

