/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.r2dbc.config;

import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.Named;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.r2dbc.operations.R2dbcOperations;
import io.micronaut.data.runtime.config.SchemaGenerate;
import io.r2dbc.spi.ConnectionFactory;
import java.util.ArrayList;
import java.util.List;

@EachProperty(value="r2dbc.datasources", primary="default")
public class DataR2dbcConfiguration
implements Named {
    private SchemaGenerate schemaGenerate = SchemaGenerate.NONE;
    private boolean batchGenerate = false;
    private Dialect dialect = Dialect.ANSI;
    private List<String> packages = new ArrayList<String>(3);
    private final String name;
    private final ConnectionFactory connectionFactory;
    private final R2dbcOperations r2dbcOperations;

    public DataR2dbcConfiguration(@Parameter String name, @Parameter ConnectionFactory connectionFactory, @Parameter R2dbcOperations r2dbcOperations) {
        this.name = name;
        this.connectionFactory = connectionFactory;
        this.r2dbcOperations = r2dbcOperations;
    }

    public R2dbcOperations getR2dbcOperations() {
        return this.r2dbcOperations;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public SchemaGenerate getSchemaGenerate() {
        return this.schemaGenerate;
    }

    public void setSchemaGenerate(SchemaGenerate schemaGenerate) {
        if (schemaGenerate != null) {
            this.schemaGenerate = schemaGenerate;
        }
    }

    public boolean isBatchGenerate() {
        return this.batchGenerate;
    }

    public void setBatchGenerate(boolean batchGenerate) {
        this.batchGenerate = batchGenerate;
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public void setPackages(List<String> packages) {
        if (packages != null) {
            this.packages = packages;
        }
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    @NonNull
    public String getName() {
        return this.name;
    }
}

