/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.r2dbc.operations;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.r2dbc.operations.ReactorReactiveCapableRepository;
import java.io.Serializable;
import java.util.Optional;
import java.util.stream.Stream;

public interface BlockingReactorRepositoryOperations
extends RepositoryOperations,
ReactorReactiveCapableRepository {
    @Nullable
    default public <T> T findOne(@NonNull Class<T> type, @NonNull Serializable id) {
        return (T)this.reactive().findOne(type, id).block();
    }

    @Nullable
    default public <T, R> R findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (R)this.reactive().findOne(preparedQuery).block();
    }

    @NonNull
    default public <T, R> Iterable<R> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
        return this.reactive().findAll(preparedQuery).toIterable();
    }

    @NonNull
    default public <T, R> Stream<R> findStream(@NonNull PreparedQuery<T, R> preparedQuery) {
        return this.reactive().findAll(preparedQuery).toStream();
    }

    @NonNull
    default public <T> T persist(@NonNull InsertOperation<T> operation) {
        return this.reactive().persist(operation).blockOptional().orElse(null);
    }

    @NonNull
    default public <T> T update(@NonNull UpdateOperation<T> operation) {
        return (T)this.reactive().update(operation).block();
    }

    @NonNull
    default public <T> Iterable<T> persistAll(@NonNull InsertBatchOperation<T> operation) {
        return (Iterable)this.reactive().persistAll(operation).collectList().block();
    }

    @NonNull
    default public Optional<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return this.reactive().executeUpdate(preparedQuery).blockOptional();
    }

    default public <T> int delete(@NonNull DeleteOperation<T> operation) {
        return ((Number)this.reactive().delete(operation).blockOptional().orElse(0)).intValue();
    }

    default public <T> Optional<Number> deleteAll(@NonNull DeleteBatchOperation<T> operation) {
        return this.reactive().deleteAll(operation).blockOptional();
    }

    default public <T> boolean exists(@NonNull PreparedQuery<T, Boolean> preparedQuery) {
        return this.reactive().exists(preparedQuery).blockOptional().orElse(false);
    }

    default public <R> Page<R> findPage(@NonNull PagedQuery<R> query) {
        return (Page)this.reactive().findPage(query).block();
    }

    @NonNull
    default public <T> Iterable<T> findAll(@NonNull PagedQuery<T> query) {
        return this.reactive().findAll(query).toIterable();
    }

    default public <T> long count(PagedQuery<T> pagedQuery) {
        return this.reactive().count(pagedQuery).blockOptional().orElse(0L);
    }

    @NonNull
    default public <T> Stream<T> findStream(@NonNull PagedQuery<T> query) {
        return this.reactive().findAll(query).toStream();
    }
}

