/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.MethodNameParser;
import java.util.List;

@Internal
public abstract class AbstractMethodMatcher
implements MethodMatcher {
    protected static final String[] ALL = new String[]{"All"};
    protected static final String[] ALL_OR_ONE = new String[]{"All", "One"};
    protected static final String[] TOP_OR_FIRST = new String[]{"Top", "First"};
    protected static final String FIRST = "First";
    protected static final String[] ORDER_VARIATIONS = new String[]{"OrderBy", "SortBy"};
    protected static final String BY = "By";
    protected static final String DISTINCT = "Distinct";
    protected static final String FOR_UPDATE = "ForUpdate";
    protected static final String RETURNING = "Returning";
    private final MethodNameParser parser;

    public AbstractMethodMatcher(MethodNameParser parser) {
        this.parser = parser;
    }

    @Override
    public MethodMatcher.MethodMatch match(MethodMatchContext matchContext) {
        String methodName = matchContext.getMethodElement().getName();
        List<MethodNameParser.Match> matches = this.parser.tryMatch(methodName);
        if (matches.isEmpty()) {
            return null;
        }
        return this.match(matchContext, matches);
    }

    protected abstract MethodMatcher.MethodMatch match(MethodMatchContext var1, List<MethodNameParser.Match> var2);
}

