/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.processor.visitors.FindInterceptorDef;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;

@Internal
public class MatchContext
implements AnnotationMetadataProvider {
    protected final @NonNull VisitorContext visitorContext;
    protected final @NonNull MethodElement methodElement;
    protected final Map<String, String> typeRoles;
    protected final List<Map.Entry<String, String>> annotationRoles;
    protected final ClassElement returnType;
    protected final @NonNull ParameterElement[] parameters;
    private final ClassElement repositoryClass;
    private final QueryBuilder queryBuilder;
    private final List<String> possibleFailures = new ArrayList<String>();
    private final Map<ClassElement, FindInterceptorDef> findInterceptors;

    MatchContext(@NonNull QueryBuilder queryBuilder, @NonNull ClassElement repositoryClass, @NonNull VisitorContext visitorContext, @NonNull MethodElement methodElement, @NonNull Map<String, String> typeRoles, @NonNull List<Map.Entry<String, String>> annotationRoles, @NonNull ClassElement returnType, @NonNull ParameterElement[] parameters, @NonNull Map<ClassElement, FindInterceptorDef> findInterceptors) {
        this.queryBuilder = queryBuilder;
        this.repositoryClass = repositoryClass;
        this.visitorContext = visitorContext;
        this.methodElement = methodElement;
        this.typeRoles = typeRoles;
        this.annotationRoles = annotationRoles;
        this.returnType = returnType;
        this.parameters = parameters;
        this.findInterceptors = findInterceptors;
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.methodElement.getAnnotationMetadata();
    }

    public boolean isTypeInRole(@NonNull ClassElement type, @NonNull String role) {
        if (type != null && role != null) {
            String r = this.typeRoles.get(type.getName());
            if (r != null) {
                return r.equalsIgnoreCase(role);
            }
            for (Map.Entry<String, String> e : this.annotationRoles) {
                if (!e.getValue().equalsIgnoreCase(role) || !type.hasStereotype(e.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    public @NonNull VisitorContext getVisitorContext() {
        return this.visitorContext;
    }

    public @NonNull MethodElement getMethodElement() {
        return this.methodElement;
    }

    public @NonNull ClassElement getReturnType() {
        return this.returnType;
    }

    public ParameterElement[] getParameters() {
        return this.parameters;
    }

    public void fail(@NonNull String message) {
        this.getVisitorContext().fail(this.getUnableToImplementMessage() + message, (Element)this.getMethodElement());
    }

    public boolean isPossiblyFailing() {
        return !this.possibleFailures.isEmpty();
    }

    public void logPossibleFailures() {
        VisitorContext visitorContext = this.getVisitorContext();
        String unableToImplementMessage = this.getUnableToImplementMessage();
        MethodElement methodElement = this.getMethodElement();
        for (String message : this.possibleFailures) {
            visitorContext.fail(unableToImplementMessage + message, (Element)methodElement);
        }
    }

    public boolean supportsImplicitQueries() {
        return this.repositoryClass.booleanValue(RepositoryConfiguration.class, "implicitQueries").orElse(true);
    }

    public @NonNull ClassElement getRepositoryClass() {
        return this.repositoryClass;
    }

    public String getUnableToImplementMessage() {
        return "Unable to implement Repository method: " + this.repositoryClass.getName() + "." + this.methodElement.getName() + "(" + Arrays.stream(this.methodElement.getParameters()).map(p -> p.getType().getSimpleName() + " " + p.getName()).collect(Collectors.joining(",")) + "). ";
    }

    public Map<ClassElement, FindInterceptorDef> getFindInterceptors() {
        return this.findInterceptors;
    }
}

