/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.model.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.jpa.criteria.ExpressionType;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import org.jspecify.annotations.NonNull;

@Internal
public final class ClassElementExpressionType<T>
implements ExpressionType<T> {
    private final ClassElement type;

    public ClassElementExpressionType(@NonNull ClassElement type) {
        this.type = type;
    }

    public String getName() {
        return this.type.getName();
    }

    public boolean isBoolean() {
        return TypeUtils.isBoolean(this.type);
    }

    public boolean isNumeric() {
        return TypeUtils.isNumber(this.type);
    }

    public boolean isComparable() {
        return TypeUtils.isComparable(this.type);
    }

    public boolean isTextual() {
        return TypeUtils.isTextual(this.type);
    }

    public Class<T> getJavaType() {
        throw CriteriaUtils.notSupportedOperation();
    }
}

