/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.expressions.EvaluatedExpressionReference;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.EntityRepresentation;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.ParameterExpression;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.annotation.QueryResult;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.annotation.TypeRole;
import io.micronaut.data.annotation.sql.Procedure;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.intercept.annotation.DataMethodQueryParameter;
import io.micronaut.data.model.CursoredPage;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.Slice;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.BindingParameter;
import io.micronaut.data.model.query.builder.AdditionalParameterBinding;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.model.criteria.impl.SourceParameterExpressionImpl;
import io.micronaut.data.processor.visitors.FindInterceptorDef;
import io.micronaut.data.processor.visitors.MappedEntityVisitor;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.Utils;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.RawQueryMethodMatcher;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.data.repository.GenericRepository;
import io.micronaut.inject.annotation.EvaluatedExpressionReferenceCounter;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@Internal
public class RepositoryTypeElementVisitor
implements TypeElementVisitor<Repository, Object> {
    public static final String SPRING_REPO = "org.springframework.data.repository.Repository";
    private static final boolean IS_DOCUMENT_ANNOTATION_PROCESSOR = ClassUtils.isPresent((String)"io.micronaut.data.document.processor.mapper.MappedEntityMapper", (ClassLoader)RepositoryTypeElementVisitor.class.getClassLoader());
    private ClassElement currentClass;
    private ClassElement currentRepository;
    private QueryBuilder queryEncoder;
    private final Map<String, String> typeRoles = new HashMap<String, String>();
    private final List<MethodMatcher> methodsMatchers;
    private boolean failing = false;
    private final Set<String> visitedRepositories = new HashSet<String>();
    private Map<String, DataType> dataTypes = Collections.emptyMap();
    private final Map<String, SourcePersistentEntity> entityMap = new HashMap<String, SourcePersistentEntity>(50);
    private Function<ClassElement, SourcePersistentEntity> entityResolver;

    public RepositoryTypeElementVisitor() {
        ArrayList<MethodMatcher> matcherList = new ArrayList<MethodMatcher>(20);
        SoftServiceLoader.load(MethodMatcher.class).collectAll(matcherList);
        OrderUtil.sort(matcherList);
        this.methodsMatchers = matcherList;
        this.typeRoles.put(Pageable.class.getName(), "pageable");
        this.typeRoles.put(Sort.class.getName(), "sort");
        this.typeRoles.put(CursoredPage.class.getName(), "cursoredPage");
        this.typeRoles.put(Page.class.getName(), "page");
        this.typeRoles.put(Slice.class.getName(), "slice");
    }

    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    private Map<ClassElement, FindInterceptorDef> createFindInterceptors(ClassElement element, VisitorContext visitorContext) {
        List<FindInterceptorDef> defaultInterceptors = FindersUtils.getDefaultInterceptors(visitorContext);
        ArrayList<FindInterceptorDef> interceptors = new ArrayList<FindInterceptorDef>(defaultInterceptors);
        AnnotationValue repositoryConfiguration = element.getAnnotationMetadata().getAnnotation(RepositoryConfiguration.class);
        if (repositoryConfiguration != null) {
            for (AnnotationValue interceptor : repositoryConfiguration.getAnnotations("findInterceptors", io.micronaut.data.annotation.FindInterceptorDef.class)) {
                interceptors.add(new FindInterceptorDef((ClassElement)interceptor.stringValue("returnType").flatMap(arg_0 -> ((VisitorContext)visitorContext).getClassElement(arg_0)).orElseThrow(), interceptor.booleanValue("isContainer").orElse(true), (ClassElement)interceptor.stringValue("interceptor").flatMap(arg_0 -> ((VisitorContext)visitorContext).getClassElement(arg_0)).orElseThrow()));
            }
        }
        return interceptors.stream().collect(Collectors.toMap(FindInterceptorDef::returnType, e -> e));
    }

    public void visitClass(ClassElement element, final VisitorContext context) {
        String interfaceName = element.getName();
        if (this.failing) {
            return;
        }
        if (this.visitedRepositories.contains(interfaceName)) {
            this.currentRepository = null;
            this.currentClass = null;
            return;
        }
        if (element.hasStereotype("io.micronaut.data.document.annotation.DocumentProcessorRequired") && !IS_DOCUMENT_ANNOTATION_PROCESSOR) {
            context.fail("Repository is required to be processed by the data-document-processor. Make sure it's included as a dependency to the annotation processor classpath!", (Element)element);
            this.failing = true;
            return;
        }
        this.currentClass = element;
        this.entityResolver = new Function<ClassElement, SourcePersistentEntity>(){
            final MappedEntityVisitor mappedEntityVisitor = new MappedEntityVisitor();
            final MappedEntityVisitor embeddedMappedEntityVisitor = new MappedEntityVisitor(false);

            @Override
            public SourcePersistentEntity apply(ClassElement classElement) {
                return RepositoryTypeElementVisitor.this.entityMap.computeIfAbsent(classElement.getName(), s -> {
                    if (classElement.hasAnnotation("io.micronaut.data.annotation.Embeddable")) {
                        this.embeddedMappedEntityVisitor.visitClass(classElement, context);
                    } else {
                        this.mappedEntityVisitor.visitClass(classElement, context);
                    }
                    return new SourcePersistentEntity(classElement, this);
                });
            }
        };
        if (element.hasDeclaredStereotype(Repository.class)) {
            this.visitedRepositories.add(interfaceName);
            this.currentRepository = element;
            this.queryEncoder = QueryBuilder.newQueryBuilder((AnnotationMetadata)element.getAnnotationMetadata());
            this.dataTypes = Utils.getConfiguredDataTypes(this.currentRepository);
            AnnotationMetadata annotationMetadata = element.getAnnotationMetadata();
            List roleArray = annotationMetadata.findAnnotation(RepositoryConfiguration.class).map(av -> av.getAnnotations("typeRoles", TypeRole.class)).orElse(Collections.emptyList());
            for (AnnotationValue parameterRole : roleArray) {
                String role = parameterRole.stringValue("role").orElse(null);
                AnnotationClassValue cv = parameterRole.get((CharSequence)"type", AnnotationClassValue.class).orElse(null);
                if (!StringUtils.isNotEmpty((CharSequence)role) || cv == null) continue;
                context.getClassElement(cv.getName()).ifPresent(ce -> this.typeRoles.put(ce.getName(), role));
            }
            if (element.isAssignable(SPRING_REPO)) {
                context.getClassElement("org.springframework.data.domain.Pageable").ifPresent(ce -> this.typeRoles.put(ce.getName(), "pageable"));
                context.getClassElement("org.springframework.data.domain.Page").ifPresent(ce -> this.typeRoles.put(ce.getName(), "page"));
                context.getClassElement("org.springframework.data.domain.Slice").ifPresent(ce -> this.typeRoles.put(ce.getName(), "slice"));
                context.getClassElement("org.springframework.data.domain.Sort").ifPresent(ce -> this.typeRoles.put(ce.getName(), "sort"));
            }
            this.annotateEntityRepresentationIfPresent(element);
            if (this.queryEncoder == null) {
                context.fail("QueryEncoder not present on annotation processor path", (Element)element);
                this.failing = true;
            }
        }
    }

    public void visitMethod(MethodElement element, VisitorContext context) {
        if (this.currentRepository == null || this.failing) {
            return;
        }
        ClassElement genericReturnType = element.getGenericReturnType();
        if (this.queryEncoder != null && this.currentClass != null && element.isAbstract() && !element.isStatic() && this.methodsMatchers != null) {
            ParameterElement[] parameters = element.getParameters();
            HashMap<String, Element> parametersInRole = new HashMap<String, Element>(2);
            for (ParameterElement parameter : parameters) {
                ClassElement type = parameter.getType();
                this.typeRoles.entrySet().stream().filter(entry -> {
                    String roleType = (String)entry.getKey();
                    return type.isAssignable(roleType);
                }).forEach(entry -> parametersInRole.put((String)entry.getValue(), (Element)parameter));
            }
            if (element.hasDeclaredAnnotation(DataMethod.class)) {
                return;
            }
            Map<ClassElement, FindInterceptorDef> findInterceptors = this.createFindInterceptors(this.currentClass, context);
            MatchContext matchContext = new MatchContext(this.queryEncoder, this.currentRepository, context, element, this.typeRoles, genericReturnType, parameters, findInterceptors);
            try {
                SourcePersistentEntity entity = this.resolvePersistentEntity(element, parametersInRole);
                MethodMatchContext methodMatchContext = new MethodMatchContext(this.queryEncoder, this.currentRepository, entity, context, genericReturnType, element, parametersInRole, this.typeRoles, parameters, this.entityResolver, findInterceptors);
                for (MethodMatcher finder : this.methodsMatchers) {
                    MethodMatchInfo methodInfo;
                    MethodMatcher.MethodMatch matcher = finder.match(methodMatchContext);
                    if (matcher == null || (methodInfo = matcher.buildMatchInfo(methodMatchContext)) == null) continue;
                    this.processMethodInfo(methodMatchContext, methodInfo);
                    return;
                }
                if (matchContext.isPossiblyFailing()) {
                    matchContext.logPossibleFailures();
                } else {
                    String messageStart = matchContext.getUnableToImplementMessage();
                    context.fail(messageStart + "No possible implementations found.", (Element)element);
                }
                this.failing = true;
            }
            catch (MatchFailedException e) {
                context.fail(matchContext.getUnableToImplementMessage() + e.getMessage(), (Element)(e.getElement() == null ? element : e.getElement()));
                this.failing = true;
            }
            catch (Exception e) {
                matchContext.fail(e.getMessage());
                this.failing = true;
            }
        }
    }

    private void processMethodInfo(MethodMatchContext methodMatchContext, MethodMatchInfo methodInfo) {
        ClassElement runtimeInterceptor;
        QueryBuilder queryEncoder = methodMatchContext.getQueryBuilder();
        MethodElement element = methodMatchContext.getMethodElement();
        SourcePersistentEntity entity = methodMatchContext.getRootEntity();
        ParameterElement[] parameters = methodMatchContext.getParameters();
        for (Map.Entry<String, Element> entry : methodMatchContext.getParametersInRole().entrySet()) {
            methodInfo.addParameterRole(entry.getKey(), entry.getValue().getName());
        }
        List parameterBinding = null;
        boolean encodeEntityParameters = false;
        boolean supportsImplicitQueries = methodMatchContext.supportsImplicitQueries();
        QueryResult queryResult = methodInfo.getQueryResult();
        if (queryResult != null) {
            if (methodInfo.isRawQuery()) {
                parameterBinding = queryResult.getParameterBindings();
                element.annotate(Query.class, builder -> builder.member("rawQuery", (String)element.stringValue(Query.class).map(q -> this.addRawQueryParameterPlaceholders(queryEncoder, queryResult.getQuery(), queryResult.getQueryParts())).orElse(null)));
                ClassElement genericReturnType = methodMatchContext.getReturnType();
                if (methodMatchContext.isTypeInRole(genericReturnType, "page") || methodMatchContext.isTypeInRole(genericReturnType, "cursoredPage") || element.isPresent(Query.class, "countQuery")) {
                    QueryResult countQueryResult = methodInfo.getCountQueryResult();
                    if (countQueryResult == null) {
                        throw new MatchFailedException("Query returns a Page and does not specify a 'countQuery' member.", (Element)element);
                    }
                    element.annotate(Query.class, builder -> builder.member("rawCountQuery", this.addRawQueryParameterPlaceholders(queryEncoder, countQueryResult.getQuery(), countQueryResult.getQueryParts())));
                }
                encodeEntityParameters = methodInfo.isEncodeEntityParameters();
            } else {
                encodeEntityParameters = methodInfo.isEncodeEntityParameters();
                parameterBinding = queryResult.getParameterBindings();
                this.bindAdditionalParameters(methodMatchContext, entity, parameterBinding, parameters, queryResult.getAdditionalRequiredParameters());
                QueryResult preparedCount = methodInfo.getCountQueryResult();
                if (preparedCount != null) {
                    element.annotate(Query.class, annotationBuilder -> {
                        annotationBuilder.value(queryResult.getQuery());
                        annotationBuilder.member("countQuery", preparedCount.getQuery());
                    });
                } else {
                    element.annotate(Query.class, annotationBuilder -> {
                        annotationBuilder.value(queryResult.getQuery());
                        String update = queryResult.getUpdate();
                        if (StringUtils.isNotEmpty((CharSequence)update)) {
                            annotationBuilder.member("update", update);
                        }
                    });
                }
                Collection joinPaths = queryResult.getJoinPaths();
                if (CollectionUtils.isNotEmpty((Collection)joinPaths)) {
                    element.removeAnnotation(Join.class);
                    joinPaths.forEach(joinPath -> element.annotate(Join.class, builder -> {
                        builder.member("value", joinPath.getPath()).member("type", (Enum)joinPath.getJoinType());
                        if (joinPath.getAlias().isPresent()) {
                            builder.member("alias", (String)joinPath.getAlias().get());
                        }
                    }));
                }
            }
        }
        if ((runtimeInterceptor = methodInfo.getRuntimeInterceptor()) == null) {
            throw new MatchFailedException("Unable to implement Repository method: " + this.currentRepository.getSimpleName() + "." + element.getName() + "(..). No possible runtime implementations found.", (Element)element);
        }
        this.annotateQueryResultIfApplicable(element, methodInfo, entity);
        boolean finalEncodeEntityParameters = encodeEntityParameters;
        List finalParameterBinding = parameterBinding;
        element.annotate(DataMethod.class, annotationBuilder -> {
            String idType;
            TypedElement resultType;
            if (element.hasAnnotation(Procedure.class)) {
                annotationBuilder.member("procedure", true);
            }
            annotationBuilder.member("opType", (Enum)methodInfo.getOperationType());
            annotationBuilder.member("rootEntity", new AnnotationClassValue[]{new AnnotationClassValue(entity.getName())});
            methodInfo.getParameterRoles().forEach((arg_0, arg_1) -> ((AnnotationValueBuilder)annotationBuilder).member(arg_0, arg_1));
            if (methodInfo.isDto()) {
                annotationBuilder.member("dto", true);
            }
            if (methodInfo.isOptimisticLock()) {
                annotationBuilder.member("optimisticLock", true);
            }
            if ((resultType = methodInfo.getResultType()) != null) {
                annotationBuilder.member("resultType", new AnnotationClassValue[]{new AnnotationClassValue(resultType.getName())});
                ClassElement type = resultType.getType();
                if (!TypeUtils.isVoid(type)) {
                    annotationBuilder.member("resultDataType", (Enum)TypeUtils.resolveDataType(type, this.dataTypes));
                }
            }
            if ((idType = this.resolveIdType(entity)) != null) {
                annotationBuilder.member("idType", idType);
            }
            annotationBuilder.member("interceptor", new AnnotationClassValue[]{new AnnotationClassValue(runtimeInterceptor.getName())});
            if (queryResult != null) {
                long offset;
                int max;
                if (finalParameterBinding.stream().anyMatch(QueryParameterBinding::isExpandable)) {
                    annotationBuilder.member("expandableQuery", queryResult.getQueryParts().toArray(new String[0]));
                    QueryResult preparedCount = methodInfo.getCountQueryResult();
                    if (preparedCount != null) {
                        annotationBuilder.member("expandableCountQuery", preparedCount.getQueryParts().toArray(new String[0]));
                    }
                }
                if ((max = queryResult.getMax()) > -1) {
                    annotationBuilder.member("pageSize", max);
                }
                if ((offset = queryResult.getOffset()) > 0L) {
                    annotationBuilder.member("pageIndex", offset);
                }
            }
            Arrays.stream(parameters).filter(p -> p.getGenericType().isAssignable(entity.getName())).findFirst().ifPresent(parameterElement -> annotationBuilder.member("entity", parameterElement.getName()));
            if (CollectionUtils.isNotEmpty((Collection)finalParameterBinding)) {
                this.bindParameters(supportsImplicitQueries, finalParameterBinding, finalEncodeEntityParameters, (AnnotationValueBuilder<DataMethod>)annotationBuilder);
            }
        });
    }

    private void bindParameters(boolean supportsImplicitQueries, List<QueryParameterBinding> finalParameterBinding, boolean finalEncodeEntityParameters, AnnotationValueBuilder<DataMethod> annotationBuilder) {
        ArrayList<AnnotationValue> annotationValues = new ArrayList<AnnotationValue>();
        for (QueryParameterBinding p : finalParameterBinding) {
            AnnotationValueBuilder builder = AnnotationValue.builder(DataMethodQueryParameter.class);
            if (p.getParameterIndex() != -1) {
                builder.member("parameterIndex", p.getParameterIndex());
            }
            if (p.getParameterBindingPath() != null) {
                builder.member("parameterBindingPath", p.getParameterBindingPath());
            }
            if (p.getPropertyPath() != null) {
                if (p.getPropertyPath().length == 1) {
                    builder.member("property", p.getPropertyPath()[0]);
                } else {
                    builder.member("propertyPath", p.getPropertyPath());
                }
            }
            if (!supportsImplicitQueries && !finalEncodeEntityParameters) {
                builder.member("dataType", (Enum)p.getDataType());
            }
            builder.member("jsonDataType", (Enum)p.getJsonDataType());
            if (p.getConverterClassName() != null) {
                builder.member("converter", new AnnotationClassValue[]{new AnnotationClassValue(p.getConverterClassName())});
            }
            if (p.isAutoPopulated()) {
                builder.member("autoPopulated", true);
            }
            if (p.isRequiresPreviousPopulatedValue()) {
                builder.member("requiresPreviousPopulatedValue", true);
            }
            if (p.isExpandable()) {
                builder.member("expandable", true);
            }
            if (p.isExpression()) {
                Object value;
                builder.member("expression", true);
                if (!supportsImplicitQueries) {
                    builder.member("name", p.getName());
                }
                if ((value = p.getValue()) != null) {
                    if (value instanceof String) {
                        String expression = (String)value;
                        String originatingClassName = DataMethodQueryParameter.class.getName();
                        String packageName = NameUtils.getPackageName((String)originatingClassName);
                        String simpleClassName = NameUtils.getSimpleName((String)originatingClassName);
                        String exprClassName = "%s.$%s%s".formatted(packageName, simpleClassName, "$Expr");
                        Integer expressionIndex = EvaluatedExpressionReferenceCounter.nextIndex((String)exprClassName);
                        builder.members(Map.of("value", new EvaluatedExpressionReference((Object)expression, originatingClassName, "value", exprClassName + expressionIndex)));
                    } else {
                        throw new IllegalStateException("The expression value should be a String!");
                    }
                }
            }
            if (supportsImplicitQueries) {
                builder.member("name", p.getKey());
            }
            annotationValues.add(builder.build());
        }
        AnnotationValue[] annotations = annotationValues.toArray(new AnnotationValue[0]);
        annotationBuilder.member("parameters", annotations);
    }

    private void bindAdditionalParameters(MatchContext matchContext, SourcePersistentEntity entity, List<QueryParameterBinding> parameterBinding, ParameterElement[] parameters, Map<String, String> params) {
        Map<String, DataType> configuredDataTypes = Utils.getConfiguredDataTypes(matchContext.getRepositoryClass());
        ListIterator<QueryParameterBinding> iterator = parameterBinding.listIterator();
        while (iterator.hasNext()) {
            QueryParameterBinding queryParameterBinding = iterator.next();
            if (!(queryParameterBinding instanceof AdditionalParameterBinding)) continue;
            AdditionalParameterBinding additionalParameterBinding = (AdditionalParameterBinding)queryParameterBinding;
            iterator.set(this.createAdditionalBinding(additionalParameterBinding.bindingContext(), matchContext, entity, parameters, additionalParameterBinding.getName(), configuredDataTypes));
        }
        if (CollectionUtils.isNotEmpty(params)) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                String key = param.getKey();
                String name = param.getValue();
                parameterBinding.add(this.createAdditionalBinding(BindingParameter.BindingContext.create().name(key), matchContext, entity, parameters, name, configuredDataTypes));
            }
        }
    }

    private QueryParameterBinding createAdditionalBinding(BindingParameter.BindingContext bindingContext, MatchContext matchContext, SourcePersistentEntity entity, ParameterElement[] parameters, String name, Map<String, DataType> configuredDataTypes) {
        List parameterExpressions = matchContext.getMethodElement().getAnnotationMetadata().getAnnotationValuesByType(ParameterExpression.class);
        Optional<AnnotationValue> parameterExpression = parameterExpressions.stream().filter(av -> av.stringValue("name").orElse("").equals(name)).findFirst();
        if (parameterExpression.isPresent()) {
            ClassElement type = RawQueryMethodMatcher.extractExpressionType(matchContext, (AnnotationValue<ParameterExpression>)parameterExpression.orElseThrow());
            return new SourceParameterExpressionImpl(configuredDataTypes, name, type, null).bind(bindingContext);
        }
        ParameterElement parameter = Arrays.stream(parameters).filter(p -> p.stringValue(Parameter.class).orElse(p.getName()).equals(name)).findFirst().orElse(null);
        if (parameter == null) {
            throw new MatchFailedException("A @Where(..) definition requires a parameter called [" + name + "] which is not present in the method signature.");
        }
        PersistentPropertyPath propertyPath = entity.getPropertyPath(name);
        bindingContext = bindingContext.incomingMethodParameterProperty(propertyPath).outgoingQueryParameterProperty(propertyPath);
        return new SourceParameterExpressionImpl(configuredDataTypes, matchContext.parameters, parameter, false, null).bind(bindingContext);
    }

    private String addRawQueryParameterPlaceholders(QueryBuilder queryEncoder, String query, List<String> queryParts) {
        if (queryEncoder instanceof SqlQueryBuilder) {
            SqlQueryBuilder sqlQueryBuilder = (SqlQueryBuilder)queryEncoder;
            Iterator<String> iterator = queryParts.iterator();
            String first = iterator.next();
            if (queryParts.size() < 2) {
                return first;
            }
            StringBuilder sb = new StringBuilder(first);
            int i = 1;
            while (iterator.hasNext()) {
                sb.append(sqlQueryBuilder.formatParameter(i++).getName());
                sb.append(iterator.next());
            }
            return sb.toString();
        }
        return query;
    }

    @Nullable
    private String resolveIdType(PersistentEntity entity) {
        ClassElement ce;
        Map typeArguments = this.currentRepository.getTypeArguments(GenericRepository.class);
        String varName = "ID";
        if (typeArguments.isEmpty()) {
            typeArguments = this.currentRepository.getTypeArguments(SPRING_REPO);
        }
        if (!typeArguments.isEmpty() && (ce = (ClassElement)typeArguments.get(varName)) != null) {
            return ce.getName();
        }
        PersistentProperty identity = entity.getIdentity();
        if (identity != null) {
            return identity.getName();
        }
        return null;
    }

    private SourcePersistentEntity resolvePersistentEntity(MethodElement element, Map<String, Element> parametersInRole) {
        ClassElement returnType = element.getGenericReturnType();
        SourcePersistentEntity entity = this.resolveEntityForCurrentClass();
        if (entity == null) {
            entity = Utils.resolvePersistentEntity(returnType, this.entityResolver);
        }
        if (entity != null) {
            List propertiesInRole = entity.getPersistentProperties().stream().filter(pp -> pp.getAnnotationMetadata().hasStereotype(TypeRole.class)).collect(Collectors.toList());
            for (PersistentProperty persistentProperty : propertiesInRole) {
                String role = persistentProperty.getAnnotationMetadata().getValue(TypeRole.class, "role", String.class).orElse(null);
                if (role == null) continue;
                parametersInRole.put(role, (Element)((SourcePersistentProperty)persistentProperty).getPropertyElement());
            }
            return entity;
        }
        throw new MatchFailedException("Could not resolved root entity. Either implement the Repository interface or define the entity as part of the signature", (Element)element);
    }

    @Nullable
    private SourcePersistentEntity resolveEntityForCurrentClass() {
        ClassElement ce;
        Map typeArguments = this.currentRepository.getTypeArguments(GenericRepository.class);
        String argName = "E";
        if (typeArguments.isEmpty()) {
            argName = "T";
            typeArguments = this.currentRepository.getTypeArguments(SPRING_REPO);
        }
        if (!typeArguments.isEmpty() && (ce = (ClassElement)typeArguments.get(argName)) != null) {
            return this.entityResolver.apply(ce);
        }
        return null;
    }

    private void annotateEntityRepresentationIfPresent(ClassElement classElement) {
        AnnotationValue entityRepresentationAnnotationValue;
        SourcePersistentEntity entity = this.resolveEntityForCurrentClass();
        if (entity != null && (entityRepresentationAnnotationValue = entity.getAnnotation(EntityRepresentation.class)) != null) {
            classElement.annotate(entityRepresentationAnnotationValue);
        }
    }

    private void annotateQueryResultIfApplicable(MethodElement element, MethodMatchInfo methodInfo, SourcePersistentEntity entity) {
        AnnotationValue entityRepresentationAnnotationValue;
        if (methodInfo.getOperationType() == DataMethod.OperationType.QUERY && methodInfo.getResultType().equals(entity.getType()) && (entityRepresentationAnnotationValue = entity.getAnnotation(EntityRepresentation.class)) != null) {
            EntityRepresentation.Type type = (EntityRepresentation.Type)entityRepresentationAnnotationValue.getRequiredValue("type", EntityRepresentation.Type.class);
            String column = (String)entityRepresentationAnnotationValue.getRequiredValue("column", String.class);
            JsonDataType jsonDataType = JsonDataType.DEFAULT;
            QueryResult.Type queryResultType = type == EntityRepresentation.Type.TABULAR ? QueryResult.Type.TABULAR : QueryResult.Type.JSON;
            element.annotate(io.micronaut.data.annotation.QueryResult.class, builder -> builder.member("type", (Enum)queryResultType).member("jsonDataType", (Enum)jsonDataType).member("column", column));
        }
    }
}

