/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders.criteria;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.annotation.Id;
import io.micronaut.data.annotation.Version;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaBuilder;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaUpdate;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaUpdate;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaBuilder;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaUpdate;
import io.micronaut.data.processor.model.criteria.impl.MethodMatchSourcePersistentEntityCriteriaBuilderImpl;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractCriteriaMethodMatch;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodNameParser;
import io.micronaut.data.processor.visitors.finders.QueryMatchId;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UpdateCriteriaMethodMatch
extends AbstractCriteriaMethodMatch {
    private final boolean isReturning;

    public UpdateCriteriaMethodMatch(List<MethodNameParser.Match> matches, boolean isReturning) {
        super(matches);
        this.isReturning = isReturning;
    }

    protected <T> void apply(MethodMatchContext matchContext, PersistentEntityRoot<T> root, PersistentEntityCriteriaUpdate<T> query, SourcePersistentEntityCriteriaBuilder cb) {
        boolean predicatedApplied = false;
        boolean projectionApplied = false;
        ArrayList<ParameterElement> nonConsumedParameters = new ArrayList<ParameterElement>(matchContext.getParametersNotInRole());
        for (MethodNameParser.Match match : this.matches) {
            if (match.id() == QueryMatchId.PREDICATE) {
                this.applyPredicates(matchContext, match.part(), nonConsumedParameters, root, query, cb);
                predicatedApplied = true;
            }
            if (match.id() != QueryMatchId.RETURNING) continue;
            this.applyProjections(match.part(), root, query, cb);
            projectionApplied = true;
        }
        if (!predicatedApplied) {
            this.applyPredicates(matchContext, nonConsumedParameters, root, query, cb);
        }
        if (!projectionApplied) {
            this.applyProjections("", root, query, cb);
        }
        SourcePersistentEntity entity = matchContext.getRootEntity();
        this.addPropertiesToUpdate(nonConsumedParameters, matchContext, root, query, cb);
        AbstractPersistentEntityCriteriaUpdate criteriaUpdate = (AbstractPersistentEntityCriteriaUpdate)query;
        entity.getPersistentProperties().stream().filter(p -> p != null && p.findAnnotation(AutoPopulated.class).map(ap -> (Boolean)ap.getRequiredValue("updateable", Boolean.class)).orElse(false) != false).forEach(p -> query.set(p.getName(), cb.parameter(null)));
        if (entity.getVersion() != null && !entity.getVersion().isGenerated() && criteriaUpdate.hasVersionRestriction()) {
            query.set(entity.getVersion().getName(), cb.parameter(null));
        }
        if (criteriaUpdate.getUpdateValues().isEmpty()) {
            throw new MatchFailedException("At least one parameter required to update");
        }
    }

    private <T> void applyPredicates(MethodMatchContext matchContext, String querySequence, List<ParameterElement> parameters, PersistentEntityRoot<T> root, PersistentEntityCriteriaUpdate<T> query, SourcePersistentEntityCriteriaBuilder cb) {
        Iterator<ParameterElement> parametersIterator = parameters.iterator();
        Predicate predicate = this.extractPredicates(querySequence, parametersIterator, root, cb);
        ArrayList<ParameterElement> remainingParameters = new ArrayList<ParameterElement>(parameters.size());
        while (parametersIterator.hasNext()) {
            remainingParameters.add(parametersIterator.next());
        }
        parameters.retainAll(remainingParameters);
        predicate = this.interceptPredicate(matchContext, parameters, root, cb, predicate);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
    }

    private <T> void applyPredicates(MethodMatchContext matchContext, List<ParameterElement> parameters, PersistentEntityRoot<T> root, PersistentEntityCriteriaUpdate<T> query, SourcePersistentEntityCriteriaBuilder cb) {
        Predicate predicate = this.interceptPredicate(matchContext, parameters, root, cb, null);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
    }

    @Override
    protected <T> Predicate interceptPredicate(MethodMatchContext matchContext, List<ParameterElement> notConsumedParameters, PersistentEntityRoot<T> root, SourcePersistentEntityCriteriaBuilder cb, Predicate existingPredicate) {
        ParameterElement entityParameter = this.getEntityParameter();
        if (entityParameter == null) {
            entityParameter = this.getEntitiesParameter();
        }
        Predicate predicate = null;
        if (entityParameter != null) {
            SourcePersistentEntity rootEntity = (SourcePersistentEntity)root.getPersistentEntity();
            predicate = rootEntity.getVersion() != null ? cb.and((Expression)cb.equal(root.id(), (Expression)cb.entityPropertyParameter(entityParameter)), (Expression)cb.equal((Expression)root.version(), (Expression)cb.entityPropertyParameter(entityParameter))) : cb.equal(root.id(), (Expression)cb.entityPropertyParameter(entityParameter));
        } else {
            ParameterElement idParameter = notConsumedParameters.stream().filter(p -> p.hasAnnotation(Id.class)).findFirst().orElse(null);
            ParameterElement versionParameter = notConsumedParameters.stream().filter(p -> p.hasAnnotation(Version.class)).findFirst().orElse(null);
            if (idParameter != null) {
                notConsumedParameters.remove(idParameter);
                predicate = cb.equal(root.id(), (Expression)cb.parameter(idParameter));
            }
            if (versionParameter != null) {
                notConsumedParameters.remove(versionParameter);
                Predicate versionPredicate = cb.equal((Expression)root.version(), (Expression)cb.parameter(versionParameter));
                predicate = predicate != null ? cb.and((Expression)predicate, (Expression)versionPredicate) : versionPredicate;
            }
        }
        if (existingPredicate != null) {
            predicate = predicate != null ? cb.and((Expression)existingPredicate, (Expression)predicate) : existingPredicate;
        }
        return super.interceptPredicate(matchContext, notConsumedParameters, root, cb, predicate);
    }

    protected <T> void applyProjections(String projection, PersistentEntityRoot<T> root, PersistentEntityCriteriaUpdate<T> query, PersistentEntityCriteriaBuilder cb) {
        if (!this.isReturning) {
            return;
        }
        List<Selection<?>> selections = this.findSelections(projection, root, cb, null);
        if (selections.isEmpty()) {
            query.returning(root);
        } else if (selections.size() == 1) {
            query.returning(selections.get(0));
        } else {
            throw new MatchFailedException("Multi-selection is not supported");
        }
    }

    protected <T> void addPropertiesToUpdate(List<ParameterElement> nonConsumedParameters, MethodMatchContext matchContext, PersistentEntityRoot<T> root, PersistentEntityCriteriaUpdate<T> query, SourcePersistentEntityCriteriaBuilder cb) {
    }

    @Override
    protected MethodMatchInfo build(MethodMatchContext matchContext) {
        List<SourcePersistentProperty> dtoProjectionProperties;
        MethodMatchSourcePersistentEntityCriteriaBuilderImpl cb = new MethodMatchSourcePersistentEntityCriteriaBuilderImpl(matchContext);
        PersistentEntityCriteriaUpdate criteriaQuery = cb.createCriteriaUpdate((Class)null);
        PersistentEntityRoot root = criteriaQuery.from((PersistentEntity)matchContext.getRootEntity());
        this.apply(matchContext, root, criteriaQuery, cb);
        FindersUtils.InterceptorMatch interceptorMatch = this.resolveReturnTypeAndInterceptor(matchContext);
        ClassElement resultType = interceptorMatch.returnType();
        ClassElement interceptorType = interceptorMatch.interceptor();
        SourcePersistentEntityCriteriaUpdate criteriaUpdate = (SourcePersistentEntityCriteriaUpdate)criteriaQuery;
        AbstractCriteriaMethodMatch.MethodResult result = this.analyzeMethodResult(matchContext, criteriaUpdate.getQueryResultTypeName(), (ClassElement)matchContext.getVisitorContext().getClassElement(Long.class).orElseThrow(), interceptorMatch, true);
        if (result.isDto() && !result.isRuntimeDtoConversion() && !(dtoProjectionProperties = this.getDtoProjectionProperties(matchContext.getRootEntity(), resultType)).isEmpty()) {
            List selectionList = dtoProjectionProperties.stream().map(p -> {
                if (matchContext.getQueryBuilder().shouldAliasProjections()) {
                    return root.get(p.getName()).alias(p.getName());
                }
                return root.get(p.getName());
            }).collect(Collectors.toList());
            criteriaUpdate.returningMulti(selectionList);
        }
        AbstractPersistentEntityCriteriaUpdate query = (AbstractPersistentEntityCriteriaUpdate)criteriaQuery;
        boolean optimisticLock = query.hasVersionRestriction();
        AnnotationMetadataHierarchy annotationMetadataHierarchy = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{matchContext.getRepositoryClass().getAnnotationMetadata(), matchContext.getAnnotationMetadata()});
        QueryBuilder queryBuilder = matchContext.getQueryBuilder();
        Map propertiesToUpdate = query.getUpdateValues();
        QueryModel queryModel = query.getQueryModel();
        QueryResult queryResult = queryBuilder.buildUpdate((AnnotationMetadata)annotationMetadataHierarchy, queryModel, propertiesToUpdate);
        return new MethodMatchInfo(this.getOperationType(), (TypedElement)result.resultType(), interceptorType).dto(result.isDto()).optimisticLock(optimisticLock).queryResult(queryResult);
    }

    @Override
    protected DataMethod.OperationType getOperationType() {
        if (this.isReturning) {
            return DataMethod.OperationType.UPDATE_RETURNING;
        }
        return DataMethod.OperationType.UPDATE;
    }
}

