/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.annotation.sql.Procedure;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.query.BindingParameter;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.processor.model.criteria.impl.SourceParameterExpressionImpl;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.Utils;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class ProcedureMethodMatcher
implements MethodMatcher {
    @Override
    public int getOrder() {
        return -1000;
    }

    @Override
    public MethodMatcher.MethodMatch match(MethodMatchContext matchContext) {
        final AnnotationValue procedureAnnotationValue = matchContext.getMethodElement().getAnnotation(Procedure.class);
        if (procedureAnnotationValue != null) {
            return new MethodMatcher.MethodMatch(){

                @Override
                public MethodMatchInfo buildMatchInfo(MethodMatchContext matchContext) {
                    FindersUtils.InterceptorMatch interceptorMatch = FindersUtils.pickProcedureInterceptor(matchContext, matchContext.getMethodElement().getReturnType());
                    MethodMatchInfo methodMatchInfo = new MethodMatchInfo(DataMethod.OperationType.QUERY, (TypedElement)interceptorMatch.returnType(), interceptorMatch.interceptor());
                    QueryResult queryResult = ProcedureMethodMatcher.this.getQueryResult(matchContext, (AnnotationValue<Procedure>)procedureAnnotationValue, matchContext.getParametersNotInRole());
                    methodMatchInfo.queryResult(queryResult);
                    return methodMatchInfo;
                }
            };
        }
        return null;
    }

    private QueryResult getQueryResult(MethodMatchContext matchContext, AnnotationValue<Procedure> procedureAnnotationValue, List<ParameterElement> parameters) {
        Object query;
        boolean namedParameters = matchContext.getRepositoryClass().booleanValue(RepositoryConfiguration.class, "namedParameters").orElse(true);
        ArrayList<QueryParameterBinding> parameterBindings = new ArrayList<QueryParameterBinding>(parameters.size());
        int index = 1;
        for (ParameterElement parameter : parameters) {
            String name = parameter.stringValue(Parameter.class).orElse(parameter.getName());
            PersistentPropertyPath propertyPath = matchContext.getRootEntity().getPropertyPath(name);
            BindingParameter.BindingContext bindingContext = BindingParameter.BindingContext.create().incomingMethodParameterProperty(propertyPath).outgoingQueryParameterProperty(propertyPath);
            bindingContext = namedParameters ? bindingContext.name(name) : bindingContext.index(index++);
            parameterBindings.add(this.bindingParameter(matchContext, parameter).bind(bindingContext));
        }
        Optional named = procedureAnnotationValue.stringValue("named");
        if (named.isPresent()) {
            query = "";
        } else {
            String procedureName = procedureAnnotationValue.stringValue().orElseGet(() -> matchContext.getMethodElement().getName());
            int parametersSize = parameters.size();
            if (!matchContext.getMethodElement().getReturnType().isVoid()) {
                ++parametersSize;
            }
            query = "CALL " + procedureName + "(" + IntStream.range(0, parametersSize).mapToObj(ignore -> "?").collect(Collectors.joining(",")) + ")";
        }
        return new QueryResult(){
            final /* synthetic */ String val$query;
            final /* synthetic */ List val$parameterBindings;
            {
                this.val$query = string;
                this.val$parameterBindings = list;
            }

            public String getQuery() {
                return this.val$query;
            }

            public List<String> getQueryParts() {
                return List.of();
            }

            public List<QueryParameterBinding> getParameterBindings() {
                return this.val$parameterBindings;
            }

            public Map<String, String> getAdditionalRequiredParameters() {
                return Collections.emptyMap();
            }
        };
    }

    private SourceParameterExpressionImpl bindingParameter(MethodMatchContext matchContext, ParameterElement element) {
        return this.bindingParameter(matchContext, element, false);
    }

    private SourceParameterExpressionImpl bindingParameter(MethodMatchContext matchContext, ParameterElement element, boolean isEntityParameter) {
        return new SourceParameterExpressionImpl(Utils.getConfiguredDataTypes(matchContext.getRepositoryClass()), matchContext.getParameters(), element, isEntityParameter);
    }
}

