/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaBuilder;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Predicate;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

@Internal
public final class Restrictions {
    private static final List<PropertyRestriction> PROPERTY_RESTRICTIONS_LIST = Arrays.stream(Restrictions.class.getClasses()).filter(clazz -> PropertyRestriction.class.isAssignableFrom((Class<?>)clazz) && !Modifier.isAbstract(clazz.getModifiers())).map(clazz -> {
        try {
            return (PropertyRestriction)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            return null;
        }
    }).toList();
    private static final List<Restriction> RESTRICTIONS_LIST = Arrays.stream(Restrictions.class.getClasses()).filter(clazz -> Restriction.class.isAssignableFrom((Class<?>)clazz) && !Modifier.isAbstract(clazz.getModifiers())).map(clazz -> {
        try {
            return (Restriction)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            return null;
        }
    }).toList();
    public static final Map<String, PropertyRestriction> PROPERTY_RESTRICTIONS_MAP = PROPERTY_RESTRICTIONS_LIST.stream().collect(Collectors.toMap(PropertyRestriction::getName, p -> p, (a, b) -> a, TreeMap::new));
    public static final Map<String, Restriction> RESTRICTIONS_MAP = RESTRICTIONS_LIST.stream().collect(Collectors.toMap(Restriction::getName, p -> p, (a, b) -> a, TreeMap::new));

    @Nullable
    public static <T> PropertyRestriction<T> findPropertyRestriction(String name) {
        return PROPERTY_RESTRICTIONS_MAP.get(name);
    }

    @Nullable
    public static <T> Restriction<T> findRestriction(String name) {
        return RESTRICTIONS_MAP.get(name);
    }

    public static interface PropertyRestriction<T> {
        public String getName();

        public int getRequiredParameters();

        @NonNull
        public Predicate find(@NonNull PersistentEntityRoot<?> var1, @NonNull PersistentEntityCriteriaBuilder var2, @NonNull Expression<T> var3, @NonNull ParameterExpression<T>[] var4);
    }

    public static interface Restriction<T> {
        public String getName();

        public int getRequiredParameters();

        @NonNull
        public Predicate find(@NonNull PersistentEntityRoot<?> var1, @NonNull PersistentEntityCriteriaBuilder var2, @NonNull ParameterExpression<T>[] var3);
    }

    public static class PropertyCollectionContains<T>
    extends PropertyArrayContains<T> {
        @Override
        public String getName() {
            return "CollectionContains";
        }
    }

    public static class PropertyArrayContains<T>
    extends SinglePropertyExpressionRestriction<T> {
        public PropertyArrayContains() {
            super(PersistentEntityCriteriaBuilder::arrayContains);
        }

        @Override
        public String getName() {
            return "ArrayContains";
        }
    }

    private static interface OneExpressionOp<T> {
        public Predicate apply(PersistentEntityCriteriaBuilder var1, Expression<T> var2);
    }

    private static interface TwoExpressionOp<T> {
        public Predicate apply(PersistentEntityCriteriaBuilder var1, Expression<T> var2, Expression<T> var3);
    }

    private static abstract class SinglePropertyExpressionRestriction<T>
    implements PropertyRestriction<T> {
        private final TwoExpressionOp<T> func;

        public SinglePropertyExpressionRestriction(TwoExpressionOp<T> func) {
            this.func = func;
        }

        @Override
        public int getRequiredParameters() {
            return 1;
        }

        @Override
        public Predicate find(PersistentEntityRoot<?> entityRoot, PersistentEntityCriteriaBuilder cb, Expression<T> expression, ParameterExpression<T>[] parameters) {
            return this.func.apply(cb, expression, (Expression<T>)parameters[0]);
        }
    }

    private static abstract class SinglePropertyRestriction<T>
    implements PropertyRestriction<T> {
        private final OneExpressionOp<T> func;

        public SinglePropertyRestriction(OneExpressionOp<T> func) {
            this.func = func;
        }

        @Override
        public int getRequiredParameters() {
            return 0;
        }

        @Override
        public Predicate find(PersistentEntityRoot<?> entityRoot, PersistentEntityCriteriaBuilder cb, Expression<T> expression, ParameterExpression<T>[] parameters) {
            return this.func.apply(cb, expression);
        }
    }

    public static class PropertyNotEqual<T>
    extends SinglePropertyExpressionRestriction<T> {
        public PropertyNotEqual() {
            super(CriteriaBuilder::notEqual);
        }

        @Override
        public String getName() {
            return "NotEqual";
        }
    }

    public static class PropertyNotEquals<T>
    extends PropertyNotEqual<T> {
        @Override
        public String getName() {
            return "NotEquals";
        }
    }

    public static class PropertyStringEqualIgnoreCase
    extends SinglePropertyExpressionRestriction<String> {
        public PropertyStringEqualIgnoreCase() {
            super(PersistentEntityCriteriaBuilder::equalStringIgnoreCase);
        }

        @Override
        public String getName() {
            return "EqualIgnoreCase";
        }
    }

    public static class PropertyStringEqualsIgnoreCase
    extends PropertyStringEqualIgnoreCase {
        @Override
        public String getName() {
            return "EqualsIgnoreCase";
        }
    }

    public static class PropertyEqual<T>
    extends SinglePropertyExpressionRestriction<T> {
        public PropertyEqual() {
            super(CriteriaBuilder::equal);
        }

        @Override
        public String getName() {
            return "Equal";
        }
    }

    public static class PropertyEquals<T>
    extends PropertyEqual<T> {
        @Override
        public String getName() {
            return "Equals";
        }
    }

    public static class PropertyBetween<T extends Comparable<? super T>>
    implements PropertyRestriction<T> {
        @Override
        public String getName() {
            return "Between";
        }

        @Override
        public int getRequiredParameters() {
            return 2;
        }

        @Override
        public Predicate find(PersistentEntityRoot<?> entityRoot, PersistentEntityCriteriaBuilder cb, Expression<T> expression, ParameterExpression<T>[] parameters) {
            return cb.between(expression, parameters[0], parameters[1]);
        }
    }

    public static class PropertyIsNotEmpty
    extends SinglePropertyRestriction<String> {
        public PropertyIsNotEmpty() {
            super(PersistentEntityCriteriaBuilder::isNotEmptyString);
        }

        @Override
        public String getName() {
            return "IsNotEmpty";
        }
    }

    public static class PropertyIsEmpty
    extends SinglePropertyRestriction<String> {
        public PropertyIsEmpty() {
            super(PersistentEntityCriteriaBuilder::isEmptyString);
        }

        @Override
        public String getName() {
            return "IsEmpty";
        }
    }

    public static class PropertyIsNull<T>
    extends SinglePropertyRestriction<T> {
        public PropertyIsNull() {
            super(CriteriaBuilder::isNull);
        }

        @Override
        public String getName() {
            return "IsNull";
        }
    }

    public static class PropertyIsNotNull<T>
    extends SinglePropertyRestriction<T> {
        public PropertyIsNotNull() {
            super(CriteriaBuilder::isNotNull);
        }

        @Override
        public String getName() {
            return "IsNotNull";
        }
    }

    public static class PropertyIsFalse
    extends SinglePropertyRestriction<Boolean> {
        public PropertyIsFalse() {
            super(CriteriaBuilder::isFalse);
        }

        @Override
        public String getName() {
            return "False";
        }
    }

    public static class PropertyIsTrue
    extends SinglePropertyRestriction<Boolean> {
        public PropertyIsTrue() {
            super(CriteriaBuilder::isTrue);
        }

        @Override
        public String getName() {
            return "True";
        }
    }

    public static class PropertyInRange<T extends Comparable<? super T>>
    extends PropertyBetween<T> {
        @Override
        public String getName() {
            return "InRange";
        }
    }

    public static class PropertyIn<T>
    implements PropertyRestriction<T> {
        @Override
        public String getName() {
            return "In";
        }

        @Override
        public int getRequiredParameters() {
            return 1;
        }

        @Override
        public Predicate find(PersistentEntityRoot<?> entityRoot, PersistentEntityCriteriaBuilder cb, Expression<T> expression, ParameterExpression<T>[] parameters) {
            return expression.in(new Expression[]{parameters[0]});
        }
    }

    public static class PropertyInList<T>
    extends PropertyIn<T> {
        @Override
        public String getName() {
            return "InList";
        }
    }

    public static class PropertyNotIn<T>
    implements PropertyRestriction<T> {
        @Override
        public String getName() {
            return "NotIn";
        }

        @Override
        public int getRequiredParameters() {
            return 1;
        }

        @Override
        public Predicate find(PersistentEntityRoot<?> entityRoot, PersistentEntityCriteriaBuilder cb, Expression<T> expression, ParameterExpression<T>[] parameters) {
            return expression.in(new Expression[]{parameters[0]}).not();
        }
    }

    public static class PropertyNotInList<T>
    extends PropertyNotIn<T> {
        @Override
        public String getName() {
            return "NotInList";
        }
    }

    public static class PropertyRlike
    extends SinglePropertyExpressionRestriction<String> {
        public PropertyRlike() {
            super(PersistentEntityCriteriaBuilder::rlikeString);
        }

        @Override
        public String getName() {
            return "Rlike";
        }
    }

    public static class PropertyIlike
    extends SinglePropertyExpressionRestriction<String> {
        public PropertyIlike() {
            super(PersistentEntityCriteriaBuilder::ilikeString);
        }

        @Override
        public String getName() {
            return "Ilike";
        }
    }

    public static class PropertyEndsWithIgnoreCase
    extends PropertyEndingWithIgnoreCase {
        @Override
        public String getName() {
            return "EndsWithIgnoreCase";
        }
    }

    public static class PropertyEndingWithIgnoreCase
    extends SinglePropertyExpressionRestriction<String> {
        public PropertyEndingWithIgnoreCase() {
            super(PersistentEntityCriteriaBuilder::endingWithStringIgnoreCase);
        }

        @Override
        public String getName() {
            return "EndingWithIgnoreCase";
        }
    }

    public static class PropertyEndingWith
    extends SinglePropertyExpressionRestriction<String> {
        public PropertyEndingWith() {
            super(PersistentEntityCriteriaBuilder::endingWithString);
        }

        @Override
        public String getName() {
            return "EndingWith";
        }
    }

    public static class PropertyEndsWith
    extends PropertyEndingWith {
        @Override
        public String getName() {
            return "EndsWith";
        }
    }

    public static class PropertyStartsWithIgnoreCase
    extends SinglePropertyExpressionRestriction<String> {
        public PropertyStartsWithIgnoreCase() {
            super(PersistentEntityCriteriaBuilder::startsWithStringIgnoreCase);
        }

        @Override
        public String getName() {
            return "StartsWithIgnoreCase";
        }
    }

    public static class PropertyStartingWithIgnoreCase
    extends PropertyStartsWithIgnoreCase {
        @Override
        public String getName() {
            return "StartingWithIgnoreCase";
        }
    }

    public static class PropertyStartsWith
    extends SinglePropertyExpressionRestriction<String> {
        public PropertyStartsWith() {
            super(PersistentEntityCriteriaBuilder::startsWithString);
        }

        @Override
        public String getName() {
            return "StartsWith";
        }
    }

    public static class PropertyStartingWith
    extends PropertyStartsWith {
        @Override
        public String getName() {
            return "StartingWith";
        }
    }

    public static class PropertyContaining
    extends PropertyContains {
        @Override
        public String getName() {
            return "Containing";
        }
    }

    public static class PropertyContainingIgnoreCase
    extends PropertyContainsIgnoreCase {
        @Override
        public String getName() {
            return "ContainingIgnoreCase";
        }
    }

    public static class PropertyContainsIgnoreCase
    extends SinglePropertyExpressionRestriction<String> {
        public PropertyContainsIgnoreCase() {
            super(PersistentEntityCriteriaBuilder::containsStringIgnoreCase);
        }

        @Override
        public String getName() {
            return "ContainsIgnoreCase";
        }
    }

    public static class PropertyContains
    extends SinglePropertyExpressionRestriction<String> {
        public PropertyContains() {
            super(PersistentEntityCriteriaBuilder::containsString);
        }

        @Override
        public String getName() {
            return "Contains";
        }
    }

    public static class PropertyRegex
    extends SinglePropertyExpressionRestriction<String> {
        public PropertyRegex() {
            super(PersistentEntityCriteriaBuilder::regex);
        }

        @Override
        public String getName() {
            return "Regex";
        }
    }

    public static class PropertyLike
    extends SinglePropertyExpressionRestriction<String> {
        public PropertyLike() {
            super(CriteriaBuilder::like);
        }

        @Override
        public String getName() {
            return "Like";
        }
    }

    public static class PropertyLessThanEquals<T extends Comparable<? super T>>
    extends SinglePropertyExpressionRestriction<T> {
        public PropertyLessThanEquals() {
            super(CriteriaBuilder::lessThanOrEqualTo);
        }

        @Override
        public String getName() {
            return "LessThanEquals";
        }
    }

    public static class PropertyLessThan<T extends Comparable<? super T>>
    extends SinglePropertyExpressionRestriction<T> {
        public PropertyLessThan() {
            super(CriteriaBuilder::lessThan);
        }

        @Override
        public String getName() {
            return "LessThan";
        }
    }

    public static class PropertyGreaterThanEquals<T extends Comparable<? super T>>
    extends SinglePropertyExpressionRestriction<T> {
        public PropertyGreaterThanEquals() {
            super(CriteriaBuilder::greaterThanOrEqualTo);
        }

        @Override
        public String getName() {
            return "GreaterThanEquals";
        }
    }

    public static class Before<T extends Comparable<? super T>>
    extends PropertyLessThan<T> {
        @Override
        public String getName() {
            return "Before";
        }
    }

    public static class After<T extends Comparable<? super T>>
    extends PropertyGreaterThan<T> {
        @Override
        public String getName() {
            return "After";
        }
    }

    public static class PropertyGreaterThan<T extends Comparable<? super T>>
    extends SinglePropertyExpressionRestriction<T> {
        public PropertyGreaterThan() {
            super(CriteriaBuilder::greaterThan);
        }

        @Override
        public String getName() {
            return "GreaterThan";
        }
    }

    public static class PropertyIds<T>
    implements Restriction<T> {
        @Override
        public String getName() {
            return "Ids";
        }

        @Override
        public int getRequiredParameters() {
            return 1;
        }

        @Override
        public Predicate find(PersistentEntityRoot<?> entityRoot, PersistentEntityCriteriaBuilder cb, ParameterExpression<T>[] parameters) {
            return entityRoot.id().in(new Expression[]{parameters[0]});
        }
    }
}

