/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.visitors.FindInterceptorDef;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class MethodMatchContext
extends MatchContext {
    private SourcePersistentEntity entity;
    private final Map<Element, String> parametersInRole;
    private final Function<ClassElement, SourcePersistentEntity> entityResolver;
    private final Function<String, SourcePersistentEntity> entityBySimplyNameResolver;

    MethodMatchContext(@NonNull QueryBuilder queryBuilder, @NonNull ClassElement repositoryClass, @NonNull SourcePersistentEntity entity, @NonNull VisitorContext visitorContext, @NonNull ClassElement returnType, @NonNull MethodElement methodElement, @NonNull Map<Element, String> parametersInRole, @NonNull Map<String, String> typeRoles, @NonNull ParameterElement[] parameters, @NonNull Function<ClassElement, SourcePersistentEntity> entityResolver, @NonNull Map<ClassElement, FindInterceptorDef> findInterceptors, @NonNull Function<String, SourcePersistentEntity> entityBySimplyNameResolver) {
        super(queryBuilder, repositoryClass, visitorContext, methodElement, typeRoles, returnType, parameters, findInterceptors);
        this.entity = entity;
        this.parametersInRole = Collections.unmodifiableMap(parametersInRole);
        this.entityResolver = entityResolver;
        this.entityBySimplyNameResolver = entityBySimplyNameResolver;
    }

    public Function<String, SourcePersistentEntity> getEntityBySimplyNameResolver() {
        return this.entityBySimplyNameResolver;
    }

    public boolean hasParameterInRole(@NonNull String role) {
        return role != null && this.parametersInRole.containsValue(role);
    }

    @Nullable
    public Element findParameterInRole(@NonNull String role) {
        for (Map.Entry<Element, String> e : this.parametersInRole.entrySet()) {
            if (!e.getValue().equals(role)) continue;
            return e.getKey();
        }
        return null;
    }

    @NonNull
    public Map<Element, String> getParametersInRole() {
        return this.parametersInRole;
    }

    public SourcePersistentEntity getRootEntity() {
        return this.entity;
    }

    public void setRootEntity(SourcePersistentEntity entity) {
        this.entity = entity;
    }

    @NonNull
    public List<ParameterElement> getParametersNotInRole() {
        return Arrays.stream(this.getParameters()).filter(p -> !this.parametersInRole.containsKey(p)).toList();
    }

    @NonNull
    public List<ParameterElement> getParametersInRoleList() {
        return Arrays.stream(this.getParameters()).filter(this.parametersInRole::containsKey).toList();
    }

    @NonNull
    public SourcePersistentEntity getEntity(@NonNull ClassElement element) {
        return this.entityResolver.apply(element);
    }
}

